/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


#include <FMOD/fmod.h>

#include "AIdef.h"
#include "main.h"
#include "bsgExplosion.h"
#include "bsgTurret.h"
#include "bsgTanker.h"

Bitmap    * g_pimTanker=NULL;

bsgTanker::bsgTanker()
{
    m_nTeam=MEM_CYLON;
    m_nType=ID_TANKER;
    m_nAI=AI_MOVE;
    m_fSpeed=0;
    m_fMaxSpeed=3;
    m_fSteer=0.02;
    SetImage(g_pimTanker);
    m_fX=5000;
    m_fY=5000;
    m_nZ=3;
    m_nMaxHealth=1000;
	m_nHealth=m_nMaxHealth;


	m_pTurret=new bsgTurret(TT_360);
    m_pTurret->m_fX=m_fX;
    m_pTurret->m_fY=m_fY;
    m_pTurret->m_nTeam = MEM_CYLON;
    m_pTurret->m_nZ=m_nZ+1;
    m_pEngine->add(m_pTurret);

}


bsgTanker::~bsgTanker()
{
   if (m_pTurret!=NULL)
   {
      m_pTurret->m_blDestroyed=true;
   }
}


void bsgTanker::do_ai(float a_fLagCount)
{

    switch(m_nAI)
    {
        case AI_NONE:
        break;

        case AI_EVADE:

        break;

        case AI_MOVE:
        m_fSpeed=m_fMaxSpeed;
        if (Ai_Move(a_fLagCount))
        {
          m_pTurret->m_blDisabled  = true;
          m_pTurret->m_blOutOfGame = true;
          m_nAI=AI_HOLD;
        }

        break;

        case AI_WANDER:
        break;

        case AI_HOLD:
        break;


    }


    if ((m_nHealth<=0)&&(!m_blDestroyed))
    {

        int nB    = m_pImage->Height()/2;
        int nOfsX = (m_pImage->Width()/2)-nB;
        float PX[5];
        float PY[5];

        PX[0] = m_fX-(nOfsX*m_fCosAngle);
        PY[0] = m_fY-(nOfsX*m_fSinAngle);

        PX[1] = m_fX;
        PY[1] = m_fY;

        PX[2] = m_fX+(nOfsX*m_fCosAngle);
        PY[2] = m_fY+(nOfsX*m_fSinAngle);

        nOfsX/=2;

        PX[3] = m_fX-(nOfsX*m_fCosAngle);
        PY[3] = m_fY-(nOfsX*m_fSinAngle);

        PX[4] = m_fX+(nOfsX*m_fCosAngle);
        PY[4] = m_fY+(nOfsX*m_fSinAngle);

      for (int i=0;i<5;i++)
      {
        m_blDestroyed=true;
        bsgExplosion * pE;
        pE=new bsgExplosion;
        pE->m_nZ=m_nZ+1;
        pE->m_fX=PX[i];
        pE->m_fY=PY[i];
        pE->m_fAngle=m_fAngle;
        pE->m_fSpeed=m_fSpeed;
        m_pEngine->add(pE);
      }


        float fD = distance(m_fX,m_fY,m_pEngine->m_nCameraX,m_pEngine->m_nCameraY);
        int nCannelHandle=FSOUND_PlaySound(FSOUND_FREE,GetSample(SND_EXPLODE));
        if (fD<400)
        {
            FSOUND_SetVolume(nCannelHandle,255);
        }
        else
        {
            FSOUND_SetVolume(nCannelHandle,100);
        }
    }
    else
    {
        Control();
        int nOfsX=40;
        int nOfsY=0;

        float fTX=(m_fX+((-nOfsX*m_fCosAngle)-(-nOfsY*m_fSinAngle)));
        float fTY=(m_fY+((-nOfsY*m_fCosAngle)+(-nOfsX*m_fSinAngle)));

        m_pTurret->m_fX=fTX;
        m_pTurret->m_fY=fTY;
        m_pTurret->m_fRestAngle = m_fAngle;
    }
}


bool LoadTankerSprites()
{
  g_pimTanker = new Bitmap("Gfx/Still/Tanker.png");

  if (g_pimTanker!=NULL)
  {
     return true;
  }
  else
  {
     return false;
  }
}

