/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/



#include "bsgSmoke.h"
#include "AIdef.h"


vector< Bitmap *> im_Smoke;

bsgSmoke::bsgSmoke()
{
    m_nWait=2;
    m_nFrame=0;
    m_fOpacity=0.5;
    m_nType=ID_SMOKE;
    SetImage(im_Smoke[m_nFrame]);
}

bsgSmoke::~bsgSmoke()
{

}




void bsgSmoke::do_ai(float a_fLagCount)
{
    m_nWait-=a_fLagCount;
    if (m_nWait <=0)
    {
        m_nFrame++;

        if (m_nFrame<im_Smoke.size())
            SetImage(im_Smoke[m_nFrame]);
        else
            m_blDestroyed=true;

        m_nWait=8;
    }
}



bool LoadSmokeSprites()
{
    im_Smoke = Bitmap::LoadListOfBitmaps("Gfx/Animated/smoke/S", "png", 2);
    return !im_Smoke.empty();
}






















