/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <FMOD/fmod.h>
#include <assert.h>
#include "AIDef.h"
#include "main.h"
#include "bsgShuttle.h"
#include "bsgExplosion.h"
#include "bsgBattlestar.h"




Bitmap    * g_pimShuttle=NULL;
Bitmap    * g_pimShuttleShadow=NULL;



bsgShuttle::bsgShuttle()
{
    m_nTeam=MEM_COLONY;
    m_nType=ID_SHUTTLE;
    m_nAI=AI_MOVE;
    m_fSpeed=0;
    m_fMaxSpeed=4;
    m_pBattlestar=NULL;
    m_fSteer=0.02;
    m_blDocking=false;
    m_blLaunching=false;
    m_pBattlestar=NULL;
    m_nILSPoint=0;
    SetImage(g_pimShuttle);
    SetShadow(g_pimShuttleShadow);
    m_fX=5000;
    m_fY=4890;
    m_nZ=9;
    m_nMaxHealth=800;
	m_nHealth=m_nMaxHealth;
}


bsgShuttle::bsgShuttle(int a_nLaunchBay)
{
    m_nTeam=MEM_COLONY;
    m_nType=ID_SHUTTLE;
    m_pBattlestar=NULL;
    m_nAI=AI_MOVE;
    m_fSpeed=0;
    m_fMaxSpeed=4;
    m_pBattlestar=NULL;

    m_fSteer=0.03;
    m_blDocking=false;
    m_blLaunching=false;
    SetImage(g_pimShuttle);
    SetShadow(g_pimShuttleShadow);

    m_nMaxHealth=800;
	m_nHealth=m_nMaxHealth;

    m_nILSPoint=0;

}






bsgShuttle::~bsgShuttle()
{

}




void bsgShuttle::do_ai(float a_fLagCount)
{

    switch(m_nAI)
    {
        case AI_NONE:
        break;

        case AI_EVADE:

        break;

        case AI_MOVE:
        m_fSpeed=m_fMaxSpeed;
        if (Ai_Move(a_fLagCount))
        {
            if (m_pBattlestar!=NULL)
            {

                if (! m_pBattlestar->m_blIncoming1)
                {
                   m_pBattlestar->m_blIncoming1=true;
                   m_nBAY=BAY_LEFT;
                   m_nAI=AI_DOCK;
                }
                else if (! m_pBattlestar->m_blIncoming2)
                {
                   m_pBattlestar->m_blIncoming2=true;
                   m_nBAY=BAY_RIGHT;
                   m_nAI=AI_DOCK;
                }

            }
        }

        break;

        case AI_WANDER:
        break;

        case AI_HOLD:
        break;

        case AI_DOCK:
           Ai_Dock(a_fLagCount);
        break;


        case AI_LAUNCH:
             Ai_Launch(a_fLagCount);
        break;
    }


    float fD = distance(m_fX,m_fY,m_nWaypointX,m_nWaypointX);

    m_fSpeed=(fD/50)+1;

    if (m_fSpeed<0)
    {
        m_fSpeed=0;
    }
    if (m_fSpeed>m_fMaxSpeed)
    {
        m_fSpeed=m_fMaxSpeed;
    }

    if ((m_nHealth<=0)&&(!m_blDestroyed))
    {
        m_blDestroyed=true;
        bsgExplosion * pE;
        pE=new bsgExplosion;
        pE->m_nZ=m_nZ+1;
        pE->m_fX=m_fX;
        pE->m_fY=m_fY;
        pE->m_fAngle=m_fAngle;
        pE->m_fSpeed=m_fSpeed;
        m_pEngine->add(pE);



        float fD = distance(m_fX,m_fY,m_pEngine->m_nCameraX,m_pEngine->m_nCameraY);
        int nCannelHandle=FSOUND_PlaySound(FSOUND_FREE,GetSample(SND_EXPLODE));
        if (fD<400)
        {
            FSOUND_SetVolume(nCannelHandle,255);
        }
        else
        {
            FSOUND_SetVolume(nCannelHandle,100);
        }
    }
    else
    {
        Control();
    }

}





void bsgShuttle::launch()
{
    m_nAI=AI_LAUNCH;
}


void bsgShuttle::land()
{
    m_nAI=AI_DOCK;
}



void bsgShuttle::Ai_Dock(float a_fLagCount)
{

    if (m_nILSPoint<4)
    {
        m_IlsPoint     = m_pBattlestar->GetILSPoint(m_nILSPoint,m_nBAY);
        m_fAngleSeek    = waypoint(m_IlsPoint.m_nX,m_IlsPoint.m_nY);

        float fD = distance(m_fX,m_fY,m_IlsPoint.m_nX,m_IlsPoint.m_nY);

        float fAdjustSpeed=m_fMaxSpeed;
        if (m_nILSPoint>1) fAdjustSpeed=m_fMaxSpeed+3;

        if (m_fSpeed<fAdjustSpeed/((m_nILSPoint+1)))
        {
           m_fSpeed+=0.4;
        }

        if (m_fSpeed>fAdjustSpeed/((m_nILSPoint+1)))
        {
           m_fSpeed-=0.4;
        }

        if (fD<50-(m_nILSPoint*10))
        {
            m_nILSPoint++;
            if (m_nILSPoint > 2)
            {
               m_nZ=1;
               m_pEngine->Sort();
               m_pTarget=NULL;
            }
        }
    }
    else
    {
         m_fSpeed=0;
         m_blDocking=false;
         m_nZ = 1;
         assert(m_pBattlestar!=NULL);

         if (m_nType==ID_PLAYER)
         {
             m_pBattlestar->m_nPlayerDocked=true;
             m_blDestroyed=true;
             m_pBattlestar->m_nVipersInAction--;
         }
         else
         {
             if ( m_nBAY==BAY_LEFT)
             {
                m_pBattlestar->m_nShuttles++;
                m_pBattlestar->m_blIncoming1=false;
             }
             else if ( m_nBAY==BAY_RIGHT)
             {
                 m_pBattlestar->m_nShuttles++;
                 m_pBattlestar->m_blIncoming2=false;
             }

             m_blDestroyed=true;
         }
    }
}


void bsgShuttle::Ai_Launch(float a_fLagCount)
{
    if (m_nZ<10)
    {
        m_nZ=2;

        if (m_fSpeed==0)
        {
           m_nWaypointX=int(m_fX+500);
           m_nWaypointY=int(m_fY);

        }

        float fD = distance(m_fX,m_fY,m_nWaypointX,m_nWaypointY);
        m_fAngleSeek=waypoint(m_nWaypointX,m_nWaypointY);
        m_fSpeed=m_fMaxSpeed;

        if (fD<20)
        {
            m_nZ=10;
            m_pEngine->Sort();
        }

    }
    else
    {
         m_blLaunching=false;

         SetWaypoint(m_fX+200,m_fY,false);

         m_nILSPoint=0;
    }

}


bool LoadShuttleSprites()
{
    g_pimShuttle = new Bitmap("Gfx/Still/Shuttle.png");
    g_pimShuttleShadow = new Bitmap("Gfx/Still/Shuttleshd.png");

    if ((g_pimShuttle!=NULL)&&(g_pimShuttleShadow!=NULL))
    {
            return true;
    }
    else
    {
           return false;
    }
}

