/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <FMOD/fmod.h>

#include "AIdef.h"
#include "main.h"
#include "bsgRaider.h"
#include "bsgBullet.h"
#include "bsgExplosion.h"

Bitmap    * g_pimRaider;
Bitmap    * g_pimRaiderShadow;




bsgRaider::bsgRaider()
{
    m_nTeam=MEM_CYLON;
    m_nType=ID_RAIDER;
    m_nAI=AI_CHASE;
    m_fFireDelay=0;
    m_fSteer=0.02;
    m_fMaxSpeed=5;
    m_nMaxHealth=400;
	m_nHealth=m_nMaxHealth;
    m_nMissiles=4;
    SetImage(g_pimRaider);
    SetShadow(g_pimRaiderShadow);
}


bsgRaider::~bsgRaider()
{




}

void bsgRaider::do_ai(float a_fLagCount)
{
    bsgSprite * pObstacle = SeekObstacle();
    float dist;


    if (m_nTargetType==ID_ANY)
    {
        m_pTarget=SeekTarget();
    }
    else
    {
        m_pTarget=SeekTarget(m_nTargetType);
    }

    if ((m_pTarget!=NULL)&&(m_pTarget->m_blDestroyed))
    {
        m_pTarget=NULL;
    }


    if ((m_pEscort != NULL)&&(m_nAI != AI_ESCORT))
    {
       dist = distance(m_fX,m_fY,m_pEscort->m_fX,m_pEscort->m_fY);

       if (dist > 1000)
       {
            m_nOldAI = m_nAI;
            m_nAI= AI_ESCORT;
       }

       if (m_pEscort->m_blDestroyed)
       {
         m_pEscort=NULL;
       }
    }

    switch(m_nAI)
    {
        case AI_NONE:
        break;

        case AI_CHASE:
        Ai_Chase(a_fLagCount);
        break;

        case AI_EVADE:
        Ai_Evade(a_fLagCount);
        break;

        case AI_MOVE:
        if (Ai_Move(a_fLagCount))
        {
            m_nAI=AI_CHASE;
        }
        break;

        case AI_ESCORT:
        Ai_Escort(a_fLagCount);
        break;

        case AI_WANDER:
        break;

        case AI_HOLD:
        break;
    }





    if (m_fSpeed<0)
    {
        m_fSpeed=0;
    }
    if (m_fSpeed>m_fMaxSpeed)
    {
        m_fSpeed=m_fMaxSpeed;
    }

    if (m_fFireDelay>0)
    {
        m_fFireDelay-=a_fLagCount;
    }


    if (m_fFireDelaySpartan>0)
    {
       m_fFireDelaySpartan-=(a_fLagCount*2);
    }


    if ((m_nHealth<=0)&&(!m_blDestroyed))
    {
        m_blDestroyed=true;
        bsgExplosion * pE;
        pE=new bsgExplosion;
        pE->m_nZ=m_nZ+1;
        pE->m_fX=m_fX;
        pE->m_fY=m_fY;
        pE->m_fAngle=m_fAngle;
        pE->m_fSpeed=m_fSpeed;
        m_pEngine->add(pE);
        FSOUND_PlaySound(FSOUND_FREE,GetSample(SND_EXPLODE));
    }
    else
    {
       if (pObstacle != NULL)
       {
            double e = evade(pObstacle->m_fX,pObstacle->m_fY,50,200);
            if ( e!=0 )
            {
                m_fAngleSeek = m_fAngle + e;
                m_fSpeed = m_fMaxSpeed /2;
            }
       }
       //m_fSpeed=0;
       Control();
    }

}



void bsgRaider::Fire()
{

    if (m_fFireDelay<=0)
    {
        int nOfsX=-15;
        int nOfsY=15;

        float fL1X=(m_fX+((-nOfsX*m_fCosAngle)-(-nOfsY*m_fSinAngle)));
        float fL1Y=(m_fY+((-nOfsY*m_fCosAngle)+(-nOfsX*m_fSinAngle)));
        float fL2X=(m_fX+((-nOfsX*m_fCosAngle)-(+nOfsY*m_fSinAngle)));
        float fL2Y=(m_fY+((+nOfsY*m_fCosAngle)+(-nOfsX*m_fSinAngle)));

        bsgBullet * pB;
        pB=new bsgBullet(BT_LASER2);
        pB->m_fX=fL1X;
        pB->m_fY=fL1Y;
        pB->m_nZ=m_nZ-1;
        pB->m_fSpeed=m_fSpeed+6;
        pB->m_fAngle=m_fAngle;
        pB->m_nTeam=m_nTeam;
        m_pEngine->add(pB)
        ;

        pB=new bsgBullet(BT_LASER2);
        pB->m_fX=fL2X;
        pB->m_fY=fL2Y;
        pB->m_nZ=m_nZ-1;
        pB->m_fSpeed=m_fSpeed+6;
        pB->m_fAngle=m_fAngle;
        pB->m_nTeam=m_nTeam;
        m_pEngine->add(pB);


        float fD = distance(m_fX,m_fY,m_pEngine->m_nCameraX,m_pEngine->m_nCameraY);

        int nCannelHandle=FSOUND_PlaySound(FSOUND_FREE,GetSample(SND_RAIDERLASER));

        if (fD<400)
        {
            FSOUND_SetVolume(nCannelHandle,255);
        }
        else
        {
            FSOUND_SetVolume(nCannelHandle,100);
        }

        m_fFireDelay=20;
    }

}


void bsgRaider::Ai_Chase(float a_fLagCount)
{
    if (m_pTarget!=NULL)
    {
        float fD = distance(m_fX,m_fY,m_pTarget->m_fX,m_pTarget->m_fY);
        float fShotLead=fD/12;
        float fSX=m_pTarget->m_fX+m_pTarget->m_fCosAngle*m_pTarget->m_fSpeed*fShotLead;
        float fSY=m_pTarget->m_fY+m_pTarget->m_fSinAngle*m_pTarget->m_fSpeed*fShotLead;

        m_fAngleSeek=waypoint(fSX,fSY);

        m_fSpeed=fD/50;

        if (m_fSpeed>m_fMaxSpeed)
        {
            m_fSpeed=m_fMaxSpeed;
        }

        if (m_fSpeed<m_fMaxSpeed/2)
        {
            m_fSpeed=m_fMaxSpeed/2;
        }

        float fT=m_fAngleSeek-m_fAngle;
        if (fT<0)
            fT=-fT;
        if ((fD<=600)&&(fD>100)&&(fT<0.1))
        {
            Fire();
        }


        if ((fD<=1500)&&(fD>300)&&(fT<0.2))
        {
            FireSpartan();
        }



        if (fD<50)
        {
           m_nAI=AI_EVADE;
        }
    }
    else
    {
        // ToDo pick another AI state
        m_fAngleSeek=waypoint(m_fWX,m_fWY);
        m_fSpeed=m_fMaxSpeed/2;


    }

}



void bsgRaider::Ai_Evade(float a_fLagCount)
{
    if (m_pTarget!=NULL)
    {
        float fD = distance(m_fX,m_fY,m_pTarget->m_fX,m_pTarget->m_fY);

        float fSX=m_pTarget->m_fX;
        float fSY=m_pTarget->m_fY;
        float fTargetAngle=waypoint(fSX,fSY);
        m_fAngleSeek=fTargetAngle+2*PI;
        m_fSpeed=m_fMaxSpeed;

        float fT=fTargetAngle-m_fAngle;
        if (fT<0)
        {
            fT=-fT;
        }

        if ((fD<=600)&&(fD>100)&&(fT<0.1))
        {
            Fire();
        }

        if ((fD>600)||(fT<1))
        {
           m_nAI=AI_CHASE;
        }


    }
    else
    {
        // ToDo pick another AI state
        m_fAngleSeek=waypoint(m_fWX,m_fWY);
        m_fSpeed=m_fMaxSpeed/2;


    }

}










bool LoadRaiderSprites()
{
    g_pimRaider = new Bitmap("Gfx/Still/Raider.png");
    g_pimRaiderShadow = new Bitmap("Gfx/Still/Raidershd.png");

    if ((g_pimRaider!=NULL)&&(g_pimRaiderShadow!=NULL))
    {
            return true;
    }
    else
    {
           return false;
    }
}






