#include <iostream>
#include <fstream>
#include <string>
#include "AIdef.h"
#include "Engine.h"
#include "bsgBattlestar.h"
#include "bsgShip.h"
#include "bsgViper.h"
#include "bsgPlayer.h"
#include "bsgRaider.h"
#include "bsgBullet.h"
#include "bsgSmoke.h"
#include "bsgExplosion.h"
#include "particle.h"
#include "spartan.h"
#include "bsgTurret.h"
#include "bsgShuttle.h"
#include "bsgTanker.h"
#include "bsgMission.h"

//readingmode
#define RM_NONE          0
#define RM_MISSION       1
#define RM_GALACTICA     2
#define RM_BASESTAR      3
#define RM_PLAYER        4
#define RM_VIPER         5
#define RM_RAIDER        6
#define RM_SHUTTLE       7
#define RM_TANKER        8
#define RM_OBJECT       14
#define RM_PLANET       15
#define RM_NEXTMISSION  20
#define RM_EPILOGUE     50

//reading parameter
#define RP_NONE           0
#define RP_VIPERS         1
#define RP_RAIDERS        2
#define RP_X              3
#define RP_Y              4
#define RP_ANGLE          5
#define RP_SPEED          6
#define RP_WX             7
#define RP_WY             8
#define RP_IGNORE         9
#define RP_TARGET        10
#define RP_TARGETTYPE    11
#define RP_M             12
#define RP_MC            13
#define RP_DISCOVER      14
#define RP_TIME          20
#define RP_MOVETIME      21
#define RP_ID            22
#define RP_ESCORT        23

// constructor
bsgMission::bsgMission()
{
  m_nScore      =    0;
  m_nTargets    =    0;
  m_nProtects   =    0;
  m_fTX         = 5000;
  m_fTY         = 5000;

  m_blFail          = false;
  m_blTargetEscaped = false;

  m_pTraveler   = NULL;
  m_pEngine     = NULL;
  m_pPlayer     = NULL;
  m_pGalactica  = NULL;

  nLineIndex    =    0;

}

//Destructor
bsgMission::~bsgMission()
{
   	m_vTargetGoal.clear();
    m_vProtectGoal.clear();
    m_vDescription.clear();
    m_vEpilogue.clear();
}

int GetTimeMinutes(string & strTime)
{
 int nReturnVal=0;
 size_t index;
 index=strTime.find_first_of(':');
 string strMinutes=strTime.substr(0,index);
 nReturnVal= atoi(strMinutes.c_str());
 return nReturnVal;
}

int GetTimeSeconds(string & strTime)
{
 int nReturnVal=0;
 size_t index;
 index=strTime.find_first_of(':');
 string strSeconds=strTime.substr(index+1,2);
 nReturnVal= atoi(strSeconds.c_str());
 return nReturnVal;
}


void bsgMission::updateLists()
{
    std::list<bsgSprite *>::iterator p=m_vTargetGoal.begin();
	while (p!=m_vTargetGoal.end())
	{
		bsgSprite* pDummy=((bsgSprite *)*p);
		if (pDummy->m_blDestroyed)
		{
			p=m_vTargetGoal.erase(p);
			m_nTargets--;
		}
		else
		{
			if (pDummy->m_blOutOfGame)
			{
			   m_blFail          = true;
			   m_blTargetEscaped = true;
			}

			p++;
		}
	}


    p=m_vProtectGoal.begin();
	while (p!=m_vProtectGoal.end())
	{
		bsgSprite* pDummy=((bsgSprite *)*p);
		if (pDummy->m_blDestroyed)
		{
			p=m_vProtectGoal.erase(p);
			m_blFail=true;
		}
		else
		{
			p++;
		}
	}

    if ((m_pTraveler!=NULL)&&(m_pTraveler->m_blDestroyed))
    {
       m_blFail=true;
       m_pTraveler=NULL;
    }

}

void bsgMission::addTarget  ( bsgSprite * a_pSprite)
{
   m_vTargetGoal.push_back(a_pSprite);
   m_nTargets++;

}


void bsgMission::addCritical( bsgSprite * a_pSprite)
{
    m_vProtectGoal.push_back(a_pSprite);
    m_nProtects++;

}


bool bsgMission::failed()
{
    return m_blFail;
}


bool bsgMission::succeeded()
{
    bool blReturn=false;

    if (!m_blFail)
    {
        if (m_vTargetGoal.empty()&& (m_pTraveler==NULL))
        {
            blReturn=true;
        }

        if ((blReturn==true)&&(m_pTraveler!=NULL))
        {
            if (distance(m_pTraveler->m_fX,m_pTraveler->m_fY,m_fTX,m_fTY)>30)
            {
                blReturn=false;
            }
        }
    }

    return blReturn;
}

bsgPlayer * bsgMission::GetPlayer()
{
    return m_pPlayer;
}

bsgBattlestar * bsgMission::GetGalactica()
{
    return m_pGalactica;
}

string bsgMission::GetFirstLine()
{
  nLineIndex=0;
  return m_vDescription[nLineIndex];
}

string bsgMission::GetFirstEpLine()
{
  nLineIndex=0;
  return m_vEpilogue[nLineIndex];
}


int bsgMission::GetTargets()
{
  return m_nTargets;
}

int bsgMission::GetProcects()
{
  return m_nProtects;
}

string bsgMission::GetNextMission()
{
   return m_strNextMission;
}

string bsgMission::GetNextLine()
{
    nLineIndex++;
    string strFail;
    if (nLineIndex<m_vDescription.size() -1)
    {
        return m_vDescription[nLineIndex];
    }
    else
    {
        strFail="<EOL>";
        return strFail;
    }
}

string bsgMission::GetNextEpLine()
{
    nLineIndex++;
    string strFail;
    if (nLineIndex<m_vEpilogue.size() -1)
    {
        return m_vEpilogue[nLineIndex];
    }
    else
    {
        strFail="<EOL>";
        return strFail;
    }
}


bool bsgMission::readMission (bsgEngine  * a_pEngine,const char * a_szFilename)
{
    bool blSucceed=false;
    bool blLeft=true;
    string line;
    char chRead;
    ifstream myfile(a_szFilename);
    int nReadingMode      = RM_NONE;
    int nReadingParameter = RP_NONE;
    float fWaypoint_X,fWaypoint_Y;
    bool blPlayer=false;
    bsgShip * pShip=NULL;

    if ( myfile.is_open())
    {
       while (! myfile.eof() )
       {
            line="";
            bool blReady=false;

            while (!blReady)
            {
                myfile.get(chRead);
                switch (chRead)
                {
                    case '\n':
                        blReady=true;
                    break;


                default:
                        line+=chRead;

                }
            }

           if (nReadingMode!=RM_MISSION)
           {
               if(line[line.size()-1]==' ')
                 {
                    line.resize(line.size()-1);
                 }
           }



            if (line=="[MISSION]")
            {
               pShip=NULL;
               nReadingMode      = RM_MISSION;
               nReadingParameter = RP_NONE;
            }
            else if (line=="[GALACTICA]")
            {

                m_pGalactica=new bsgBattlestar;
                m_pGalactica->SetPosition(5000,5000);
                a_pEngine->add(m_pGalactica);
                nReadingMode      = RM_GALACTICA;
                nReadingParameter = RP_NONE;
            }
            else if (line=="[BASESTAR]")
            {
                pShip=NULL;
                nReadingMode      = RM_BASESTAR;
                nReadingParameter = RP_NONE;
            }
            else if (line=="[PLAYER]")
            {
                pShip=NULL;
                nReadingMode      = RM_PLAYER;
                nReadingParameter = RP_NONE;
                blPlayer=true;
                m_pPlayer=new bsgPlayer;

                m_pPlayer->m_nZ=10;

                m_pPlayer->m_fX=5000;
                m_pPlayer->m_fY=5000;

                m_pPlayer->m_nILSPoint=0;
                m_pPlayer->m_blLaunching=false;

                pShip=m_pPlayer;
                a_pEngine->add(m_pPlayer);
            }
            else if (line=="[VIPER]")
            {
                pShip=NULL;
                nReadingMode      = RM_VIPER;
                nReadingParameter = RP_NONE;

                if (blLeft)
                {
                    pShip  = new bsgViper(BAY_LEFT,m_pGalactica);
                    blLeft = false;
                }
                else
                {
                    pShip  = new bsgViper(BAY_RIGHT,m_pGalactica);
                    blLeft = true;
                }

                pShip->m_blLaunching = false;

                a_pEngine->add(pShip);
            }
            else if (line=="[RAIDER]")
            {
                pShip             = NULL;
                nReadingMode      = RM_RAIDER;
                nReadingParameter = RP_NONE;

                pShip             = new bsgRaider;
                pShip->m_nZ       = 10;
                a_pEngine->add(pShip);

            }
            else if (line=="[SHUTTLE]")
            {
                pShip=NULL;
                nReadingMode      = RM_SHUTTLE;
                nReadingParameter = RP_NONE;

                pShip             = new bsgShuttle;
                pShip->m_nZ       = 9;

                ((bsgShuttle *)pShip)->m_pBattlestar= m_pGalactica;
                a_pEngine->add(pShip);

            }
            else if (line=="[TANKER]")
            {
                pShip=NULL;
                nReadingMode      = RM_TANKER;
                nReadingParameter = RP_NONE;

                pShip             = new bsgTanker;
                pShip->m_nZ       = 3;

                a_pEngine->add(pShip);
            }
            else if (line=="[OBJECT]")
            {
                pShip=NULL;
                nReadingMode      = RM_OBJECT;
                nReadingParameter = RP_NONE;
            }
            else if (line=="[PLANET]")
            {
                pShip=NULL;
                nReadingMode      = RM_PLANET;
                nReadingParameter = RP_NONE;
            }
            else if (line=="[NEXTMISSION]")
            {
                pShip=NULL;
                nReadingMode      = RM_NEXTMISSION;
                nReadingParameter = RP_NONE;
            }
            else if (line=="[EPILOGUE]")
            {
                pShip=NULL;
                nReadingMode      = RM_EPILOGUE;
                nReadingParameter = RP_NONE;
            }
            else if (line=="VIPERS")
            {
                nReadingParameter = RP_VIPERS;
            }
            else if (line=="RAIDERS")
            {
                nReadingParameter = RP_RAIDERS;
            }
            else if (line=="X")
            {
                nReadingParameter = RP_X;
            }
            else if (line=="Y")
            {
                nReadingParameter = RP_Y;
            }
            else if (line=="ANGLE")
            {
                nReadingParameter = RP_ANGLE;
            }
            else if (line=="SPEED")
            {
                nReadingParameter = RP_SPEED;
            }
            else if (line=="MC")
            {
                nReadingParameter = RP_MC;
            }
            else if (line=="M")
            {
                nReadingParameter = RP_M;
            }
            else if (line=="DISCOVER")
            {
                nReadingParameter = RP_DISCOVER;
            }
            else if (line=="WX")
            {
                nReadingParameter = RP_WX;
            }
            else if (line=="WY")
            {
                nReadingParameter = RP_WY;
            }
            else if (line=="IGNORE")
            {
                nReadingParameter = RP_IGNORE;
            }
            else if (line=="TARGET")
            {
                nReadingParameter = RP_TARGET;
            }
            else if (line=="TARGETTYPE")
            {
                nReadingParameter = RP_TARGETTYPE;
            }
            else if (line=="MUST SURVIVE")
            {
                nReadingParameter = RP_NONE;
                addCritical(pShip);
            }
            else if (line=="MISSION TARGET")
            {
                nReadingParameter = RP_NONE;
                addTarget(pShip);
            }
            else if (line=="RETREAT")
            {
                pShip->m_blRetreat=true;
                nReadingParameter = RP_NONE;
            }
            else if (line=="ID")
            {
                nReadingParameter = RP_ID;
            }
            else if (line=="ESCORT")
            {
                nReadingParameter = RP_ESCORT;
            }
            else if (line=="TIME")
            {
                nReadingParameter = RP_TIME;
            }
            else if (line=="MOVETIME")
            {
                nReadingParameter = RP_MOVETIME;
            }
            else
            {
                switch (nReadingMode)
                {
                    case  RM_MISSION:
                          m_vDescription.push_back(line);
                          break;

                    case  RM_EPILOGUE:
                          m_vEpilogue.push_back(line);
                          break;

                    case  RM_NEXTMISSION:
                          m_strNextMission=line;
                          nReadingMode=RM_NONE;
                          break;
                }


                switch (nReadingParameter)
                {
                    case RP_VIPERS :
                         {
                            int nvipers=atoi(line.c_str());
                            if (m_pGalactica!=NULL)
                            {
                                m_pGalactica->m_nVipersBay1=nvipers;
                                m_pGalactica->m_nVipersBay2=nvipers;
                            }
                            nReadingParameter = RP_NONE;
                         }
                         break;

                    case RP_RAIDERS:

                         nReadingParameter = RP_NONE;
                         break;

                    case RP_X:
                           if (pShip!=NULL)
                           {
                               pShip->m_fX=atof(line.c_str());
                           }
                           nReadingParameter = RP_NONE;
                         break;

                    case RP_Y:
                           if (pShip!=NULL)
                           {
                                pShip->m_fY=atof(line.c_str());
                           }
                           nReadingParameter = RP_NONE;
                         break;

                    case RP_ANGLE:
                         if (pShip!=NULL)
                           {
                                pShip->m_fAngle=atof(line.c_str());
                                pShip->m_fAngleSeek=pShip->m_fAngle;
                           }
                           nReadingParameter = RP_NONE;
                           break;

                    case RP_SPEED:
                         if (pShip!=NULL)
                           {
                                pShip->m_fSpeed=atof(line.c_str());
                           }
                           nReadingParameter = RP_NONE;
                           break;


                    case RP_WX:
                            fWaypoint_X=atof(line.c_str());
                            nReadingParameter = RP_NONE;
                         break;

                    case RP_WY:
                            fWaypoint_Y=atof(line.c_str());
                            nReadingParameter = RP_NONE;
                         break;

                    case RP_IGNORE:
                         if (pShip!=NULL)
                         {
                            if (line=="YES")
                            {
                                pShip->SetWaypoint(fWaypoint_X,fWaypoint_Y,true);
                            }
                            else
                            {
                                pShip->SetWaypoint(fWaypoint_X,fWaypoint_Y,false);
                            }
                         }
                         nReadingParameter = RP_NONE;
                         break;

                    case RP_TARGET:
                         nReadingParameter = RP_NONE;
                         break;

                    case RP_TARGETTYPE:
                         nReadingParameter = RP_NONE;
                         break;

                    case RP_ID:
                         if (pShip!=NULL)
                         {
                            pShip->m_nID = atoi(line.c_str());
                         }

                         nReadingParameter = RP_NONE;
                         break;

                   case RP_ESCORT:
                         if (pShip!=NULL)
                         {
                            pShip->m_nEscortID = atoi(line.c_str());
                         }

                         nReadingParameter = RP_NONE;
                         break;


                    case RP_M:
                         if (pShip!=NULL)
                         {
                            pShip->m_nMissiles=atoi(line.c_str());
                         }
                         nReadingParameter = RP_NONE;
                         break;

                    case RP_MC:

                         nReadingParameter = RP_NONE;
                         break;

                    case RP_DISCOVER:

                         nReadingParameter = RP_NONE;
                         break;

                   case RP_TIME:
                        {
                        string strTime=line;

                        if (pShip!=NULL)
                        {
                            pShip->m_blDisabled=true;
                            pShip->m_nTimeMin=GetTimeMinutes(strTime);
                            pShip->m_nTimeSec=GetTimeSeconds(strTime);
                        }


                        nReadingParameter = RP_NONE;
                        }
                        break;

                   case RP_MOVETIME:
                        {
                           string strTime=line;

                           if (nReadingMode == RM_GALACTICA)
                           {
                             m_pGalactica->m_blTimedMovement = true;
                             m_pGalactica->m_nTimeMin=GetTimeMinutes(strTime);
                             m_pGalactica->m_nTimeSec=GetTimeSeconds(strTime);
                           }

                           else if (pShip!=NULL)
                           {
                             pShip->m_blTimedMovement = true;
                             pShip->m_nTimeMin=GetTimeMinutes(strTime);
                             pShip->m_nTimeSec=GetTimeSeconds(strTime);

                           }

                        nReadingParameter = RP_NONE;
                        }
                        break;

                 }
            }
       }
       myfile.close();
    }
    else
    {
        exit(1);
    }

    if (!blPlayer)
    {
       m_pGalactica->m_nPlayerDocked=true;
    }
    else
    {
       m_pGalactica->m_nPlayerDocked=false;
       m_pPlayer->m_pBattlestar=m_pGalactica;
       m_pPlayer->SetBay(BAY_LEFT);
    }


    std::list<bsgSprite *>::iterator p=a_pEngine->m_lstItems.begin();
    while (p!=a_pEngine->m_lstItems.end())
    {
      bsgSprite * pHulp=((bsgSprite *)*p);
      if (pHulp->m_nType >= ID_SHIP)
      {
        ((bsgShip *)pHulp)->SeekEscort();
      }
      p++;
    }

    a_pEngine->Sort();

    return blSucceed;
}



