/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


#include <FMOD/fmod.h>


#include "bsgLeftBay.h"
#include "main.h"
#include "AIdef.h"
#include "bsgSmoke.h"
#include "bsgExplosion.h"

void bsgLeftBay::draw(int a_nCameraX,int a_nCameraY)
{
    int nImageMidX=m_pImage->Width();
	int nImageMidY=m_pImage->Height();
    int nDrawX=int(SCREENCENTER_X+(m_fX-a_nCameraX)-nImageMidX/2);
	int nDrawY=int(SCREENCENTER_Y+(m_fY-a_nCameraY)-nImageMidY/2);
	// only draw what we see

	if ((m_pImage!=NULL)&&(nDrawX+nImageMidX>-100)&&(nDrawX<900)&&(nDrawY+nImageMidY>-100)&&(nDrawY<900))
	{
		m_pImage->Blit(nDrawX, nDrawY);
	}
}


void bsgLeftBay::DoCollision(bsgSprite * a_pSprite)
{
    if ((a_pSprite!=NULL)&& (a_pSprite->m_nType>ID_NONE)&&(a_pSprite->m_nType<ID_BULLET)&&(a_pSprite->m_nTeam!=m_nTeam))
    {
        bsgSmoke * pS;
        pS=new bsgSmoke;
        pS->m_fX=a_pSprite->m_fX;
        pS->m_fY=a_pSprite->m_fY;
        pS->m_fAngle=m_fAngle;
        pS->m_fSpeed=m_fSpeed-1;
        pS->m_nZ=m_nZ+1;
        m_pEngine->add(pS);


        m_nHealth-=35;
        a_pSprite->m_blDestroyed=true;


        float fD = distance(m_fX,m_fY,m_pEngine->m_nCameraX,m_pEngine->m_nCameraY);
        int nCannelHandle=FSOUND_PlaySound(FSOUND_FREE,GetSample(SND_HIT));
        if (fD<400)
        {
            FSOUND_SetVolume(nCannelHandle,255);
        }
        else
        {
            FSOUND_SetVolume(nCannelHandle,100);
        }


   }
}




void bsgLeftBay::do_ai(float a_fLagCount)
{

if ((m_nHealth<=0)&&(!m_blDestroyed))
    {
        m_blDestroyed=true;
        bsgExplosion * pE;
        pE=new bsgExplosion;
        pE->m_nZ=m_nZ+1;
        pE->m_fX=m_fX;
        pE->m_fY=m_fY;
        pE->m_fAngle=m_fAngle;
        pE->m_fSpeed=m_fSpeed;
        m_pEngine->add(pE);

        float fD = distance(m_fX,m_fY,m_pEngine->m_nCameraX,m_pEngine->m_nCameraY);
        int nCannelHandle=FSOUND_PlaySound(FSOUND_FREE,GetSample(SND_EXPLODE));
        if (fD<400)
        {
            FSOUND_SetVolume(nCannelHandle,255);
        }
        else
        {
            FSOUND_SetVolume(nCannelHandle,100);
        }

    }
}



bsgLeftBay::bsgLeftBay()
{
    m_blCanCollide=true;
    m_nTeam=MEM_COLONY;
    m_nType=ID_GALACTICA_PART;
    m_fSpeed=0;
    m_nZ=4;
    m_nMaxHealth=1000;
    m_nHealth=m_nMaxHealth;
}

bsgLeftBay::~bsgLeftBay()
{

}

