/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


#ifndef _BSGGUI
#define _BSGGUI


#include <allegro.h>
#include <OpenLayer.hpp>
#include <fstream>
#include <iostream>
#include <list>
#include <vector>
#include <string>


using namespace ol;
using namespace std;



class bsgPlayerInfo
{
public:
  char m_szPlayerName [80];
  char m_szRank       [80];
  char m_szMission    [80];
  bool m_blMedals     [50];

  int  m_nPoints;
  int  m_nMissionNr;
  void Serialize ( ofstream & a_OutputStream);
  void Unserialize( ifstream & a_InputStream);
  bsgPlayerInfo();

};


// basic gui object
class bsgGUIObject
{
friend class bsgGUI;

private:



protected:
  bsgGUI * m_pGUI;
  bsgGUIObject * m_pParentObject;


  int m_nX;
  int m_nY;
  int m_nZ;
  int m_nWidth;
  int m_nHeight;
  bool m_blVisible;
  bool m_blHasFocus;

  Rgba * m_clrBrush;
  Rgba * m_clrPen;
  Shape * m_shpIn;
  Shape * m_shpOut;

public:

  bool m_blDestroyed;
  bsgGUIObject();
  virtual ~bsgGUIObject();
  bool RemoveFromList();
  void Remove();
  bool Capture(TextRenderer * a_pTextRenderer);


  virtual void Draw(TextRenderer * m_pTextRenderer) = 0;
  virtual void Handle(TextRenderer * a_pTextRenderer) = 0;

};

class bsgConfirmDLG;

class bsgButton: public bsgGUIObject
{
 private:
  string m_strCaption;
  void (*pFunction)();
  bool m_blButtonDown;
  bool m_blIsClicked;

 public:

  bsgButton(int a_nLeft, int a_nTop, int a_nRight, int a_nBottom, char * a_szCaption ,void (*a_pFunction)()=NULL);
  virtual ~bsgButton();
  bool IsClicked();

  virtual void Draw(TextRenderer * a_pTextRenderer);
  virtual void Handle(TextRenderer * a_pTextRenderer);
};



class bsgEditBox: public bsgGUIObject
{
 private:
  string m_strText;
  int    m_nBlinkTime;
  int    m_nCarretPos;
  int    m_nCountDown;
  bool   m_blCarretBlink;
 protected:


 public:
  bsgEditBox(int a_nLeft, int a_nTop, int a_nRight, int a_nBottom);
  virtual ~bsgEditBox();
  string GetText();
  void   Clear();

  virtual void Draw(TextRenderer * a_pTextRenderer);
  virtual void Handle(TextRenderer * a_pTextRenderer);

};


//ToDo: listbox
class bsgListBox: public bsgGUIObject
{
 private:
  std::list <string *> m_lstLines;
  int    m_nBlinkTime;
  int    m_nCarretPos;
  int    m_nCountDown;
  bool   m_blCarretBlink;
  int    m_nTextHeight;
  int    m_nSelectionIndex;
  bool   m_blKeyLock;
 protected:


 public:
  void SetSelection(int a_nIndex);
  void RemoveSelection();
  bsgListBox(int a_nLeft, int a_nTop, int a_nRight, int a_nBottom);
  virtual ~bsgListBox();
  void AddLine( string a_strLine, bool a_blSelect);
  string GetSelection();
  int    GetSelectionIndex();
  void   RemoveLast();
  void   Clear();
  string GetLine(int a_nIndex);

  virtual void Draw(TextRenderer * a_pTextRenderer);
  virtual void Handle(TextRenderer * a_pTextRenderer);


};


//ToDo: listbox
class bsgChoosePlayerDLG: public bsgGUIObject
{
  private:
    void (*pFunction)(const char *);

    bsgListBox * m_pList;
    bsgButton  * m_pSelect;
    bsgButton  * m_pNew;
    bsgButton  * m_pDelete;

    bsgConfirmDLG * m_pConfirm;
    string m_strCaption;


  protected:


  public:
    string GetLine(int a_nIndex);
    int GetSelection();
    void ClearList();
    void SetSelection(int a_nIndex);
    bsgPlayerInfo * GetRecord(const char * a_strPlayer);
    bsgChoosePlayerDLG(int a_nLeft, int a_nTop,void (*a_pFunction)(const char*)=NULL);
    virtual ~bsgChoosePlayerDLG();
    void SetCaption(string a_strCaption);
    void AddItem(string a_strItem,bool a_blSelect);
    virtual void Draw(TextRenderer * a_pTextRenderer);
    virtual void Handle(TextRenderer * a_pTextRenderer);
};


class bsgAddPlayerDLG: public bsgGUIObject
{
  private:
    bsgChoosePlayerDLG * m_pList;
    bsgEditBox * m_pEdit;
    bsgButton  * m_pAdd;
    bsgButton  * m_pCancel;
    string m_strCaption;

  protected:


  public:
    bsgAddPlayerDLG(int a_nLeft, int a_nTop,bsgChoosePlayerDLG * a_pList=NULL);
    virtual ~bsgAddPlayerDLG();
    void SetCaption(string a_strCaption);
    virtual void Draw(TextRenderer * a_pTextRenderer);
    virtual void Handle(TextRenderer * a_pTextRenderer);
};


class bsgConfirmDLG: public bsgGUIObject
{
 private:
 bsgButton  * m_pYes;
 bsgButton  * m_pNo;
 int m_nClicked;
 string m_strCaption;

 protected:

 public:
  bool IsYes();
  bool IsNo();

  bsgConfirmDLG(int a_nLeft, int a_nTop,char * a_szCaption);
  virtual ~bsgConfirmDLG();
  void Close();
  virtual void Draw(TextRenderer * a_pTextRenderer);
  virtual void Handle(TextRenderer * a_pTextRenderer);
};




// the gui engine
class bsgGUI
{
private:
  std::list <bsgGUIObject *> m_lstItems;
  TextRenderer * m_pTextRenderer;
  Bitmap * m_pCursor;
  int m_nMouseX,m_nMouseY;
  bsgGUIObject * m_pFocus;

public:

  int  m_nObjectCount;
  bool m_blVisible;
  bsgGUI(TextRenderer * a_pTextRenderer,Bitmap * a_pCursor=NULL);
  ~bsgGUI();
  void Add(bsgGUIObject * a_pGuiObject);
  void SetCursor(Bitmap * a_pCursor);
  void SetFocus (bsgGUIObject * a_pSender);
  void Draw();
  void Handle();
  void Remove();
  void RemoveAll();
  void RemoveQueryAll();
};


void saveRecords();
#endif
