/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "bsgGUI.h"
extern ofstream g_Logfile;

list <bsgPlayerInfo *> g_lstPlayerInfo;


bsgPlayerInfo::bsgPlayerInfo()
{
  strcpy(m_szPlayerName,"");
  strcpy(m_szRank,      "");
  strcpy(m_szMission,   "");
  for (int i=0;i<50;i++)
  {
    m_blMedals[i]=false;
  }

  m_nPoints    = 0;
  m_nMissionNr = 0;

};

void saveRecords()
{
  g_Logfile << "Saving records \n";
  g_Logfile.flush();
  ofstream sPlayerFile("Data.bsg",ios::binary);
  size_t nRecords = g_lstPlayerInfo.size();
  if (sPlayerFile)
  {
    sPlayerFile.write((char *) &nRecords, 4);
    bsgPlayerInfo * pDummy;
    std::list<bsgPlayerInfo *>::iterator P=g_lstPlayerInfo.begin();
    int i=0;
    while (P!=g_lstPlayerInfo.end())
    {
      pDummy=((bsgPlayerInfo *)*P);
      pDummy->Serialize(sPlayerFile);
      i++;
      P++;
    }
    sPlayerFile.close();
  }
}


void bsgPlayerInfo::Serialize ( ofstream & a_OutputStream)
{
  g_Logfile << "Saving Player Info \n";
  g_Logfile.flush();
  a_OutputStream.write(m_szPlayerName,      80);
  a_OutputStream.write(m_szRank,            80);
  a_OutputStream.write(m_szMission,         80);
  a_OutputStream.write((char*) m_blMedals,  50);
  a_OutputStream.write((char*)&m_nPoints,    4);
  a_OutputStream.write((char*)&m_nMissionNr, 4);
}

void bsgPlayerInfo::Unserialize( ifstream & a_InputStream)
{
  g_Logfile << "Loading Player Info \n";
  g_Logfile.flush();
  a_InputStream.read(m_szPlayerName,       80);
  a_InputStream.read(m_szRank,             80);
  a_InputStream.read(m_szMission,          80);
  a_InputStream.read((char *) m_blMedals,  50);
  a_InputStream.read((char*) &m_nPoints,    4);
  a_InputStream.read((char*) &m_nMissionNr, 4);
}





bsgConfirmDLG::bsgConfirmDLG(int a_nLeft, int a_nTop, char * a_szCaption)
{
  m_nX         =  a_nLeft;
  m_nY         =  a_nTop;
  m_nZ         =   1;
  m_nClicked   =  -1;
  m_strCaption =  a_szCaption;
  m_nClicked   =  50;

  m_nWidth  = 150;
  m_nHeight = 100;

  m_clrBrush = new Rgba(0.7,0.7,0.7);
  m_clrPen   = new Rgba(0.3,0.3,0.3);
  m_shpIn    = new Rect(m_nX,m_nY,m_nWidth,m_nHeight);
  m_shpOut   = new Rect(m_nX,m_nY,m_nWidth,m_nHeight);

  m_pYes = new bsgButton(m_nX+10,m_nY+m_nHeight-35,m_nX+55,m_nY+m_nHeight-10,"Yes");
  m_pNo  = new bsgButton(m_nX+90,m_nY+m_nHeight-35,m_nX+140,m_nY+m_nHeight-10,"No");

 g_Logfile << "Confirm dialog created \n";
 g_Logfile.flush();
}


bsgConfirmDLG::~bsgConfirmDLG()
{
  g_Logfile << "Destroying confirm dialog ... \n";
  g_Logfile.flush();

  if (m_pYes   != NULL)
  {
    delete m_pYes;
    m_pYes=NULL;
  }
  if (m_pNo != NULL)
  {
    delete m_pNo;
    m_pNo=NULL;
  }
  g_Logfile << "Confirm dialog destroyed \n";
 g_Logfile.flush();
}

void bsgConfirmDLG::Close()
{
 Remove();
}


bool bsgConfirmDLG::IsYes()
{
  if (m_nClicked==1) return true;
      else return false;
}

bool bsgConfirmDLG::IsNo()
{
  if (m_nClicked==2) return true;
      else return false;
}



void bsgConfirmDLG::Draw(TextRenderer * a_pTextRenderer)
{
   int nTextWidth   = a_pTextRenderer->Width(m_strCaption);
   int nMiddButtonX = m_nX+(m_nWidth/2);
   int nHalfSizeX   = nTextWidth/2;
   if ((m_clrBrush!=NULL) && (m_shpIn!=NULL)) m_shpIn->Draw(*m_clrBrush);
   if ((m_clrPen!=NULL) && (m_shpOut!=NULL))  m_shpOut->DrawOutline(*m_clrPen);
   int nHeight = a_pTextRenderer->Height(m_strCaption);
   Rgba originalColor = a_pTextRenderer->GetColor();
   a_pTextRenderer->SetColor(Rgba::BLACK);
   a_pTextRenderer->Print(m_strCaption,nMiddButtonX-nHalfSizeX,m_nY+nHeight);
   a_pTextRenderer->SetColor(originalColor);

   if (m_pYes   != NULL)
   {
     m_pYes->Draw(a_pTextRenderer);
   }

   if (m_pNo != NULL)
   {
      m_pNo->Draw(a_pTextRenderer);
   }


}

void bsgConfirmDLG::Handle(TextRenderer * a_pTextRenderer)
{
    if (m_pYes != NULL)
    {
      m_pYes->Handle(a_pTextRenderer);

      if (m_pYes->IsClicked())
      {
         m_nClicked=1;
      }
    }

    if (m_pNo != NULL)
    {
      m_pNo->Handle(a_pTextRenderer);

      if (m_pNo->IsClicked())
      {
         m_nClicked=2;
      }
    }


}


bsgAddPlayerDLG::bsgAddPlayerDLG(int a_nLeft, int a_nTop,bsgChoosePlayerDLG * a_pList)
{
 m_pList = NULL;
 m_pList = a_pList;
 m_nX    = a_nLeft;
 m_nY    = a_nTop;
 m_nZ    = 1;

 m_strCaption="Add Player";

 m_nWidth  = 300;
 m_nHeight = 100;

 m_clrBrush = new Rgba(0.7,0.7,0.7);
 m_clrPen   = new Rgba(0.3,0.3,0.3);
 m_shpIn    = new Rect(m_nX,m_nY,m_nWidth,m_nHeight);
 m_shpOut   = new Rect(m_nX,m_nY,m_nWidth,m_nHeight);

 m_pEdit   = new bsgEditBox(m_nX+5,m_nY+20,m_nX+m_nWidth-5,m_nY+m_nHeight-50);
 m_pAdd    = new bsgButton(m_nX+5,m_nY+m_nHeight-35,m_nX+50,m_nY+m_nHeight-10,"Add");
 m_pCancel = new bsgButton(m_nX+120,m_nY+m_nHeight-35,m_nX+195,m_nY+m_nHeight-10,"Cancel");

 g_Logfile << "Add Player dialog created \n";
 g_Logfile.flush();

}

bsgAddPlayerDLG::~bsgAddPlayerDLG()
{
  g_Logfile << "Destroying AddPlayer Dialog... \n";
  g_Logfile.flush();

  if (m_pAdd != NULL)
  {
    delete m_pAdd;
  }
  if (m_pCancel    != NULL)
  {
    delete m_pCancel;
  }

  if (m_pEdit   != NULL)
  {
    delete m_pEdit;
  }

  g_Logfile << "Add Player dialog destroyed \n";
  g_Logfile.flush();
}

void bsgAddPlayerDLG::SetCaption(string a_strCaption)
{
 m_strCaption = a_strCaption;
}

void bsgAddPlayerDLG::Draw(TextRenderer * a_pTextRenderer)
{
   int nTextWidth   = a_pTextRenderer->Width(m_strCaption);
   int nMiddButtonX = m_nX+(m_nWidth/2);
   int nHalfSizeX   = nTextWidth/2;
   if ((m_clrBrush!=NULL) && (m_shpIn!=NULL)) m_shpIn->Draw(*m_clrBrush);
   if ((m_clrPen!=NULL) && (m_shpOut!=NULL))  m_shpOut->DrawOutline(*m_clrPen);
   int nHeight = a_pTextRenderer->Height(m_strCaption);
   Rgba originalColor = a_pTextRenderer->GetColor();
   a_pTextRenderer->SetColor(Rgba::BLACK);
   a_pTextRenderer->Print(m_strCaption,nMiddButtonX-nHalfSizeX,m_nY+nHeight);
   a_pTextRenderer->SetColor(originalColor);

    if (m_pEdit   != NULL)
    {
      m_pEdit->Draw(a_pTextRenderer);
    }
    if (m_pAdd != NULL)
    {
      m_pAdd->Draw(a_pTextRenderer);
    }
    if (m_pCancel    != NULL)
    {
      m_pCancel->Draw(a_pTextRenderer);
    }
}

void bsgAddPlayerDLG::Handle(TextRenderer * a_pTextRenderer)
{
  if (m_pEdit   != NULL)
    {
      m_pEdit->Handle(a_pTextRenderer);
    }

  if (m_pAdd != NULL)
    {
      m_pAdd->Handle(a_pTextRenderer);

      if (m_pAdd->IsClicked()|| key[KEY_ENTER])
      {
        g_Logfile << " Add player clicked \n" ;
        g_Logfile.flush();
        if (m_pList!=NULL)
        {
          g_Logfile << "Getting text of editbox \n";
          g_Logfile.flush();
          string strText=m_pEdit->GetText();
          assert(strText!="");
          g_Logfile << "Edit Box returned " << strText.c_str() << " \n";
          g_Logfile.flush();

          m_pList->AddItem(strText,true);

        }
        g_Logfile << "Flag AddPlayer Dialog for destruction \n";
        g_Logfile.flush();

        Remove();
      }
    }

  if (m_pCancel != NULL)
    {
      m_pCancel->Handle(a_pTextRenderer);
      if (m_pCancel->IsClicked())
      {
        g_Logfile << " Cancel button clicked \n" ;
        g_Logfile.flush();
        Remove();
      }
    }

}



bsgChoosePlayerDLG::bsgChoosePlayerDLG(int a_nLeft, int a_nTop,void (*a_pFunction)(const char *))
{
  pFunction = a_pFunction;
  m_nX         = a_nLeft;
  m_nY         = a_nTop;
  m_nZ         = 1;
  m_pConfirm   = NULL;

  m_nWidth  = 200;
  m_nHeight = 400;

  m_clrBrush = new Rgba(0.7,0.7,0.7);
  m_clrPen   = new Rgba(0.3,0.3,0.3);
  m_shpIn    = new Rect(m_nX,m_nY,m_nWidth,m_nHeight);
  m_shpOut   = new Rect(m_nX,m_nY,m_nWidth,m_nHeight);

  m_pList   = new bsgListBox(m_nX+5,m_nY+20,m_nX+m_nWidth-5,m_nY+m_nHeight-40);
  m_pDelete = new bsgButton(m_nX+5,m_nY+m_nHeight-35,m_nX+50,m_nY+m_nHeight-10,"Delete");
  m_pNew    = new bsgButton(m_nX+60,m_nY+m_nHeight-35,m_nX+130,m_nY+m_nHeight-10,"New Pilot");
  m_pSelect = new bsgButton(m_nX+140,m_nY+m_nHeight-35,m_nX+195,m_nY+m_nHeight-10,"Start");


  ifstream sPlayerFile("Data.bsg",ios::binary);
  m_pList->Clear();
  ClearList();
  bsgPlayerInfo * pInfo;
  size_t nRecords=0;
  if (sPlayerFile)
  {
     sPlayerFile.read((char *) &nRecords, 4);
     for (size_t i=0;i<nRecords;i++)
     {
       pInfo = new bsgPlayerInfo;
       pInfo->Unserialize(sPlayerFile);

       g_lstPlayerInfo.push_back(pInfo);
       m_pList->AddLine(pInfo->m_szPlayerName, false);
     }
  sPlayerFile.close();
  }
 g_Logfile << "Choose Player dialog created \n";
 g_Logfile.flush();
}


void bsgChoosePlayerDLG::ClearList()
{
 if (!g_lstPlayerInfo.empty())
    {
      std::list<bsgPlayerInfo *>::iterator p=g_lstPlayerInfo.begin();
	  while (p!=g_lstPlayerInfo.end())
	  {
		bsgPlayerInfo * pDummy=((bsgPlayerInfo *)*p);
		p=g_lstPlayerInfo.erase(p);
		delete pDummy;
      }
    }
}



bsgChoosePlayerDLG::~bsgChoosePlayerDLG()
{
  g_Logfile << "Destroying Choose Player dialog ... \n";
  g_Logfile.flush();

  ofstream sPlayerFile("Data.bsg",ios::binary);
  size_t nRecords = g_lstPlayerInfo.size();
  if (sPlayerFile)
  {
    sPlayerFile.write((char *) &nRecords, 4);
    bsgPlayerInfo * pDummy;
    std::list<bsgPlayerInfo *>::iterator P=g_lstPlayerInfo.begin();
    while (P!=g_lstPlayerInfo.end())
    {
      pDummy=((bsgPlayerInfo *)*P);
      pDummy->Serialize(sPlayerFile);
      P++;
    }
    sPlayerFile.close();
  }

  if (m_pList   != NULL)
  {
    delete m_pList;
  }
  if (m_pSelect != NULL)
  {
    delete m_pSelect;
  }
  if (m_pNew    != NULL)
  {
    delete m_pNew;
  }
  if (m_pDelete    != NULL)
  {
    delete m_pDelete;
  }

  g_Logfile << "Choose player dialog destroyed \n";
  g_Logfile.flush();
}

void bsgChoosePlayerDLG::Draw(TextRenderer * a_pTextRenderer)
{

    int nTextWidth   = a_pTextRenderer->Width(m_strCaption);
    int nMiddButtonX = m_nX+(m_nWidth/2);
    int nHalfSizeX   = nTextWidth/2;


    if ((m_clrBrush!=NULL) && (m_shpIn!=NULL)) m_shpIn->Draw(*m_clrBrush);
    if ((m_clrPen!=NULL) && (m_shpOut!=NULL))  m_shpOut->DrawOutline(*m_clrPen);
    int nHeight = a_pTextRenderer->Height(m_strCaption);
    Rgba originalColor = a_pTextRenderer->GetColor();
    a_pTextRenderer->SetColor(Rgba::BLACK);
    a_pTextRenderer->Print(m_strCaption,nMiddButtonX-nHalfSizeX,m_nY+nHeight);
    a_pTextRenderer->SetColor(originalColor);

    if (m_pList   != NULL)
    {
      m_pList->Draw(a_pTextRenderer);
    }
    if (m_pSelect != NULL)
    {
      m_pSelect->Draw(a_pTextRenderer);
    }
    if (m_pNew    != NULL)
    {
      m_pNew->Draw(a_pTextRenderer);
    }

    if (m_pDelete    != NULL)
    {
      m_pDelete->Draw(a_pTextRenderer);
    }

    if (m_pConfirm!=NULL)
    {
       if (m_pConfirm->IsYes())
       {
         int nIndex = m_pList->GetSelectionIndex();
         string strName= "<FAIL>";
         strName = m_pList->GetLine(nIndex);
         assert(strName!="<FAIL>");

         bsgPlayerInfo * pDummy;
         list<bsgPlayerInfo *>::iterator P=g_lstPlayerInfo.begin();
         while (P!=g_lstPlayerInfo.end())
         {
            pDummy = ((bsgPlayerInfo *) *P);
            if (!strcmp(pDummy->m_szPlayerName,strName.c_str()))
            {
               P=g_lstPlayerInfo.erase(P);
               delete pDummy;
            }
            else
            {
               P++;
            }
         }


         m_pList->RemoveSelection();
         m_pConfirm->Close();
       }

       if (m_pConfirm->IsNo())
       {
          m_pConfirm->Close();
       }
    }
}

void bsgChoosePlayerDLG::SetCaption(string a_strCaption)
{
  m_strCaption = a_strCaption;
}


void bsgChoosePlayerDLG::AddItem(string a_strItem, bool a_blSelect)
{
    g_Logfile << "Adding item " << a_strItem.c_str() << " \n";
    g_Logfile.flush();

    bsgPlayerInfo * pInfo= new bsgPlayerInfo;
    strcpy(pInfo->m_szPlayerName,a_strItem.c_str());
    strcpy(pInfo->m_szRank,"Rookie");
    strcpy(pInfo->m_szMission,"<EMPTY>");
    g_lstPlayerInfo.push_back(pInfo);

    m_pList->AddLine(a_strItem, a_blSelect);
}

string bsgChoosePlayerDLG::GetLine(int a_nIndex)
{
  string strResult;
  strResult= m_pList->GetLine(a_nIndex);
  return strResult;
}


int bsgChoosePlayerDLG::GetSelection()
{
  return m_pList->GetSelectionIndex();
}

void bsgChoosePlayerDLG::SetSelection(int a_nIndex)
{
   m_pList->SetSelection(a_nIndex);
}

bsgPlayerInfo * bsgChoosePlayerDLG::GetRecord( const char * a_strPlayer)
{
    g_Logfile << "Get record with name " << a_strPlayer << " \n";
    g_Logfile.flush();
    bsgPlayerInfo * pInfo=NULL;
    bsgPlayerInfo * pDummy;
    list<bsgPlayerInfo *>::iterator P=g_lstPlayerInfo.begin();
    while ((P!=g_lstPlayerInfo.end()) && (pInfo==NULL))
    {
         pDummy = ((bsgPlayerInfo *) *P);
         if (!strcmp(pDummy->m_szPlayerName,a_strPlayer))
         {
           pInfo=pDummy;
         }

         P++;
    }

    g_Logfile << pInfo->m_szPlayerName << " found in player database \n";
    g_Logfile.flush();

    return  pInfo;
}

void bsgChoosePlayerDLG::Handle(TextRenderer * a_pTextRenderer)
{
   if (m_pList   != NULL)
    {
      m_pList->Handle(a_pTextRenderer);
    }
    if (m_pSelect != NULL)
    {
      m_pSelect->Handle(a_pTextRenderer);

      if (m_pSelect->IsClicked())
      {
        g_Logfile << " Start button clicked \n" ;
        g_Logfile.flush();
        if (m_pList->GetSelection()!="<NONE>")
        {
            if (pFunction!=NULL) pFunction(m_pList->GetSelection().c_str());
            Remove();
        }
      }
    }
    if (m_pNew    != NULL)
    {
      m_pNew->Handle(a_pTextRenderer);
      if (m_pNew->IsClicked())
      {
        bsgAddPlayerDLG * pAddDlg = new bsgAddPlayerDLG(10,10,this);
        m_pGUI->Add(pAddDlg);
      }
    }

    if (m_pDelete    != NULL)
    {
        m_pDelete->Handle(a_pTextRenderer);
        if (m_pDelete->IsClicked()&& (!m_pList->GetSelection().empty()))
        {
          m_pConfirm = new bsgConfirmDLG(10,100,"Delete selected Player ?");
          m_pGUI->Add(m_pConfirm);
        }
    }
}


 bsgListBox::bsgListBox(int a_nLeft, int a_nTop, int a_nRight, int a_nBottom)
 {
  m_nX         = a_nLeft;
  m_nY         = a_nTop;
  m_nZ         = 1;
  m_nBlinkTime = 25;
  m_blKeyLock  = false;

  m_nSelectionIndex = -1;


  m_blCarretBlink = true;
  m_nCountDown    = m_nBlinkTime;

  m_nWidth  = a_nRight - a_nLeft;
  m_nHeight = a_nBottom - a_nTop;

  m_clrBrush = new Rgba(1.0,1.0,1.0);
  m_clrPen   = new Rgba(0.5,0.5,0.5);
  m_shpIn    = new Rect(m_nX,m_nY,m_nWidth,m_nHeight);
  m_shpOut   = new Rect(m_nX,m_nY,m_nWidth,m_nHeight);

  g_Logfile << " Listbox created \n" ;
   g_Logfile.flush();

 }

 bsgListBox::~bsgListBox()
 {
  g_Logfile << "Destroying ListBox dialog ... \n";
  g_Logfile.flush();

  Clear();

  g_Logfile << " Listbox destroyed \n" ;
  g_Logfile.flush();
 }

void bsgListBox::RemoveLast()
{
  list<string * >::iterator itRemove = m_lstLines.end();
  string * pDummy=((string *)*itRemove);
  m_lstLines.erase(itRemove);
  delete pDummy;
}

void bsgListBox::Clear()
{
 if (!m_lstLines.empty())
    {
      std::list<string *>::iterator p=m_lstLines.begin();
	  while (p!= m_lstLines.end())
	  {
		string * pDummy=((string *)*p);
		p=m_lstLines.erase(p);
		delete pDummy;
      }
    }
}

void bsgListBox::SetSelection(int a_nIndex)
{
  if ((a_nIndex>-1) &&(a_nIndex<m_lstLines.size()))
  {
    m_nSelectionIndex=a_nIndex;
    g_Logfile << "Selection set to " << m_nSelectionIndex << " \n" ;
    g_Logfile.flush();
  }
}


 void bsgListBox::AddLine( string a_strLine,bool a_blSelect)
 {
   g_Logfile << "Adding " << a_strLine.c_str() << " to listbox \n" ;
   g_Logfile.flush();
   string * pString= new string;
   pString->assign(a_strLine);
   m_lstLines.push_back(pString);

   if (a_blSelect)
   {
     m_nSelectionIndex=m_lstLines.size()-1;
   }
   g_Logfile << "Adding " << a_strLine.c_str() << " successfull \n" ;
   g_Logfile.flush();
 }

void bsgListBox::RemoveSelection()
{
  if ((m_nSelectionIndex>-1)&&(!m_lstLines.empty()))
  {

    list<string * >::iterator itRemove = m_lstLines.begin();
    for (int i=0;i<m_nSelectionIndex;i++)
    {
       itRemove++;
    }
    string * pDummy=((string *)*itRemove);
    m_lstLines.erase(itRemove);
    delete pDummy;
    m_nSelectionIndex=-1;
  }
}


 void bsgListBox::Draw(TextRenderer * a_pTextRenderer)
 {
    if ((m_clrBrush!=NULL) && (m_shpIn!=NULL)) m_shpIn->Draw(*m_clrBrush);
    if ((m_clrPen!=NULL) && (m_shpOut!=NULL))  m_shpOut->DrawOutline(*m_clrPen);
    Rgba originalColor = a_pTextRenderer->GetColor();

    if (m_nSelectionIndex>-1)
    {
        int nStart = m_nY+4 + (m_nSelectionIndex*m_nTextHeight);
        Rect tmpRect(m_nX,nStart,m_nWidth,m_nTextHeight);
        tmpRect.Draw(Rgba::BLACK);
    }

    list<string *>::const_iterator P=m_lstLines.begin();
    int i =0;
    while ( P!=m_lstLines.end())
    {
       string * pstrLine=*P;
       if (i==m_nSelectionIndex)
       {
          a_pTextRenderer->SetColor(Rgba::WHITE);
       }
       else
       {
          a_pTextRenderer->SetColor(Rgba::BLACK);
       }
       int nTextHeight  = a_pTextRenderer->Height(*pstrLine);
       a_pTextRenderer->Print(*pstrLine,m_nX+3,m_nY+nTextHeight+(i*nTextHeight));
       i++;
       P++;
    }



    a_pTextRenderer->SetColor(originalColor);
 }

 void bsgListBox::Handle(TextRenderer * a_pTextRenderer)
 {
    string text = "ABZX";
    m_nTextHeight = a_pTextRenderer->Height(text);

    int nSel=m_nSelectionIndex;
    if ((mouse_b & 1)&&
       (mouse_x > m_nX) && (mouse_x < (m_nX+m_nWidth)) &&
       (mouse_y > m_nY) && (mouse_y < (m_nY+m_nHeight)))
       {
          nSel=(mouse_y-m_nY)/m_nTextHeight;
       }


     while ((m_lstLines.size()>0) && keypressed())
     {
       int nVal  =  readkey();

       if (! m_blKeyLock)
       {
          if ((nVal >> 8) == KEY_UP)
          {
             nSel--;
             m_blKeyLock=true;
          }
          if ((nVal >> 8) == KEY_DOWN)
          {
             nSel++;
             m_blKeyLock=true;
          }
       }

    if (nSel < 0) nSel=m_lstLines.size()-1;
    if (nSel>m_lstLines.size()-1) nSel=0;
    }
    m_blKeyLock=false;



    if ((nSel<(m_lstLines.size()))&&(nSel >= -1))
       {
             m_nSelectionIndex=nSel;
       }

 }

int bsgListBox::GetSelectionIndex()
{
 return m_nSelectionIndex;
}



string bsgListBox::GetSelection()
{
  string strResult="<NONE>";

  if (m_nSelectionIndex>-1)
  {
    list<string*>::iterator P=m_lstLines.begin();
    for (int i=0;i<m_nSelectionIndex;i++)
    {
       P++;
    }
    strResult=**P;
    return strResult;
  }
  else
  {
    return strResult;
  }


}

string bsgListBox::GetLine(int a_nIndex)
{
  if ((a_nIndex<0)|| (a_nIndex>m_lstLines.size()-1))
  {
     return "";
  }
  else
  {
    list<string * >::iterator P=m_lstLines.begin();
    for (int i=0;i<m_nSelectionIndex;i++)
    {
       P++;
    }
    string strResult;
    strResult=**P;
    return strResult;
  }
}



bsgEditBox::bsgEditBox(int a_nLeft, int a_nTop, int a_nRight, int a_nBottom)
{
  m_nX         = a_nLeft;
  m_nY         = a_nTop;
  m_nZ         = 1;
  m_nBlinkTime = 25;
  m_strText    = "";

  m_blCarretBlink = true;
  m_nCountDown    = m_nBlinkTime;

  m_nWidth  = a_nRight - a_nLeft;
  m_nHeight = a_nBottom - a_nTop;

  m_clrBrush = new Rgba(1.0,1.0,1.0);
  m_clrPen   = new Rgba(0.5,0.5,0.5);
  m_shpIn    = new Rect(m_nX,m_nY,m_nWidth,m_nHeight);
  m_shpOut   = new Rect(m_nX,m_nY,m_nWidth,m_nHeight);

}

void bsgEditBox::Draw(TextRenderer * a_pTextRenderer)
{

  if ((m_clrBrush!=NULL) && (m_shpIn!=NULL)) m_shpIn->Draw(*m_clrBrush);
  if ((m_clrPen!=NULL) && (m_shpOut!=NULL))  m_shpOut->DrawOutline(*m_clrPen);

  Rgba originalColor = a_pTextRenderer->GetColor();
  a_pTextRenderer->SetColor(Rgba::BLACK);

  if (m_blCarretBlink)
  {
    a_pTextRenderer->Print(m_strText+'_',m_nX+3,m_nY+m_nHeight-5);
  }
  else
  {
    a_pTextRenderer->Print(m_strText,m_nX+3,m_nY+m_nHeight-5);
  }
  a_pTextRenderer->SetColor(originalColor);
}



void bsgEditBox::Handle(TextRenderer * a_pTextRenderer)
{
  if (m_nCountDown <= 0)
  {
     m_blCarretBlink = !m_blCarretBlink;
     m_nCountDown    =  m_nBlinkTime;
  }
  else
  {
      m_nCountDown--;
  }

  // Text capture code

  while (keypressed())
  {
    int nSize = a_pTextRenderer->Width(m_strText+'W');
    int nVal  =  readkey();
    if (((nVal >> 8) == KEY_BACKSPACE) && (! m_strText.empty()))
    {
      m_strText.erase(m_strText.length()-1);

    }
    else if (((nVal  & 0xff)>31)&&((nVal  & 0xff)<125)&&(nSize < m_nWidth))
    {
      m_strText += char(nVal & 0xff);
    }
  }
};


string bsgEditBox::GetText()
{
   return m_strText;
}

void bsgEditBox::Clear()
{
  m_strText.clear();
}

bsgEditBox::~bsgEditBox()
{
  g_Logfile << "Destroying EditBox \n";
  g_Logfile.flush();
}

bsgButton::bsgButton(int a_nLeft, int a_nTop, int a_nRight, int a_nBottom,char * a_szCaption,void (*a_pFunction)())
{
  m_strCaption.assign(a_szCaption);
  pFunction = a_pFunction;
  m_nX = a_nLeft;
  m_nY = a_nTop;
  m_nZ = 1;
  m_nWidth  = a_nRight - a_nLeft;
  m_nHeight = a_nBottom - a_nTop;
  m_blButtonDown = false;
  m_blIsClicked  = false;

  m_clrBrush = new Rgba(0.5,0.5,0.5);
  m_clrPen   = new Rgba(1.0,1.0,1.0);

  m_shpIn  = new Rect(m_nX,m_nY,m_nWidth,m_nHeight);
  m_shpOut = new Rect(m_nX,m_nY,m_nWidth,m_nHeight);

}

bsgButton::~bsgButton()
{
  g_Logfile << "Destroying Button \n";
  g_Logfile.flush();
}


void bsgButton::Handle(TextRenderer * a_pTextRenderer)
{
  if ((mouse_x > m_nX) && (mouse_x < (m_nX+m_nWidth)) &&
     (mouse_y > m_nY) && (mouse_y < (m_nY+m_nHeight)))
     {
        if (mouse_b & 1)
        {
          m_blButtonDown = true;
          m_blIsClicked  = false;
        }
     else
        {
          if (m_blButtonDown)
          {
             m_blIsClicked=true;
          }
          m_blButtonDown=false;
        }
     }
}

bool bsgButton::IsClicked()
{
  bool blResult  = m_blIsClicked;
  m_blIsClicked  = false;
  return blResult;
}


void bsgButton::Draw(TextRenderer * a_pTextRenderer)
{
  if (m_blVisible)
  {
    int nTextWidth   = a_pTextRenderer->Width(m_strCaption);
    int nTextHeight  = a_pTextRenderer->Height(m_strCaption);
    int nMiddButtonX = m_nX+(m_nWidth/2);
    int nMiddButtonY = m_nY+(m_nHeight/2);
    int nHalfSizeX   = nTextWidth/2;
    int nHalfSizeY   = nTextHeight/2;

    if (m_blButtonDown)
    {
       if ((m_clrBrush!=NULL) && (m_shpIn!=NULL)) m_shpIn->Draw(*m_clrPen);
       if ((m_clrPen!=NULL) && (m_shpOut!=NULL))  m_shpOut->DrawOutline(*m_clrBrush);

       Rgba originalColor = a_pTextRenderer->GetColor();
       a_pTextRenderer->SetColor(*m_clrBrush);
       a_pTextRenderer->Print(m_strCaption,nMiddButtonX-nHalfSizeX,nMiddButtonY+nHalfSizeY);
       a_pTextRenderer->SetColor(originalColor);
    }
    else
    {
       if ((m_clrBrush!=NULL) && (m_shpIn!=NULL)) m_shpIn->Draw(*m_clrBrush);
       if ((m_clrPen!=NULL) && (m_shpOut!=NULL))  m_shpOut->DrawOutline(*m_clrPen);

       a_pTextRenderer->Print(m_strCaption,nMiddButtonX-nHalfSizeX,nMiddButtonY+nHalfSizeY);
    }
  }
}





bsgGUIObject::bsgGUIObject()
{
  m_nX      = 0;
  m_nY      = 0;
  m_nWidth  = 0;
  m_nHeight = 0;


  m_clrBrush = NULL;
  m_clrPen   = NULL;
  m_shpIn    = NULL;
  m_shpOut   = NULL;

  m_blDestroyed   = false;
  m_blVisible     = true;
  m_blHasFocus    = false;
  m_pParentObject = NULL;

}

bsgGUIObject::~bsgGUIObject()
{
  if (m_clrBrush!=NULL)  delete(m_clrBrush);
  if (m_clrPen!=NULL)    delete(m_clrPen);
  if (m_shpIn!=NULL)     delete(m_shpIn);
  if (m_shpOut!=NULL)    delete(m_shpOut);
}




void bsgGUIObject::Remove()
{
m_blDestroyed=true;
}

bool bsgGUIObject::RemoveFromList()
{
return m_blDestroyed;
}






bsgGUI::bsgGUI(TextRenderer * a_pTextRenderer,Bitmap * a_pCursor)
{
 m_pTextRenderer = a_pTextRenderer;
 m_nObjectCount  = 0;
 m_blVisible     = true;
 m_pCursor       = a_pCursor;
 m_pFocus        = NULL;
}


bsgGUI::~bsgGUI()
{
  RemoveAll();
}



void bsgGUI::Draw()
{
 if (m_blVisible)
    {
      std::list<bsgGUIObject *>::const_iterator p=m_lstItems.begin();
	  while (p!=m_lstItems.end())
	  {
		 bsgGUIObject* pDummy=((bsgGUIObject *)*p);

		 if ((pDummy!=NULL)&&(!pDummy->RemoveFromList()))
		 {
		   pDummy->Draw(m_pTextRenderer);
		 }

		 p++;
      }
      if (m_pCursor != NULL)
      {
         m_pCursor->Blit(mouse_x,mouse_y);
      }

    }
}

void bsgGUI::Handle()
{
   m_pFocus=((bsgGUIObject *)m_lstItems.back());
   if ((m_pFocus!=NULL)&&(! m_pFocus->RemoveFromList()))
   {
     m_pFocus->Handle(m_pTextRenderer);
   }
}


void bsgGUI::Remove()
{
  std::list<bsgGUIObject *>::iterator p=m_lstItems.begin();
	while (p!=m_lstItems.end())
	{
		bsgGUIObject* pDummy=((bsgGUIObject *)*p);
		if (pDummy->RemoveFromList())
		{
			g_Logfile << "[Removing GUI Object] \n" ;
            g_Logfile.flush();
			p=m_lstItems.erase(p);
            delete pDummy;
            m_nObjectCount--;
		}
		else
		{
			p++;
		}
	}
}

void bsgGUI::RemoveAll()
{
g_Logfile << "[Removing all GUI Objects] \n" ;
g_Logfile.flush();
if (!m_lstItems.empty())
    {
      std::list<bsgGUIObject *>::iterator p=m_lstItems.begin();
	  while (p!=m_lstItems.end())
	  {
		bsgGUIObject* pDummy=((bsgGUIObject *)*p);
		p=m_lstItems.erase(p);
		delete pDummy;
      }
    }
 m_nObjectCount=0;
}

void bsgGUI::RemoveQueryAll()
{
g_Logfile << "[Request removal of  all GUI Objects] \n" ;
g_Logfile.flush();
if (!m_lstItems.empty())
    {
      std::list<bsgGUIObject *>::iterator p=m_lstItems.begin();
	  while (p!=m_lstItems.end())
	  {
		bsgGUIObject* pDummy=((bsgGUIObject *)*p);
		pDummy->Remove();
		p++;
      }
    }
 m_nObjectCount=0;
}


void bsgGUI::Add(bsgGUIObject * a_pGuiObject)
{
 g_Logfile << "[Adding GUI Object] \n" ;
 g_Logfile.flush();
 a_pGuiObject->m_pGUI = this;
 m_lstItems.push_back(a_pGuiObject);
 m_nObjectCount++;
 m_pFocus=a_pGuiObject;
}

void bsgGUI::SetCursor(Bitmap * a_pCursor)
{
  m_pCursor=a_pCursor;
}

