/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/



#include <allegro.h>
#include <OpenLayer.hpp>
//#include <loadpng.h>
#include "bsgBullet.h"
#include "AIdef.h"



Bitmap    * g_pimLaser1=NULL;
Bitmap    * g_pimLaser2=NULL;


bsgBullet::bsgBullet(int a_nBulletType)
{
    m_fEnergy=100;
    m_fSpeed=8;
    //m_fOpacity=0.7;
    m_nType=a_nBulletType;
    m_blPlayerBullet=false;
    switch(m_nType)
    {
        case BT_LASER1:
        SetImage(g_pimLaser1);
        break;

        case BT_LASER2:
        SetImage(g_pimLaser2);
        break;

        default:
        SetImage(g_pimLaser1);
    }

}

bsgBullet::~bsgBullet()
{


}


void bsgBullet::do_ai(float a_fLagCount)
{
    m_fEnergy-=a_fLagCount;
    if (m_fEnergy<=0)
    {
        m_blDestroyed=true;
    }
}


bool LoadBulletSprites()
{
    g_pimLaser1 = new Bitmap("Gfx/Still/laser1.png");
    g_pimLaser2 = new Bitmap("Gfx/Still/laser2.png");

    if ((g_pimLaser1!=NULL)&&(g_pimLaser2!=NULL))
    {
            return true;
    }
    else
    {
           return false;
    }
}

