/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


#include "bsgBattlestar.h"
#include "main.h"
#include "AIdef.h"
#include "bsgSmoke.h"
#include "spartan.h"
#include "bsgViper.h"

extern bool g_blDebug;

Bitmap    * g_pimBattlestar=NULL;
Bitmap    * g_pimLeftBay=NULL;
Bitmap    * g_pimRightBay=NULL;


bsgBattlestar::bsgBattlestar()
{
    m_nEnemies=0;
    m_fMaxSpeed=1;
    m_nVipersBay1=5;
    m_nVipersBay2=5;
    m_fLaunchTimer=100;
    m_nVipersInAction=0;
    m_nType=ID_GALACTICA;
    m_nTeam=MEM_COLONY;

    m_blIncoming1=false;
    m_blIncoming2=false;
    m_nPlayerDocked=true;
    SetImage(g_pimBattlestar);

    m_pTurret1  = NULL;
    m_pTurret2  = NULL;
    m_pLeftBay  = NULL;
    m_pRightBay = NULL;

    m_pTurret1=new bsgTurret(TT_LEFT);
    m_pTurret1->m_fX=m_fX +  178;
    m_pTurret1->m_fY=m_fY -   64;
    m_pTurret1->m_nZ=6;
    m_pEngine->add(m_pTurret1);

    m_pTurret2=new bsgTurret(TT_RIGHT);
    m_pTurret2->m_fX=m_fX + 178;
    m_pTurret2->m_fY=m_fY +  58;
    m_pTurret2->m_nZ=6;
    m_pEngine->add(m_pTurret2);

    m_pLeftBay=new bsgLeftBay();
    m_pLeftBay->m_fX=m_fX - 152;
    m_pLeftBay->m_fY=m_fY - 117;
    m_pLeftBay->m_nZ=4;
    m_pLeftBay->SetImage(g_pimLeftBay);
    m_pEngine->add(m_pLeftBay);

    m_pRightBay=new bsgLeftBay();
    m_pRightBay->m_fX=m_fY - 146;
    m_pRightBay->m_fY=m_fY + 106;
    m_pRightBay->m_nZ=4;
    m_pRightBay->SetImage(g_pimRightBay);
    m_pEngine->add(m_pRightBay);

    m_nZ=3;
    m_pTarget=NULL;
}

bsgBattlestar::~bsgBattlestar()
{
    if (m_pTurret1!=NULL)
    {
       m_pTurret1->m_blDestroyed=true;
    }

    if (m_pTurret2!=NULL)
    {
      m_pTurret2->m_blDestroyed=true;
    }
}

void bsgBattlestar::draw(int a_nCameraX,int a_nCameraY)
{
    int nImageMidX=m_pImage->Width();
	int nImageMidY=m_pImage->Height();
    int nDrawX=int(SCREENCENTER_X+(m_fX-a_nCameraX)-nImageMidX/2);
	int nDrawY=int(SCREENCENTER_Y+(m_fY-a_nCameraY)-nImageMidY/2);
	// only draw what we see

	if ((m_pImage!=NULL)&&(nDrawX+nImageMidX>-100)&&(nDrawX<900)&&(nDrawY+nImageMidY>-100)&&(nDrawY<700))
	{
		m_pImage->Blit(nDrawX, nDrawY);
	}

	if (g_blDebug)
	{
	   for (int i=0; i<4; i++)
	   {
	      bsgPoint point = GetILSPoint(i,BAY_LEFT);
	      nDrawX=int(SCREENCENTER_X+(point.m_nX-a_nCameraX));
	      nDrawY=int(SCREENCENTER_Y+(point.m_nY-a_nCameraY));
	      GfxRend::Circle( nDrawX, nDrawY, 5, Rgba(255,0,0,255));

	      point = GetILSPoint(i,BAY_RIGHT);
	      nDrawX=int(SCREENCENTER_X+(point.m_nX-a_nCameraX));
	      nDrawY=int(SCREENCENTER_Y+(point.m_nY-a_nCameraY));
	      GfxRend::Circle( nDrawX, nDrawY, 5, Rgba(255,0,0,255));
	   }

	}

}


void bsgBattlestar::do_ai(float a_fLagCount)
{
    m_pTarget=SeekTarget();

    if ((m_pTurret1!=NULL)&&(m_pTurret1->m_blDestroyed))
    {
        m_pTurret1=NULL;
    }

    if ((m_pTurret2!=NULL)&&(m_pTurret2->m_blDestroyed))
    {
        m_pTurret2=NULL;
    }


    if ((m_pLeftBay!=NULL)&&(m_pLeftBay->m_blDestroyed))
    {
        m_pLeftBay=NULL;
    }

    if ((m_pRightBay!=NULL)&&(m_pRightBay->m_blDestroyed))
    {
        m_pRightBay=NULL;
    }

    if (m_pLeftBay == NULL) m_blIncoming1=true;
    if (m_pRightBay == NULL) m_blIncoming2=true;

    if (key[KEY_L])
        {
            Launch_Player();
            m_fLaunchTimer=100;
        }


   if ((key[KEY_V])&&(m_fLaunchTimer<=0))
   {
        Launch_Viper2(true);
        Launch_Viper(true);
        m_fLaunchTimer=100;
   }



    if ((m_pTarget!=NULL)&&(m_fLaunchTimer<=0)&&(m_nEnemies>m_nVipersInAction))
    {
        Launch_Viper2(true);
        Launch_Viper(true);
        m_fLaunchTimer=100;
    }

    if (m_fLaunchTimer>0) m_fLaunchTimer-=a_fLagCount;
}



void bsgBattlestar::Launch_Viper(bool a_blDefense)
{
      if (m_nVipersBay1>0)
      {
        bsgViper * pV;
        pV = new bsgViper(BAY_LEFT,this);
        pV->m_fX = m_fX;
        pV->m_fY = m_fY - 110;
        pV->m_nZ = 1;

        m_pEngine->add(pV);
        pV->launch();
        pV->m_nWingNr=m_nVipersBay1;
        pV->m_nPosture=POS_DEFEND_GALACTICA;
        pV->m_nTargetType=ID_ANY;
        m_nVipersBay1--;
        m_nVipersInAction++;

      }
}


void bsgBattlestar::Launch_Viper2(bool a_blDefense)
{
      if (m_nVipersBay2>0)
      {
        bsgViper * pV;
        pV = new bsgViper(BAY_RIGHT,this);
        pV->m_fX=m_fX;
        pV->m_fY=m_fY+100;
        pV->m_nZ=1;

        m_pEngine->add(pV);
        pV->launch();
        pV->m_nWingNr=m_nVipersBay2;
        pV->m_nPosture=POS_DEFEND_GALACTICA;
        pV->m_nTargetType=ID_ANY;
        m_nVipersBay2--;
        m_nVipersInAction++;
      }
}


void bsgBattlestar::Launch_Player()
{
      if (m_nPlayerDocked)
      {
        bsgPlayer * pPlayer;
        pPlayer = new bsgPlayer;
        pPlayer->m_fX=m_fX;
        pPlayer->m_fY=m_fY-110;
        pPlayer->m_blLaunching=true;
        m_pEngine->add(pPlayer);
        SetPlayerPointer(pPlayer);
        pPlayer->m_pBattlestar=this;
        m_nPlayerDocked=false;
        m_nVipersInAction++;
      }
}



bsgShip * bsgBattlestar::SeekTarget()
{
    m_nEnemies=0;
    bsgSprite * pTarget=NULL;
    float nDist=VIEW_DISTANCE;
    float nD;
    std::list<bsgSprite *>::iterator p=m_pEngine->m_lstItems.begin();
    while (p!=m_pEngine->m_lstItems.end())
    {
        bsgSprite * pHulp=((bsgSprite *)*p);

        if ((pHulp->m_nTeam==MEM_CYLON)&&(!pHulp->m_blDestroyed)&&(pHulp->m_nType>=ID_SHIP)&&(pHulp->m_nZ>2))
        {
            nD=distance(m_fX,m_fY,pHulp->m_fX,pHulp->m_fY);
            if (nD<=nDist)
            {
                pTarget=pHulp;
                m_nEnemies++;
            }
        }
        p++;
    }
    return ((bsgShip *) pTarget);
}


void bsgBattlestar::SetPosition(int a_nX,int a_nY)
{
 m_fX=a_nX;
 m_fY=a_nY;
 if (m_pTurret1!=NULL)
 {
    m_pTurret1->m_fX=m_fX +  178;
    m_pTurret1->m_fY=m_fY -   64;
 }

 if (m_pTurret2!=NULL)
 {
    m_pTurret2->m_fX=m_fX + 178;
    m_pTurret2->m_fY=m_fY +  58;
 }


 if (m_pLeftBay!=NULL)
 {
     m_pLeftBay->m_fX=m_fX - 152;
     m_pLeftBay->m_fY=m_fY - 117;
 }


 if (m_pRightBay!=NULL)
 {
     m_pRightBay->m_fX=m_fX - 146;
     m_pRightBay->m_fY=m_fY + 106;
 }

}


void bsgBattlestar::move(float a_fLagCount)
{
	if (m_fSpeed>0)
	{
	  m_fX=m_fX+(m_fSpeed*a_fLagCount);
	  if (m_pTurret1!=NULL)
      {
	     m_pTurret1->m_fX=m_fX +  178;
         m_pTurret1->m_fY=m_fY -   64;
      }

      if (m_pTurret2!=NULL)
      {
	     m_pTurret2->m_fX=m_fX + 178;
         m_pTurret2->m_fY=m_fY +  58;
      }


      if (m_pLeftBay!=NULL)
      {
        m_pLeftBay->m_fX=m_fX - 152;
        m_pLeftBay->m_fY=m_fY - 117;
      }


      if (m_pRightBay!=NULL)
      {
        m_pRightBay->m_fX=m_fX - 146;
        m_pRightBay->m_fY=m_fY + 106;
      }
	}
}

bsgPoint bsgBattlestar::GetILSPoint(int a_nILSState, int a_nLandingBay)
{
  bsgPoint ILS;
  ILS.m_nX = int(m_fX);
  ILS.m_nY = int(m_fY);
  switch(a_nLandingBay)
  {
     case BAY_LEFT:
     switch(a_nILSState)
     {
       case 0:
        ILS.m_nX=int(m_fX) - 2000 ;
        ILS.m_nY=int(m_fY) -  300;
       break;

       case 1:
        ILS.m_nX=int(m_fX) - 1500 ;
        ILS.m_nY=int(m_fY) -  110;
       break;

       case 2:
        ILS.m_nX=int(m_fX) -  500 ;
        ILS.m_nY=int(m_fY) -  110;
       break;

       case 3:
        ILS.m_nX=int(m_fX);
        ILS.m_nY=int(m_fY) -  110;
       break;

     }
     break;

     case BAY_RIGHT:
     switch(a_nILSState)
     {
       case 0:
        ILS.m_nX=int(m_fX) - 2000 ;
        ILS.m_nY=int(m_fY) +  300;
       break;

       case 1:
        ILS.m_nX=int(m_fX) - 1500 ;
        ILS.m_nY=int(m_fY) +  110;
       break;

       case 2:
        ILS.m_nX=int(m_fX) -  500 ;
        ILS.m_nY=int(m_fY) +  110;
       break;

       case 3:
        ILS.m_nX=int(m_fX);
        ILS.m_nY=int(m_fY) + 110;
       break;
     }
     break;
  }
  return ILS;
}


bool LoadBattlestarSprites()
{
    g_pimBattlestar = new Bitmap("Gfx/Still/Galactica.png");
    g_pimLeftBay = new Bitmap("Gfx/Still/leftbay.png");
    g_pimRightBay= new Bitmap("Gfx/Still/rightbay.png");

    if ((g_pimBattlestar!=NULL)&&(g_pimLeftBay!=NULL))
    {
            return true;
    }
    else
    {
           return false;
    }
}



