/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/




#ifndef _ENGINE
#define _ENGINE

#include <allegro.h>
#include <OpenLayer.hpp>
#include <math.h>
#include <list>


using namespace ol;
using namespace std;


#define PI                  3.14159265358
#define TORAD               0.02454369261
#define CYCLES_PER_SEC     60

class bsgEngine;




class bsgPoint
{
public:
int m_nX;
int m_nY;
int m_nZ;
bsgPoint()
 {
  m_nX=0;
  m_nY=0;
  m_nZ=0;
 }
};


class bsgSprite
{
private:

protected:
Bitmap * m_pImage;     // pointer to the sprite image
Bitmap * m_pShadow;    // pointer to the sprite image

bsgEngine * m_pEngine; // pointer to the engine


float  m_fOpacity;     // how "solid" is the sprite
bool m_blCanCollide;   // can this sprite collide

public:

bool m_blDisabled;      // unit not yet IN the game
bool m_blOutOfGame;      // unit out of game
bool m_blTimedMovement; // start moving at some time
int  m_nTimeSec;        // the time to appear in the game
int  m_nTimeMin;
bool m_blDestroyed;     // If true the engine will remove this object in the next kill()
bool m_blMustSurvive;

float m_fX,            // World X position
	  m_fY;            // World Y Position
int   m_nZ;            // Drawing Depth

float m_fSpeed,        // the speed
      m_fMaxSpeed,
      m_fAngle,        // the facing angle
      m_fCosAngle,     // Cosine of angle
      m_fSinAngle;     // Sin of angle


int   m_nType,         // UnitType
	  m_nTeam,         // To what "group" does this unit belong Colonial,Cylon etc
	  m_nHealth,       // Health O= destroyed
	  m_nMaxHealth;




double waypoint(float a_fX,float a_fY);  // returns the angle to reach (a_fX,a_fY)
void SetImage(Bitmap * a_pImage);        // set the sprite image
void SetShadow(Bitmap * a_pImage);       // set the shadow image
virtual void draw(int a_nCameraX,int a_nCameraY); // Draws this sprite proportional to the camera
virtual void move(float a_fLagCount);    // Move the sprite in the direction m_fAngle
virtual void do_ai(float a_fLagCount);   // AI routine
void precalc();
virtual void DoCollision(bsgSprite * a_pSprite); // called if this sprite collided with another

friend class bsgEngine;
friend bool Comp(const bsgSprite * p1, const bsgSprite * p2);


bsgSprite();
virtual ~bsgSprite();
};


class bsgEngine
{
private:
int m_nOldX, // stores the old camera position for the star layers
    m_nOldY;

int m_nSeekX,
    m_nSeekY;

int m_nCount; // Number of objects in the engine

time_t m_tmStartTime;
time_t m_tmCurrentTime;




public:

tm * pTime;

bool m_blTransition;
int m_nRaiders; // just for demo !
int m_nCameraX,m_nCameraY;	// camera position

std::list <bsgSprite *> m_lstItems;

void move(float a_fLagCount); //move all sprites
void draw();//draw all sprites

void Sort(); //Z-Sort
void add(bsgSprite * a_pSprite); // Add a sprite
void kill();   // remove all destroyed sprites
void killAll();
void SetCamera(int a_nCameraX,int a_nCameraY, bool a_blLookAhead); // set camera position
void Translate(int a_nX, int a_nY); // scroll camera to position
void init_stars(); // init star layers
void draw_stars(); // draw the stars
void update_stars();// update the stars
void reset_movement();
void StartTimer();
void UpdateTimer();
bool Load_Blibs();
string GetTimestring();
void bsgEngine::draw_sensor(int a_nX,int a_nY);// draw a sensor screen
void bsgEngine::draw_large_sensor(int a_nX,int a_nY, bsgSprite * a_pPlayer);// draw a sensor overlay
virtual bool detect_collision(bsgSprite * a_pSprite1,bsgSprite * a_pSprite2);// check for collisions

bsgEngine();
virtual ~bsgEngine();

};


float distance(float a_fX1,float a_fY1,float a_fX2,float a_fY2);

#endif

