// Copyright Tuomas Korppi 2004. This file is distributed under GPL.
// This file uses Allegro 3.0 game routine library. Replacing 3.0 with
// some newer should be quite straight-forward.


#include <stdio.h>
#include <allegro.h>
#include <math.h>
// #include <dir.h>

DECLARE_COLOR_DEPTH_LIST(COLOR_DEPTH_8);

BITMAP *activepage;
BITMAP *page1;
BITMAP *page2;


#define FOR_EACH(s,t) if (t!=0) for((s)=(t); (s)!=0; (s)=(s)->next)

char ohjeet[40][25][50]; int ohjex1; int ohjex2;

void lueohjeet()
{ int i=0;
  int j=0;
  int k=0;
  char c='a';
  FILE *f=fopen("petsep.txt","r");

  for(i=0; i<40; i++) for(j=0; j<25; j++) for(k=0; k<50; k++)
  ohjeet[i][j][k]=0;

  i=0; j=0; k=0;
  while(c!=EOF)
  { while(c!=EOF && c!='$')
    { while(  (c=fgetc(f))!=EOF && c!='$' && c!='\n'
            && k<50 ) ohjeet[i][j][k++]=c;
      k=0; j++; ohjeet[i][j][49]=0;
    }
    k=0; j=0; i++; if(c=='$') c=fgetc(f);
  }
  fclose(f);


}

const koko=20;

int pakkoheitto=0;

int kantax=10*320;
int kantay=10*240;

BITMAP *oikeatausta=0;

int pyyhikaikki=0;

RGB oikeapaletti[300];

inline double pytis(double x1, double y1, double x2, double y2)
{
  return sqrt( (x1-x2)*(x1-x2) + (y1-y2)*(y1-y2) );
}


inline double tulo(double x1,double y1,double x2,double y2)
{
  return x1*x2+y1*y2;
}

inline double abs(double x)
{
  if (x<0) return -x; else return x;
}

inline int abs(int x)
{
  if (x<0) return -x; else return x;
}



class pyyhkimaan
{ public:
  int x[1000],y[1000],xx[1000],yy[1000];
  long int ala;
  int osoitin;
   pyyhi();
   merkkaa(int nx, int ny, int nxx, int nyy);

  pyyhkimaan() {osoitin=0; ala=0;}
};

pyyhkimaan::merkkaa(int nx, int ny, int nxx, int nyy)
  {x[osoitin]=nx-kantax; y[osoitin]=ny-kantay; xx[osoitin]=nxx-kantax;
   yy[osoitin]=nyy-kantay;
   osoitin++;
   ala+=abs( (nx-nxx)*(ny-nyy) );
   if(osoitin>999) {osoitin=999; ala=1000000;}
  }

pyyhkimaan::pyyhi()
  { int i; if(ala<200000) for(i=0; i<osoitin; i++)
    {blit(oikeatausta, activepage, x[i], y[i], x[i], y[i],
               xx[i]-x[i], yy[i]-y[i]);}
    else blit(oikeatausta, activepage, 0,0,0,0,640,480);
    osoitin=0; ala=0;
  }

pyyhkimaan pyyhi1;
pyyhkimaan pyyhi2;
pyyhkimaan *activepyyhi=&pyyhi1;


int vari(int i){ return i+1; }

void muutavari(int i, int rr, int gg, int bb)
{ oikeapaletti[i].r=rr; oikeapaletti[i].g=gg;
  oikeapaletti[i].b=bb; }

void muutapaletti()
{ muutavari(0, 0,0,0);
  muutavari(1, 63,63,63);
  muutavari(2, 63,0,0);
  muutavari(3, 0,0,63);
  muutavari(4, 40,20,20);
  muutavari(5, 20,20,40);

  muutavari(10,  3,8,3 ); // ulko ruoho
  muutavari(11,  0, 0,0 );
  muutavari(12,  7,15,7 );

  muutavari(13,  0,12,0 ); // ulko pitkaruoho
  muutavari(14,  0, 4, 0 );
  muutavari(15,  8, 25, 8 );

  muutavari(16,  10, 3, 0 ); // raskassnadi
  muutavari(17,  0, 0, 0 );
  muutavari(18,  20, 5, 5 );

  muutavari(19,  60, 60, 60 ); // ulko seina
  muutavari(20,  63, 20, 63 ); // ulko pehmoseina
  muutavari(21,  20, 15, 5 ); // hiekka

  muutavari(22, 30, 40, 63 ); // teleport
  muutavari(23, 35,35,0); // pacman

  muutavari(24, 63,40,63 ); //sisa seina
  muutavari(25, 63, 40, 20); // sisa pylvas
  muutavari(26, 10, 10, 0); //sisa hiekka
  muutavari(27, 0, 0,  63); // sisa pyoroseina
  muutavari(28, 63, 10, 63); // sisa pehmoseina

  muutavari(29, 10, 2, 20); // taivas

  muutavari(30, 63,63,0); // aurinko

  muutavari(31, 0,0,0); // kaarre

  muutavari(32, 63, 30, 10); // laser

  muutavari(33, 15, 25, 0); // voimakentta

  muutavari(34, 25, 0, 0); // sotilasalue

  set_palette(oikeapaletti);
}

long int aika=0;

class tekstia
{public:
 int varasto[2000];
 int alku, loppu;
 int odotus;
 tekstia()
 {alku=0; loppu=0; odotus=aika;}
 void lisaa(char *s, int i);
 void nayta();
};

tekstia teksti;

int nayttomoodi=0;

void tekstia::lisaa(char *s,int i)
{ if (i==1)
  { alku=0; loppu=0;
    for(i=1; i<80; i++) varasto[loppu++]=' ';
  }

  while(*s!=0) {varasto[loppu++]=*s; s++; if (loppu==2000) loppu=0; }
}

void tekstia::nayta()
{ int a=alku; int i=0; char s[3];
  if (alku==loppu) {odotus=aika; }
  if (alku!=loppu && aika>odotus+25 ) { odotus+=25; alku++; }
  if (alku==2000) alku=0;

  while(i<79 && a != loppu)
  { if (varasto[a]!=' ') {sprintf(s,"%c",varasto[a]);
    text_mode(0);
    textout(activepage,font,s, i*8, 470,19); }
    a++; i++;
  }

  activepyyhi->merkkaa(0+kantax,470+kantay, 640+kantax,480+kantay);

}


volatile int kello=0; int kelllo=0;

void lisaakello(...)
{ kello++; }
END_OF_FUNCTION(lisaakello)

int annakello()
{ if (kello==0) { kelllo=0; return 0; }
  kello--;
  kelllo++;
  if (kelllo>9) { kello=0; kelllo=0; return 0; }
  return 1;
}


int max(int x, int y)
{ if (x<y) return y; else return x; }

class pallo;

class este;

int piirtoindeksi;
este *piirtokasa[1000];

class este
{ public:
  este *next;
  este *prev;
  este **kanta;
  double prioriteetti;
  int vari;
  este(este **e)
  { kanta=e; vari=nayttomoodi;
    if(*e==0) { next=0; prev=0; *e=this; }
    else  { (*e)->prev=this; prev=0; next=*e; *e=this; prioriteetti=0; }
  }
  virtual ~este()
  {if(prev==0)*kanta=next;
   if(prev!=0)prev->next=next;
   if(next!=0)next->prev=prev;
  }
  virtual void tormaa(pallo *p){}
  virtual void paivita(BITMAP *bit){}
  virtual void piirra(BITMAP *bit){}
  virtual void lisaapiirrettava() { piirtokasa[piirtoindeksi++]=this; }
};

void piirrakentta(BITMAP *bmp, este *kanta)
{ este *vali; int i,j; este *e; piirtoindeksi=0;
  if(kanta==0) return;
  FOR_EACH(e, kanta) e->lisaapiirrettava();
  for(i=0; i<piirtoindeksi; i++) for(j=i; j<piirtoindeksi; j++)
  if( (piirtokasa[i])->prioriteetti > (piirtokasa[j])->prioriteetti)
  { vali=piirtokasa[i]; piirtokasa[i]=piirtokasa[j];
    piirtokasa[j]=vali; }

  for(i=0; i < piirtoindeksi; i++) piirtokasa[i]->piirra(bmp);
}

int lukuarvo[]={ 0, 4, 2, 6, 1, 7, 3, 5};

/*
inline int lukuarvo(int i)
{ if(i==0) return 0; else
  if(i==4) return 1;
  else if (i==2) return 2;
  else if (i==6) return 4;
  else if (i==1) return 5;
  else if (i==3) return 6;
  else if (i==7) return 7;
}
*/

inline int rasteri(int x, int y)
{ return (lukuarvo[x%8]+lukuarvo[y%8])*8;
}

inline int isorasteri(int x, int y)
{ return rasteri(x,y)-20;
}



class pmeste : public este
{ public:
  int x,y,xx,yy;
  pmeste(este **e, int x1, int y1, int x2, int y2) : este(e)
  { x = x1+kantax; y=y1+kantay; xx=x2+kantax; yy=y2+kantay; }
  virtual void tormaa(pallo *p);
  virtual void tormayta(pallo *p1, pallo *p2) {}
};

double maxliikuttu=0;
double vanhamaxliikuttu=0;

class pallo
{ public:
  int pl; int tuhoa; int paikka;
  int eisaapoistaa;
  double x,y,xx,yy;
  double mx,my,mm;
  double etaisyys;
  int tyyppi;
  pmeste *tormays;
  pallo(double ax,double ay,double axx,double ayy,int tt);
  virtual bool liikuta();
  pallo *next, *prev;
  void piirra();
  virtual ~pallo();
};

class jousipallo : public pallo
{ public:
  pallo *p;
  jousipallo(double ax, double ay, double axx, double ayy, int tt,
  pallo *pp);
  virtual bool liikuta();
  virtual ~jousipallo();
};

jousipallo::jousipallo(double ax, double ay, double axx, double ayy, int tt,
pallo *pp) : pallo(ax,ay,axx,ayy,tt)
{ p=pp; pp->eisaapoistaa++; }


void pmeste::tormaa(pallo *p)
{ if (p->x>= x && p->y >=y && p->x <=xx&& p->y <=yy)
    p->tormays=this;
}


pallo *pallot=0;
este  *obj[koko][koko];

jousipallo::~jousipallo()
{ p->eisaapoistaa--;
if(prev!=0)prev->next=next;
if(next!=0)next->prev=prev;
if(prev==0)pallot=next;
}


const int ruutupuskuri=18;

class tnaytto
{ public:
  BITMAP *kentat[ruutupuskuri];
  int    ajat[ruutupuskuri];
  int    x[ruutupuskuri];
  int    y[ruutupuskuri];
  int    aikka;
  tnaytto(){ int i; aikka=0;
             for(i=0;i<ruutupuskuri;i++) {ajat[i]=-1; x[i]=-10; y[i]=-10;} }
  BITMAP *anna(int xx, int yy);
};

RGB pal[300];

BITMAP *tnaytto::anna(int xx,int yy)
{ int i; int j; int k; char s[15]; /*ffblk f;*/ BITMAP *bmp;
  int vx; int vy;
  aikka++; if(aikka>100000000) abort();

  for(i=0; i<ruutupuskuri; i++)
     if( x[i]==xx && y[i]==yy && ajat[i]!=-1)
             {ajat[i]=aikka; return kentat[i];}

   j=11; k=100000000;
  for(i=0; i<ruutupuskuri; i++) if(ajat[i]<k) {j=i; k=ajat[j]; }

  if(ajat[j]!=-1) destroy_bitmap(kentat[j]);
  /*sprintf(s,"kl%dk%d.bmp",xx,yy);*/ ajat[j]=aikka; x[j]=xx; y[j]=yy;
  if( /*!findfirst(s,&f,0)*/ 0 ) { /*kentat[j]=load_bitmap(s,pal);*/ }
  else { kentat[j]=create_bitmap(320,240);
         clear(kentat[j]);
         vx=kantax; vy=kantay; kantax=320*xx; kantay=240*yy;
         if(xx>-1 && yy>-1 && xx<koko && yy<koko && obj[xx][yy]!=0)
           piirrakentta(kentat[j],obj[xx][yy]);
         kantax=vx; kantay=vy;
       }
  return kentat[j];
}

tnaytto naytto=tnaytto();



inline void lline(BITMAP *p,int x,int y, int xx, int yy, int c)
{ line(p,x-kantax,y-kantay,xx-kantax,yy-kantay,c);
}

inline void ccircle(BITMAP *p,int x, int y, int r, int c)
{ circlefill(p,x-kantax,y-kantay,r,c);
}

inline void ccirlce(BITMAP *p,int x, int y, int r, int c)
{ circle(p,x-kantax,y-kantay,r,c);
}


inline void rrectfill(BITMAP *bmp, int x, int y, int xx, int yy, int c)
{ rectfill(bmp, x-kantax, y-kantay, xx-kantax, yy-kantay,c);
}

inline void pputpixel(BITMAP *bmp, int x, int y, int c)
{ putpixel(bmp,x-kantax,y-kantay,c);
}

inline int ggetpixel(BITMAP *bmp, int x, int y)
{ return getpixel(bmp, x-kantax, y-kantay);
}

void pakotatormays()
{ pallo *p;
  FOR_EACH(p,pallot) {p->etaisyys=0;}
}


pallo::pallo(double ax, double ay, double axx, double ayy,int tt)
{ x=ax; y=ay; xx=axx; yy=ayy; tyyppi=tt; tormays=0;
  etaisyys=-1; tuhoa=0; paikka=0;
  if(pallot==0) { next=0; prev=0; pallot=this; }
          else  { pallot->prev=this; prev=0; next=pallot; pallot=this; }
  if (tyyppi!=0) eisaapoistaa=0; else eisaapoistaa=1;
  pakotatormays();
}

void pallo::piirra()
{ activepyyhi->merkkaa(int(x)-3, int(y)-3, int(x)+3, int(y)+3);
  if (tyyppi!=5 && tyyppi!=6)
      ccircle(activepage,int(x),int(y),2,vari(tyyppi));
  if (next!=0) next->piirra();
}

pallo::~pallo()
{  if(prev!=0)prev->next=next;
   if(next!=0)next->prev=prev;
   if(prev==0)pallot=next;
}


bool pallo::liikuta()
{ double vanhax=x;
  double vanhay=y;
  double matka=0;
  double dis;
  double mdis=1000000;
  pallo *p;
  bool b=1;
  este *e;

  if (tyyppi!=6)
  {
  pl=0;
  if (tyyppi==0 || tyyppi==5 ) aika++;
  if (etaisyys < 2.7)
  {
    for(p=pallot; p!=0; p=p->next )
    if (p!=this && p->tyyppi!=5 && p->tyyppi!=6)
    { dis=sqrt((x-p->x)*(x-p->x) + (y-p->y)*(y-p->y))/2;
      if (p->etaisyys > dis) p->etaisyys=dis;
      if (dis < mdis) mdis=dis;

        if (dis < 2.34520788)
        {
        if(p->tormays==0 && tormays==0 )
        {
          double bx = x - p->x; double by= y - p->y;
          double cx = xx - p-> xx; double cy = yy - p->yy;

          if (bx*cx + by*cy < 0 )
            { double sk = ( bx * xx + by * yy ) / ( bx*bx + by*by);
              double ssk = ( bx * p->xx + by * p->yy) / ( bx*bx + by*by );

              xx += (ssk- sk) * bx;
              yy += (ssk- sk) * by;
              p->xx +=  (sk -ssk) *bx;
              p->yy +=  (sk -ssk) *by;
            }
         }
         else if (tormays!=0) tormays->tormayta(this,p); else
          p->tormays->tormayta(p, this);
         }

    }

   etaisyys = mdis;

  }


  tormays=0;
  mx=0; my=0; mm=0;
  FOR_EACH(e, obj[int(x) / 320][int(y) / 240] ) e->tormaa(this);

  if(int(x) % 320 < 5 && int(x) /320 > 0 )
  FOR_EACH(e, obj[int(x) / 320 - 1][int(y) / 240] ) e->tormaa(this);

  if(int(x) % 320 > 315 && int(x)/320 < koko-1 )
  FOR_EACH(e, obj[int(x) / 320 + 1][int(y) / 240] ) e->tormaa(this);

  if(int(y) % 240 < 5 && int(y) /240 >0 )
  FOR_EACH(e, obj[int(x) / 320 ][int(y) / 240 - 1] ) e->tormaa(this);

  if(int(y) % 240 > 235 && int(x) /240 < koko-1 )
  FOR_EACH(e, obj[int(x) / 320 ][int(y) / 240 + 1] ) e->tormaa(this);



  xx+=mx; yy+=my;


  x+=xx; y+=yy;

  matka=sqrt( (x-vanhax)*(x-vanhax) + (y-vanhay)*(y-vanhay) )
  +0.0001;

  etaisyys-=matka;

  if (xx<0.002 && xx>-0.002 && yy<0.002 && yy>-0.002)
  paikka++; else paikka=0;

  if (paikka>10) {b=0; paikka=11; }

  if (next!=0) b = next->liikuta() || b;

  b=b || pl;

  if (tyyppi==4 && xx<0.002 && xx>-0.002 && yy<0.002 && yy>-0.002)
  { double d; pallo *pp;

    FOR_EACH(pp,pallot)
    {double xlis, ylis,pyt;
     d = (x-pp->x)*(x-pp->x) + (y-pp->y)*(y-pp->y); if(d==0) d=1;
     xlis=(pp->x-x)/d*30;
     ylis= (pp->y-y)/d*30;
     if ( (pyt=pytis(0,0,xlis,ylis)) > 1.5)
     { xlis= xlis/pyt*1.5;
       ylis= ylis/pyt*1.5;
     }
    pp->xx+=xlis; pp->yy+=ylis;

    }
    teksti.lisaa("BOOOOOOOOOOOOOOOM!!!!!!!",1);
    tyyppi=6;
    b=1;
  }

  if (tuhoa) tyyppi=6;

  if (x < 10 )         x=10;
  if (y < 10 )         y=10;
  if (x > 320*koko-10) x=320*koko-10;
  if (y > 240*koko-10) y=240*koko-10;

  if(tyyppi==6 && !eisaapoistaa) delete(this);

  return b;
}

else { if (next!=0) return next->liikuta(); else return 0; }

}



bool liikutapallot()
{ bool b=1;
  while( annakello() && b==1 && !pakkoheitto)
  { b = pallot->liikuta();
  }
  return b && !pakkoheitto;
}


int hetki=0;

inline double ratkaisu(double x1, double y1, double x2, double y2,
                       double x3, double y3, double x4, double y4)
{ // return * (x1,y1) + (x2,y2) = l* (x3,y3) + (x4,y4) \exists l

   if (x1*y3 - y1*x3 == 0)
   { if (y3!=0) x1+=0.001; else
     if (x1!=0) y3+=0.001; else
     if (y1!=0) x3+=0.001; else
     if (x3!=0) y1+=0.001;
   }

   return (y2*x3 - x2*y3 + x4*y3 - y4*x3) / (x1*y3 - y1*x3);

}


bool jousipallo::liikuta()
{ if (pytis(x,y,p->x,p->y) > 15 )
  { xx += (p->x-x) *0.001;
    yy += (p->y-y) *0.001;
    p->xx += (x-p->x) *0.001;
    p->yy += (y-p->y) *0.001;
  }
  return pallo::liikuta();
}


class raskassnadi : public pmeste
{ public:
  raskassnadi(este **e,int x1, int y1, int x2, int y2) :
  pmeste(e,x1,y1,x2,y2) {prioriteetti=0.1; }
  virtual void tormayta(pallo *p1, pallo *p2);
  virtual void piirra(BITMAP *bmp);
};

void raskassnadi::piirra(BITMAP *bmp)
{ rrectfill(bmp, x,y,xx,yy, 16); }

void raskassnadi::tormayta(pallo *p1, pallo *p2)
{ double bx = p1->x - p2->x; double by= p1->y - p2->y;
  double cx = p1->xx - p2-> xx; double cy = p1->yy - p2->yy;

     if (bx*cx + by*cy < 0 )
     { double sk =  ( bx * p1->xx + by * p1->yy ) / ( bx*bx + by*by);
       double ssk = ( bx * p2->xx + by * p2->yy) / ( bx*bx + by*by );

       if (p1->tyyppi==0) {p2->xx +=  (sk -ssk) *bx*2;
                           p2->yy +=  (sk -ssk) *by*2;}
       else if (p2->tyyppi==0) { p1->xx +=  (ssk -sk) *bx*2;
                                 p1->yy +=  (ssk -sk) *by*2;}
       else { p1->xx +=  (ssk -sk) *bx;
              p1->yy +=  (ssk -sk) *by;
              p2->xx +=  (sk -ssk) *bx;
              p2->yy +=  (sk -ssk) *by; }
     }
}

class vaihtotormays : public raskassnadi
{ public:
  vaihtotormays(este **e,int x1, int y1, int x2, int y2)
  : raskassnadi(e,x1,y1,x2,y2) {}
  virtual void tormayta(pallo *p1, pallo *p2);
};

void vaihtotormays::tormayta(pallo *p1, pallo *p2)
{ double bx = p1->x - p2->x; double by= p1->y - p2->y;
  double cx = p1->xx - p2-> xx; double cy = p1->yy - p2->yy;
  int varasto;

     if (bx*cx + by*cy < 0 )
     { double sk =  ( bx * p1->xx + by * p1->yy ) / ( bx*bx + by*by);
       double ssk = ( bx * p2->xx + by * p2->yy) / ( bx*bx + by*by );
       p2->xx +=  (sk -ssk) *bx;
       p2->yy +=  (sk -ssk) *by;
       p1->xx +=  (ssk -sk) *bx;
       p1->yy +=  (ssk -sk) *by;
       if(p1->tyyppi!=0 && p2->tyyppi!=0)
       { varasto=p1->tyyppi; p1->tyyppi=p2->tyyppi; p2->tyyppi=varasto; }
     }
}

class annihiloitormays : public raskassnadi
{ public:
  annihiloitormays(este **e,int x1, int y1, int x2, int y2)
  : raskassnadi(e,x1,y1,x2,y2) {}
  virtual void tormayta(pallo *p1, pallo *p2);
};

void annihiloitormays::tormayta(pallo *p1, pallo *p2)
{ double bx = p1->x - p2->x; double by= p1->y - p2->y;
  double cx = p1->xx - p2-> xx; double cy = p1->yy - p2->yy;
  int varasto;

     if (bx*cx + by*cy < 0 )
     { if(p1->tyyppi!=0 && p1->tyyppi!=5) p1->tuhoa=1;
       if(p2->tyyppi!=0 && p2->tyyppi!=5) p2->tuhoa=1;
     }
}




class jousitykki : public este
{ public:
  int x,y,xx,yy, tx,ty; double txx,tyy; int passiivi;
  jousitykki(este **e, int x1, int y1, int xx1, int yy1,
                       int tx1, int ty1, double txx1, double tyy1);
  virtual void piirra(BITMAP *bmp);
  virtual void tormaa(pallo *p);
};

jousitykki::jousitykki(este **e, int x1, int y1, int xx1, int yy1,
int tx1, int ty1, double txx1, double tyy1) : este(e)
{ x=x1+kantax; y=y1+kantay; xx=xx1+kantax; yy=yy1+kantay;
  tx=tx1+kantax; ty=ty1+kantay; txx=txx1; tyy=tyy1;
  passiivi=aika-100; prioriteetti=0.6;
}

void jousitykki::piirra(BITMAP *bmp)
{ rect(bmp,x-kantax,y-kantay,xx-kantax,yy-kantay, 31 ); }

void jousitykki::tormaa(pallo *p)
{ pallo *pp; int i;
  if (p->x > x && p->y > y && p->x < xx && p->y < yy && passiivi+100 < aika
      && p->tyyppi!=0 && p->tyyppi!=5)
  { passiivi=aika;
    i=0;
    FOR_EACH(pp,pallot) i++;
    if (i<200) new jousipallo(tx,ty,txx,tyy, p->tyyppi,p);
  }
}

class painovoima : public este
{ public:
  int x,y,xx,yy; double dx, dy; int kell;
  painovoima(este **e, int x1,int y1,int xx1, int yy1);
  virtual void piirra(BITMAP *bmp);
  virtual void tormaa(pallo *p);
};

painovoima::painovoima(este **e, int x1, int y1, int xx1, int yy1)
: este(e)
{ x=x1+kantax; y=y1+kantay; xx=xx1+kantax; yy=yy1+kantay;
  dx=(x+xx)/2; dy=(y+yy)/2; kell=aika;
  prioriteetti=0.3;
}

void painovoima::piirra(BITMAP *bmp)
{ int i; int x1,y1;
  for(i=0; i<1000; i++)
  { x1=rand() % (xx-x);
    y1=rand() % (yy-y);
    pputpixel(bmp,x+x1,y+y1, 1);
  }
}

void painovoima::tormaa(pallo *p)
{ if (p->x>x && p->x<xx&& p->y>y&&p->y<yy)
  { if (p->tyyppi==0 || p->tyyppi==5)
    { dx=p->x; dy=p->y; kell=aika; }
    else if(pytis(p->x,p->y,dx,dy) >15 && kell > aika-5 )
    { double ddx=dx-p->x; double ddy=dy-p->y;
      double dd = sqrt( ddx*ddx+ddy*ddy ) * ( ddx*ddx + ddy*ddy );
      if (dd!=0) { p->xx+=ddx/dd*10; p->yy+=ddy/dd*10; }
    }
  }
}

class ruoho : public este
{ public:
  int x,y,xx,yy;
  ruoho(este **e,int x1,int y1,int x2,int y2);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bmp);
};

void ruoho::piirra(BITMAP *bmp)
{ if(vari==0) rrectfill(bmp,x,y,xx,yy, 10);
  else if(vari==2)
  { int i; for(i=x; i<xx; i+=2)
    lline(bmp, i,y,i,yy, 13);
  }
  else rrectfill(bmp,x,y,xx,yy,  0);
}

void ruoho::tormaa(pallo *p)
{ if( p->x>= x && p->x <= xx && p->y >=y && p->y<=yy)
 { if (p->xx!=0 || p->yy!=0 )
   { p->xx-=0.001*p->xx/sqrt(p->xx*p->xx+p->yy*p->yy);
     p->yy-=0.001*p->yy/sqrt(p->xx*p->xx+p->yy*p->yy);
   }
 }
}

ruoho::ruoho(este **e,int x1,int y1,int x2,int y2) : este(e)
  { x=x1+kantax; y=y1+kantay; xx=x2+kantax; yy=y2+kantay; prioriteetti=0;
     if (vari==2) prioriteetti=1.1; }

class selitys : public este
{ public:
  int x,y,xx,yy; int lippu;
  char s[500];
  selitys(este **e,int x1,int y1,int x2,int y2, char *ss);
  virtual void tormaa(pallo *p);
};

  selitys::selitys(este **e,int x1,int y1,int x2,int y2, char *ss) : este(e)
  { int i; x=x1+kantax; y=y1+kantay; xx=x2+kantax; yy=y2+kantay;
   i=0; while(ss[i]!=0) {s[i]=ss[i]; i++;} s[i]=0; lippu=0; prioriteetti=0; }

  void selitys::tormaa(pallo *p)
  { if( p->x>= x && p->x <= xx && p->y >=y && p->y<=yy && p->tyyppi==0 && lippu==0 )
    { teksti.lisaa(s,1); lippu=1;
    }
  }



class pitkaruoho : public este
{ public:
  int x,y,xx,yy;
  pitkaruoho(este **e,int x1,int y1,int x2,int y2);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bmp);
};

void pitkaruoho::piirra(BITMAP *bmp)
{ rrectfill(bmp,x,y,xx,yy,13);
}

pitkaruoho::pitkaruoho(este **e,int x1,int y1,int x2,int y2) : este(e)
{ x=x1+kantax; y=y1+kantay; xx=x2+kantax; yy=y2+kantay; prioriteetti=0; }

void pitkaruoho::tormaa(pallo *p)
{ if( p->x>= x && p->x <= xx && p->y >=y && p->y<=yy)
    { if (p->xx!=0 || p->yy!=0 )
      { p->xx-=0.002*p->xx/sqrt(p->xx*p->xx+p->yy*p->yy);
        p->yy-=0.002*p->yy/sqrt(p->xx*p->xx+p->yy*p->yy);
      }
    }
}


class nippu : public este
{ public:
  int x,y,xx,yy;
  este *pohja;
  nippu(este **e, int x1, int y1,int xx1,int yy1);
  virtual void tormaa(pallo *p);
  virtual void paivita(BITMAP *bmp);
  virtual void piirra(BITMAP *bmp);
  virtual void lisaapiirrettava();
};

  nippu::nippu(este **e, int x1, int y1,int xx1,int yy1) : este(e)
  { x=x1+kantax-4; y=y1+kantay-4; xx=xx1+kantax+4; yy=yy1+kantay+4;
    pohja=0; prioriteetti=0; }

  void nippu::tormaa(pallo *p)
  {este *e; if(p->x >= x && p->x <= xx && p->y >= y && p->y <= yy)
    FOR_EACH(e,pohja) e->tormaa(p);}

  void nippu::paivita(BITMAP *bmp)
  { este *e; FOR_EACH(e, pohja) e->paivita(bmp);
  }

  void nippu::lisaapiirrettava()
  { este *e; FOR_EACH(e, pohja) e->lisaapiirrettava(); }

  void nippu::piirra(BITMAP *bmp)
  { este *e; FOR_EACH(e, pohja) e->piirra(bmp); }

class boxi : public este
{ public:
  int x,y,xx,yy;
  este *yla, *ala, *oik, *vas;
  boxi(este **e, int x1, int y1,int xx1,int yy1);
  virtual void tormaa(pallo *p);
  virtual void paivita(BITMAP *bmp);
  virtual void lisaapiirrettava();
  virtual void piirra(BITMAP *bmp);
};

  boxi::boxi(este **e, int x1, int y1,int xx1,int yy1) : este(e)
  { x=x1+kantax; y=y1+kantay; xx=xx1+kantax; yy=yy1+kantay;
    yla=0; ala=0; vas=0; oik=0; prioriteetti=0; }

  void boxi::tormaa(pallo *p)
  {este *e; if(p->x >= x-4 && p->x <= xx+4 && p->y >= y-4 && p->y <= yy+4)
   if (p->y < y || p->y > yy )
   { FOR_EACH(e,yla) e->tormaa(p);
     FOR_EACH(e,ala) e->tormaa(p);
     FOR_EACH(e,oik) e->tormaa(p);
     FOR_EACH(e,vas) e->tormaa(p);
   } else
   { FOR_EACH(e,vas) e->tormaa(p);
     FOR_EACH(e,oik) e->tormaa(p);
     FOR_EACH(e,yla) e->tormaa(p);
     FOR_EACH(e,ala) e->tormaa(p);
   }
  }

  void boxi::paivita(BITMAP *bmp)
  { este *e;
    FOR_EACH(e, yla) e->paivita(bmp);
    FOR_EACH(e, ala) e->paivita(bmp);
    FOR_EACH(e, oik) e->paivita(bmp);
    FOR_EACH(e, vas) e->paivita(bmp);
  }

   void boxi::lisaapiirrettava()
   { este *e;
     FOR_EACH(e, yla) e->lisaapiirrettava();
     FOR_EACH(e, ala) e->lisaapiirrettava();
     FOR_EACH(e, vas) e->lisaapiirrettava();
     FOR_EACH(e, oik) e->lisaapiirrettava();
   }

   void boxi::piirra(BITMAP *bmp)
   { este *e;
     FOR_EACH(e, yla) e->piirra(bmp);
     FOR_EACH(e, ala) e->piirra(bmp);
     FOR_EACH(e, oik) e->piirra(bmp);
     FOR_EACH(e, vas) e->piirra(bmp);
   }

class teleport : public este
{ public:
  int x1,y1, xx1, yy1, x2, y2, xx2, yy2;
  teleport(este **e,int ax1, int ay1, int axx1, int ayy1,
                    int ax2, int ay2, int axx2, int ayy2);
  int testaatormays(int x,int y,int xx,int yy, pallo *p);
  void teleporttaa(int x, int y, int xx, int yy, pallo *p);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bit);

};

  teleport::teleport(este **e,int ax1, int ay1, int axx1, int ayy1,
                    int ax2, int ay2, int axx2, int ayy2) : este(e)
  { x1=ax1+kantax; y1=ay1+kantay; xx1=axx1+kantax; yy1=ayy1+kantay;
    x2=ax2+kantax; y2=ay2+kantay; xx2=axx2+kantax; yy2=ayy2+kantay;
    prioriteetti=1.1; }

  int teleport::testaatormays(int x,int y,int xx,int yy, pallo *p)
  { double a = ratkaisu(xx-x, yy-y, x,y, yy-y, x-xx, p->x, p->y);
    double b = ratkaisu(yy-y,x-xx,p->x,p->y,xx-x,yy-y,x,y) ;

     if (a>=0 && a<=1 && abs(b)*pytis(x,y,xx,yy) <= 3 &&
     tulo(b*(yy-y),b*(x-xx),p->xx,p->yy) > 0 )

    { double mx = (xx-x) / pytis(x,y,xx,yy);
      double my = (yy-y) / pytis(x,y,xx,yy);
      double nx = p->xx*mx + p->yy*my;
      double ny = p->yy*mx - p->xx*my;
      p->xx=nx;
      p->yy=ny;
      p->x=a;
      p->y=b;
      return(1);
    }
  return(0);
  }

  void teleport::teleporttaa(int x, int y, int xx, int yy, pallo *p)
  { double mx = (xx-x) / pytis(x,y,xx,yy);
    double my = (yy-y) / pytis(x,y,xx,yy);
    double nx = p->xx*mx - p->yy*my;
    double ny = p->yy*mx + p->xx*my;
    double ux = p->x * (xx-x) + p->y * (yy-y) + x;
    double uy = p->x * (yy-y) + p->y * (x-xx) + y ;
    p->x=ux; p->y=uy; p->xx=nx; p->yy=ny;
  }

  void teleport::tormaa(pallo *p)
  { if ( testaatormays(x1,y1,xx1,yy1,p))
       teleporttaa (x2,y2,xx2,yy2,p); else
    if ( testaatormays(x2,y2,xx2,yy2,p))
       teleporttaa(x1,y1,xx1,yy1,p);
  }

  void teleport::piirra(BITMAP *bit) {lline(bit,x1,y1,xx1,yy1,22);
                               lline(bit,x2,y2,xx2,yy2,22);
                               }


class monttu : public este
{ public:
  int x; int y; int r1; int r2; double h;
  monttu(este **e, int x1, int y1, int rr1, int rr2, double hh);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bit);
};

  monttu::monttu(este **e, int x1, int y1, int rr1, int rr2, double hh)
  : este(e) { x=x1+kantax; y=y1+kantay; r1=rr1; r2=rr2; h=hh;
  prioriteetti=0.2; }

  void monttu::tormaa(pallo *p)
  { double a = pytis(x,y,p->x,p->y);
    if (a > r1 && a < r2)
    { p->xx += (x-p->x) / a *h;
      p->yy += (y-p->y) / a *h;
    }
  }

  void monttu::piirra(BITMAP *bit)
  {  int i; double d; double dd; int x1, y1,g; if (h<0) i=2; else i=1;
     int xmin,ymin,xmax,ymax; double hh;

     xmin=int(x-r2); if (xmin-kantax < 0) xmin=kantax;
     xmax=int(x+r2); if (xmax-kantax > 320) xmax=320+kantax;
     ymin=int(y-r2); if (ymin-kantay < 0) ymin=kantay;
     ymax=int(y+r2); if (ymax-kantay > 240) ymax=240+kantay;
     hh=abs(h)*300;

     for(y1=ymin; y1< ymax; y1++)
     { xmin=int(x-sqrt(double(r2)*r2-double(y1-y)*(y1-y) + 1 ) );
       if (xmin-kantax < 0) xmin=kantax;
       xmax=int(x+sqrt(double(r2)*r2-double(y1-y)*(y1-y) + 1) );
       if (xmax-kantax > 320) xmax=320+kantax;

       for(x1=xmin; x1< xmax; x1++)
       { dd=pytis(x1,y1,x,y); d=dd;
         if (d < r1) d=r1;
         d = (r2 - d)*hh;
         if (d>100) d=100;
         if ( d!=0 && ( d > rasteri(x1,y1)  ||
         ( dd > r1-1 && dd < r1+1 && d>isorasteri(x1,y1) )
         ) && (g=_getpixel(bit,x1-kantax,y1-kantay)) % 3 == 1)
         _putpixel(bit,x1-kantax,y1-kantay,i+g );
       }
     }

  }

class palloharjanne : public este
{ public:
  int x; int y; double r1; double r2; double r3; double k;
  palloharjanne(este **e, int x1, int y1, double rr1, double rr2, double kk);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bit);
};

  palloharjanne::palloharjanne(este **e, int x1, int y1, double rr1, double rr2, double kk)
  : este(e) { x=x1+kantax; y=y1+kantay; r1=rr1; r3=rr2;
  r2 = (r1+r3)/2; k=kk; prioriteetti=0.2; }

  void palloharjanne::tormaa(pallo *p)
  { double a = pytis(x,y,p->x,p->y);
    if (a<r3 && a>r1)
    { if (a<r2) { p->xx += (x-p->x) /a *k; p->yy+= (y-p->y) / a *k; }
      if (a>r2) { p->xx += (p->x-x) /a *k; p->yy+= (p->y-y) / a *k; }
    }
  }

  void palloharjanne::piirra(BITMAP *bit)
  { int i; double d, sq; int x1, y1; int lippu;
    int xmin, ymin, xmax, ymax,g; double kk;

    if (k<0) i=1; else i=2;
    ymin=int(y-r3); if(ymin-kantay < 0) ymin=0+kantay;
    ymax=int(y+r3); if(ymax-kantay >240) ymax=240+kantay;
    kk=abs(k)*300;

     for(y1=ymin; y1< ymax; y1++)
     {  xmin=int(x-sqrt( double(r3)*r3 - double(y1-y)*(y1-y) +1 )  );
        if(xmin-kantax < 0) xmin=0+kantax;
        xmax=int(x+sqrt( double(r3)*r3 -double(y1-y)*(y1-y) +1 )  );
        if(xmax-kantax > 320) xmax=320+kantax;
        if ( abs(y1-y)+1 >  r1 ) lippu=1;
        else
         { lippu=0;
           sq = sqrt( double(r1)*r1 - double(y1-y)*(y1-y) );
         }

       for(x1=xmin; x1< xmax; x1++)
       { d=abs( pytis(x1,y1,x,y) -r2 );
         d=(r2-r1-d)*kk;
         if (d>100) d=100;
         if ( d!=0 && d > rasteri(x1,y1) &&
             (g=_getpixel(bit,x1-kantax,y1-kantay)) % 3 == 1)
         _putpixel(bit,x1-kantax,y1-kantay,i+g );

         if( lippu==0 && x1 > x - sq  )
         { x1 = x + int(sq); lippu=1; }
       }
     }


  }


class biliskentta : public este
{ public:
  int active;
  int x,y,xx,yy;
  biliskentta(este **e, int x1,int y1,int xx1,int yy1);
  virtual void tormaa(pallo *p);
  virtual void paivita(BITMAP *bmp);
  virtual void lisaapiirrettava() {}
  void teepallot();
  void teevaspallot();
};

biliskentta::biliskentta(este **e, int x1, int y1, int xx1, int yy1) : este(e)
{ x=x1+kantax; y=y1+kantay; xx=xx1+kantax; yy=yy1+kantay; active=-1;
}

void biliskentta::teepallot()
{ new pallo( (x+3*xx)/4,   (y+yy)/2,   0,0,3);
  new pallo( (x+3*xx)/4+4, (y+yy)/2+4, 0,0,3);
  new pallo( (x+3*xx)/4+4, (y+yy)/2-4, 0,0,3);
  new pallo( (x+3*xx)/4+8, (y+yy)/2+8, 0,0,3);
  new pallo( (x+3*xx)/4+8, (y+yy)/2   ,0,0,3);
  new pallo( (x+3*xx)/4+8, (y+yy)/2-8, 0,0,3);
}

void biliskentta::teevaspallot()
{ new pallo( (3*x+xx)/4,   (y+yy)/2,   0,0,3);
  new pallo( (3*x+xx)/4-4, (y+yy)/2+4, 0,0,3);
  new pallo( (3*x+xx)/4-4, (y+yy)/2-4, 0,0,3);
  new pallo( (3*x+xx)/4-8, (y+yy)/2+8, 0,0,3);
  new pallo( (3*x+xx)/4-8, (y+yy)/2   ,0,0,3);
  new pallo( (3*x+xx)/4-8, (y+yy)/2-8, 0,0,3);
}


void biliskentta::tormaa(pallo *p)
{
  if (active==-1 && x < p->x && xx>p->x && y < p->y && yy > p->y )
  {active=0; teevaspallot(); }


  if (active==1 && x < p->x && xx>p->x && y < p->y && yy > p->y )
  {active=0; teepallot(); }

}

void biliskentta::paivita(BITMAP *bmp)
{ if ( active==0 && (pallot==0 ||
     ( pallot->next==0 && pallot->x > (x+xx)/2  ) ) ) active = -1;
  if ( active==0 && (pallot==0 ||
     ( pallot->next==0 ) ) ) active = 1;

  if (active==1)
  { ccircle ( bmp, (x+3*xx)/4, (y+yy)/2, 2,     4);
    ccircle ( bmp, (x+3*xx)/4+4, (y+yy)/2+4, 2, 4);
    ccircle ( bmp, (x+3*xx)/4+4, (y+yy)/2-4, 2, 4);
    ccircle ( bmp, (x+3*xx)/4+8, (y+yy)/2+8, 2, 4);
    ccircle ( bmp, (x+3*xx)/4+8, (y+yy)/2, 2,   4);
    ccircle ( bmp, (x+3*xx)/4+8, (y+yy)/2-8, 2, 4);
  }

  if (active==-1)
  { ccircle ( bmp, (3*x+xx)/4, (y+yy)/2, 2,     4);
    ccircle ( bmp, (3*x+xx)/4-4, (y+yy)/2+4, 2, 4);
    ccircle ( bmp, (3*x+xx)/4-4, (y+yy)/2-4, 2, 4);
    ccircle ( bmp, (3*x+xx)/4-8, (y+yy)/2+8, 2, 4);
    ccircle ( bmp, (3*x+xx)/4-8, (y+yy)/2, 2,   4);
    ccircle ( bmp, (3*x+xx)/4-8, (y+yy)/2-8, 2, 4);
  }

}


class kaarre : public este
{ public:
  int x,y,xx,yy; double r;
  kaarre(este **e,int x1,int y1,int x2,int y2, double r1);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bmp);
};

  kaarre::kaarre(este **e,int x1,int y1,int x2,int y2, double r1) : este(e)
  { x=x1+kantax; y=y1+kantay; xx=x2+kantax; yy=y2+kantay; r=r1;
   prioriteetti=0.3; }

  void kaarre::tormaa(pallo *p)
  { if( p->x>= x && p->x <= xx && p->y >=y && p->y<=yy)
    { if (p->xx!=0 || p->yy!=0 )
      { double ax=1; double ay=r; double b; double nx; double ny;
        b = sqrt(ax*ax+ay*ay); ax=ax/b; ay=ay/b;
        nx = p->xx*ax - p->yy*ay;
        ny = p->xx*ay + p->yy*ax;
        p->xx=nx;
        p->yy=ny;
      }
    }
  }

  void kaarre::piirra(BITMAP *bmp)
  { BITMAP *bmp2; double d; int x1; int y1;
    bmp2=create_bitmap(40,40);
    rectfill(bmp2,0,0,39,39,10);
    if (r>0)
    {
    for(d=0 ; d < 3*PI/2; d+=0.01)
    putpixel(bmp2, int(20+cos(d)*10), int(20+sin(d)*10), 31);
    line(bmp2, 20, 10, 15, 5, 31);
    line(bmp2, 20, 10, 15, 15, 31);
    }
    else
    {
    for(d=0 ; d < 3*PI/2; d+=0.01)
    putpixel(bmp2, int(20-cos(d)*10), int(20+sin(d)*10), 31);
    line(bmp2, 20, 10, 25, 5, 31);
    line(bmp2, 20, 10, 25, 15, 31);
    }
    for(x1=x; x1 < xx; x1+=40)
    for(y1=y; y1 < yy; y1+=40)
    blit(bmp2, bmp, 0,0, x1-kantax, y1-kantay, 40,40);
    destroy_bitmap(bmp2);
  }



class voimakentta : public este
{ public:
  int x,y,xx,yy; double vx,vy;
  voimakentta(este **e,int x1,int y1,int x2,int y2, double vx1, double vy1);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bit);
};


  voimakentta::voimakentta(este **e,int x1,int y1,int x2,int y2, double vx1, double vy1)
  : este(e)
  { x=x1+kantax; y=y1+kantay; xx=x2+kantax; yy=y2+kantay;
    vx=vx1; vy=vy1; prioriteetti=0.4;}

  void voimakentta::tormaa(pallo *p)
  { if( p->x>= x && p->x <= xx && p->y >=y && p->y<=yy)
    { if (p->xx!=0 || p->yy!=0 )
      { p->xx+=vx; p->yy+=vy; p->pl=1;
      }
    }
  }

inline int min(int x, int y)
{ if (x<y) return x; else return y; }

  void voimakentta::piirra(BITMAP *bit)
  { int x0,y0; int xa; int ya; int xl; int yl;
    if (vari!=2)
    {
    rrectfill(bit,x,y,xx,yy,33);
    if (abs(vx) > abs(vy) )
    { if (vx>0) {x0=1; y0=0; } else {x0=-1; y0=0; } }
    else
    { if( vy>0) {x0=0; y0=1; } else {x0=0; y0=-1; } }
    xa=(x+xx)/2; ya=(y+yy)/2;
    xl=int( (xx-x)/2.1); yl=int( (yy-y) /2.1);
    lline(bit, xa-xl*x0, ya-yl*y0, xa+xl*x0, ya+yl*y0, 34);

    lline(bit, xa-min(xl,yl)*y0, ya-min(yl,xl)*x0, xa+xl*x0, ya+yl*y0, 34);
    lline(bit, xa+min(xl,yl)*y0, ya+min(yl,xl)*x0, xa+xl*x0, ya+yl*y0, 34);
    } else
    {
    rrectfill(bit,x,y,xx,yy,29);
    }
  }


class sotilasalue : public este
{ public:
  int x,y,xx,yy; BITMAP *kuva;
  sotilasalue(este **e,int x1,int y1,int x2,int y2);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bit);

};

  sotilasalue::sotilasalue(este **e,int x1,int y1,int x2,int y2)
  : este(e)
  { x=x1+kantax; y=y1+kantay; xx=x2+kantax; yy=y2+kantay; prioriteetti=0.4;
    kuva=create_bitmap(x2-x1+1, y2-y1+1);
    rectfill(kuva,0,0,x2-x1,y2-y1,10);
    text_mode(-1);
    textout(kuva,font,
    "MILITARY ZONE MILITARY ZONE MILITARY ZONE MILITARY ZONE",
    1,3,34);
    rect(kuva,0,0,x2-x1,y2-y1,34);
  }

  void sotilasalue::tormaa(pallo *p)
  { if( p->x>= x && p->x <= xx && p->y >=y && p->y<=yy)
        { if (p->tyyppi!=0) p->tyyppi=4;
          if (abs(xx) < 0.03 && abs(yy)<0.03) {xx*=2; yy*=2;}
        }

  }

  void sotilasalue::piirra(BITMAP *bit)
  { /*rrectfill(bit,x,y,xx,yy,0);
    rect(bit,x-kantax,y-kantay,xx-kantax,yy-kantay,2);
    set_clip(bit,x-kantax+1,y-kantay+1,xx-kantax-1,yy-kantay-1);
    textout(bit,font,
    "MILITARY ZONE MILITARY ZONE MILITARY ZONE MILITARY ZONE",
    x-kantax+1,y-kantay+3,2);
    set_clip(bit,0,0,319,239); */
    blit(kuva,bit,0,0,x-kantax,y-kantay,xx-x+1,yy-y+1);
  }

class varoitus : public este
{ public: int x,y;
  varoitus(este **e, int x1,int y1);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bit);
};

varoitus::varoitus(este **e, int x1,int y1) : este(e)
{ x=x1+kantax; y=y1+kantay; prioriteetti=0.4; }

void varoitus::tormaa(pallo *p)
{}

void varoitus:: piirra(BITMAP *bit)
{ textout(bit, font, "Here Are The Monsters", x-kantax, y-kantay, 3);}


class ohje : public este
{ public:
  int sivu;
  ohje(este **e, int ssivu) : este(e) { sivu=ssivu; prioriteetti=0.4; }
  virtual void tormaa(pallo *p) {}
  virtual void piirra(BITMAP *bit);
};

void ohje::piirra(BITMAP *bit)
{ int i;
  for(i=0; i<22; i++)
  textout(bit, font, ohjeet[sivu][i], 15, 30+9*i, 2);
}


class snadihiekka : public este
{ public:
  int x,y,xx,yy; double teho;
  snadihiekka(este **e,int x1,int y1,int x2,int y2, double teh=0.99);
  virtual void piirra(BITMAP *bit);
  virtual void tormaa(pallo *p);
};

  snadihiekka::snadihiekka(este **e,int x1,int y1,int x2,int y2, double teh=0.99) : este(e)
  { x=x1+kantax; y=y1+kantay; xx=x2+kantax; yy=y2+kantay; teho=teh;
    prioriteetti=0.35; }

  void snadihiekka::tormaa(pallo *p)
  { if( p->tyyppi==0 && p->x>= x && p->x <= xx && p->y >=y && p->y<=yy)
    { if (p->xx!=0 || p->yy!=0 )
      { p->xx*=teho;
        p->yy*=teho;
      }
    }
  }

  void snadihiekka::piirra(BITMAP *bit)
  {
  rrectfill(bit,x,y,xx,yy,21);

  }


class hiekka : public este
{ public:
  int x,y,xx,yy; double teho;
  hiekka(este **e,int x1,int y1,int x2,int y2, double teh=0.99);
  virtual void piirra(BITMAP *bit);
  virtual void tormaa(pallo *p);
};

  hiekka::hiekka(este **e,int x1,int y1,int x2,int y2, double teh=0.99) : este(e)
  { x=x1+kantax; y=y1+kantay; xx=x2+kantax; yy=y2+kantay; teho=teh;
    prioriteetti=0.35; }

  void hiekka::tormaa(pallo *p)
  { if( p->x>= x && p->x <= xx && p->y >=y && p->y<=yy)
    { if (p->xx!=0 || p->yy!=0 )
      { p->xx*=teho;
        p->yy*=teho;
      }
    }
  }

  void hiekka::piirra(BITMAP *bit)
  {
  int x1; int y1;
  if (vari!=1)
  { int xmin,xmax,ymin,ymax;
    xmin=x-2; if (xmin-kantax < 0) xmin=kantax;
    xmax=xx+2; if (xmax-kantax > 320) xmax=320+kantax;
    ymin=y-2; if (ymin-kantay < 0) ymin=kantay;
    ymax=yy+2; if (ymax-kantay > 240) ymax=240+kantay;
    for(x1=xmin; x1 < xmax; x1++)
    for(y1=ymin; y1 < ymax; y1++)
    if (rand()%100 > 50 ) _putpixel(bit,x1-kantax,y1-kantay,21);
  } else
  rrectfill(bit,x,y,xx,yy,26);

  }

class suuntahiekka : public este
{ public:
  int x,y,xx,yy, s; double teho;
  suuntahiekka(este **e,int x1,int y1,int x2,int y2, int ss, double teh=0.97);
  virtual void piirra(BITMAP *bit);
  virtual void tormaa(pallo *p);
};

suuntahiekka::suuntahiekka
(este **e,int x1,int y1,int x2,int y2, int ss, double teh=0.97) : este(e)
  { x=x1+kantax; y=y1+kantay; xx=x2+kantax; yy=y2+kantay; teho=teh;
    s=ss;
    prioriteetti=0.35; }

  void suuntahiekka::tormaa(pallo *p)
  { if( p->x>= x && p->x <= xx && p->y >=y && p->y<=yy)
    { if (p->xx!=0 || p->yy!=0 )
      { if(s) p->xx*=teho; else p->yy*=teho;

      }
    }
  }

  void suuntahiekka::piirra(BITMAP *bit)
  {
  int x1; int y1; int v; int xmin,xmax,ymin,ymax;
  if (vari!=1) v=21; else v=26;
  xmin=x-2; if (xmin-kantax < 0) xmin=kantax;
  xmax=xx+2; if (xmax-kantax > 320) xmax=320+kantax;
  ymin=y-2; if (ymin-kantay < 0) ymin=kantay;
  ymax=yy+2; if (ymax-kantay > 240) ymax=240+kantay;
  if (!s) for(y1=ymin; y1 < ymax; y1+=2)
    lline(bit,xmin,y1, xmax, y1,v);
  else for(x1=xmin; x1 < xmax; x1+=2)
    lline(bit,x1,ymin,x1,ymax,v);
  }


class miina : public este
{ public:
  int x,y;
  miina(este **e, int xx, int yy);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bit);
};

  miina::miina(este **e, int xx, int yy) : este(e) {
  x=xx+kantax; y=yy+kantay; prioriteetti=1; }

  void miina::tormaa(pallo *p)
  { if( (p->x - x)*(p->x-x)+(p->y -y)*(p->y-y) < 36 )

    { pallo *pp;
      FOR_EACH(pp,pallot)
      { double xlis,ylis,pyt;
        double d =(x-pp->x)*(x-pp->x)+(y-pp->y)*(y-pp->y);
        d=sqrt(sqrt(d));
        d=d*d*d;
        xlis=(pp->x-x)/d; ylis= (pp->y-y)/d;
        if ( (pyt=pytis(0,0,xlis,ylis)) > 1 )
        { xlis=xlis/pyt; ylis=ylis/pyt;}
        pp->xx+=xlis; pp->yy+=ylis;
      }
    }

  }

  void miina::piirra(BITMAP *bit)
  {
  ccircle(bit,x,y,3,0);
  lline(bit, x, y-5, x, y+5,0);
  lline(bit, x-4,y-4,x+4,y+4,0);
  lline(bit, x-4, y+4, x+4, y-4,0);
  lline(bit, x-5,y,x+5,y,0);
  }




class seina : public este
{ public:
  int x,y,xx,yy;
  seina(este **e,int xx1, int yy1, int xx2, int yy2);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bit);
};

  seina::seina(este **e,int xx1, int yy1, int xx2, int yy2) : este(e)
  { x=xx1+kantax; xx=xx2+kantax; y=yy1+kantay; yy=yy2+kantay;
    prioriteetti=1; }

  void seina::tormaa(pallo *p)
  {  double a = ratkaisu(xx-x, yy-y, x,y, yy-y, x-xx, p->x, p->y);
     double b = ratkaisu(yy-y,x-xx,p->x,p->y,xx-x,yy-y,x,y) ;

     if (a>=0 && a<=1 && abs(b)*pytis(x,y,xx,yy) <= 3 &&
     tulo(b*(yy-y),b*(x-xx),p->xx,p->yy) > 0 )
     { double axx= tulo(yy-y,x-xx,p->xx,p->yy)*(yy-y)/
       ( (yy-y)*(yy-y) + (xx-x)*(xx-x) );
       double ayy= tulo(yy-y,x-xx,p->xx,p->yy)*(x-xx)/
       ( (yy-y)*(yy-y) + (xx-x)*(xx-x) );
       p->xx-=2*axx;
       p->yy-=2*ayy;
     } else
     if( (xx-p->x)*(xx-p->x)+(yy-p->y)*(yy-p->y) < 9 &&
     tulo(xx-p->x,yy-p->y,p->xx,p->yy) > 0 )
     { double ax = xx-p->x; double ay=yy-p->y;
       b = ax*p->xx + ay*p->yy;
       p->xx-=2*b*ax/(ax*ax+ay*ay);
       p->yy-=2*b*ay/(ax*ax+ay*ay);
     } else
     if( (x-p->x)*(x-p->x)+(y-p->y)*(y-p->y) < 9 &&
     tulo(x-p->x,y-p->y,p->xx,p->yy) > 0 )
     { double ax = x-p->x; double ay=y-p->y;
       b = ax*p->xx + ay*p->yy;
       p->xx-=2*b*ax/(ax*ax+ay*ay);
       p->yy-=2*b*ay/(ax*ax+ay*ay);
     }
  }

  void seina::piirra(BITMAP *bit)
  { if  (vari!=1) lline(bit,x,y,xx,yy,19);
                 else lline(bit,x,y,xx,yy, 24);
  }


class pseudoliikkuva : public este
{ public:
  int x,y,xx,yy,t;
  pseudoliikkuva(este **e,int x1,int y1,int xx1,int yy1,int t1=0): este(e)
  {x=x1+kantax; y=y1+kantay; xx=xx1+kantax; yy=yy1+kantay; t=t1;
   prioriteetti=0; }
  virtual void tormaa(pallo *p);
};

void pseudoliikkuva::tormaa(pallo *p)
{
  if(p->x > x && p->y > y && p->x < xx && p->y < yy)
  { if (p->tyyppi!=0 && p->tyyppi!=5) p->pl=1;
    if (t) p->pl=1;
  }
}

class kuulansyoja : public seina
{ public:
  kuulansyoja(este **e,int xx1, int yy1, int xx2, int yy2) : seina(e,xx1,yy1,xx2,yy2) {}
  virtual void tormaa(pallo *p);
};

void kuulansyoja::tormaa(pallo *p)
{ double xx; double yy;
  xx=p->xx; yy=p->yy;
  seina::tormaa(p);
  if(p->tyyppi==3 && ( xx!= p->xx || yy!= p->yy ) ) p->tuhoa=1;
}



class hyppy: public este
{ public:
  int x; int y; int xx; int yy; int hx; int hy;
  hyppy(este **e, int x1, int y1, int x2, int y2, int hx1, int hy1);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bmp);
};

void hyppy::tormaa(pallo *p)
  {  double a = ratkaisu(xx-x, yy-y, x,y, yy-y, x-xx, p->x, p->y);
     double b = ratkaisu(yy-y,x-xx,p->x,p->y,xx-x,yy-y,x,y) ;

     if (a>=0 && a<=1 && abs(b)*pytis(x,y,xx,yy) <= 3 &&
     tulo(b*(yy-y),b*(x-xx),p->xx,p->yy) > 0 )
     { p->x+=hx; p->y+=hy;
     } else
     if( (xx-p->x)*(xx-p->x)+(yy-p->y)*(yy-p->y) < 9 &&
     tulo(xx-p->x,yy-p->y,p->xx,p->yy) > 0 )
     { p->x+=hx; p->y+=hy;
     } else
     if( (x-p->x)*(x-p->x)+(y-p->y)*(y-p->y) < 9 &&
     tulo(x-p->x,y-p->y,p->xx,p->yy) > 0 )
     { p->x+=hx; p->y+=hy;
     }
  }

void hyppy::piirra(BITMAP *bmp)
{ lline(bmp,x,y,xx,yy,22); }

hyppy::hyppy(este **e, int x1, int y1, int xx1, int yy1, int hx1, int hy1)
: este(e)
{ prioriteetti=1; x=x1+kantax; y=y1+kantay; xx=xx1+kantax; yy=yy1+kantay;
  hx=hx1; hy=hy1; }


class laser : public seina
{ public:
  int ylhaalla, sekvenssi, alkuasento;
  laser(este **e, int x1, int y1, int x2, int y2, int ylh, int sekv,
  int aa);
  virtual void tormaa(pallo *p);
  virtual void paivita(BITMAP *bmp);
  virtual void piirra(BITMAP *bmp) {}
};

laser::laser(este **e, int x1, int y1, int x2, int y2, int ylh, int sekv,
  int aa) : seina(e,x1,y1,x2,y2)
{ ylhaalla=ylh; sekvenssi=sekv; alkuasento=aa; }

void laser::tormaa(pallo *p)
{ if ( (aika+alkuasento) % sekvenssi < ylhaalla+1) seina::tormaa(p); }

void laser::paivita(BITMAP *bmp)
{ if ( (aika+alkuasento) % sekvenssi < ylhaalla+1)
  { activepyyhi->merkkaa(min(x,xx)-1,min(y,yy)-1,max(x,xx)+1,max(y,yy)+1 );
    lline(bmp,x,y,xx,yy,32);
  }
}

class pehmoseina : public este
{ public:
  int x,y,xx,yy; double d;
  pehmoseina(este **e,int xx1, int yy1, int xx2, int yy2, double d1=0.4);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bit);
};

  pehmoseina::pehmoseina(este **e,int xx1, int yy1, int xx2, int yy2, double d1=0.4) : este(e)
  { x=xx1+kantax; xx=xx2+kantax; y=yy1+kantay; yy=yy2+kantay; d=d1;
    prioriteetti=1; }

  void pehmoseina::tormaa(pallo *p)
  {  double a = ratkaisu(xx-x, yy-y, x,y, yy-y, x-xx, p->x, p->y);
     double b = ratkaisu(yy-y,x-xx,p->x,p->y,xx-x,yy-y,x,y) ;

     if (a>=0 && a<=1 && abs(b)*pytis(x,y,xx,yy) <= 3 &&
     tulo(b*(yy-y),b*(x-xx),p->xx,p->yy) > 0 )
     { double axx= tulo(yy-y,x-xx,p->xx,p->yy)*(yy-y)/
       ( (yy-y)*(yy-y) + (xx-x)*(xx-x) );
       double ayy= tulo(yy-y,x-xx,p->xx,p->yy)*(x-xx)/
       ( (yy-y)*(yy-y) + (xx-x)*(xx-x) );
       p->xx-=2*axx;
       p->yy-=2*ayy;
       p->xx*=d;
       p->yy*=d;
     } else
     if( (xx-p->x)*(xx-p->x)+(yy-p->y)*(yy-p->y) < 9 &&
     tulo(xx-p->x,yy-p->y,p->xx,p->yy) > 0 )
     { double ax = xx-p->x; double ay=yy-p->y;
       b = ax*p->xx + ay*p->yy;
       p->xx-=2*b*ax/(ax*ax+ay*ay);
       p->yy-=2*b*ay/(ax*ax+ay*ay);
       p->xx*=d;
       p->yy*=d;
     } else
     if( (x-p->x)*(x-p->x)+(y-p->y)*(y-p->y) < 9 &&
     tulo(x-p->x,y-p->y,p->xx,p->yy) > 0 )
     { double ax = x-p->x; double ay=y-p->y;
       b = ax*p->xx + ay*p->yy;
       p->xx-=2*b*ax/(ax*ax+ay*ay);
       p->yy-=2*b*ay/(ax*ax+ay*ay);
       p->xx*=d;
       p->yy*=d;
     }
  }

  void pehmoseina::piirra(BITMAP *bit)
  { if (vari!=1) lline(bit,x,y,xx,yy,20);
        else lline(bit,x,y,xx,yy,28);
  }


class kaari : public este
{ public:
  int x,y,r; double k1,k2;
  kaari(este **e, int x1,int y1,int r1,double k11,double k22) : este(e)
  { x=x1+kantax; y=y1+kantay; r=r1; k1=k11; k2=k22; prioriteetti=1; }
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bit);
};

void kaari::piirra(BITMAP *bit)
{ double k;
  for(k=k1; k <k2; k+=1.0/r)
  pputpixel(bit,x+int(r*cos(k)),y+int(r*sin(k)),19);
}

void kaari::tormaa(pallo *p)
{ double alkux=cos(k1); double alkuy=sin(k1);
  double loppux; double loppuy;
  double sijx=p->x-x; double sijy=p->y-y;
  double et=pytis(sijx,sijy,0,0);

  if (et > r+3 || et < r-3) return ;

  sijx=(p->x-x)*(alkux)+(p->y-y)*(alkuy);
  sijy=(p->y-y)*(alkux)-(p->x-x)*(alkuy);

  et=pytis(sijx, sijy,0,0);

  sijx=sijx/et; sijy=sijy/ et;

  loppux=cos(k2)*alkux + sin(k2)*alkuy;
  loppuy=sin(k2)*alkux - cos(k2)*alkuy;

  if( (loppuy < 0 && sijy > 0) ||
      (loppuy > 0 && sijy > 0 && sijx > loppux) ||
      (loppuy < 0 && sijy < 0 && sijx < loppux) )
  {   double d = (x-p->x)*(p->xx) + (y-p->y)*(p->yy);
      d/=(x-p->x)*(x-p->x)+(y-p->y)*(y-p->y);
      if( (d > 0 && et>r) || (d<0 && et<r))
      { p->xx-=2*(x-p->x)*d; p->yy-=2*(y-p->y)*d; }
  }
  else
  if (pytis(x+cos(k1)*r,y+sin(k1)*r,p->x,p->y) < 3 &&
     (x+cos(k1)*r-p->x)*(p->xx) + (y+sin(k1)*r-p->y)*(p->yy) > 0 )
    { double d = (x+cos(k1)*r-p->x)*(p->xx) +
                 (y+sin(k1)*r-p->y)*(p->yy);
      d/=(x+cos(k1)*r-p->x)*(x+cos(k1)*r-p->x)+
         (y+sin(k1)*r-p->y)*(y+sin(k1)*r-p->y);
      if( d > 0) { p->xx-=2*(x+cos(k1)*r-p->x)*d;
                   p->yy-=2*(y+sin(k1)*r-p->y)*d; }
    }
  else
  if (pytis(x+cos(k2)*r,y+sin(k2)*r,p->x,p->y) < 3 &&
     (x+cos(k2)*r-p->x)*(p->xx) + (y+sin(k2)*r-p->y)*(p->yy) > 0 )
    { double d = (x+cos(k2)*r-p->x)*(p->xx) +
                 (y+sin(k2)*r-p->y)*(p->yy);
      d/=(x+cos(k2)*r-p->x)*(x+cos(k2)*r-p->x)+
         (y+sin(k2)*r-p->y)*(y+sin(k2)*r-p->y);
      if( d > 0) { p->xx-=2*(x+cos(k2)*r-p->x)*d;
                   p->yy-=2*(y+sin(k2)*r-p->y)*d; }
    }
}


class voimaseina : public este
{ public:
  int x,y,xx,yy; double d;
  voimaseina(este **e,int xx1, int yy1, int xx2, int yy2, double d1=2);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bit);

};
  voimaseina::voimaseina(este **e,int xx1, int yy1, int xx2, int yy2, double d1=2) : este(e)
  { x=xx1+kantax; xx=xx2+kantax; y=yy1+kantay; yy=yy2+kantay; d=d1;
    prioriteetti=1.1; }

  void voimaseina::tormaa(pallo *p)
  {  double a = ratkaisu(xx-x, yy-y, x,y, yy-y, x-xx, p->x, p->y);
     double b = ratkaisu(yy-y,x-xx,p->x,p->y,xx-x,yy-y,x,y) ;
     double pyt;

     if (a>=0 && a<=1 && abs(b)*pytis(x,y,xx,yy) <= 3 &&
     tulo(b*(yy-y),b*(x-xx),p->xx,p->yy) > 0 )
     { double axx= tulo(yy-y,x-xx,p->xx,p->yy)*(yy-y)/
       ( (yy-y)*(yy-y) + (xx-x)*(xx-x) );
       double ayy= tulo(yy-y,x-xx,p->xx,p->yy)*(x-xx)/
       ( (yy-y)*(yy-y) + (xx-x)*(xx-x) );
       p->xx-=(1+d)*axx;
       p->yy-=(1+d)*ayy;
       if ((pyt=pytis(p->xx,p->yy,0,0)) > 2.9 )
       { p->xx= p->xx /pyt*2.9; p->yy=p->yy/pyt*2.9; }
     } else
     if( (xx-p->x)*(xx-p->x)+(yy-p->y)*(yy-p->y) < 9 &&
     tulo(xx-p->x,yy-p->y,p->xx,p->yy) > 0 )
     { double ax = xx-p->x; double ay=yy-p->y;
       b = ax*p->xx + ay*p->yy;
       p->xx-=(1+d)*b*ax/(ax*ax+ay*ay);
       p->yy-=(1+d)*b*ay/(ax*ax+ay*ay);
         if ((pyt=pytis(p->xx,p->yy,0,0)) > 2.9 )
       { p->xx= p->xx /pyt*2.9; p->yy=p->yy/pyt*2.9; }
     } else
     if( (x-p->x)*(x-p->x)+(y-p->y)*(y-p->y) < 9 &&
     tulo(x-p->x,y-p->y,p->xx,p->yy) > 0 )
     { double ax = x-p->x; double ay=y-p->y;
       b = ax*p->xx + ay*p->yy;
       p->xx-=(1+d)*b*ax/(ax*ax+ay*ay);
       p->yy-=(1+d)*b*ay/(ax*ax+ay*ay);
         if ((pyt=pytis(p->xx,p->yy,0,0)) > 2.9 )
       { p->xx= p->xx /pyt*2.9; p->yy=p->yy/pyt*2.9; }
     }
  }

  void voimaseina::piirra(BITMAP *bit)
  { lline(bit,x,y,xx,yy,2);
  }

class palautasnadi: public este
{ public:
  int x,y,xx,yy;
  palautasnadi(este **e, int x1, int y1, int xx1, int yy1) : este(e)
  {x=x1+kantax; y=y1+kantay; xx=xx1+kantax; yy=yy1+kantay; prioriteetti=0; }
  virtual void tormaa(pallo *p);
};

void palautasnadi::tormaa(pallo *p)
{
 if(p->tyyppi==5 && p->x >= x && p->x <= xx && p->y >= y && p->y <= yy)
 {p->tyyppi=0;}
}





class nappula : public este
{ public:
  int x,y,tila;
  este *onkasa;
  este *offkasa;
  este *actkasa;
  nappula(este **e, int xx, int yy, int t, int i=0);
  virtual void tormaa(pallo *p);
  virtual void paivita(BITMAP *bmp);
  virtual void lisaapiirrettava();
};

void nappula::tormaa(pallo *p)
{ double xx=p->xx;
  double yy=p->yy;
  este *e;
  FOR_EACH(e, actkasa) { e->tormaa(p); }
  if (p->xx !=xx || p->yy !=yy) {tila=1-tila; pyyhikaikki=1; }
  if (tila) { FOR_EACH(e, onkasa) e->tormaa(p); } else
  { FOR_EACH(e, offkasa) e->tormaa(p); }
}

void nappula::lisaapiirrettava()
{ este *e; FOR_EACH(e, actkasa) e->lisaapiirrettava(); }


void nappula::paivita(BITMAP *bmp)
{ este *e; text_mode(-1);
  if (tila) textout(bmp, font, "ON ", x-kantax, y-kantay,2);
  else textout(bmp,font, "OFF", x-kantax, y-kantay,2);
  if (tila) {FOR_EACH(e,onkasa) { e->piirra(bmp); e->paivita(bmp); } }
  else {FOR_EACH(e,offkasa) { e->piirra(bmp); e->paivita(bmp); } }
}

nappula::nappula(este **e, int xx, int yy, int t, int i) : este(e)
{ x=xx+kantax; y=yy+kantay; prioriteetti=1.1; tila=t; actkasa=0;
  onkasa=0; offkasa=0;
  if (i==1)
  { boxi *n=new boxi(&actkasa, xx-2, yy-2, xx+26, yy+10);
    new seina( &(n->yla), xx-2, yy-2, xx+26, yy-2);
    new seina( &(n->vas), xx-2, yy-2, xx-2, yy+10);
    new seina( &(n->ala), xx-2, yy+10, xx+26, yy+10);
    new seina( &(n->oik), xx+26, yy-2, xx+26, yy+10);
  }
}

class aikanappula : public nappula
{ public:
  int jakso; int aiga;
  aikanappula(este **e, int xx, int yy, int jaxo, int t=0)
  : nappula(e,xx,yy,0,t) { jakso=jaxo; aiga=0; }
  virtual void tormaa(pallo *p);
  virtual void paivita(BITMAP *bmp);
};

void aikanappula::tormaa(pallo *p)
{ int til=tila;
  nappula::tormaa(p);
  if(til==0 && tila==1) {aiga=aika;}
  if (tila==1 && aika > aiga+jakso) {tila=0; pyyhikaikki=1; }
  if (tila==1) p->pl=1;
}

void aikanappula::paivita(BITMAP *bmp)
{ if (tila==1 && aika > aiga+jakso) {tila=0; pyyhikaikki=1; }
  nappula::paivita(bmp);
}

class valkky : public este
{ public:
  int ylhaalla, sekvenssi, alkuasento, tila;
  este *onkasa;
  este *offkasa;
  valkky(este **e, int ylh, int sekv, int aa);
  virtual void tormaa(pallo *p);
  virtual void paivita(BITMAP *bmp);
};

valkky::valkky(este **e, int ylh, int sekv, int aa) : este(e)
{ ylhaalla=ylh; sekvenssi=sekv; alkuasento=aa; onkasa=0; offkasa=0; tila=0; }

void valkky::tormaa(pallo *p)
{ este *e;
  if ( (aika+alkuasento) % sekvenssi < ylhaalla+1)
  { FOR_EACH(e, onkasa) e->tormaa(p); } else
  { FOR_EACH(e, offkasa) e->tormaa(p); }
}

void valkky::paivita(BITMAP *bmp)
{ este *e;
  if ( (aika+alkuasento) % sekvenssi < ylhaalla+1)
  {FOR_EACH(e,onkasa) { e->piirra(bmp); e->paivita(bmp); }
   if (tila==0) {tila=1; pyyhikaikki=1; } }
  else
  {FOR_EACH(e,offkasa) { e->piirra(bmp); e->paivita(bmp); }
   if (tila==1) {tila=0; pyyhikaikki=1; } }
}




class pacman : public este
{ public:
  int x,y,xx,yy,t; int xn, yn, xxn, yyn; double mn; int lask; double pieru;
  pacman(este **e, int x1, int y1, int xx1, int yy1, int t1,double pier=0.3);
  void paikkanyt();
  int onkosuissa(pallo *p);
  virtual void tormaa(pallo *p);
  virtual void paivita(BITMAP  *bmp);

};
  pacman::pacman(este **e, int x1, int y1, int xx1, int yy1, int t1, double pier=0.3) : este(e)
  {x=x1+kantax; y=y1+kantay; xx=xx1+kantax; yy=yy1+kantay; t=t1; lask=0; pieru=pier;
   prioriteetti=1.1; }

  void pacman::paikkanyt()
  { int tt = (t+aika/2) % ( 2*(xx-x) + 2*(yy-y) );

    if (tt < xx-x ) { xn = tt+x ; yn = y; xxn=1; yyn=0; } else
    if (tt < xx-x + yy-y) { xn=xx; yn = y+tt-(xx-x); xxn=0; yyn=1; } else
    if (tt < 2*(xx-x) + yy-y) {xn = xx-(tt-xx+x-yy+y); yn=yy; xxn=-1; yyn=0;} else
    {xn=x; yn=yy-(tt-2*(xx-x)-yy+y); xxn=0; yyn=-1;}

    mn = ( double( (aika/2) % 40) ) * (PI/60);
    if (mn>PI/3) mn=PI*(2.0/3)-mn;
  }

  int pacman::onkosuissa(pallo *p)
  { double tul; double d; double kos;
    if ( (p->x -xn) * (p->x -xn ) + (p->y-yn) * (p->y -yn) > 144 ) return 0;
    d =sqrt(  (p->x-xn) * (p->x-xn) + (p->y-yn)*(p->y-yn) ); if (d==0) d=1;
    tul = ( (p->x-xn) * xxn + (p->y-yn) *yyn ) /d;
    kos = cos(mn);
    if (tul >= kos) return 1;

    return 2;
  }

  void pacman::tormaa(pallo *p)
  {
     int ppl;
     int b; paikkanyt();
     b = onkosuissa(p);
    if (b==1 )
    { if (p->tyyppi!=0 && p->tyyppi!=5 ) p->tuhoa=1; else
     if (p->tyyppi==0)
     { p->tyyppi=5; p->pl=1; lask=200; p->x=xn; p->y=yn; p->xx=0; p->yy=0;
       pakotatormays();
     }
    }
    if (b==2)
    { double d; double dd;
      p->xx-=double(xxn)/2; p->yy-=double(yyn)/2;
      d = (xn-p->x)*(p->xx) + (yn-p->y)*(p->yy);
      if (d==0) d=1;
      dd=(xn-p->x)*(xn-p->x)+(yn-p->y)*(yn-p->y); if(dd==0) dd=1;
      d=d/dd;
      if( d > 0) { p->xx-=1.5*(xn-p->x)*d; p->yy-=1.5*(yn-p->y)*d; }
      p->xx+=double(xxn)/2; p->yy+=double(yyn)/2;
    }
  if (lask == 1 && p->tyyppi==5)
  {    p->tyyppi=0;
       p->x=xn -12*(xxn+yyn); p->y=yn - 12*(xxn+yyn);
       p->xx=double(-xxn-yyn) *pieru;
       p->yy=double(-xxn-yyn) *pieru;
       lask=0;

  }

  if (lask>0 && p->tyyppi==5) { lask--; p->pl=1; p->x=xn; p->y=yn;
  if (lask==100) teksti.lisaa("PROOOOOT!!!!",1);}

  ppl=p->pl;

  if (p->x > x-11 && p->x < x+11 && p->y> y-11 && p->y < yy+11) p->pl=1;
  if (p->x > xx-11 && p->x < xx+11 && p->y> y-11 && p->y < yy+11) p->pl=1;
  if (p->x > x-11 && p->x < xx+11 && p->y> y-11 && p->y < y+11) p->pl=1;
  if (p->x > x-11 && p->x < xx+11 && p->y> yy-11 && p->y < yy+11) p->pl=1;


  if( pytis(p->x,p->y,x-11,y-11) < 4 && !ppl) p->pl=0;
  if( pytis(p->x,p->y,x-11,yy+11) < 4 && !ppl) p->pl=0;
  if( pytis(p->x,p->y,xx+11,y-11) < 4 && !ppl) p->pl=0;
  if( pytis(p->x,p->y,xx+11,yy+11) < 4 && !ppl) p->pl=0;
  }




  void pacman::paivita(BITMAP  *bmp)
  { double sx1; double sy1; double sx2; double sy2;
    paikkanyt();
    ccircle(bmp,xn,yn,10, 23);
    activepyyhi->merkkaa(xn-12, yn-12, xn+12, yn+12);
    if (yyn==0) { sx1 = cos(mn)*xxn; sy1 = sin(mn)*xxn;
                  sx2=cos(mn)*xxn; sy2 = -sin(mn)*xxn; }
    else { sy1 = cos(mn)*yyn; sx1 = -sin(mn)*yyn;
           sy2 = cos(mn)*yyn; sx2 = sin(mn)*yyn; }

    lline(bmp,xn,yn, xn+ int(sx1*11), yn+ int(sy1*11), 10);
    lline(bmp,xn,yn, xn+ int(sx2*11), yn+ int(sy2*11), 10);
    floodfill(bmp, xn + int(sx1*5 + sx2*5) - kantax,
                   yn + int(sy1*5 + sy2*5) - kantay, 10);

  }

class putous : public este
{ public:
  int x,y,yy; long int aikk; int lasku; int tih;
  long int mato[30]; int matoalku; int matoloppu;
  putous(este **e, int x1, int y1, int yy1, int tihh=40);
  virtual void paivita(BITMAP *bmp);
  virtual void tormaa(pallo *p);
};

putous::putous(este **e, int x1, int y1, int yy1, int tihh): este(e)
{x=x1+kantax; y=y1+kantay; yy=yy1+kantay; matoalku=0; matoloppu=0;
tih=tihh; lasku=0; aikk=aika; }

void putous::paivita(BITMAP *bmp)
{ long int i,j,k,l; int aik=aika/2;
  for(i=y + aik%tih; i<yy; i+=tih)
  { j=( (i-aik)/tih ) %4; while(j<0) j+=4;
    if (j==0 || j==2) k=4; else if (j==1) k=2; else k=3;
    l=0;

    for( j=matoalku; j!=matoloppu; (++j)==30?(j=0):j )
    { if (mato[j]+aik == i ) l=1; }

    if (!l)
    { ccircle(bmp,x,i,2,k); activepyyhi->merkkaa(x-3,i-3,x+3,i+3); }
  }

}

void putous::tormaa(pallo *p)
{ long int i,j,k,l; long int aik=aika/2; pallo *pp;
  for(i=y + aik%tih; i<yy; i+=tih)
  { j=( (i-aik)/tih)%4; while(j<0) j+=4;
    if (j==0 || j==2) k=4; else if (j==1) k=2; else k=3;

    while(mato[matoalku]+aik > yy && matoalku!=matoloppu)
    { matoalku++; if (matoalku==30) matoalku=0; }

    l=0;
    for( j=matoalku; j!=matoloppu; (++j)==30?(j=0):j )
    if (mato[j]+aik == i ) l=1;

    if (!l)
    if ( pytis(p->x,p->y, x,i) < 5)
    { mato[matoloppu]=i-aik; matoloppu++; if (matoloppu==30) matoloppu=0;
      new pallo(x,i,0,0.5,k-1);
    }
  }

  if (aikk!=aika) {aikk=aika; lasku=0; }

  if (p->x > x-7 && p->x < x+7 && p->y > y-5 && p->y < yy+5) lasku++;

  if (lasku>30) {
   FOR_EACH(pp,pallot)
   if (pp->x > x-7 && pp->x < x+7 && pp->y > y-5 && pp->y < yy+5
   && (pp->tyyppi==1 || pp->tyyppi==2 || pp->tyyppi==3) )
   pp->tuhoa=1;
   lasku=0; }

}

class pyoroseina : public este
{ public:
  int x,y,l; double r,ar,vx,vy,xx,yy,d;
  pyoroseina(este **e,int xx1, int yy1, int l1, double r1, double ar1, double d1=0.9);
  void alustakierros();
  void alustatormays(double tx, double ty, pallo *p);
  void viimeisteletormays(pallo *p);
  virtual void tormaa(pallo *p);
  virtual void paivita(BITMAP *bit);
  virtual void piirra(BITMAP *bit);
};
  pyoroseina::pyoroseina(este **e,int xx1, int yy1, int l1, double r1, double ar1, double d1=0.9)
  : este(e)
  { x=xx1+kantax; y=yy1+kantay; l=l1; r=r1; ar=ar1; d=d1;
    prioriteetti=1.1; }

  void pyoroseina::alustakierros()
  { xx = x+cos(aika*r+ar)*l; yy=y+sin(aika*r+ar)*l; }

  void pyoroseina::alustatormays(double tx, double ty, pallo *p)
  { double tv;
    tv=sqrt( (x-tx)*(x-tx)+(y-ty)*(y-ty) );
    vx = -sin(aika*r+ar)*tv*r; vy = cos(aika*r+ar)*tv*r;
    p->xx-=vx; p->yy-=vy; }

  void pyoroseina::viimeisteletormays(pallo *p)
  { p->xx+=vx; p->yy+=vy; }



  void pyoroseina::tormaa(pallo *p)
  {  double a; double b;
     alustakierros();
     if ( sqrt( (x-p->x)*(x-p->x) + (y-p->y)*(y-p->y) ) < l+2.8) p->pl=1;
     a = ratkaisu(xx-x, yy-y, x,y, yy-y, x-xx, p->x, p->y);
     b = ratkaisu(yy-y,x-xx,p->x,p->y,xx-x,yy-y,x,y) ;
     if (a>=0 && a<=1 && abs(b)*pytis(x,y,xx,yy) <= 3 )
     { double axx; double ayy;
       alustatormays(p->x, p->y , p);
       axx= tulo(yy-y,x-xx,p->xx,p->yy)*(yy-y)/
       ( (yy-y)*(yy-y) + (xx-x)*(xx-x) );
       ayy= tulo(yy-y,x-xx,p->xx,p->yy)*(x-xx)/
       ( (yy-y)*(yy-y) + (xx-x)*(xx-x) );
       if(tulo(b*(yy-y),b*(x-xx),p->xx,p->yy) > 0)
       {p->xx-=2*axx;
        p->yy-=2*ayy;
        p->xx*=d;
        p->yy*=d; }
       viimeisteletormays(p);
     } else
     if( (xx-p->x)*(xx-p->x)+(yy-p->y)*(yy-p->y) < 9 )
     { double ax = xx-p->x; double ay=yy-p->y;
       alustatormays(xx,yy,p);
       b = ax*p->xx + ay*p->yy;
       if(tulo(xx-p->x,yy-p->y,p->xx,p->yy) > 0)
       {p->xx-=2*b*ax/(ax*ax+ay*ay);
       p->yy-=2*b*ay/(ax*ax+ay*ay);
       p->xx*=d;
       p->yy*=d;}

       viimeisteletormays(p);
     } else
     if( (x-p->x)*(x-p->x)+(y-p->y)*(y-p->y) < 9 )
     { double ax = x-p->x; double ay=y-p->y;
       alustatormays(xx,yy,p);
       b = ax*p->xx + ay*p->yy;
       if( tulo(x-p->x,y-p->y,p->xx,p->yy) > 0)
       {p->xx-=2*b*ax/(ax*ax+ay*ay);
       p->yy-=2*b*ay/(ax*ax+ay*ay);
       p->xx*=0.8;
       p->yy*=0.8;}

       viimeisteletormays(p);
     }
  }


  void pyoroseina::paivita(BITMAP *bit)
  { alustakierros();
    if (vari!=1) lline(bit,x,y,int(xx),int(yy),19);
    else  lline(bit,x,y,int(xx),int(yy),27);
    activepyyhi->merkkaa( x-(l+1), y-(l+1), x+l+1, y+l+1 );
  }

  void pyoroseina::piirra(BITMAP *bit)
  { }


  class flipperi : public pyoroseina
  { public:
    int tila;
    double nopeus; double alkukulma;
    int jakso;
    int kello;
    virtual void tormaa(pallo *p);
    virtual void paivita(BITMAP *bit);
    void lasketila();
    flipperi(este **e, int xx1, int yy1, int l1, double r1, double ar1, double jakso1, double d1=0.9);
   };

   flipperi::flipperi
   (este **e, int xx1, int yy1, int l1, double r1, double ar1,
    double jakso1, double d1=0.9) : pyoroseina(e,xx1,yy1, l1, 0, ar1, d1)
   { nopeus = r1; jakso=int(jakso1/r1); tila=0; kello=0; alkukulma=ar1; }


   void flipperi::lasketila()
   { if(tila==1 && jakso+kello < aika )
     { tila=-1; r=-nopeus; ar=nopeus*(kello+2*jakso) + alkukulma; }
     if(tila==-1 && 2*jakso+kello < aika )
     { tila=0; r=0; ar=alkukulma; }
   }

   void flipperi::tormaa(pallo *p)
   { double xx; double yy; double x; double y; int pl;
     xx=p->xx; yy=p->yy; x=p->x; y=p->y; pl=p->pl; lasketila();
     pyoroseina::tormaa(p);
     if (tila==0 && (p->xx != xx || p->yy != yy) )
     { ar=-nopeus*aika + alkukulma; r=nopeus; kello=aika; tila=1;
       p->x=x; p->y=y; p->xx=xx; p->yy=yy; pyoroseina::tormaa(p); }
     if (tila==0) p->pl=pl;
   }

  void flipperi::paivita(BITMAP *bit)
  { lasketila();
    pyoroseina::paivita(bit);
  }




class pylvas : public este
{ public:
  int x,y,r;
  pylvas(este **e, int x1,int y1, int r1);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bit);
};
  pylvas::pylvas(este **e, int x1,int y1, int r1) : este(e)
  { x=x1+kantax; y=y1+kantay; r=r1; prioriteetti=1; }

  void pylvas::tormaa(pallo *p)
  { if (pytis(x,y,p->x,p->y) < r+3 && (x-p->x)*(p->xx) + (y-p->y)*(p->yy) > 0 )
    { double d = (x-p->x)*(p->xx) + (y-p->y)*(p->yy);
      d/=(x-p->x)*(x-p->x)+(y-p->y)*(y-p->y);
      if( d > 0) { p->xx-=2*(x-p->x)*d; p->yy-=2*(y-p->y)*d; }

    }
  }

  void pylvas::piirra(BITMAP *bit)
  { if (vari!=1) ccircle(bit,x,y,r,19);
            else ccircle(bit,x,y,r,25);
  }

class ampu : public pylvas
{ public:
  long int aik; double ax, ay;
  ampu(este **e, int x1, int y1, int r1) : pylvas(e,x1,y1,r1)
  {aik=aika; ax=1; ay=0;}
  virtual void tormaa(pallo *p);
  virtual void paivita(BITMAP *bmp);
  void etsiuhri();
};

void ampu::etsiuhri()
{ pallo *p,*pp; double et=10000;
  if (aika-aik < 1000) { return; }
  aik=aika;
  if (pallot==0) {return; }
  pp=pallot;
  FOR_EACH(p,pallot) if ( pytis(x,y,p->x,p->y) < et
                          && (p->tyyppi==1 || p->tyyppi==2) )
  { et=pytis(x,y,p->x,p->y); pp=p; }

  ax = (pp->x - x) / pytis(pp->x,pp->y,x,y);
  ay = (pp->y - y) / pytis(pp->x,pp->y,x,y);
}

void ampu::tormaa(pallo *p)
{ double xx; double yy; double xxx; double yyy;
  pylvas::tormaa(p);
  etsiuhri();
  if ( (p->tyyppi==0 || p->tyyppi==1 || p->tyyppi==2)
       && pytis(x,y,p->x,p->y) < r+3)
  { new pallo(x + (r+4)*ax,y + (r+4)*ay,ax*2,ay*2,3); aik=aika; }

}

void ampu::paivita(BITMAP *bmp)
{ etsiuhri(); activepyyhi->merkkaa(x-r,y-r,x+r,y+r);
  lline(bmp,x,y,x + int(r*ax), y + int(r*ay), 3); }


class tykki : public pylvas
{ public:
  int min2,var2;
  tykki(este **e, int x1, int y1, int r1, int min1=3, int var1=4);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bmp);
};

  tykki::tykki(este **e, int x1, int y1, int r1, int min1=3, int var1=4)
  : pylvas(e,x1,y1,r1)
  {min2=min1; var2=var1; }

  void tykki::tormaa(pallo *p)
  { int i; int j; int k; double xx; double yy; double xxx; double yyy;
    pallo *pp; xx=p->xx; yy=p->yy;
    pylvas::tormaa(p); j=min2+rand()%var2;
    if (xx != p->xx || yy!= p->yy)
    { k=0;
      FOR_EACH(pp,pallot) k++;
      if (k < 200) for(i=1; i<j ; i++)
      { xx=double(rand()%1000)/500 -1 ;
        yy=double(rand()%1000)/500 -1 ;
        xxx= xx / sqrt(xx*xx + yy*yy);
        yyy= yy / sqrt(xx*xx + yy*yy);
        new pallo(x + (r+4)*xxx,y + (r+4)*yyy,xx,yy,3);
      }
    }
  }

  void tykki::piirra(BITMAP *bmp)
  { pylvas::piirra(bmp);
    if (vari==1) { textout(bmp, font, "PUSHING THIS", x+r+5-kantax, y-r-kantay, 34);
                   textout(bmp, font, "BUTTON IS", x+r+5-kantax, y-r+10-kantay, 34);
                   textout(bmp, font, "STRICTLY", x+r+5-kantax, y-r+20-kantay, 34);
                   textout(bmp, font, "FORBIDDEN!!!", x+r+5-kantax, y-r+30-kantay, 34);
                 }
  }

class aurinko : public pylvas
{ public:
  aurinko(este **e, int x1, int y1, int r1);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bmp);
};

aurinko::aurinko(este **e, int x1, int y1, int r1)
: pylvas(e,x1,y1,r1) {}

void aurinko::tormaa(pallo *p)
{ if ( pytis(p->x,p->y, x,y) < r+3 )
  { if (p->tyyppi==0 || p->tyyppi==5) pylvas::tormaa(p);
    else
    { p->tuhoa=1; teksti.lisaa("   Icarus, I see...",1); }
  }
}

void aurinko::piirra(BITMAP *bmp)
{ { ccircle(bmp,x,y,r,30);
    lline(bmp, x-r-2, y, x-2*r,y, 30);
    lline(bmp, x+r+2, y, x+2*r,y, 30);
    lline(bmp, x, y-r-2, x, y-2*r,30);
    lline(bmp, x, y+r+2, x, y+2*r,30);

    lline(bmp, x-(3*r)/4, y-(3*r)/4, x-3*r/2, y-3*r/2, 30);
    lline(bmp, x-(3*r)/4, y+(3*r)/4, x-3*r/2, y+3*r/2, 30);
    lline(bmp, x+(3*r)/4, y-(3*r)/4, x+3*r/2, y-3*r/2, 30);
    lline(bmp, x+(3*r)/4, y+(3*r)/4, x+3*r/2, y+3*r/2, 30);

    ccircle(bmp, x-r/2, y, r/6, 3);
    ccircle(bmp, x+r/2, y, r/6, 3);

    set_clip(bmp, x-kantax-r, y-kantay+r/2, x-kantax+r, y-kantay+r);
    ccircle(bmp, x,y, (2*r)/3, 2);
    set_clip(bmp,0,0,319,239);

}

}


class maki : public este
{ public:
  int x,y,xx,yy;
  double h,k;
  maki(este **e,int xx1, int yy1, int xx2, int yy2,double hh, double kk);
  virtual void tormaa(pallo *p);
  virtual void piirra(BITMAP *bit);
};
  maki::maki(este **e,int xx1, int yy1, int xx2, int yy2,double hh, double kk) : este(e)
  { x=xx1+kantax; xx=xx2+kantax; y=yy1+kantay; yy=yy2+kantay;h=hh; k=kk;
    prioriteetti=0.2; }

  void maki::tormaa(pallo *p)
  {  double a = ratkaisu(xx-x, yy-y, x,y, yy-y, x-xx, p->x, p->y);
     double b = ratkaisu(yy-y,x-xx,p->x,p->y,xx-x,yy-y,x,y) ;

     if (a>=0 && a<=1 && h-abs(b)*pytis(x,y,xx,yy)*k > p->mm )
     { int i=0;
       if (b>0) i=1; else if(b<0) i=-1;
       p-> mx = (y-yy)*i*k / pytis(x,y,xx,yy);
       p-> my = (xx-x)*i*k / pytis(x,y,xx,yy);
       p-> mm = h-abs(b)*pytis(x,y,xx,yy)*k;
     }

     if( h-pytis(p->x,p->y,x,y)*k > p->mm )
     {
       p-> mx = -(x-p->x)/pytis(x,y,p->x,p->y)*k;
       p-> my = -(y-p->y)/pytis(x,y,p->x,p->y)*k;
       p-> mm = h-pytis(p->x,p->y,x,y)*k;
     }
     if( h-pytis(p->x,p->y,xx,yy)*k > p->mm )
     {
       p-> mx = -(xx-p->x)/pytis(xx,yy,p->x,p->y)*k;
       p-> my = -(yy-p->y)/pytis(xx,yy,p->x,p->y)*k;
       p-> mm = h-pytis(p->x,p->y,xx,yy)*k;
     }




  }

  void maki::piirra(BITMAP *bit)
  {  int x1,x2,x3,y1,y2,y3, xmin,xmax,ymin,ymax,g; double mm;
     int piir;
     double a,b,p,pyt;
     if (x<xx) {x1=x; x3=xx; } else {x1=xx; x3=x; }
     if (y<yy) {y1=y; y3=yy; } else {y1=yy; y3=y; }

     xmin=x1-int(h/k); if(xmin-kantax<0) xmin=0+kantax;
     xmax=x3+int(h/k); if(xmax-kantax>320) xmax=320+kantax;
     ymin=y1-int(h/k); if(ymin-kantay<0) ymin=0+kantay;
     ymax=y3+int(h/k); if(ymin-kantay>240) ymin=240+kantay;

     pyt=pytis(x,y,xx,yy)*k;

     for(y2=ymin; y2 < ymax; y2++)
     { piir=0;
     for(x2=xmin; x2 < xmax; x2++)

      { b = ratkaisu(yy-y,x-xx,x2,y2,xx-x,yy-y,x,y) ;

       if ( (p=h-abs(b)*pyt) > 0)
       { a = ratkaisu(xx-x, yy-y, x,y, yy-y, x-xx, x2, y2);
         mm=0;
         if (a>=0 && a<=1 ) mm = p*300;
         else
           { if( (p=h-pytis(x2,y2,xx,yy)*k) > 0 ) mm = p*300; else
             if( (p=h-pytis(x2,y2,x,y)*k) > 0 )   mm = p*300;
           }

         if ( mm!=0 && mm > rasteri(x2,y2) &&
            (g=_getpixel(bit,x2-kantax,y2-kantay))% 3 == 1)
         _putpixel(bit, x2-kantax,y2-kantay, g+2 );

         if (mm!=0) piir=1; else if (piir==1) break;

        } else if (piir==1) break;
      }
     }

  }



class naytalahin
{ public:
  int aiga;
  int laskuri;
  int vanhalask;
  naytalahin() {laskuri=0; aiga=0; vanhalask=0; }
  void nayta(BITMAP *bmp);



};

void naytalahin::nayta(BITMAP *bmp)
{ pallo *p; pallo *pp; double d; int i; int j;
  if (laskuri==0) {aiga=aika; return;}

  if (laskuri!=vanhalask) {aiga=aika;}

  while(aiga+3 < aika) {aiga=aiga+3; if (laskuri>0) laskuri--;}

  FOR_EACH(p,pallot) if (p->tyyppi==5 || p->tyyppi==0) pp=p;

  d=10000*10000; i=0;

  FOR_EACH(p,pallot) if ( pytis(p->x,p->y,pp->x,pp->y)<d &&
  (p->tyyppi==1 || p->tyyppi==2) )
  { d=pytis(p->x,p->y,pp->x,pp->y); i=p->tyyppi; }

  d=10000*10000;

  if (i==0) return;

  FOR_EACH(p,pallot) if ( pytis(p->x,p->y,pp->x,pp->y)<d &&
  (p->tyyppi==3-i) )
  { d=pytis(p->x,p->y,pp->x,pp->y);  }

  if (laskuri%10 < 6) j=0; else j=vari(i);

  FOR_EACH(p,pallot) if ( pytis(p->x,p->y,pp->x,pp->y)<d &&
  (p->tyyppi==i) )
  { int xx; int yy;
    xx=int(p->x); yy=int(p->y);

    lline(bmp, xx-4, yy-4, xx+4, yy-4, j );
    lline(bmp, xx-4, yy+4, xx+4, yy+4, j );
    lline(bmp, xx-4, yy-4, xx-4, yy+4, j );
    lline(bmp, xx+4, yy-4, xx+4, yy+4, j );
    activepyyhi->merkkaa(xx-5, yy-5, xx+5, yy+5);
  }

  vanhalask=laskuri;
}

naytalahin naytalah;


int sinpist=0; int punpist=0;

inline int mmin(int x, int y)
{ if (x<y) return x; else return y;}

inline int mmax(int x, int y)
{ if (x<y) return y; else return x;}

int vanhakantax=-1; int vanhakantay=-1;

void piirrataustablokki(int kx, int ky, int x, int y)
{ blit(naytto.anna(kx, ky) , oikeatausta, mmax(0,-x), mmax(0,-y),
  mmax(0, x), mmax(0,y), (x<0)? (320+x) : (x>320) ? 640-x : 320,
  (y<0)? (240+y) : (y>240) ? 480-y : 240 );
}

int piirratausta()
{ if (vanhakantax==kantax && vanhakantay==kantay && pyyhikaikki==0 )
  return 1;

  vanhakantax=kantax; vanhakantay=kantay; pyyhikaikki=0;

  piirrataustablokki ((kantax+3200)/320-10,(kantay+2400)/240-10,
      0-(kantax+3200)%320 , 0-(kantay+2400)%240) ;
  piirrataustablokki ((kantax+3200)/320-9, (kantay+2400)/240-10,
    320-(kantax+3200)%320 , 0-(kantay+2400)%240) ;
  piirrataustablokki ((kantax+3200)/320-8, (kantay+2400)/240-10,
    640-(kantax+3200)%320 , 0-(kantay+2400)%240) ;

  piirrataustablokki ((kantax+3200)/320-10,(kantay+2400)/240-9,
      0-(kantax+3200)%320 , 240-(kantay+2400)%240 );
  piirrataustablokki ((kantax+3200)/320-9, (kantay+2400)/240-9,
    320-(kantax+3200)%320 , 240-(kantay+2400)%240 );
  piirrataustablokki ((kantax+3200)/320-8, (kantay+2400)/240-9,
    640-(kantax+3200)%320 , 240-(kantay+2400)%240 );

  piirrataustablokki ((kantax+3200)/320-10,(kantay+2400)/240-8,
      0-(kantax+3200)%320 , 480-(kantay+2400)%240 );
  piirrataustablokki ((kantax+3200)/320-9, (kantay+2400)/240-8,
    320-(kantax+3200)%320 , 480-(kantay+2400)%240 );
  piirrataustablokki ((kantax+3200)/320-8, (kantay+2400)/240-8,
    640-(kantax+3200)%320 , 480-(kantay+2400)%240 );


return 0;
}

void piirraliikkuvat()
{ int kx=kantax/320;
  int ky=kantay/240;
  este *e;

  FOR_EACH(e, obj[kx][ky]) e->paivita(activepage);
  FOR_EACH(e, obj[kx+1][ky]) e->paivita(activepage);
  FOR_EACH(e, obj[kx+2][ky]) e->paivita(activepage);
  FOR_EACH(e, obj[kx][ky+1]) e->paivita(activepage);
  FOR_EACH(e, obj[kx+1][ky+1]) e->paivita(activepage);
  FOR_EACH(e, obj[kx+2][ky+1]) e->paivita(activepage);
  FOR_EACH(e, obj[kx][ky+2]) e->paivita(activepage);
  FOR_EACH(e, obj[kx+1][ky+2]) e->paivita(activepage);
  FOR_EACH(e, obj[kx+2][ky+2]) e->paivita(activepage);

}


int plippu=0;



void ppaivitanaytto(int x, int y, int mx, int my, int tt)
{
  if (activepage==page1)   {activepage=page2; activepyyhi=&pyyhi1; }
                      else {activepage=page1; activepyyhi=&pyyhi2; }

  if (piirratausta())
  { if (plippu)
    { plippu=0; activepyyhi->osoitin=0;
      blit(oikeatausta, activepage, 0,0,0,0,SCREEN_W,SCREEN_H); }
    else
    activepyyhi->pyyhi();
  }
    else
  { activepyyhi->osoitin=0; plippu=1;
    blit(oikeatausta, activepage, 0,0,0,0,SCREEN_W,SCREEN_H);
  }


  piirraliikkuvat();

  pallot->piirra();

  naytalah.nayta(activepage);

  teksti.nayta();

  if(tt!=-1)
  {
  lline(activepage,x,y,x+mx/15,y+my/15,vari(tt));
  lline(activepage,x+mx/5,y+my/5-3,x+mx/5,y+my/5+3,vari(tt));
  lline(activepage,x+mx/5-3,y+my/5,x+mx/5+3,y+my/5,vari(tt));
  activepyyhi->merkkaa(x-50, y-50, x+50, y+50);
  }

  if (activepage==page1) scroll_screen(0,0); else scroll_screen(0,480);

}


void paivitanaytto()
{ ppaivitanaytto(-1,-1,-1,-1,-1); }

int rb=0; int bb=0; int pelikaynnissa=0;

int sinmatch=0; int punmatch=0;

void naytatietoa()
{  char s[500];


   sprintf(s,
"Balls left: Blue %d Red %d   Current Score: Blue %d Red %d\
     Matches Won: Blue %d Red %d",
   rb, bb, sinpist, punpist, sinmatch, punmatch);

   naytalah.laskuri=150;

   teksti.lisaa(s,1);
}


int pallkm=3;

void pellkm(int i)
{ if (i==1 && pallkm==6) {pallkm=3; if (!pelikaynnissa) {bb=3; rb=3;}
  teksti.lisaa("From this on each team has only three balls per round",1);}

  if (i==2 && pallkm==3) {pallkm=6; if (!pelikaynnissa) {bb=6; rb=6;}
  teksti.lisaa("From this on each team has six balls per round",1);}
}

void talletaruutu()
{  /*BITMAP *bmp; char s[50]; int vkx; int vky;
   sprintf(s,"Really save?");
   textout(activepage,font,s,10,10,7);

   while(!key[KEY_Y]) { if (key[KEY_N]) return;}

   vkx=kantax; vky=kantay;
   kantax=((kantax+5)/320)*320;
   kantay=((kantay+5)/240)*240;

   bmp=create_bitmap(320,240); clear(bmp);
   if(obj[(kantax+5)/320][(kantay+5)/240]!=0)
       obj[(kantax+5)/320][(kantay+5)/240]->piirra(bmp);
   sprintf(s,"kk%dk%d.bmp",kantax/320,kantay/240);
   save_bitmap(s,bmp,oikeapaletti);
   destroy_bitmap(bmp);*/
}

int skrollimuuttuja=0;

int skrollikello=0;

void skrollaa(int x, int y)
{  int skrolli;
   skrollimuuttuja+=1;
   skrolli=skrollimuuttuja;
   if (skrolli>20) skrolli=20;
   skrolli*=(aika-skrollikello);
   if (skrolli>100) skrolli=100;
   if (x < kantax) { if (x > kantax+skrolli) kantax=x;
                     else kantax-=skrolli; }

   if (y < kantay) { if (y > kantay+skrolli) kantay=y;
                     else kantay-=skrolli; }

   if (x > kantax) { if (x < kantax+skrolli) kantax=x;
                     else kantax+=skrolli; }

   if (y > kantay) { if (y < kantay+skrolli) kantay=y;
                     else kantay+=skrolli; }

}

void liikutanaytto(pallo *p)
{   int skrolli=skrollimuuttuja;
    if(key[KEY_LEFT]) skrollaa(kantax-2*(aika-skrollikello), kantay);
    if(key[KEY_RIGHT])skrollaa(kantax+2*(aika-skrollikello), kantay);
    if(key[KEY_UP]) skrollaa(kantax,kantay-2*(aika-skrollikello));
    if(key[KEY_DOWN]) skrollaa(kantax,kantay+2*(aika-skrollikello));
    if(key[KEY_SPACE]) naytatietoa();
    if(key[KEY_ESC]) exit(0);
    //if(key[KEY_P]) talletaruutu();
    if(key[KEY_F1]) pellkm(1);
    if(key[KEY_F2]) pellkm(2);
    if(key[KEY_F]) { pakkoheitto=1; teksti.lisaa("Ok, forcing a new throw",1); }

    if( (mouse_b&2) && p!=0) skrollaa(int(p->x)-320, int(p->y)-240);

    if(key[KEY_H]) skrollaa(160+ohjex1*320-320, 120-240);
    if(key[KEY_1]) skrollaa(160+ohjex1*320-320, 120);
    if(key[KEY_2]) skrollaa(160+ohjex1*320-320, 4*240+120);
    if(key[KEY_3]) skrollaa(160+ohjex1*320-320, 6*240+120);
    if(key[KEY_4]) skrollaa(160+ohjex1*320-320, 10*240+120);
    if(key[KEY_5]) skrollaa(160+ohjex2*320-320, 120-240);

    if (skrolli==skrollimuuttuja) skrollimuuttuja=0;
    skrollikello=aika;
}


int vaspist=0; int oikpist=0;

void heitto(int x, int y,int t, int tt)
{ int mx=40,my=0,mmx,mmy; double pit;
  pallo *p=new pallo(x,y,0,0,t);
  while( (mouse_b &1) || key[KEY_ENTER] ) { while(annakello()) aika++;
                                            paivitanaytto();
                                            liikutanaytto(p); }

  while( (!(mouse_b&1)) && (!key[KEY_ENTER]) )
  {
    if(key[KEY_W]) my+=-1;
    if(key[KEY_S]) my+=1;
    if(key[KEY_A]) mx+=-1;
    if(key[KEY_D]) mx+=1;

    get_mouse_mickeys(&mmx,&mmy);
    if ( key[KEY_ESC] ) exit(0);

    mx+=mmx; my+=mmy; if (mx==0 && my==0) mx=1; pit=sqrt(mx*mx+my*my);
    if (mx*mx + my*my > 220*220 && t!=0)
                                { mx = int(mx / pit*220);
                                  my = int(my / pit*220);
                                }

    if (mx*mx + my*my > 180*180 && t==0)
                                { mx = int(mx / pit*180);
                                  my = int(my / pit*180);
                                }



    if (mx*mx + my*my < 60*60 && t!=0)
                                { mx = int(mx / pit*60);
                                  my = int(my / pit*60);
                                }

    if (mx*mx + my*my < 10000 && t==0)
                                { mx = int(mx / pit*100);
                                  my = int(my / pit*100);
                                }
    while(annakello()) aika++;

    liikutanaytto(p);

    ppaivitanaytto(x,y,mx,my,tt);
  }

  pakkoheitto=0;
  p->xx=double(mx) / 200; p->yy=double(my) /200;

}


void alusta()
{ int i,j; BITMAP *bmp;
  allegro_init();
  LOCK_VARIABLE(kello);
  LOCK_FUNCTION(lisaakello);
  install_keyboard();
  install_mouse();
  install_timer();
  install_int( lisaakello, 6);
  if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 960)) exit(1);
  page1  = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
  page2  = create_sub_bitmap(screen, 0, SCREEN_H, SCREEN_W, SCREEN_H);
  clear(page1); clear(page2);
  activepage = page2;
  muutapaletti();
  oikeatausta=create_bitmap(640,480);
  for(i=0; i<20; i++) for(j=0; j<20; j++) obj[i][j]=0;
}

int entx; int enty;

int peli(int x, int y, int t)
{ int i=pallkm, j=pallkm; double d1,d2; pallo *p=0; pallo *pp;

    char s[100];  rb=j; bb=i;

    heitto(x,y,0,t); p=pallot; pakotatormays();

    while( liikutapallot() ){paivitanaytto(); liikutanaytto(p);}

  i=pallkm; j=pallkm; pelikaynnissa=1;

  heitto(x,y,t,t); if(t==1) i--; else if(t==2)j--; rb=j; bb=i;
  pakotatormays();
  while( liikutapallot() ){ paivitanaytto(); liikutanaytto(p);}


  while(i!=0 || j!=0)
  { d1=10000.0*10000.0; d2=10000.0*10000.0;
    for(pp=pallot; pp!=0; pp=pp->next)
    { double d=(pp->x-p->x)*(pp->x-p->x) + (pp->y-p->y)*(pp->y-p->y);
      if (d < d1 && pp->tyyppi==1) d1=d;
      if (d < d2 && pp->tyyppi==2) d2=d;
    }
    if(i==0) {heitto(x,y,2,2);j--;} else if(j==0) {heitto(x,y,1,1);i--;}
    else if (d2 < d1) {heitto(x,y,1,1);i--;} else {heitto(x,y,2,2);j--;}

    rb=j; bb=i;
    pakotatormays();
    while( liikutapallot() ) {paivitanaytto(); liikutanaytto(p);}

  }
  d1=10000.0*10000.0; i=1;
  FOR_EACH(pp,pallot) if(pp->tyyppi==1 || pp->tyyppi==2)
  { if( (pp->x-p->x)*(pp->x-p->x) +(pp->y-p->y)*(pp->y-p->y)  <d1 )
    { d1=(pp->x-p->x)*(pp->x-p->x)+(pp->y-p->y)*(pp->y-p->y);
      i = pp->tyyppi;
    }
  }
  d2=10000.0*10000.0;
  FOR_EACH(pp,pallot) if((pp->tyyppi==1 || pp->tyyppi==2) && pp->tyyppi!=i)
  { if( (pp->x-p->x)*(pp->x-p->x)+(pp->y-p->y)*(pp->y-p->y)<d2 )
    { d2=(pp->x-p->x)*(pp->x-p->x)+(pp->y-p->y)*(pp->y-p->y);
    }
  }
  j=0;
  FOR_EACH(pp,pallot) if(pp->tyyppi==i)
    if( (pp->x-p->x)*(pp->x-p->x)+(pp->y-p->y)*(pp->y-p->y)<d2 ) j++;

  if(i!=1) {sprintf(s,"Blue wins %d points        ",j);
            teksti.lisaa(s,1); sinpist+=j; }
  else {sprintf(s,"Red wins %d points          ",j);
        teksti.lisaa(s,1); punpist+=j; }
  if (sinpist>12) {sinpist=0; punpist=0; sinmatch+=1;
      sprintf(s," Blue wins the match "); teksti.lisaa(s,0);}
  if (punpist>12) {sinpist=0; punpist=0; punmatch+=1;
      sprintf(s," Red wins the match "); teksti.lisaa(s,0);}

  sprintf(s,
   "Current score: Blue %d  Red %d. Matches won by Blue %d by Red %d"
   ,sinpist,punpist,sinmatch,punmatch);
  teksti.lisaa(s,0);

  pelikaynnissa=0;

  naytalah.laskuri=200;

  while(naytalah.laskuri>0)
  { while(annakello())aika++; paivitanaytto(); liikutanaytto(p); }

  entx=int(p->x); enty=int(p->y);

  return i;
}


void ottelu()
{ int t=1;
  while(1)
  { t=peli(entx,enty,t);
    while(pallot!=0) delete pallot;
  }
}



void kentta1010()
{  este **pohja = &(obj[10][10]);
   kantax=320*10; kantay=240*10;
   nayttomoodi=0;
   new maki (pohja,40,35,330,35,0.15,0.005);
   new maki (pohja,40,205,330,205,0.15,0.005);
   new maki (pohja,250, 120, 360, 120,0.2,0.01);
   new maki (pohja,40,30,40,210,0.1,0.01);
   new ruoho(pohja,0,0,319,239);
   new hiekka(pohja,210,155,310,175);
}

void kentta1011()
{ nappula *e1, *e2, *e3, *e4; nayttomoodi=0;
  este **pohja= &(obj[10][11]);
  kantax=320*10; kantay=240*11;
  new pitkaruoho(pohja, 0,0,320,239);
  e1= new nappula(pohja, 150, 10, 0, 1);
  e2= new nappula(pohja, 290, 115, 1, 1);
  e3= new nappula(pohja, 150, 220, 1, 1);
  e4= new nappula(pohja, 10, 115,  0, 1);
  new seina(&(e1->onkasa), 176, 15, 300, 115);
  new seina(&(e2->onkasa), 300, 125, 176, 225);
  new seina(&(e3->onkasa), 150, 225, 20, 125);
  new seina(&(e4->onkasa), 20, 115, 150,15);
  new tykki(pohja,160,120,5);
}

void kentta1111()
{ este **pohja= &(obj[11][11]);
  kantax=320*11; kantay=240*11; nayttomoodi=0;
  new ruoho(pohja, 0,0,320,240);
  new jousitykki(pohja,5,5, 40, 40, 3, 3, 0.7, 0.7);
  new jousitykki(pohja,5,200,40, 235, 3, 236, 0.7, -0.7);
  new jousitykki(pohja,280, 5, 315, 40, 316,3,-0.7 ,0.7);
  new jousitykki(pohja,280,200, 315, 235, 316, 236, -0.7,-0.7);
  new pylvas(pohja, 160,120, 5);
  new seina(pohja,0,0,40,0);
  new seina(pohja,0,0,0,40);
  new seina(pohja,280,0, 319,0);
  new seina(pohja, 319,0, 319, 40);
  new seina(pohja, 0,200,0,239);
  new seina(pohja, 0,239,40,239);
  new seina(pohja, 319,200,319,239);
  new seina(pohja,319,239, 280,239);
  new seina(pohja, 100, 50, 220, 50);
  new seina(pohja, 100, 190, 220, 190);
  new seina(pohja, 60, 70, 60, 180);
  new seina(pohja, 260, 70, 260, 180);
}

void kentta1211()
{ este **pohja= &(obj[12][11]);
  kantax=320*12; kantay=240*11; nayttomoodi=0; nappula *n;
  new pitkaruoho(pohja,0,0,319,239);
  n=new nappula(pohja, 150,115, 0, 1);
  new laser(&(n->onkasa),160,10,160,115, 100, 200, 0);
  new laser(&(n->onkasa), 160, 125, 160, 235, 100, 200, 0);
  new laser(&(n->offkasa), 160, 10, 160, 115, 200, 400, 0);
  new laser(&(n->offkasa), 160,125,160,235, 200, 400, 0);

  new monttu(pohja, 100, 120, 30, 50, 0.01);
  new monttu(pohja, 220, 120, 30, 50, 0.01);

  new maki(pohja, 20, 80, 80, 20, 0.24, 0.02);
  new maki(pohja, 20, 160, 80, 220, 0.24, 0.02);
  new maki(pohja, 300,80, 240, 20, 0.24, 0.02);
  new maki(pohja, 300,160, 240, 220, 0.24, 0.02);
}

void kentta1210()
{ este **pohja= &(obj[12][10]);
  kantax=320*12; kantay=240*10; nayttomoodi=0;
  new ruoho(pohja,0,0,319,239);
  new kaarre(pohja,0,100,319,140,0.005);
  new kaarre(pohja,140,0,180,110,0.005);
  new kaarre(pohja,140,140,180,239,0.005);
  new seina(pohja, 0,0, 130, 0);
  new seina(pohja, 190,0,319,0);
  new seina(pohja, 319,0,319,50);
  new seina(pohja, 319,190, 319,239);
  new seina(pohja, 220,239,319,239);
  new seina(pohja, 0,239,50,239);
  new seina(pohja, 20,20, 50,50);
  new seina(pohja, 20,220, 50, 190);
  new seina(pohja, 300, 220, 270, 190);
  new seina(pohja, 300, 20, 270, 50);
}

void kentta1209()
{ este **pohja= &(obj[12][9]);
  kantax=320*12; kantay=240*9; nayttomoodi=0;
  new ruoho(pohja,0,0,320,240);
  new pehmoseina(pohja,0,0, 140, 0);
  new pehmoseina(pohja,180,0,319,0);
  new pehmoseina(pohja,319,0,319,100);
  new pehmoseina(pohja,319,140,319,239);
  new ampu(pohja,50,50,15);
  new ampu(pohja,160,120,15);
  new ampu(pohja,270,50,15);
  new ampu(pohja,50,190,15);
  new ampu(pohja,270,190,15);
}

void kentta1207()
{ este **pohja= &(obj[12][7]);
  kantax=320*12; kantay=240*7; nayttomoodi=0;
  new pitkaruoho(pohja,99,0,221,239);
  new seina(pohja,50,120, 270,120);
  new voimakentta(pohja,0,0,100,120,0.003,0);
  new voimakentta(pohja,0,120,100,239,0.003,0);
  new voimakentta(pohja,220,0,319,120,-0.003,0);
  new voimakentta(pohja,220,120,319,239,-0.003,0);
}

void kentta1206()
{ este **pohja= &(obj[12][6]);
  kantax=320*12; kantay=240*6; nayttomoodi=0;
  new ruoho(pohja,0,0,319,239);
  new seina(pohja,0,0,130,0);
  new seina(pohja,190,0,319,0);

  new seina(pohja,0,239,130,239);
  new seina(pohja,190,239,319,239);

  new seina(pohja,319,0,319,70);
  new seina(pohja,319,170,319,239);
  new maki(pohja,100,120, 220,120, 0.6, 0.007);
}

void kentta1105()
{ este **pohja= &(obj[11][5]);
  kantax=320*11; kantay=240*5; nayttomoodi=0;
  valkky *v; nappula *n;
  new ruoho(pohja, 0,0,319,239);
  new pehmoseina(pohja,0,0,140,0);
  new pehmoseina(pohja,180,0,319,0);
  new pehmoseina(pohja,319,0,319,100);
  new pehmoseina(pohja,319,140,319,239);
  new pehmoseina(pohja,0,0,0,100);
  new pehmoseina(pohja,0,140,0,239);
  v = new valkky(pohja,200,800,0);
  new sotilasalue(&(v->onkasa),50,50,270,60);
  new sotilasalue(&(v->onkasa),50,180,270,190);
  new sotilasalue(&(v->onkasa),50,60,60,180);
  new sotilasalue(&(v->onkasa),260,60,270,180);
  new pseudoliikkuva(&(v->offkasa),50,50,270,60);
  new pseudoliikkuva(&(v->offkasa),50,180,270,190);
  new pseudoliikkuva(&(v->offkasa),50,60,60,180);
  new pseudoliikkuva(&(v->offkasa),260,60,270,180);
  n = new nappula(pohja,150,115,1,1);
  v = new valkky(&(n->onkasa),200,800,400);
  new snadihiekka(&(v->onkasa),1,1,318,49,0.8);
  new snadihiekka(&(v->onkasa),1,191,318,238,0.8);
  new snadihiekka(&(v->onkasa),1,49,49,191,0.8);
  new snadihiekka(&(v->onkasa),271,49,318,191,0.8);
  new pylvas(pohja,80,80,4);
  new pylvas(pohja,240,80,4);
  new pylvas(pohja,80,160,4);
  new pylvas(pohja,240,160,4);
}

void kentta0905()
{ este **pohja=&(obj[9][5]);
  kantax=320*9; kantay=240*5; nayttomoodi=0;
  new ruoho(pohja,0,0,319,239);
  new kuulansyoja(pohja,0,0,140,0);
  new kuulansyoja(pohja,180,0,319,0);
  new kuulansyoja(pohja,0,0,0,239);
  new kuulansyoja(pohja,319,0,319,100);
  new kuulansyoja(pohja,319,140,319,239);
  new kuulansyoja(pohja,0,239,319,239);
  new tykki(pohja,160,120,80,30,2);
}

void kentta1004()
{ este **pohja=&(obj[10][4]);
  kantax=320*10; kantay=240*4; nayttomoodi=0;
  new ruoho(pohja,0,0,319,239);
  new maki(pohja,30,120,160,30, 0.18,0.008);
  new maki(pohja,30,120,160,210, 0.18, 0.008);
  new maki(pohja,160,30, 290,120, 0.18, 0.008);
  new maki(pohja,160,210,290,120, 0.18, 0.008);
  new maki(pohja,160,120,160,210,0.18,0.008);
  new pehmoseina(pohja,2,140,2,239,0.4);
  new monttu(pohja,30,20,5,15,-0.008);
  new monttu(pohja,290,20,5,15,-0.008);
  new monttu(pohja,30,220,5,15,-0.008);
  new monttu(pohja,290,220,5,15,-0.008);

}


void kentta0804()
{ este **pohja=&(obj[8][4]);
  kantax=320*8; kantay=240*4;
  new ruoho(pohja,0,0,319,239);
  new vaihtotormays(pohja,0,0,319,239);
  new pehmoseina(pohja,0,0,140,0);
  new pehmoseina(pohja,180,0,319,0);
  new pehmoseina(pohja,0,0,0,100);
  new pehmoseina(pohja,0,140,0,239);
  new pehmoseina(pohja,319,0,319,100);
  new pehmoseina(pohja,319,140,319,239);
  new pylvas(pohja,160,120,5);
}

void kentta0904()
{ este **pohja=&(obj[9][4]);
  kantax=320*9; kantay=240*4;
  new ruoho(pohja,0,0,319,239);
  new annihiloitormays(pohja,60,60,260,180);
  new seina(pohja,0,0,140,0);
  new seina(pohja,180,0,319,0);
  new seina(pohja,319,0,319,100);
  new seina(pohja,319,140,319,239);
  new pylvas(pohja,160,120,3);
}

void kentta1005()
{ este **pohja=&(obj[10][5]);
  kantax=320*10; kantay=240*5; nayttomoodi=0;
  new ruoho(pohja,0,0,319,239);
  new pacman(pohja,60,120, 260,120,0,0.8);
  new voimakentta(pohja,50,60,270,110,0,0.004);
  new voimakentta(pohja,50,130,270,180,0,-0.004);
  new pehmoseina(pohja,2,0,2,100,0.4);
  new hyppy(pohja,4,50,4,70,-10,0);

}

void kentta0805()
{ este **pohja= &(obj[8][5]);
  kantax=320*8; kantay=240*5; nayttomoodi=0;
  new ruoho(pohja,0,0,319,239);
  new pehmoseina(pohja,318,0,318,239,0.3);
  new seina(pohja,100,0,319,0);
  new flipperi(pohja,10,100,110, 0.01, -PI*0.3, PI*0.04);
  new flipperi(pohja,10,140,110, -0.01, PI*0.3, -PI*0.04);
  new pylvas(pohja,10,100,3);
  new pylvas(pohja,10,140,3);
  new seina(pohja,160,120,319,120);
}

void kentta1205()
{ este **pohja= &(obj[12][5]);
  kantax=320*12; kantay=240*5; nayttomoodi=0;
  new pitkaruoho(pohja,0,0,319,239);
  new flipperi(pohja,85,10, 110,  -0.005,PI*0.75,-PI/4);
  new flipperi(pohja,85,230, 110, 0.005, -PI*0.75 ,PI/4);
  new flipperi(pohja,235,10, 110, 0.005, PI*0.25  ,PI/4);
  new flipperi(pohja,235,230, 110, -0.005, -PI*0.25 ,-PI/4);
  new hiekka(pohja,0,0,319,20);
  new hiekka(pohja,0,220,319,240);
  new hiekka(pohja,140,115,180,125);
  new pehmoseina(pohja,140,220,180,220,0.2);
}

void kentta1306()
{ este **pohja=&(obj[13][6]);
  kantax=320*13; kantay=240*6; nayttomoodi=0;
  new ruoho(pohja,0,0,319,239);
  new seina(pohja,0,0,100,0);
  new teleport(pohja, 100,0,110,0, 100,239,110,239);
  new seina(pohja,0,239,100,239);
  new putous(pohja,105,2,236);

  new seina(pohja,220,0,319,0);
  new seina(pohja,220,239,319,239);
  new seina(pohja,319,0,319,239);
  new teleport(pohja,210,0,220,0,210,239,220,239);
  new putous(pohja,215,2,236);

  new voimakentta(pohja,100,0,110,239,-0.003,0);
  new voimakentta(pohja,210,0,220,239,0.003,0);

}

void kentta1305()
{ este **pohja=&(obj[13][5]);
  kantax=320*13; kantay=240*5; nayttomoodi=0;
  new ruoho(pohja,0,0,319,239);
  new pehmoseina(pohja,20,20,140,80,0.9);
  new pehmoseina(pohja,20,20,100,100,0.9);
  new seina(pohja,300,20,180,80);
  new seina(pohja,300,20,220,100);

  new seina(pohja,20,220,140,160);
  new seina(pohja,20,220,100,140);
  new pehmoseina(pohja,300,220,180,160,0.9);
  new pehmoseina(pohja,300,220,220,140,0.9);

  new seina(pohja,210,239,319,239);
  new seina(pohja,0,239,110,239);
  new hiekka(pohja,0,0,20,100);
  new hiekka(pohja,0,140,20,239);
}


void kentta1307()
{ este **pohja=&(obj[13][7]);
  kantax=320*13; kantay=240*7; nayttomoodi=0;
  new ruoho(pohja,0,0,319,239);
  new seina(pohja,0,239,110,239);
  new seina(pohja,210,239,319,239);
  new seina(pohja,0,0,110,0);
  new seina(pohja,210,0,319,0);
  new seina(pohja,319,0,319,100);
  new seina(pohja,319,140,319,239);
  new seina(pohja,0,0,0,100);
  new seina(pohja,0,140,0,239);
  new suuntahiekka(pohja,105,1,110,239,0,0.8);
  new suuntahiekka(pohja,215,1,220,239,0,0.8);
  new pylvas(pohja,160,120,5);
}


void kentta1106()
{ este **pohja= &(obj[11][6]);
  kantax=320*11; kantay=240*6; nayttomoodi=0;
  new ruoho(pohja,0,0,319,239);
  new seina(pohja,0,0,130,0);
  new seina(pohja,190,0,319,0);

  new seina(pohja,0,0,0,80);
  new seina(pohja,0,160,0,239);

  new maki(pohja,100,120, 220,120, 0.6, 0.007);
}


void kentta1208()
{ este **pohja=&(obj[12][8]);
  kantax=320*12; kantay=240*8; nayttomoodi=0;
  new pitkaruoho(pohja,0,0,320,240);
  new maki(pohja,30,30,30,210, 0.2, 0.025);
  new maki(pohja,290,30,290,210, 0.2, 0.025);
  new maki(pohja,60,30,260,30, 0.2, 0.025);
  new maki(pohja,60,210,260,210, 0.2, 0.025);

  new maki(pohja,60,30,140, 30, 0.4, 0.025);
  new maki(pohja,180,30, 260,30, 0.4, 0.025);

  new maki(pohja,60,210,140, 210, 0.4, 0.025);
  new maki(pohja,180,210, 260,210, 0.4, 0.025);

  new maki(pohja,30,30, 30,100,0.4,0.025);
  new maki(pohja,30,140,30,210, 0.4, 0.025);

  new maki(pohja,290,30, 290,100,0.4,0.025);
  new maki(pohja,290,140,290,210, 0.4, 0.025);



  new maki(pohja,60,80,140,80, 0.4, 0.025);
  new maki(pohja,180,80,260,80,0.4, 0.025);
  new maki(pohja,60,160,140,160,0.4,0.025);
  new maki(pohja,180,160,260,160, 0.4, 0.025);
  new maki(pohja,120, 120, 200, 120, 0.4, 0.025);
}

void kentta1110()
{ este **pohja = &(obj[11][10]);
  kantax=320*11; kantay=240*10;
  new ruoho (pohja, 0,0,320,240);
  nayttomoodi=0;
  new maki  (pohja, 0 ,30, 10, 30, 0.15, 0.005);
  new maki  (pohja, 0, 210, 10,210, 0.15,0.005);
  new maki  (pohja, 0, 120,30,120, 0.2, 0.01);
  new pehmoseina (pohja, 0,0,160,0,0.9);
  new pehmoseina (pohja, 160,0,160,239,0.9);
  new pehmoseina (pohja, 0,239,160,239,0.9);
  new voimakentta (pohja, 60, 2, 158,238, -0.01, 0);

  new pehmoseina(pohja, 318,120,318, 238, 0.6);
  new seina(pohja, 318,60, 318, 120);
  new pehmoseina(pohja, 160,238, 318,238,0.6);
  new monttu(pohja, 238,160, 20, 78, 0.003);

  new sotilasalue(pohja, 201, 70, 278, 80);

}

void kentta0806()
{ este **pohja = &(obj[8][6]);
  kantax=320*8; kantay=240*6;
  nayttomoodi=0;
  new ruoho(pohja,0,0,320,240);
  new kaarre(pohja, 0,0,320,240,0.01);
  new seina( pohja, 130,1,319,1);
  new seina( pohja, 1,1,100,1);
  new seina( pohja, 1,1, 1, 90);
  new seina( pohja, 1,150,1,239);
  new seina( pohja, 1,239, 130,239);
  new seina( pohja, 190,239, 319,239);
  new seina( pohja, 319,1, 319, 90);
  new seina( pohja, 319,150, 319,239);
  new pylvas( pohja, 50,50, 3);
  new pylvas( pohja, 50,190,3);
  new pylvas( pohja, 270,50,3);
  new pylvas(pohja, 270,190,3);
  }

void kentta0706()
{ este **pohja = &(obj[7][6]); nappula *n;
  kantax=320*7; kantay=240*6;
  nayttomoodi=0;
  new ruoho(pohja,0,0,320,240);

  new pehmoseina( pohja, 1,1,319,1);
  new pehmoseina( pohja, 1,1, 1, 90);
  new pehmoseina( pohja, 1,150,1,239);
  new pehmoseina( pohja, 1,239, 130,239);
  new pehmoseina( pohja, 190,239, 319, 239);
  new pehmoseina( pohja, 319,1, 319, 90);
  new pehmoseina( pohja, 319,150, 319,239);

  n = new nappula(pohja, 10, 5, 0, 1);
  new voimakentta(&(n->onkasa), 3,30, 40, 237, 0, -0.005);
  n = new nappula(pohja, 50, 5, 0, 1);
  new voimakentta(&(n->onkasa), 40,30, 80, 237, 0, -0.005);
  n = new nappula(pohja, 90, 5, 0, 1);
  new pylvas(&(n->offkasa), 100, 120, 4);
  new voimakentta(&(n->onkasa), 80,30, 120, 237, 0, -0.005);
  n = new nappula(pohja, 130, 5, 0, 1);
  new voimakentta(&(n->onkasa), 120,30, 160, 237, 0, -0.005);
  n = new nappula(pohja, 170, 5, 0, 1);
  new voimakentta(&(n->onkasa), 160,30, 200, 237, 0, -0.005);
  n = new nappula(pohja, 210, 5, 0, 1);
  new pylvas(&(n->offkasa), 230, 120,4);
  new voimakentta(&(n->onkasa), 200,30, 240, 237, 0, -0.005);
  n = new nappula(pohja, 250, 5, 0, 1);
  new voimakentta(&(n->onkasa), 240,30, 280, 237, 0, -0.005);
  n = new nappula(pohja, 290, 5, 0, 1);
  new voimakentta(&(n->onkasa), 280,30, 317, 237, 0, -0.005);

}


void kentta0807()
{ este **pohja= &(obj[8][7]);
  kantax=320*8; kantay=240*7;
  nayttomoodi=0;
  new ruoho(pohja,0,0,320,240);
  new seina( pohja, 1,1,130,1);
  new seina( pohja, 190,1,319,1);
  new seina( pohja, 1,1, 1, 90);
  new seina( pohja, 1,150,1,239);
  new seina( pohja, 1,239, 130,239);
  new seina( pohja, 190,239, 319,239);
  new seina( pohja, 319,1, 319, 90);
  new seina( pohja, 319,150, 319,239);
  new tykki( pohja, 160,120,5);
  new seina ( pohja, 140,50,180,50);
  new seina ( pohja, 50, 100, 50, 140);
  new seina ( pohja, 140, 190, 180,190);
  new seina ( pohja, 270, 100, 270,140);
}

void kentta0907()
{ este **pohja = & (obj[9][7]);
  kantax=320*9; kantay=240*7;
  nayttomoodi=0;
  new ruoho( pohja, 0,0, 320,240);
  new pacman( pohja, 25,25,295,215, 0);
  new pacman( pohja, 25,25,295,215, 230);
  new pacman( pohja, 25,25,295,215, 230*2);
  new pacman( pohja, 25,25,295,215, 230*3);

  new pacman( pohja, 100,80, 220, 160,0);
  new pacman( pohja, 100,80, 220, 160,200);

}

void kentta1006()
{ este **pohja= &(obj[10][6]);
  kantax=320*10; kantay=240*6; nayttomoodi=0; nappula *n;
  new pitkaruoho(pohja,0,0,319,239);

  new monttu(pohja, 100, 120, 25, 50, -0.01);
  new monttu(pohja, 220, 120, 25, 50, -0.01);

  new maki(pohja, 20, 80, 80, 20, 0.24, 0.02);
  new maki(pohja, 20, 160, 80, 220, 0.24, 0.02);
  new maki(pohja, 300,80, 240, 20, 0.24, 0.02);
  new maki(pohja, 300,160, 240, 220, 0.24, 0.02);
  n = new nappula(pohja, 150, 115, 0, 1);
  new pylvas(&(n->onkasa), 100, 210, 5);
  new pylvas(&(n->onkasa), 140, 210, 5);
  new pylvas(&(n->onkasa), 180, 210, 5);
  new pylvas(&(n->onkasa), 220, 210, 5);
  new pylvas(&(n->offkasa), 100, 30, 5);
  new pylvas(&(n->offkasa), 140, 30, 5);
  new pylvas(&(n->offkasa), 180, 30, 5);
  new pylvas(&(n->offkasa), 220, 30, 5);
}


void kentta1007()
{ este **pohja = &(obj[10][7]); nippu *n;
  kantax=10*320; kantay=240*7;
  nayttomoodi=0;
  new ruoho(pohja,0,0,320,240);
  new seina(pohja, 20,20, 140, 100);
  new seina(pohja, 300,20, 180,100);
  new seina(pohja, 20, 220, 140, 140);
  new seina(pohja, 300,220, 180, 140);

  new pehmoseina(pohja, 100, 115, 65, 100, 0.8);
  new pehmoseina(pohja, 100, 125, 65, 140, 0.8);

  new pehmoseina(pohja, 220, 115, 255, 100, 0.8);
  new pehmoseina(pohja, 220, 125, 255, 140, 0.8);

  new pehmoseina(pohja, 155, 70, 130, 50, 0.8);
  new pehmoseina(pohja, 165, 70, 190, 50, 0.8);

  new pehmoseina(pohja, 155, 170, 130, 190, 0.8);
  new pehmoseina(pohja, 165, 170, 190, 190, 0.8);


}

void kentta0906()
{ este **pohja= &(obj[9][6]);
  kantax=320*9; kantay=240*6;
  nayttomoodi=0;
  new hiekka(pohja,0,0,320,240);
  new seina( pohja, 1,1,319,1);
  new seina( pohja, 1,1, 1, 90);
  new seina( pohja, 1,150,1,239);
  new seina( pohja, 1,239, 319,239);
  new seina( pohja, 319,1, 319, 239);
  new voimakentta( pohja, 1,40, 40, 90, 0, -0.013);
  new voimakentta( pohja, 1,150, 40, 239, 0,-0.013);
  new voimakentta( pohja, 1,1, 280,40, 0.013,0);
  new voimakentta( pohja, 280,1, 319,200, 0, 0.013);
  new voimakentta( pohja, 40,200, 319,240, -0.013, 0);
  new voimakentta( pohja, 100, 100, 120, 140,-0.1,0);
  new voimakentta( pohja, 180, 100, 200, 140,-0.1,0);
}

#define sylos(x,y) a=new boxi(pohja,x,y,x+30,y+30);\
                   new pehmoseina(&(a->vas), x,y,x,y+30);\
                   new pehmoseina(&(a->ala), x,y+30,x+30,y+30);\
                   new pehmoseina(&(a->oik), x+30,y+30,x+30,y);



#define salas(x,y) a=new boxi(pohja,x,y,x+30,y+30);\
                   new pehmoseina(&(a->vas), x,y,x,y+30);\
                   new pehmoseina(&(a->yla), x,y,x+30,y);\
                   new pehmoseina(&(a->oik), x+30,y+30,x+30,y);


#define soik(x,y)  a=new boxi(pohja,x,y,x+30,y+30);\
                   new pehmoseina(&(a->vas), x,y,x,y+30);\
                   new pehmoseina(&(a->ala), x,y+30,x+30,y+30);\
                   new pehmoseina(&(a->yla), x,y,x+30,y);


#define svas(x,y)  a=new boxi(pohja,x,y,x+30,y+30);\
                   new pehmoseina(&(a->yla), x,y,x+30,y);\
                   new pehmoseina(&(a->ala), x,y+30,x+30,y+30);\
                   new pehmoseina(&(a->oik), x+30,y+30,x+30,y);



void kentta0808()
{ este **pohja= &(obj[8][8]); boxi *a;
  kantax=320*8; kantay=240*8; nayttomoodi=0;
  new ruoho( pohja, 0,0,320,240);

  salas(10,10);
  salas(100,10);
  salas(190,10);
  salas(260,10);

  sylos(10,200);
  sylos(100,200);
  sylos(170,200);
  sylos(260,200);

  soik(10,120);
  svas(260,120);
  svas(130,120);
  soik(160,120);

  new pylvas(pohja,75,75,4);
  new pylvas(pohja,255,75,4);
  new pylvas(pohja,75,155,4);
  new pylvas(pohja,255,155,4);

}

void kentta0910()
{ este **pohja= &(obj[9][10]); nippu *a; este **aa;
  kantax=320*9; kantay=240*10; nayttomoodi=0;
  new ruoho( pohja, 0,0,320,240);
  new pehmoseina(pohja,1,1,140,1,0.8);
  new pehmoseina(pohja,180,1,319,1,0.8);
  new pehmoseina(pohja,1,1,1,100,0.8);
  new pehmoseina(pohja,1,140,1,239,0.8);
  new pehmoseina(pohja,319,1,319,100,0.8);
  new pehmoseina(pohja,319,140,318,239,0.8);
  new pehmoseina(pohja,1,239,140,239,0.8);
  new pehmoseina(pohja,180,239,319,239,0.8);

  a=new nippu(pohja,10,10,110,110); aa=&(a->pohja);
  new pyoroseina(aa,60,60, 50, 0.007, 0);
  new pyoroseina(aa,60,60, 50, 0.007, 2.0/3*PI);
  new pyoroseina(aa,60,60, 50, 0.007, 4.0/3*PI);

  a=new nippu(pohja,10,130,110,230); aa=&(a->pohja);
  new pyoroseina(aa,60,180, 50, 0.007, 0);
  new pyoroseina(aa,60,180, 50, 0.007, 2.0/3*PI);
  new pyoroseina(aa,60,180, 50, 0.007, 4.0/3*PI);

  a=new nippu(pohja,210,10,310,110); aa=&(a->pohja);
  new pyoroseina(aa,260,60, 50, 0.007, 0);
  new pyoroseina(aa,260,60, 50, 0.007, 2.0/3*PI);
  new pyoroseina(aa,260,60, 50, 0.007, 4.0/3*PI);

  a=new nippu(pohja,210,130,310,230); aa=&(a->pohja);
  new pyoroseina(aa,260,180, 50, 0.007, 0);
  new pyoroseina(aa,260,180, 50, 0.007, 2.0/3*PI);
  new pyoroseina(aa,260,180, 50, 0.007, 4.0/3*PI);

  new pylvas(pohja,160,120,3);

}

#define laatikko(x,y,xx,yy) a=new boxi(pohja,x,y,x+55,y+55); \
                            new pehmoseina(&(a->yla), x,y,x+55,y,0.9);\
                            new pehmoseina(&(a->vas), x,y,x,y+55,0.9);\
                            new pehmoseina(&(a->oik), x+55,y,x+55,y+55,0.9);\
                            new pehmoseina(&(a->ala), x,y+55,x+55,y+55,0.9);\
                            new teleport(pohja, x+2,y+2, x+53, y+2,\
                                     xx+53, yy+53, xx+53, yy+2);

void kentta1009()
{

este **pohja=&(obj[10][9]);  boxi *a; este **aa;
kantax=320*10; kantay=240*9; nayttomoodi=0;
new pitkaruoho(pohja,0,0,320,240);

laatikko (140,90, 85,90);

laatikko (260, 180, 170,180);
laatikko (170, 180, 80, 180);
laatikko (80,180, 10,180);

laatikko (10, 180, 10,10);
laatikko (10, 10, 80,10);
laatikko (80, 10, 170, 10);
laatikko (170,10, 260, 10);
laatikko (260,10, 140, 90);

new teleport( pohja, 260+53, 180+53, 260+53, 180+2,
              260+53,  175+2, 260+2, 175+2 );
}


void kentta0909()
{ este **pohja=&(obj[9][9]);
  kantax=320*9; kantay=240*9; nayttomoodi=0;
  new pitkaruoho( pohja, 0,0,320,240);
  new monttu(pohja, 160,120,20,60,0.003);
  new teleport(pohja, 70, 10, 10, 40, 310, 200, 250, 230 );
  new teleport(pohja, 310, 40, 250,10,  70,230, 10, 200 );
  new pehmoseina(pohja, 70,8, 10,38);
  new pehmoseina(pohja, 310,202, 250,232);
  new pehmoseina(pohja, 310,38, 250, 8);
  new pehmoseina(pohja, 70, 232, 10, 202);

}

void kentta0908()
{ este **pohja=&(obj[9][8]); nayttomoodi=0;
  kantax=320*9; kantay=240*8;
  new ruoho( pohja, 0,0,320,240);
  new raskassnadi(pohja,0,0,320,240);
  new pylvas(pohja, 160,120,10);
  new seina(pohja,1,80, 1,160);
  new seina(pohja,318,80,318,160);
  new seina(pohja,100,1, 220,1);
  new seina(pohja,100,238,220,238);
}

void kentta1008()
{ este **pohja=&(obj[10][8]); nayttomoodi=0;
  kantax=320*10; kantay=240*8;
  new ruoho( pohja, 0,0,320,240);
  new raskassnadi(pohja, 0,0,320,240);
  new seina( pohja, 1,1,319,1);
  new seina( pohja, 1,239, 319,239);
  new seina( pohja, 1,50, 1,239);
  new seina( pohja, 80,  1, 80, 189);
  new seina( pohja, 160,50, 160,239);
  new seina( pohja, 240,  1, 240, 189);
  new seina( pohja, 319, 50, 319, 239);
}

void kentta1108()
{ int i,j; nippu *a; nayttomoodi=0;
  este **pohja=&(obj[11][8]);
  kantax=320*11; kantay=240*8;
  new ruoho( pohja, 0,0,320,240);
  new raskassnadi(pohja,0,0,320,240);
  for(i=0; i<320; i+=40)
  { a=new nippu(pohja,i,0,i+40,240);
    for(j=0; j<240; j+=40)
    new monttu(&(a->pohja), 20+i,20+j,10,20,0.002);
  }
}

void kentta1109()
{ este **pohja=&(obj[11][9]); nayttomoodi=0;
  kantax=320*11; kantay=240*9;
  new ruoho( pohja, 0,0, 320,240);
  new pehmoseina( pohja, 100,120,220,120, 0.05);
  new pehmoseina( pohja, 160,60, 160,180, 0.05);
  new monttu( pohja, 160,120, 60,80, -0.06);
  new voimaseina(pohja,2,50,60,2,3);
  new voimaseina(pohja,2,190,60,238,3);
  new voimaseina(pohja,318,50,260,2,3);
  new voimaseina(pohja,318,190,260,238,3);
  new pehmoseina(pohja,1,1,100,1);
  new pehmoseina(pohja,220,1,319,1);
  new pehmoseina(pohja,125,1, 195, 1);

  new pehmoseina(pohja,1,1, 1,90);
  new pehmoseina(pohja,1,160,1,239);
  new pehmoseina(pohja,1,239,160,239);
  new pehmoseina(pohja,250,239,319,239);
  new pehmoseina(pohja,319,239, 319,160);
  new pehmoseina(pohja,319,120,319,1);
  new hiekka( pohja, 2,60, 10,180);
  new hiekka( pohja, 70,2, 250,10);
  new hiekka( pohja, 310,60, 320, 180);
  new hiekka( pohja, 70,230, 250, 239);
}

void kentta1107()
{ este **pohja=&(obj[11][7]); nayttomoodi=0;
  kantax=320*11; kantay=240*7;
  new ruoho( pohja, 0,0, 319, 239);
  new laser( pohja, 0,0,319, 0, 500, 1000, 0);
  new laser( pohja, 318, 0, 318,239, 500,1000, 250);
  new laser( pohja, 0,239, 319,239, 500,1000,500);
  new laser( pohja, 0,0, 0,239, 500,1000, 750);
  new laser( pohja, 0,120, 319,120, 250, 700, 0);
  new laser( pohja, 100, 0, 100,239, 750, 1500, 0);
  new laser( pohja, 200, 0, 200,239, 750, 1500, 500);
}

void kentta0911()
{ este **pohja = &(obj[9][11]); nayttomoodi=0;
  kantax=320*9; kantay=240*11;
  new pitkaruoho( pohja,0,0,320,240);
  new miina( pohja,160,120);
  new seina( pohja,140,107, 180,107);
  new seina( pohja,140,133, 180,133);
  new maki ( pohja, 50,20, 160,70, 0.04,0.002);
  new maki ( pohja, 160,170, 180,170, 0.03, 0.003);
  new maki ( pohja, 100, 70, 100,180, 0.03, 0.003);
  new maki ( pohja, 20, 210, 300,170, 0.05, 0.002);
  new pylvas( pohja, 300,20,10);
}

void kentta0912()
{ este **pohja = &(obj[9][12]); nayttomoodi=0;
  kantax=320*9; kantay=240*12;
  new pitkaruoho( pohja, 0,0,320,240);

  new pylvas (pohja, 15,25,13);
  new teleport ( pohja, 20,20, 300, 20,  20,23, 300, 62 );
  new seina( pohja, 300,21, 300, 61);
  new teleport( pohja, 20,26, 300, 104, 20,29, 300, 144);
  new seina( pohja, 300,105, 300, 143);
  new teleport( pohja, 20,32, 300, 184, 18, 33, 298, 224);
  new seina(pohja, 300, 185, 299, 224);
  new teleport( pohja, 15, 33, 246, 224, 12, 33, 194, 224);
  new seina(pohja, 245, 224, 193,224);
  new teleport( pohja, 9, 33, 142, 224, 6, 33, 90, 224);
  new seina(pohja, 141, 224, 91, 224);

}

void kentta0809()
{ este **pohja = &(obj[8][9]); nippu *a; este **aa;
  kantax=320*8; kantay=240*9; nayttomoodi=0;
  new ruoho( pohja,0,0,320,240 );

  a=new nippu( pohja, 20, 20, 310, 40); aa=&(a->pohja);
  new pylvas( aa,30,30,5 );
  new pylvas( aa,60,30,5 );
  new pylvas( aa,90,30,5 );
  new pylvas( aa,120,30,5 );
  new pylvas( aa,150,30,5 );
  new pylvas( aa,180,30,5 );
  new pylvas( aa,210,30,5 );
  new pylvas( aa,240,30,5 );
  new pylvas( aa,270,30,5 );
  new pylvas( aa,300,30,5 );

  a=new nippu( pohja, 20, 50, 40, 220); aa=&(a->pohja);
  new pylvas( aa,30,60,5 );
  new pylvas( aa,30,90,5 );
  new pylvas( aa,30,120,5 );
  new pylvas( aa,30,150,5 );
  new pylvas( aa,30,180,5 );
  new pylvas( aa,30,210,5 );

  a=new nippu( pohja, 50, 200, 310, 220); aa=&(a->pohja);
  new pylvas( aa,60,210,5 );
  new pylvas( aa,90,210,5 );
  new pylvas( aa,120,210,5 );
  new pylvas( aa,150,210,5 );
  new pylvas( aa,180,210,5 );
  new pylvas( aa,210,210,5 );
  new pylvas( aa,240,210,5 );
  new pylvas( aa,270,210,5 );
  new pylvas( aa,300,210,5 );

  a=new nippu( pohja, 290, 50, 310, 220); aa=&(a->pohja);
  new pylvas( aa,300,60,5 );
  new pylvas( aa,300,90,5 );
  new pylvas( aa,300,120,5 );
  new pylvas( aa,300,150,5 );
  new pylvas( aa,300,180,5 );
  new pylvas( aa,300,210,5 );

  a=new nippu( pohja, 90, 90, 230, 110); aa=&(a->pohja);
  new pylvas( aa, 100,100, 5);
  new pylvas( aa, 130,100, 5);
  new pylvas( aa, 160,100, 5);
  new pylvas( aa, 190,100, 5);
  new pylvas( aa, 220,100, 5);

  a=new nippu( pohja, 90, 130, 230, 150); aa=&(a->pohja);
  new pylvas( aa, 100,140, 5);
  new pylvas( aa, 130,140, 5);
  new pylvas( aa, 160,140, 5);
  new pylvas( aa, 190,140, 5);
  new pylvas( aa, 220,140, 5);

  new pylvas( pohja, 65,65,5);
  new pylvas( pohja, 260,65,5);

  new pylvas( pohja, 65,175,5);
  new pylvas( pohja, 260,175,5);


}

#define kuobba(x,y,xx,yy) a=new nippu(pohja, x,y,x+40,y+40);\
new hiekka( &(a->pohja) , x,y,x+40,y+40); \
new voimakentta( &(a->pohja), \
 xx!=1 ? x+1 : x+20 , yy!=1 ? y+1 : y+20, \
 xx!=-1 ? x+39 : x+20, yy!=-1 ? y+39 : y+20,\
 -0.02*xx, -0.02*yy);

void kentta0810()
{ este **pohja=&(obj[8][10]); nippu *a;  nayttomoodi=0;
  kantax=320*8; kantay=240*10;
  new ruoho(pohja,0,0,320,240);
  new hiekka(pohja,0,0,319,10);
  kuobba(0,10,0,1);
  kuobba(90,10,1,0);
  kuobba(180,10,1,0);
  kuobba(270,10,0,1);

  kuobba(0,100, -1,0);
  kuobba(270,100,0,1);
  kuobba(90,100,1,0);
  kuobba(180,100,-1,0);

  kuobba(0,190,0,1);
  kuobba(90,190,-1,0);
  kuobba(180,190,1,0);
  kuobba(270,190,0,1);

}

void kentta0811()
{ este **pohja=&(obj[8][11]); nayttomoodi=0;
  kantax=320*8; kantay=240*11;
  new ruoho( pohja, 0,0, 319, 239);
  new laser( pohja, 0,0,319, 0, 200, 400, 0);
  new laser( pohja, 319, 0, 319,239, 200,400, 0);
  new laser( pohja, 0,239, 319,239, 200,400, 0);
  new laser( pohja, 0,0, 0,239, 200,400, 0);
  new laser( pohja, 0,120, 319,120, 200, 400, 0);
  new laser( pohja, 100, 0, 100,239, 200, 400, 0);
  new laser( pohja, 200, 0, 200,239, 200, 400, 0);
}

void kentta0711()
{ este **pohja=&(obj[7][11]); nayttomoodi=0; nippu *n;
  kantax=320*7; kantay=240*11;
  new ruoho(pohja,0,0,319,239);
  new voimakentta(pohja,0,0, 50, 200,0,0.015);
  new voimakentta(pohja,270, 40, 319, 238,0,-0.015);
  new hiekka(pohja,0,0,50,200);
  new hiekka(pohja,270,40,319,238);
  new jousitykki(pohja, 0,0, 50, 50, 25, 2, 0, 1);
  new seina(pohja,270,239, 319,239);
  new pehmoseina(pohja,0,239, 50, 239, 0.3);
  new pehmoseina(pohja,270, 1, 319,1, 0.3);
  n = new nippu(pohja, 110, 70, 210, 170);
  new pehmoseina(&(n->pohja), 160, 70, 160, 110);
  new pehmoseina(&(n->pohja), 160, 130, 160, 170);
  new pehmoseina(&(n->pohja), 110, 95, 152, 117);
  new pehmoseina(&(n->pohja), 110, 145, 152, 123);
  new pehmoseina(&(n->pohja), 210, 95, 168, 117);
  new pehmoseina(&(n->pohja), 210, 145, 168, 123);
  new raskassnadi(pohja, 0,200, 50, 239);
  new raskassnadi(pohja, 270,0,319,40);
}


void kentta1308()
{ este **pohja = &(obj[13][8]); nayttomoodi=2;
  kantax=320*13; kantay=240*8;

  new seina(pohja, 319,0,319,100);
  new seina(pohja, 319,140,319,235);

  new pehmoseina(pohja, 0, 239, 119, 239, 0.3);
  new ruoho(pohja, 0,235, 120,239);
  new pehmoseina(pohja, 201,239,319,239, 0.3);
  new ruoho(pohja, 200,235, 319,239);

  new pehmoseina(pohja, 121, 192, 199,192, 0.3);
  new ruoho(pohja, 120,188, 200, 192);

  new pehmoseina(pohja, 11, 140, 129, 140, 0.3);
  new ruoho(pohja, 10, 136, 130, 140);
  new pehmoseina(pohja, 201, 150, 309, 150, 0.3);
  new ruoho(pohja, 200, 146, 310, 150 );

  new pehmoseina(pohja, 121, 48 , 219, 48, 0.3);
  new ruoho(pohja, 120,44, 220, 48);

  new voimakentta(pohja,0, 192, 319, 235, 0,0.003);
  new voimakentta(pohja,120,235, 200, 239, 0,0.003);
  new voimakentta(pohja,0,140, 120, 192,0, 0.003);
  new voimakentta(pohja,200, 150, 319, 192,0, 0.003);
  new voimakentta(pohja,120,150, 200, 188,0, 0.003);
  new voimakentta(pohja,0,0,120,136,0,0.003);
  new voimakentta(pohja,220,0,319, 146,0,0.003);
  new voimakentta(pohja,120,0,220, 44,0,0.003);
  new voimakentta(pohja,0,136,10,140,0,0.003);
  new voimakentta(pohja,310,146,319,150,0,0.003);
  new voimakentta(pohja,130,48,200,188,0,0.003);
  new voimakentta(pohja,200,48,220, 146,0,0.003);
  new voimakentta(pohja,120,48,130, 136,0,0.003);
  new voimakentta(pohja,120,140,130, 150,0,0.003);
}

void kentta0709()
{ este **pohja = &(obj[7][9]); nayttomoodi=2;
  kantax=320*7; kantay=240*9;
  new ruoho(pohja,0,232,320,240);
  new seina(pohja, 0,0, 319,0);
  new seina(pohja, 319,0,319,200);
  new seina(pohja, 0,0, 0,219);
  new pehmoseina(pohja, 0,236,221,236, 0.3);
  new seina(pohja, 0,239, 319,239);
  new pehmoseina(pohja, 250, 227, 319, 200,0.9);

  new voimakentta(pohja,0,0, 319, 232, 0, 0.003);
  new voimakentta(pohja,222, 232, 319, 235,0,0.003);

  new seina(pohja, 250,239, 245, 238);
  new seina(pohja, 245,238, 240, 236);
  new seina(pohja, 240,236, 235, 233);
  new seina(pohja, 235,233, 230, 229);
  new seina(pohja, 230,229, 225, 224);
  new seina(pohja, 225,224, 221, 219);
  new seina(pohja, 221,219,221,239);
  new aurinko(pohja, 100,50,15);
}

void kentta1012()
{ este **pohja = & (obj[10][12]); nayttomoodi=0;
  kantax=320*10; kantay=240*12;
  new ruoho(pohja,0,190,110,240);
  new ruoho(pohja,210,190,320,240);
  new voimakentta(pohja,110,0, 210, 240, 0, 0.002);

  new voimakentta(pohja,0,0,110,190, 0, 0.002);
  new voimakentta(pohja,210,0,320,190, 0, 0.002);

  new pehmoseina(pohja, 0,239,319,239, 0.3);
  new pehmoseina(pohja, 0,190,0,239, 0.3);
  new pehmoseina(pohja, 319,190,319,239, 0.3);
  new seina(pohja, 110, 240, 160,190);
  new seina(pohja, 160,190, 210,240);
  new seina(pohja, 160,190, 160, 100);
  new seina(pohja, 110, 190, 110,0);
  new seina(pohja, 210, 190, 210,0);
  new seina(pohja, 110,0,210,0);

  new pyoroseina(pohja, 50,100, 30, 0.005, 0);
  new pyoroseina(pohja, 50,100, 30, 0.005, 3.14159*2.0/3.0);
  new pyoroseina(pohja, 50,100, 30, 0.005, 3.14159*4.0/3.0);


  new pyoroseina(pohja, 270,100, 30, 0.005, 0);
  new pyoroseina(pohja, 270,100, 30, 0.005, 3.14159*2.0/3.0);
  new pyoroseina(pohja, 270,100, 30, 0.005, 3.14159*4.0/3.0);

}

void kentta1112()
{ este **pohja = & (obj[11][12]); nayttomoodi=0;
  kantax=320*11; kantay=240*12;
  new ruoho(pohja,0,0,320,240);
  new seina(pohja,0,0,0,120);  
  new seina(pohja,0,120,200,120);
  new seina(pohja,80,239,319,239);
  new seina(pohja,319,110, 209,0);
  new seina(pohja,319,130, 209,240);
  new seina(pohja,160,0,320,0);
}

void kentta1212()
{ este **pohja = & (obj[12][12]); nayttomoodi=0;
  kantax=320*12; kantay=240*12;
  new ruoho(pohja,0,0,320,50);
  new voimakentta(pohja,0,50,320,240,0,-0.005);
  new pehmoseina(pohja,80,1,319,1,0.3);
  new seina(pohja,0,0,0,50);
  new seina(pohja,80,0,80,50);
  new seina(pohja,160,0,160,50);
  new seina(pohja,240,0,240,50);

}

  void kentta1312()
{ este **pohja = & (obj[13][12]); nayttomoodi=0;
  kantax=320*13; kantay=240*12;
  new ruoho(pohja,0,0,320,50);
  new voimakentta(pohja,0,50,320,240,0,-0.005);
  new pehmoseina(pohja,0,1,240,1,0.3);
  new seina(pohja,0,0,0,50);
  new seina(pohja,80,0,80,50);
  new seina(pohja,160,0,160,50);
  new seina(pohja,240,0,240,50);
  new seina(pohja,319,240,319,0);
}

void kentta1311()
{ este **pohja= & (obj[13][11]); nayttomoodi=0;
  kantax=320*13; kantay=240*11;
  new ruoho(pohja,0,0,320,240);

  new biliskentta(pohja,50,50,270,190);
  new teleport(pohja,50,50,270,50, 50,190,270,190);
  new teleport(pohja,50,50,50,190, 270,50,270,190);
  new hyppy(pohja, 150, 48, 170,48,0,5);
  new hyppy(pohja, 150, 192, 170,192, 0,-5);
  new teleport(pohja, 48,115, 48,125, 52,115, 52, 125);
}


void kentta0708()
{ este **pohja = &(obj[7][8]); nayttomoodi=0;
  kantax=320*7; kantay=240*8;
  new ruoho(pohja, 0,0,319,239);
  new voimakentta(pohja,0,0,319,110,0,0.01);
  new voimakentta(pohja,0,130,319,239,0,-0.01);
  new pehmoseina(pohja,64,110,64,130,0.9);
  new pehmoseina(pohja,128,110,128,130,0.9);
  new pehmoseina(pohja,192,110,192,130,0.9);
  new pehmoseina(pohja,256,110,256,130,0.9);
}

void kentta0707()
{ este **pohja = &(obj[7][7]); nayttomoodi=0;
  kantax=320*7; kantay=240*7;
  new pitkaruoho(pohja,0,0,319,239);
  new palloharjanne(pohja,160,120,8,35,0.01);
  new palloharjanne(pohja,160,120,38,65,0.01);
  new palloharjanne(pohja,160,120,68,95,0.01);
  new seina(pohja, 20,40, 50,20);
  new seina(pohja, 20, 200, 50, 220);
  new seina(pohja, 300,40,270,20);
  new seina(pohja, 300,200, 270,220);
  new seina(pohja, 50, 239, 270,239);
}

void kentta0710()
{ este **pohja= &(obj[7][10]); nayttomoodi=0;
  kantax=320*7; kantay=240*10;
  new pitkaruoho(pohja,0,21,320,219);
  new sotilasalue(pohja,0,1,319,21);
  new seina(pohja,0,0,319,0);
  new seina(pohja,0,239,320,239);
  new sotilasalue(pohja,0,220,319,238);
  new monttu(pohja,60,60,3,10,-0.04);
  new monttu(pohja,260,60,3,10,-0.03);
  new monttu(pohja,60,180,3,10,-0.03);
  new monttu(pohja,260,180,3,10,-0.03);
  new monttu(pohja,160,120,3,10,-0.03);
}

void kentta0609()
{ este **pohja= &(obj[6][9]); nayttomoodi=0;
  kantax=320*6; kantay=240*9;
  new ruoho(pohja,0,0, 319,239);
  new pyoroseina(pohja,30,210,30,-0.02,0);

  new seina(pohja,0,180,0,240);
  new seina(pohja,40,239,100,239);
  new seina(pohja,0,180,30,180);
  new seina(pohja,30,180,30,0);
  new seina(pohja,60,200,60,20);
  new seina(pohja,100,20,100,200);
  new seina(pohja,60,20,100,20);
  new seina(pohja,60,200,100,200);
  new seina(pohja,30,0,100,0);
  new voimakentta(pohja,60,0,70,20, 0.01,0);
  new hiekka(pohja,0,180,60,240);
  new hiekka(pohja,30,0,60,20);
  new maki(pohja, 260, 50,260,150, 0.40, 0.01);
  new maki(pohja, 160, 50,160,150, 0.40, 0.01);
  new pylvas(pohja, 30,210,5);
}

#define kraateri(x,y) { n= new nippu(pohja, x-25, y-25, x+25, y+25);\
                        new palloharjanne(&(n->pohja), x,y, 16, 24, 0.02);\
                        new monttu(&(n->pohja), x,y, 10, 16, 0.02);}

kentta0508()
{ este **pohja= &(obj[5][8]); nippu *n; nayttomoodi=0;
  kantax=5*320; kantay=8*240;
  new ruoho(pohja,0,0,319,239);
  new seina(pohja,0,0,0,239); new seina(pohja,0,0,319,0);
  new seina(pohja,319,0,319,140); new seina(pohja,319,180,319,239);
  new ampu(pohja,160,50,5);

  kraateri(50,30); kraateri(200, 60); kraateri(130, 100);
  kraateri(200, 150); kraateri(280, 200); kraateri(50, 210);
  kraateri(140, 215);

  new hiekka(pohja, 30,60, 70, 80);

  new sotilasalue(pohja,100,30,110,35);
  new sotilasalue(pohja,250,40,300,45);
  new sotilasalue(pohja,20,165, 170,175);
}


kentta0509()
{ este **pohja= &(obj[5][9]); nippu *n; nayttomoodi=0;
  kantax=5*320; kantay=9*240;
  new ruoho(pohja,0,0,319,239);
  new seina(pohja,0,0,0,239); new seina(pohja,0,239,319,239);
  new ampu(pohja,160,190,5);
  new hiekka(pohja, 100, 180, 150, 190);
  new hiekka(pohja,150,160, 200, 170);
  new hiekka(pohja,140,0,200,20);

  kraateri(50,50); kraateri(290,30); kraateri(290,200);
  kraateri(100,100); kraateri(230,80);

  new sotilasalue(pohja,10,150,50,170);
  new sotilasalue(pohja,290,100, 310,105);
}


void kentta0611()
{ este **pohja= &(obj[6][11]); nayttomoodi=0;
  kantax=320*6; kantay=240*11;
  new ruoho(pohja, 0,0, 319,239);
  new painovoima(pohja,0,0,319,239);
  new raskassnadi(pohja,0,0,319,239);
  new seina(pohja,0,0, 140, 0); new seina(pohja, 180,0,319,0);
  new seina(pohja,0,0, 0, 220 );
  new seina(pohja, 319, 0,319, 200);
  new seina(pohja, 140,239,319,239);
  new seina(pohja, 0,239,100,239);
}



void kentta0608()
{ este **pohja= &(obj[6][8]); nayttomoodi=0;
  kantax=320*6; kantay=240*8;
  new pitkaruoho(pohja,0,0,319,239);
  new hiekka(pohja,150,0,170,239);
  new monttu(pohja,60,60,10,50,0.005);
  new monttu(pohja,60,179,10,50,0.005);
  new monttu(pohja,259,60,10,50,0.005);
  new monttu(pohja,259,179,10,50,0.005);
}

void kentta0607()
{ este **pohja= &(obj[6][7]); nayttomoodi=0;
  kantax=320*6; kantay=240*7;
  new ruoho(pohja,0,0,319,239);
  new biliskentta(pohja,50,50, 270, 190);

  new seina(pohja,58, 50, 152, 50);
  new seina(pohja,166, 50, 262, 50);

  new seina(pohja,58, 190, 152, 190);
  new seina(pohja,166, 190, 262, 190);

  new seina(pohja,50, 58, 50, 182);
  new seina(pohja,270, 58, 270, 182);

  new hyppy(pohja,272, 100, 272, 140, -10,0);
  new hyppy(pohja, 48, 100, 48, 140, 10, 0);

  new hyppy(pohja, 170, 192, 210, 192, 0, -10);
  new hyppy(pohja, 170, 48, 210, 48, 0, 10);
}

void kentta0606()
{ este **pohja=&(obj[6][6]); nayttomoodi=0;
  kantax=320*6; kantay=240*6;
  new ruoho(pohja,0,0,319,239);
  new miina(pohja,160,120);
  new tykki(pohja,50,50,4);
  new tykki(pohja,270,50,4);
  new tykki(pohja,50,190,4);
  new tykki(pohja,270,190,4);
  new seina(pohja,0,50, 0,239);
  new seina(pohja,0,0,110, 0);
  new seina(pohja,210,0,319,0);
}

void kentta0506()
{ este **pohja=&(obj[5][6]); nayttomoodi=0;
  kantax=320*5; kantay=240*6;
  new ruoho(pohja,0,0,320,240);
  new pehmoseina(pohja, 0,1,319,1, 0);
  new seina(pohja, 0,50, 0, 220);
  new seina(pohja, 319,50, 319, 220);
  new voimakentta(pohja, 1, 50, 319, 239, 0, 0.005);
}

void kentta0507()
{ este **pohja=&(obj[5][7]); nayttomoodi=0;
  kantax=320*5; kantay=240*7;
  new ruoho(pohja,0,0,320,240);
  new voimaseina(pohja, 0,238,319,238,4 );
  new seina(pohja, 0,50, 0, 200);
  new seina(pohja, 319,50, 319, 200);
  new voimakentta(pohja, 1, 0, 319, 200, 0, 0.005);
}


void kentta0610()
{ este **pohja=&(obj[6][10]); nayttomoodi=0;
  kantax=320*6; kantay=240*10;
  new ruoho(pohja,0,0,319,239);
  new seina(pohja,0,0, 0, 180);
  new seina(pohja,0,180, 100,180);
  new seina(pohja,100,160,100,0);
  new seina(pohja,40,0,40,160);
  new seina(pohja,40,160,100,160);
  new hiekka(pohja, 0,160,40,180);
  new voimakentta(pohja, 40,160, 50,180, 0.02,0);
  new palloharjanne( pohja, 210,120, 60, 100, 0.01);
  new hiekka(pohja, 100,0,320,20);
}

void kentta0510()
{ este **pohja=&(obj[5][10]); nayttomoodi=0;
  kantax=320*5; kantay=240*10;
  new ruoho(pohja,0,0,319,239);

  new teleport(pohja,2,2,2,178,317,2,317,178);

  new hyppy(pohja,2,2,317,2,0,15);

  new seina(pohja,0,0,0,180);

  new seina(pohja,0,239,140,239);
  new seina(pohja,180,239,319,239);

  new hyppy(pohja,2,237,138,237,0,-15);
  new hyppy(pohja,182,237,317,237,0,-15);

  new hyppy(pohja,50,76, 60,76, 0,15 );
  new hyppy(pohja,270,76, 280,76, 0, 15);
  new hyppy(pohja,50,164,60,164,0,-15);
  new hyppy(pohja,270,164,280,164,0,-15);

  new teleport(pohja,50,80,280,80, 50, 100, 280, 100);
  new teleport(pohja,50,140,280,140, 50,160,280,160);
}

void kentta0511()
{ este **pohja=&(obj[5][11]); nayttomoodi=0;
  kantax=320*5; kantay=240*11;
  new ruoho(pohja,0,0,319,240);
  new pehmoseina(pohja,0,0,0,220);
  new ampu(pohja,50,50,10);
  new ampu(pohja,270,50,10);
  new pyoroseina(pohja,160,150,70,0.008,0);
  new pyoroseina(pohja,160,150,70,0.008,3.14159);
  new tykki(pohja,50,220,10);
}

void kentta0512()
{ este **pohja=&(obj[5][12]); nayttomoodi=0;
  kantax=320*5; kantay=240*12;
  new ruoho(pohja,0,0,319,240);
  new seina(pohja,0,20,0,239);
  new pehmoseina(pohja,0,239,319,239);
  new ampu(pohja,50,190,10);
  new ampu(pohja,270,190,10);
  new pyoroseina(pohja,160,90,70,0.008,0);
  new pyoroseina(pohja,160,90,70,0.008,3.14159);
  new tykki(pohja,270, 20, 10);
}


void kentta0913()
{ este **pohja=&(obj[9][13]); nayttomoodi=0;
  kantax=320*9; kantay=240*13;
  new ruoho(pohja,200,0,320,240);
  new voimakentta(pohja,0,0,200,240,0,0.004);
  new seina(pohja,0,0,200,50);
  new seina(pohja,0,50,200,100);
  new seina(pohja,0,100,200,150);
  new seina(pohja,0,150,200,200);
  new seina(pohja,0,239,200,239);
  new seina(pohja,0,190,0,239);
  new seina(pohja,0,190,200,239);
}

void kentta1013()
{ este **pohja=&(obj[10][13]);
  int i,j;
  nayttomoodi=0;
  kantax=320*10; kantay=240*13;
  new ruoho(pohja,0,0,320,240);
  for(i=0; i<8; i++) {nippu *n=new nippu(pohja,i*40,0,i*40+40,239);
    for(j=0; j<6; j++)
    { if ( (i+j) % 2) new kaarre(&(n->pohja),i*40,j*40,i*40+39,j*40+39,-0.01);
          else new kaarre(&(n->pohja),i*40,j*40,i*40+39,j*40+39,0.01);
  }}
  new pehmoseina(pohja,0,0,0,100);
  new pehmoseina(pohja,0,140,0,240);
  new seina(pohja,0,239,120,239);
  new seina(pohja,200,239,320,239);
  new seina(pohja,319,0,319,80);
  new seina(pohja,319,160,319,239);
}

void kentta1113()
{ este **pohja=&(obj[11][13]); nayttomoodi=0;
  kantax=320*11; kantay=240*13;
  new ruoho(pohja,0,0,320,240);
  new pehmoseina(pohja,80,239,319,239);
  new pehmoseina(pohja,319,100,319,239);
  new putous(pohja,110,1,238);
  new putous(pohja,120,1,238,63);
  new voimakentta(pohja,105,1,140,238,0.003,0);
  new hyppy(pohja,105,238,125,238,30,-5);
  new painovoima(pohja, 180,0, 319,239);
  new raskassnadi(pohja, 180,0,319,239);
  new hiekka(pohja,5,80,40, 160);
}

void kentta0813()
{ este **pohja=&(obj[8][13]); nayttomoodi=0;
  kantax=320*8; kantay=240*13;
  new pitkaruoho(pohja,0,0,60,239);
  new pitkaruoho(pohja,260,0,319,239);
  new ruoho(pohja,60,0,260,239);
  new kaari(pohja, 160,120, 100, PI/2, PI*3.0/2.0);
  new kaari(pohja, 162, 140, 80, -PI/2, PI/2);
  new kaari(pohja, 160, 120, 60, PI/2, PI*3.0/2.0);
  new kaari(pohja, 162, 140, 40, -PI/2, PI/2);
  new kaari(pohja, 160, 120, 20, PI/2, PI*3.0/2.0);
}

void kentta0713()
{ este **pohja=&(obj[7][13]); nayttomoodi=0;
  kantax=320*7; kantay=240*13;
  new pitkaruoho(pohja,0,0,319,239);
  new vaihtotormays(pohja,20,10,300,230);
  new kaari(pohja,70,50,40, -PI, 0);
  new kaari(pohja,135,50,40, 0, PI);
  new kaari(pohja,195,50,40, -PI, 0);
  new kaari(pohja,255,50,40, 0, PI);

  new kaari(pohja,70,120,40, -PI, 0);
  new kaari(pohja,135,120,40, 0, PI);
  new kaari(pohja,195,120,40, -PI, 0);
  new kaari(pohja,255,120,40, 0, PI);

  new kaari(pohja,70,190,40, -PI, 0);
  new kaari(pohja,135,190,40, 0, PI);
  new kaari(pohja,195,190,40, -PI, 0);
  new kaari(pohja,255,190,40, 0, PI);
}

void pyoroovi(este **e, int x, int y )
{ nippu *ee=new nippu(e,x-30,y-30,x+30,y+30);
  new kaari(&(ee->pohja),x,y,28, PI/4, 3*PI/4);
  new kaari(&(ee->pohja),x,y,28, 5*PI/4, 7*PI/4);
  new pyoroseina(&(ee->pohja),x,y,25, 0.01, 0);
  new pyoroseina(&(ee->pohja),x,y,25, 0.01, PI/2);
  new pyoroseina(&(ee->pohja),x,y,25, 0.01, PI);
  new pyoroseina(&(ee->pohja),x,y,25, 0.01, 3*PI/2);
}

void kentta0613()
{ este **pohja=&(obj[6][13]); nayttomoodi=0;
  kantax=320*6; kantay=240*13;
  new pitkaruoho(pohja,0,0,320,240);
  pyoroovi(pohja,50,50);
  pyoroovi(pohja,50,120);
  pyoroovi(pohja,50,190);
  pyoroovi(pohja,160,50);
  pyoroovi(pohja,160,120);
  pyoroovi(pohja,160,190);
  pyoroovi(pohja,270,50);
  pyoroovi(pohja,270,120);
  pyoroovi(pohja,270,190);
}




void kentta0812()
{ este **pohja=&(obj[8][12]); nayttomoodi=0;
  kantax=320*8; kantay=240*12;
  new pitkaruoho(pohja,0,0,320,240);
  new kaarre(pohja,1,40, 278,200, 0.0008);
  new voimakentta(pohja,0,40, 280,200, -0.004, 0);
  new hiekka(pohja,300,40, 320, 200);
}

void kentta0712()
{ este **pohja=&(obj[7][12]); nayttomoodi=0;
  kantax=320*7; kantay=240*12;
  new pitkaruoho(pohja,0,0,320,240);
  new kaarre(pohja,0,40, 319,200, 0.0008);
  new voimakentta(pohja,0,40, 319,200, -0.004, 0);
}

void kentta0612()
{ este **pohja=&(obj[6][12]); nayttomoodi=0;
  kantax=320*6; kantay=240*12;
  new pitkaruoho(pohja,0,0,320,240);
  new kaarre(pohja,100,40, 319,200, 0.0008);
  new voimakentta(pohja,100,40, 319,200, -0.004, 0);
  new pehmoseina(pohja,1,1, 1,220);
}

void kentta1310()
{ este **pohja=&(obj[13][10]); nayttomoodi=0;
  kantax=320*13; kantay=240*10; valkky *v;
  new ruoho(pohja,0,0,319,239);
  new pehmoseina(pohja,0,1,120,1,0.8);
  new pehmoseina(pohja,200,1,319,1,0.8);
  new pehmoseina(pohja,0,239,120,239,0.8);
  new pehmoseina(pohja,200,239,319,239,0.8);
  new pehmoseina(pohja,319,1,319,100,0.8);
  new pehmoseina(pohja,319,140,319,239,0.8);

  v=new valkky(pohja,400,800,0);
  new miina(&(v->onkasa), 50,50);
  new miina(&(v->onkasa), 270,50);
  new miina(&(v->onkasa), 50,190);
  new miina(&(v->onkasa), 270,190);
  new pylvas(&(v->offkasa), 50,50,5);
  new pylvas(&(v->offkasa), 270,50,5);
  new pylvas(&(v->offkasa), 50,190,5);
  new pylvas(&(v->offkasa), 270,190,5);

  new pylvas(pohja, 160,50, 5);
  new pylvas(pohja, 50,120, 5);
  new pylvas(&(v->offkasa), 160,120, 5);
  new miina(&(v->onkasa), 160,120 );
  new pylvas(pohja, 270,120, 5);
  new pylvas(pohja, 160,190, 5);
}

void kentta1309()
{ este **pohja=&(obj[13][9]); nayttomoodi=0;
  int i; nippu *n; este **n1, **n2, **n3, **n4, **n5, **n6;
  kantax=320*13; kantay=240*9;

  n=new nippu(pohja,0,0,120,120); n1=&(n->pohja);
  n=new nippu(pohja,120,0,200,120); n2=&(n->pohja);
  n=new nippu(pohja,200,0,320,120); n3=&(n->pohja);

  n=new nippu(pohja,0,120,120,240); n4=&(n->pohja);
  n=new nippu(pohja,120,120,200,240); n5=&(n->pohja);
  n=new nippu(pohja,200,120,320,240); n6=&(n->pohja);

  new ruoho(pohja,0,0,320,240);
  new seina(pohja,120,120,200,120);

  new seina(n1,0,0,120,0);
  new seina(n3,200,0,319,0);
  new seina(n3,319,0,319,80);
  new seina(n6,319,160,319,239);
  new seina(n4,0,239,120,239);
  new seina(n6,200,239,319,239);

  for(i=120; i<201; i+=10)
  { new laser(n2, i, 0, i, 120, 700, 900, 565+ 80-i );
    new laser(n5, i, 120, i, 240, 700, 900, 775+ i);
  }
  for(i=0; i < 46; i+=10)
  { new laser(n1, int( tan(i/180.0*PI) * 120), 0, 120, 120, 700, 900, 90-2*i + 535);
    new laser(n1, 0, int( tan(i/180.0*PI) * 120) , 120, 120, 700, 900, 2*i + 625);
    new laser(n4, 0, 239-int( tan(i/180.0*PI) * 120) , 120, 120, 700, 900, 90-2*i + 715);
    new laser(n4, int( tan(i/180.0*PI) * 120), 239, 120, 120, 700, 900, 2*i + 805);

    new laser(n3, 319-int( tan(i/180.0*PI) * 120), 0, 200, 120, 700, 900, 2*i+355);
    new laser(n3, 319, int( tan(i/180.0*PI) * 120) , 200, 120, 700, 900, 90-2*i+265);
    new laser(n6, 319, 239-int( tan(i/180.0*PI) * 120) , 200, 120, 700, 900, 2*i+175);
    new laser(n6, 319-int( tan(i/180.0*PI) * 120), 239, 200, 120, 700, 900, 90-2*i+ 85);


  }

}

void kentta0705()
{ int i;
  este **pohja=&(obj[7][5]); nayttomoodi=0;
  nippu *n;
  kantax=320*7; kantay=240*5;
  new ruoho(pohja,0,0,319,239);
  new raskassnadi(pohja,0,100,319,239);
  new pehmoseina(pohja,0,0,319,0,0.4);
  new pehmoseina(pohja,0,238,319,238,0.4);
  new seina(pohja,0,0,0,100);
  new seina(pohja,317,140,317,239);
  new seina(pohja,317,0,317,100);
  new hyppy(pohja,319,140,319,239,-10,0);
  new hyppy(pohja,319,0,319,100,-10,100);
  n=new nippu(pohja,0,0,320,100);
  for(i=0; i<319; i+=18)
  { new jousitykki(&(n->pohja),i,0,i+19,100,i+10,80,0,0.8); }
}

void kentta0605()
{ este **pohja=&(obj[6][5]); nayttomoodi=0;
  kantax=320*6; kantay=240*5;
  new ruoho(pohja,0,0,319,239);
  new kaari(pohja,160,110,100, PI/4.0+0.4, PI+PI/4.0-0.4);
  new kaari(pohja,160,110,100, PI+PI/4.0+0.4, 2*PI+PI/4-0.4);
  new kaari(pohja,160,110,70, -PI/2.0+0.4, 2*PI-PI/2.0-0.4);
  new pylvas(pohja,160,110,20);
}

void kentta0505()

{ este **pohja=&(obj[5][5]); nayttomoodi=0;
  kantax=320*5; kantay=240*5;
  new ruoho(pohja,0,220,319,239);
  new voimakentta(pohja,0,0,319,225,0,0.005);
  new seina(pohja,0,237,319,237);
  new suuntahiekka(pohja,0,233,100,239,0,0.3);
  new suuntahiekka(pohja,220,233,319,239,0,0.3);
  new teleport(pohja,319,200,319,239,310,225,310,237);
  new seina(pohja,319,0, 319,200);
  new seina(pohja,310,0,310,225);
  new kaari(pohja,210,197,40,PI/2,PI-0.3);
  new kaari(pohja,110,197,40,0.3,PI/2);
  new seina(pohja,0,0,319,0);
  new seina(pohja,0,0,0,239);


}

void kentta1104()
{ este **pohja=&(obj[11][4]); nayttomoodi=0;
  aikanappula *n;
  kantax=320*11; kantay=240*4;
  new ruoho(pohja,0,0,319,239);
  n=new aikanappula(pohja,155,115,1000,1);
  new pacman(&(n->onkasa),30,30,290,30,0,0.01);
  new pacman(&(n->onkasa),30,60,290,60,0,0.01);
  new pacman(&(n->onkasa),30,90,290,90,0,0.01);
  new pacman(&(n->onkasa),30,150,290,150,0,0.01);
  new pacman(&(n->onkasa),30,180,290,180,0,0.01);
  new pacman(&(n->onkasa),30,210,290,210,0,0.01);
  new palautasnadi(&(n->offkasa),0,0,319,239);
  new voimakentta(pohja,0,0,319,10,0,0.01);
  new voimakentta(pohja,0,0,10,239,0.01,0);
  new voimakentta(pohja,309,0,319,239,-0.01,0);
  new voimakentta(pohja,0,229,319,239,0,-0.01);
}

void kentta1204()
{ este **pohja=&(obj[12][4]); nayttomoodi=0;
  kantax=320*12; kantay=240*4;
  new ruoho(pohja,0,0,319,239);
  new kaari(pohja,200,120,100,-PI/2,PI/2);
  new seina(pohja,0,120,220,120);
}

void ohjekentta(int x,int y, int i)
{ este **pohja=&(obj[x][y]); nayttomoodi=1;
  kantax=320*x; kantay=240*y;
  new ruoho(pohja,0,0,320,240);
  new ohje(pohja, i);
  new pehmoseina(pohja,1,1,1,238);
  new pehmoseina(pohja,1,1,318,1);
  new pehmoseina(pohja,1,238,318,238);
  new pehmoseina(pohja,318,1,318,238);
}


void tyhjakentta(int x,int y)
{ este **pohja=&(obj[x][y]); nayttomoodi=1;
  kantax=320*x; kantay=240*y;
  new ruoho(pohja,0,0,320,240);
  new varoitus(pohja, 100,100);
  new pehmoseina(pohja,1,1,1,238);
  new pehmoseina(pohja,1,1,318,1);
  new pehmoseina(pohja,1,238,318,238);
  new pehmoseina(pohja,318,1,318,238);
}


int main(int argc, char **argv)
{  int i,j;
   alusta();
   lueohjeet();

   kentta1010(); kentta0809(); kentta0911();
   kentta0807(); kentta0906(); kentta0808();
   kentta0806(); kentta0910(); kentta1009();
   kentta1110(); kentta0709(); kentta0610();
   kentta0609(); kentta0909(); kentta0810();

   kentta0908(); kentta1008(); kentta1108();
   kentta0710(); kentta0708(); kentta0707();
   kentta1109(); kentta0907(); kentta1107();
   kentta0811(); kentta1011(); kentta0706();
   kentta0608(); kentta0607(); kentta1007();

   kentta1111(); kentta1211(); kentta1006();
   kentta0611(); kentta0711(); kentta1210();
   kentta1209(); kentta1208(); kentta0606();
   kentta1207(); kentta1206(); kentta1106();
   kentta0508(); kentta0509(); kentta0510();

   kentta1306(); kentta0912(); kentta0612();
   kentta0712(); kentta0812(); kentta0506();
   kentta0507(); kentta0511(); kentta0512();
   kentta1012(); kentta1112(); kentta1212();
   kentta1312(); kentta1311(); kentta1307();

   kentta1309(); kentta1308(); kentta1310();
   kentta1105(); kentta1205(); kentta1305();
   kentta0905(); kentta1005(); kentta0805();
   kentta0705(); kentta0804(); kentta0904();
   kentta1004(); kentta1104(); kentta0605();

   kentta0505(); kentta0813(); kentta0713();
   kentta1204(); kentta0913(); kentta0613();
   kentta1013(); kentta1113();

   ohjex1=9; ohjex2=9;
   for(i=0; i<20; i++) for(j=0; j<20; j++)
   {if (obj[i][j]!=0 && i<ohjex1) ohjex1=i;
    if (obj[i][j]!=0 && i>ohjex2) ohjex2=i;
   }
   ohjex1--;
   ohjex2++;

   for(i=0; i<16; i++) ohjekentta(ohjex1,i,i);
   for(i=0; i<10; i++) ohjekentta(ohjex2,i,i+16);

   for(i=0; i<20; i++)for(j=0; j<20; j++)
   if (obj[i][j]==0) tyhjakentta(i,j);

   kantax=9*320; kantay=9*240;

   if (argc > 1 && argv[1][0]=='d')
   {kantax=11*320; kantay=13*240;}

   entx=kantax+50; enty=kantay +120;

   kantax-=160; kantay-=120;

   teksti.lisaa("WELCOME TO PLAY EXTREME PETANKKI BY TUOMAS KORPPI. HAVE FUN!",1);
   teksti.lisaa("   --- SCROLL INTO THE HELP FILE BY HOLDING DOWN THE 'H' KEY",0);
   teksti.lisaa("   --- SCROLL INTO THE HELP FILE BY HOLDING DOWN THE 'H' KEY",0);
   teksti.lisaa("   --- SCROLL INTO THE HELP FILE BY HOLDING DOWN THE 'H' KEY",0);
   teksti.lisaa("   --- SCROLL INTO THE HELP FILE BY HOLDING DOWN THE 'H' KEY",0);
   teksti.lisaa("   --- SCROLL INTO THE HELP FILE BY HOLDING DOWN THE 'H' KEY",0);
   teksti.lisaa("   --- SCROLL INTO THE HELP FILE BY HOLDING DOWN THE 'H' KEY",0);
   teksti.lisaa("   --- SCROLL INTO THE HELP FILE BY HOLDING DOWN THE 'H' KEY",0);

   ottelu();

}

