#ifndef		TEGMAP_H
#define		TEGMAP_H

#include <allegro.h>
#include <tegel.h>

class Tegmap
{
	private:
		DATAFILE *tileset;
		
		TEG_MAP *map;
		
		bool tsptr_owned;
	public:
		void LoadTileset( char *path )
		{
			if (tileset && tsptr_owned) teg_unload_datafile(tileset);
			tileset = teg_load_datafile(path);
			tsptr_owned = true;
		}
		
		void AssignTileset( DATAFILE *ts )
		{
			if (tileset && tsptr_owned) teg_unload_datafile(tileset);
			tileset = ts;
			tsptr_owned = false;
		}
		
		void LoadMap( char *path, char *tsname )
		{
			if (map) teg_destroymap(map);
			map = teg_loadmap(path, (TEG_TILELIST*) (find_datafile_object(tileset, tsname)->dat));
		}
		
		void Draw( BITMAP *dest, int layer, int x, int y ) { teg_draw(dest, map, layer, x, y); }
		void DrawFrame( BITMAP *dest, int layer, int x, int y, int frame ) { teg_draw_frame(dest, map, layer, x, y, frame); }
		void DrawRLE( BITMAP *dest, int layer, int x, int y, int frame ) { teg_draw_rle(dest, map, layer, x, y, frame); }
		void DrawBMP( BITMAP *dest, int layer, int x, int y, int frame ) { teg_draw_bmp(dest, map, layer, x, y, frame); }
		
		void DrawPart( BITMAP *dest, int layer, int sx, int sy, int w, int h, int dx, int dy )
		{
			teg_partdraw(dest, map, layer, sx, sy, w, h, dx, dy);
		}
		
		int MapGet( int layer, int x, int y )
		{
			if (x<0 || x>=map->w || y<0 || y>=map->h)
				return 0;
			else
				return teg_mapget(map, layer, x, y);
		}
		void MapPut( int layer, int x, int y, int val ) { teg_mapput(map, layer, x, y, val); }
		
		int TileAtPoint( int layer, int x, int y )
		{
			if ((x>=0) && (x<320) && (y>=0) && (y<240))
				return teg_mapget(map, layer, x/16, y/16);
			else
				return 0;
		}
		
		Tegmap() :
			tileset(NULL),
			map(NULL),
			tsptr_owned(false)
		{
		}
		
		~Tegmap()
		{
			if (tsptr_owned) teg_unload_datafile(tileset);
			teg_destroymap(map);
		}
};

#endif		// TEGMAP_H