#define DEBUGMODE

#include "StaticEnemy.h"
#include "Play.h"
#include "GameScreen.h"
#include "AudioSampler.h"

StaticEnemy::StaticEnemy(GameScreen *gs)
	:Object(gs, false),
	static_type(0), damage(0)
{
	type = OBJTYPE_STATICENEMY;
	health = 100;
	is_character = false;
	user_controlled = false;
	possessable = false;
	fullhealth = 1000;
	
	aexplode = new AudioSampler(GetSound());
}

void StaticEnemy::ReadProperties(MyINI *ini)
{
	Object::ReadProperties(ini);
	
	if (!strcmp(ini->Variable(), "statictype"))
		static_type = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "animation"))
	{
		char *s = ini->ReadQString();
		anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist[s]));
		free(s);
	}
	if (!strcmp(ini->Variable(), "damage"))
		damage = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "aexplode"))
		aexplode->LoadFromINI(ini);
}

bool StaticEnemy::Interact(Object *obj)
{
	bool ret = false;
	
	switch(static_type)
	{
		case 0: // Standard. Just damage.
			obj->DamageWD(damage);
			ret = false;
			break;
		case 1: // Explode. Kill.
			obj->Death();
			ret = true;
			break;
	}
	
	return ret;
}

void StaticEnemy::ProcessAI()
{
	bool
		destroyed = false,
		isonscreen = IsOnScreen();
	
	Object *mc = gamescreen->GetPlay()->GetMainCharacter();
	if (!mc->IsDead())
		if (Intersect(mc))
			destroyed = Interact(mc);
	
	gamescreen->CNReset();
	while(!gamescreen->CNEnd() && !destroyed)
	{
		Object *obj = gamescreen->CNGet();
		if (!obj->IsDead())
			if (obj->Type() != OBJTYPE_GHOST)
				if (Intersect(obj))
					destroyed = Interact(obj);
		gamescreen->CNNext();
	}
	
	if (destroyed)
	{
		if (isonscreen)
			aexplode->Play();
		Destroy();
	}
}