#define DEBUGMODE

#include "Resources.h"

Resources::Resources():
	sprites(NULL),
	tilesets(NULL),
	sounds(NULL),
	fonts(NULL)
{
	sound = new Sound;
}

Resources::~Resources()
{
	unload_datafile(sprites);
	teg_unload_datafile(tilesets);
	unload_datafile(sounds);
	unload_datafile(fonts);
	unload_datafile(images);
	
	std::vector <Tegmap*>::iterator i;
	for ( i = maps.begin(); i != maps.end(); i++ ) delete *i;
	
	delete sound;
}

void Resources::Init()
{
	sprites = load_datafile("data\\sprites.dat");
	tilesets = teg_load_datafile("data\\tileset.dat");
TRACE("Tilesets loaded\n");
	images = load_datafile("data\\images.dat");
TRACE("Images loaded!\n");
	LoadMaps("data\\gamescreens.txt");
TRACE("Gamescreens loaded!\n");
	LoadAnimations("data\\animations.txt");
	LoadMessageTexts("data\\messages.txt");
	sound->LoadFromDatafile("data\\sounds.dat");
	//sound->Play("2", 128, 128, 1);
}

void Resources::LoadAnimations(char *path)
{
	MyINI ini;
	int d;
	char *s, *section = NULL;
	Animation *a = NULL;

	ini.LoadINI(path);
	
	for( int i=0; i<ini.Count(); i++ )
	{
		if (ini.IsSection())
		{
			free(section);
			section = strassign(ini.SectionName());
			a = new Animation;
			animlist[section] = a;
		}
		
		if (ini.IsAssignment())
		{
			if (!strcmp(ini.Variable(), "intervaltoall"))
			{
				a->SetIntervalToAll(ini.ReadInteger());
			}
			else
			{
				s = ini.ReadQString();
				d = ini.ReadInteger();
				a->Add((BITMAP*)find_datafile_object(sprites, s)->dat, d);
				free(s);
			}
		}
		
		ini.NextLine();
	}
	free(section);
}

void Resources::LoadMaps(char *path)
{
	MyINI ini;
	int section = SEC_UNKNOWN;
	
	Tegmap *tm;
	MAPEX mex;
	char *s;
	
TRACE("Loading maps... from %s\n", path);
	ini.LoadINI(path);

	for( int i=0; i<ini.Count(); i++ )
	{
		TRACE("INI #%d\n", i);
		if (ini.IsSection())
		{
			if (!strcmp(ini.SectionName(), "entryinfo")) section = SEC_ENTRYINFO;
			if (!strcmp(ini.SectionName(), "gamescreens")) section = SEC_GAMESCREENS;
		}
		
		if (ini.IsAssignment() || ini.IsSingle())
		{
			switch ( section )
			{
				case SEC_ENTRYINFO:
					if (!strcmp(ini.Variable(), "entryscreen"))
						entryinfo.entryscreen = ini.ReadInteger();
					if (!strcmp(ini.Variable(), "pos"))
					{
						entryinfo.posx = ini.ReadInteger();
						entryinfo.posy = ini.ReadInteger();
					}
					if (!strcmp(ini.Variable(), "tileset"))
						entryinfo.tileset = ini.ReadQString();
					break;
				case SEC_GAMESCREENS:
					s = ini.ReadQString();
					if (!ini.Error())
					{
						tm = new Tegmap;
						tm->AssignTileset(tilesets);
						tm->LoadMap(s, entryinfo.tileset);
						maps.push_back(tm);
						free(s);
					}
					mex.bgname = ini.ReadQString();
					mex.left = ini.ReadInteger();
					mex.right = ini.ReadInteger();
					mex.top = ini.ReadInteger();
					mex.bottom = ini.ReadInteger();
					mex.bgx = ini.ReadInteger();
					mex.bgy = ini.ReadInteger();
					mex.plays_music = ini.ReadBool();
					mex.music = ini.ReadQString();
					mex.infofile = ini.ReadQString();
					mapex.push_back(mex);
					break;
			}
		}
		ini.NextLine();		
	}
}

void Resources::LoadMessageTexts(char *path)
{
	MyINI ini;
	int mid, rt;
	char *text;

	ini.LoadINI(path);
	
	for( int i=0; i<ini.Count(); i++ )
	{	
		if (ini.IsAssignment())
		{
			mid = text_to_msgid(ini.Variable());
			if (mid >= 0)
			{
				rt = ini.ReadInteger();
				text = ini.ReadQString();
				msgtexts[rt][mid].push_back(new std::string(text));
				free(text);
			}
		}
		
		ini.NextLine();
	}
}

BITMAP *Resources::GetSprite(char* id)
{
	DATAFILE *t;
	t = find_datafile_object(sprites, id);
	if (t)
		if (t->type != DAT_BITMAP)
			return NULL;
		else
			return (BITMAP*) t->dat;
}

BITMAP *Resources::GetImage(char *id)
{
	DATAFILE *t;
	t = find_datafile_object(images, id);
	if (t)
		if (t->type != DAT_BITMAP)
			return NULL;
		else
			return (BITMAP*) t->dat;
}

TEG_TILELIST *Resources::GetTileset(char *id)
{
	DATAFILE *t;
	t = find_datafile_object(tilesets, id);
	if (t)
		if (t->type != DAT_TEG_TILELIST)
			return NULL;
		else
			return (TEG_TILELIST*) t->dat;
}

SAMPLE *Resources::GetSound(char *id)
{
	DATAFILE *t;
	t = find_datafile_object(sounds, id);
	if (t)
		if (t->type != DAT_SAMPLE)
			return NULL;
		else
			return (SAMPLE*) t->dat;
}

FONT *Resources::GetFont(char *id)
{
	DATAFILE *t;
	t = find_datafile_object(fonts, id);
	if (t)
		if (t->type != DAT_FONT)
			return NULL;
		else
			return (FONT *) t->dat;
}

const char *Resources::GetMsgtext(int msgid, int ref, int textid)
{
	return msgtexts[ref][msgid][textid]->c_str();
}

const char *Resources::GetRndMsgtext(int msgid, int ref)
{
	return GetMsgtext(msgid, ref, rand() % msgtexts[ref][msgid].size());
}