#include "RescuePoint.h"
#include "GameScreen.h"
#include "Particles.h"
#include "GreenBeli.h"

RescuePoint::RescuePoint(GameScreen *gs)
	:Object(gs, false)
{
	type = OBJTYPE_RESCUEPOINT;
	
	health = fullhealth = 100;
	
	user_controlled = false;
	is_character = false;
	uses_anims = false;
	possessable = false;
	
	w = hw = 5;
	h = hh = 5;
	hx = hy = 0;
}

void RescuePoint::ProcessAI()
{
	if (!IsOnScreen()) return;
	
	gamescreen->CNReset();
	while(!gamescreen->CNEnd())
	{
		Object *obj = gamescreen->CNGet();
		if (obj->Type() == OBJTYPE_GREENBELI)
			if (!obj->IsDead())
				if (Intersect(obj))
					((GreenBeli *) obj)->Rescue();
		gamescreen->CNNext();
	}
	gamescreen->GetParticles()->SpawnParticles(
		xpos>>8, ypos>>8,
		6, gamescreen->Identifier(),
		makecol32(128, 128, 128), makecol32(255, 255, 255));
}