#include "RandomSounds.h"

RandomSounds::RandomSounds(Sound *snd, char *path)
	:framecounter(0),
	framedest(0),
	cur_audiosample(0),
	active(false)
{
	sound = snd;
	
	LoadFromINI(path);
}

RandomSounds::~RandomSounds()
{
	for( int i = 0; i < audio.size(); i++ )
		delete audio[i];
}

void RandomSounds::LoadFromINI(char *path)
{
	MyINI ini;
	AudioSampler *as;
	char *s;
	
	ini.LoadINI(path);
	
	for( int i=0; i<ini.Count(); i++ )
	{		
		if (ini.IsAssignment())
		{
			as = new AudioSampler(sound);
			s = ini.ReadQString();
			as->SetObjectID(s);
			as->SetSamplenum(0);
			as->SetInterval(0);
			as->SetVolume(ini.ReadInteger());
			audio.push_back(as);
			free(s);
			
		}
		
		ini.NextLine();
	}
}

void RandomSounds::Frametick()
{
	if (!active)
	{
		active = true;
		GenerateNextSound();
		return;
	}
	
	framecounter++;
	if (framecounter == framedest)
	{
		audio[cur_audiosample]->Play();
		GenerateNextSound();
	}
}

void RandomSounds::GenerateNextSound()
{
	framecounter = 0;
	framedest = rand() % 20000 + 5000;
	cur_audiosample = rand() % audio.size();
}