#ifndef		TIGCPB_PAUSEMENU_H
#define		TIGCPB_PAUSEMENU_H

#include <allegro.h>
#include <vector>
#include <string>

class Game;

class PauseMenu
{
	private:
		Game *game;
		int
			current_option,
			ret_value;
		
		std::vector <std::string> options;
		std::vector <int> status;
		std::vector <bool> enabled;
	public:
		PauseMenu(Game *gm);
		
		void AddOption(std::string str)
		{
			options.push_back(str);
			status.push_back(0);
			enabled.push_back(true);
		}
		void SetStatus(int on, int s)  { status[on] = s; }
		void Enable(int on) { enabled[on] = true; }
		void Disable(int on) { enabled[on] = false; }
		
		void Draw(BITMAP *dest);
		void LogicalUpdate();
		
		int ReturnValue();
};

#endif		// TIGCPB_PAUSEMENU_H