#include "PauseMenu.h"
#include "Buttons.h"
#include "Resources.h"
#include "Game.h"
#include "Play.h"

PauseMenu::PauseMenu(Game *gm)
	:game(gm),
	current_option(0),
	ret_value(-1)
{
/*	options.push_back("Back to game");
	options.push_back("Load game");
	options.push_back("Save game");
	options.push_back("Quit");
	
	status.push_back(2);
	status.push_back(1);
	status.push_back(1);
	status.push_back(1);*/
}

void PauseMenu::LogicalUpdate()
{
	Buttons *input = game->GetButtons();
	
	if (input->KeyPress(BTN_UP))
	{
		current_option--;
		if (current_option < 0)
			current_option = options.size()-1;
		if (!enabled[current_option])
			current_option--;
		if (current_option < 0)
			current_option = options.size()-1;
	}
	
	if (input->KeyPress(BTN_DOWN))
	{
		current_option++;
		if (current_option >= options.size())
			current_option = 0;
		if (!enabled[current_option])
			current_option++;
		if (current_option >= options.size())
			current_option = 0;
	}
	
	for(int i = 0; i < status.size(); i++)
		status[i] = 0;
	
	status[current_option] = 1;
	
	if (input->KeyDown(BTN_ACT4))
		ret_value = current_option;
}

void PauseMenu::Draw(BITMAP *dest)
{
	int
		color,
		disabled_clr = makecol(64, 64, 64),
		enabled_clr = makecol(128, 128, 128),
		highlighted_clr = makecol(255, 255, 0),
		
		yi = (dest->h - text_height(font) * options.size()) / 2;
	
	for( int i = 0; i < options.size(); i++)
	{
		if (!enabled[i])
			color = disabled_clr;
		else
			{
				if (status[i] == 0)
					color = enabled_clr;
				if (status[i] == 1)
					color = highlighted_clr;
			}
		textout_centre_ex(dest, font, options[i].c_str(), dest->w / 2, yi, color, -1);
		yi += text_height(font);
	}
}

int PauseMenu::ReturnValue()
{
	int ret = ret_value;
	ret_value = -1;
	return ret;
}