#define DEBUGMODE

#include "Particles.h"
#include "Tegmap.h"
#include "Play.h"

Particles::Particles(Play *owner)
{
	play = owner;
	particles.resize(DEFAULT_PARTICLES);
}

void Particles::SpawnParticles(int x, int y, int num, int map, int cmin, int cmax)
{
	int i;
	fixed angle, spd;
	int
		minr = getr32(cmin),
		ming = getg32(cmin),
		minb = getb32(cmax),
		maxr = getr32(cmax),
		maxg = getg32(cmax),
		maxb = getb32(cmax),
		rd = maxr-minr,
		gd = maxg-ming,
		bd = maxb-minb;
	
	for (i = 0; i < particles.size(); i++)
	{
		if (particles[i].life) continue;
		
		spd = itofix((rand() % 40) + 1);
		spd = fdiv(spd, itofix(15));
		particles[i].x = itofix(x);
		particles[i].y = itofix(y);
		angle = itofix(rand() % 256); 
		particles[i].xv = fmul(fcos(angle), spd);
		particles[i].yv = fmul(fsin(angle), spd);
		
		particles[i].life = ((rand() % 35) + 15) * 5;
		
		particles[i].colour =
			makecol(
				rd > 0 ? (rand() % rd) + minr : minr,
				gd > 0 ? (rand() % gd) + ming : ming,
				bd > 0 ? (rand() % bd) + minb : minb
			);
		
		particles[i].map = map;
		
		if (--num == 0)
			return;
	}
	
	if (particles.size() >= MAX_PARTICLES)
		return;
	
	particles.resize(particles.size() + 50);

	
	ResetParticles(particles.size() - 50);
	SpawnParticles(x, y, num, map, cmin, cmax);
}

void Particles::SpawnCasing(int x, int y, int facing)
{
	int i;
	
	for (i = 0; i < particles.size(); i++)
	{
		if (particles[i].life) continue;
		
		particles[i].x = itofix(x);
		particles[i].y = itofix(y);
		particles[i].xv = (facing ? itofix(-1) : itofix(1));
		particles[i].yv = ftofix(-0.5);
		particles[i].life = 20;
		particles[i].colour = 175;
		return;
	}
}

void Particles::LogicalUpdate()
{
	int i, t;
	
	for (i = 0; i < particles.size(); i++)
	{
		if (!particles[i].life) continue;
		
		particles[i].life--;
		
		particles[i].x += particles[i].xv;
		particles[i].y += (particles[i].yv += ftofix(.09));
		
		t = play->GetMap(particles[i].map)->TileAtPoint(1, fixtoi(particles[i].x), fixtoi(particles[i].y));
		if (t)
		{
			particles[i].xv *= -.5;
			particles[i].yv *= -.5;
			if (abs(particles[i].xv) < ftofix(.0) && abs(particles[i].yv) < ftofix(.0) && particles[i].life < 10)
				particles[i].life = 0;
		}
	}
}

void Particles::Draw(BITMAP *dest)
{
	int i;
	
	for (i = particles.size() - 1; i >= 0; i--)
	{
		if (!particles[i].life) continue;
		if (play->GetGS(particles[i].map) != play->GetActualGS()) continue;
			
		putpixel(dest, fixtoi(particles[i].x), fixtoi(particles[i].y), particles[i].colour);
	}
}

void Particles::ResetParticles(int lower)
{
	std::vector<PARTICLE>::iterator i;
	for (i = particles.begin()+lower; i != particles.end(); i++)
		(*i).life = 0;
}

void Particles::ResetParticles()
{
	ResetParticles(0);
}
