#ifndef		__MYINI_H__
#define		__MYINI_H__

#include <allegro.h>
#include <vector>
#include "Misc.h"

#define	MAX_LINE_WIDTH	512

#define	LT_UNKNOWN		-1
#define	LT_COMMENT		0
#define	LT_SINGLE			1
#define	LT_SECTION		2
#define	LT_ASSIGNMENT		3
#define	LT_PPDIRECTIVE 		4

typedef
	struct _INILINE
	{
		int lntype;
		char* name;
		char* value;
	} INILINE;


//
//
// MyINI class
//
//

	
class MyINI
{
	private:
		std::vector<INILINE> lines;
		
		// Current line
		int c_line;
		// Value string iterator
		int vit;
		// Error data
		int error;
	protected:
		bool ValidateRead();
	public:
		// File-handling methods
		void LoadINI(char* filename);
		void SaveINI(char* filename);
		
		// Return section/variable and value names
		char* SectionName() { return lines[c_line].name; }
		char* Variable() { return lines[c_line].name; }
		char* Value() { return lines[c_line].value; }
		
		// Value reading functions
		int ReadInteger(int def=0);
		char* ReadQString(char* def=NULL);
		char* ReadString(char* def=NULL);
		bool ReadBool(bool def=false);
		
		void ReadRestart() { vit = error = 0; }
		void ClearError() { error = 0; }
		
		int Error() { return error; }
		
		int Count() { return lines.size(); }
		
		bool IsSection() { return lines[c_line].lntype == LT_SECTION; }
		bool IsAssignment() { return lines[c_line].lntype == LT_ASSIGNMENT; }
		bool IsSingle() { return lines[c_line].lntype == LT_SINGLE; }
		
		// Navigation methods
		void FirstLine() { c_line = 0; vit = error = 0; }
		void LastLine() { c_line = lines.size()-1; vit = error = 0; }
		void NextLine() { if (c_line < lines.size()-1) { c_line++; vit = error = 0; } }
		void PrevLine() { if (c_line > 0) { c_line--; vit = error = 0; } }
		
		// Constructor and destructor
		MyINI();
};


//
//
// Standalone routines
//
//


// Returns the type of INI line
int line_type(char* line);

// Parsing and string manipulation methods
void skip_behind(char* line, char c, int &i);
void parse_assignment(char* line, char* &variable, char* &value);
char* parse_string(char* line, int &i);
char* parse_between(char* line, char c1, char c2, int &i);

// Parses first unsigned integer from character position < i > in string < value >
bool valgetuint(char* value, int &uintval, int &i);
// Parses first quote-string value from character position < i > in string < value >
bool valgetqstr(char* value, char* &strval, int &i);
// Parses first string value from character position < i > in string < value >
bool valgetstr(char* value, char* &strval, int &i);
// Parses first boolean value from character position < i > in string < value >
bool valgetbool(char* value, bool &boolval, int &i);


#endif		// __MYINI_H__