#include "MyINI.h"


//
//
// MyINI method implementation
//
//

MyINI::MyINI()
	:c_line(0),
	error(0),
	vit(0)
{
}

void MyINI::LoadINI(char* filename)
{
	PACKFILE* f;
	INILINE iniline;
	int i;
	char *directive, *v1, *v2;
	char line[MAX_LINE_WIDTH];
	
	f = pack_fopen(filename, F_READ);
	
	while(pack_fgets(line, sizeof(line), f))
	{
		iniline.lntype = line_type(line);
		switch(iniline.lntype)
		{
			case LT_SECTION:
			{
				i = 0;
				iniline.name = parse_between(line, '[', ']', i);
				if (iniline.name) lines.push_back(iniline);
				break;
			}
			case LT_ASSIGNMENT:
			{
				parse_assignment(line, iniline.name, iniline.value);
				if (iniline.name && iniline.value) lines.push_back(iniline);
				break;
			}
			case LT_SINGLE:
			{
				i = 0;
				iniline.name = parse_string(line, i);
				if (iniline.name) lines.push_back(iniline);
				break;
			}
			case LT_PPDIRECTIVE:
			{
				i = 0;
				skip_behind(line, '$', i);
				directive = parse_string(line, i);
				
				if (!strcmp(directive, "include"))
				{
					if (valgetqstr(line, v1, i))
					{
						
					}
				}
				
				if (!strcmp(directive, "define"))
				{
				}
				
				free(directive);
			}
		}
	}
	
	pack_fclose(f);
	
	FirstLine();
}

bool MyINI::ValidateRead()
{
	return ((c_line < lines.size()) && (lines[c_line].lntype == LT_ASSIGNMENT) && (!error));
}

int MyINI::ReadInteger(int def)
{
	int ret = def;
	int err = 1;
	
	if (!ValidateRead()) return ret;
	
	if (valgetuint(lines[c_line].value, ret, vit)) err = 0;
	
	error = err;
	
	return ret;
}

char *MyINI::ReadQString(char *def)
{
	char* ret = def;
	int err = 1;
	
	if (!ValidateRead()) return ret;
	
	if (valgetqstr(lines[c_line].value, ret, vit)) err = 0;
	
	error = err;
	
	return ret;
}

char *MyINI::ReadString(char *def)
{
	char *ret = def;
	int err = 1;
	
	if (!ValidateRead()) return ret;
	
	if (valgetstr(lines[c_line].value, ret, vit)) err = 0;
	
	error = err;
	
	return ret;
}

bool MyINI::ReadBool(bool def)
{
	bool ret = def;
	int err = 1;
	
	if (!ValidateRead()) return ret;
	
	if (valgetbool(lines[c_line].value, ret, vit)) err = 0;
	
	error = err;
	
	return ret;
}

//
//
// Standalone routines
//
//


int line_type(char *line)
{
	int linetype = LT_UNKNOWN;
	
	if (strlen(line) > 4) linetype = LT_SINGLE;
	
	while(*line)
	{
		if (*line == '[')
		{
			linetype = LT_SECTION;
			break;
		}
		else
			if (*line == '=')
			{
				linetype = LT_ASSIGNMENT;
				break;
			}
			else
				if (*line == '#')
				{
					linetype = LT_COMMENT;
					break;
				}
				else
					if (*line == '$')
					{
						linetype = LT_PPDIRECTIVE;
						break;
					}
		line++;
	}
	
	return linetype;
}

void parse_assignment(char *line, char* &variable, char* &value)
{
	int i = 0;
	int start;

	value = NULL;
	
	variable = parse_string(line, i);

	if (!line[i]) return;	
	
	// Skipping to character '='
	while (line[i] && (line[i] != '=')) i++;
	
	if (!line[i]) return;
	
	i++;
	
	// Skipping to first character which is not space or tab
	while (line[i] && ((line[i] == (char) 32) || (line[i] == (char) 9))) i++;
	
	if (!line[0])
	{
		free(variable);
		return;
	}
	
	// Parsing the value of assignment
	value = strcreate(strlen(line)-i);
	memcpy(value, line+i, strlen(line)-i);
}

char *parse_string(char *line, int &i)
{
	char *newstr;
	int start;
	
	while (line[i] && ((line[i] < 'A') || ((line[i] > 'Z') && (line[i] < 'a')) || (line[i] > 'z'))) i++;
	
	if (!line[i]) return NULL;
	
	start = i++;
	
	while (line[i] && ( ((line[i] >= 'A') && (line[i] <= 'Z')) || ((line[i] >= 'a') && (line[i] <= 'z')) )) i++;
	
	newstr = strcreate(i-start);
	memcpy(newstr, line+start, i-start);
	strlower(newstr);
	
	return newstr;
}

char* parse_between(char* line, char c1, char c2, int &i)
{
	char* newstr;
	int start;

	while (line[i] && (line[i] != c1)) i++;
	
	if (!line[i])
	{
TRACE("parse_between(): Iterator 'i' couldn't locate char '%c'. I=%d, which is the last character of string\nReturn: NULL\n", c1, i);
		return NULL;
	}
	
	start = ++i;
	
	while (line[i] && (line[i] != c2)) i++;
	
	if (!line[i])
	{
TRACE("parse_between(): Iterator 'i' couldn't locate char '%c'. I=%d, which is the last character of string\nReturn: NULL\n", c1, i);
		return NULL;
	}
	
	newstr = strcreate(i-start);
	memcpy(newstr, line+start, i-start);
	return newstr;
}

void skip_behind(char* line, char c, int &i)
{
	while (line[i] && (line[i] != c)) i++;
	
	if (line[i]) i++;
}

bool valgetuint(char* value, int &uintval, int &i)
{
	int start;
	char* newstr;

	while(value[i] && ((value[i] < '0') || (value[i] > '9'))) i++;
	
	if (!value[i]) return false;
	
	start = i;

	while(value[i] && ((value[i] >= '0') && (value[i] <= '9'))) i++;
	
	newstr = strcreate(i-start);
	memcpy(newstr, value+start, i-start);

	uintval = atoi(newstr);
	
	free(newstr);
	
	skip_behind(value, ',', i);

	return true;
}

bool valgetqstr(char* value, char* &strval, int &i)
{
	strval = parse_between(value, '"', '"', i);

	skip_behind(value, ',', i);

	return strval ? true : false;
}

bool valgetstr(char* value, char* &strval, int &i)
{
	strval = parse_string(value, i);
	
	skip_behind(value, ',', i);
	
	if (strval) return true;
}

bool valgetbool(char* value, bool &boolval, int &i)
{
	char* s = parse_string(value, i);
	
	skip_behind(value, ',', i);
	
	if (!strcmp(s, "true"))
	{
		boolval = true;
		return true;
	}
	
	if (!strcmp(s, "false"))
	{
		boolval = false;
		return true;
	}
	
	return false;
}

