#include "Misc.h"

bool strstartswith( char* str1, char* str2 )
{
	bool b = true;
	
	while( *str1 && *str2 && b) b = *(str1++) == *(str2++);
	
	if (!(*str1) && (*str2))
		return false;
	else
		return b;
}

bool strcontains( char* str1, char* str2 )
{
	int i, j, L1 = strlen(str1), L2 = strlen(str2);
	bool b = false;
	
	if (L2 > L1) return false;
	
	for( i=0; i<L1-L2+1; i++ )
	{
		b = true;
		for( j=0; (j<L2) && b; j++ ) b = str1[i+j] == str2[j];
		if (b) break;
	}
	
	return b;
}

char* str_remspill( char* str, char chr )
{
	char* nstr;
	int n = strlen(str);
	
	if (!n) return str;
	
	while( str[--n] == chr );
	
	nstr = (char*) malloc( n+2 );
	memcpy(nstr, str, n+1);
	nstr[n+1] = 0;
	
	free(str);
	
	return nstr;
}

char* str_fillspill( char* str, char chr, int fixedsize )
{
	char* nstr;
	
	nstr = (char*) malloc( fixedsize+1 );
	memcpy(nstr, str, strlen(str));
	
	for ( int i=fixedsize; i>=strlen(str); i-- ) nstr[i] = chr;
	
	nstr[fixedsize] = 0;
	
	free(str);
	
	return nstr;
}

char* strassign( char* str )
{
	char* nstr;
	nstr = (char*) malloc( strlen(str)+1 );
	memcpy(nstr, str, strlen(str));
	nstr[strlen(str)] = 0;
	return nstr;
}

char* strcreate( int n )
{
	char* str = (char*) malloc( n+1 );
	str[n] = 0;
	return str;
}

char* inttostr( int n )
{
	char* str;
	int i=0,tn=n;
	
	if (!n) i=1;
	else while (n > 0) { i++; n/=10; }

	str = strcreate(i--);

	if (!tn) str[0]=48;
	else while (tn > 0) { str[i--]=tn%10+48; tn/=10; }
	
	return str;
}

void strlower( char* str )
{
	while(*str)
	{
		if ((*str >= 'A') && (*str <= 'Z')) *str += 32;
		str++;
	}
}
