#include "Marquee.h"
#include "GameScreen.h"

Marquee::Marquee(GameScreen *gs)
	:Object(gs, false),
	framecounter(0),
	framedest(0),
	charpointer(0),
	nchars(0),
	buf(NULL)
{
	type = OBJTYPE_MARQUEE;
	health = 1000;
	user_controlled = false;
	uses_anims = false;
	is_character = false;
	skin[0] = NULL;
	skin[1] = NULL;
	skin[2] = NULL;
}

Marquee::~Marquee()
{
	destroy_bitmap(buf);
}

void Marquee::ProcessAI()
{
	framecounter++;
	if (framecounter >= framedest)
	{
		charpointer++;
		if (charpointer >= display_text.size())
			charpointer = 0;
		framecounter = 0;
	}
}

void Marquee::ReadProperties(MyINI *ini)
{
	Object::ReadProperties(ini);
	
	if (!strcmp(ini->Variable(), "speed"))
		framedest = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "displaytext"))
		SetDisplayText(ini->ReadQString());
	Setup((char*)display_text.c_str(), NULL, NULL, NULL, framedest);
	if (!strcmp(ini->Variable(), "setup"))
	{
		char *s1, *s2, *s3, *s4, sp;
		s1 = ini->ReadQString();
		s2 = ini->ReadQString();
		s3 = ini->ReadQString();
		s4 = ini->ReadQString();
		sp = ini->ReadInteger();
		Setup(s1, s2, s3, s4, sp);
		free(s1);
		free(s2);
		free(s3);
		free(s4);
	}
}

void Marquee::Setup(char *text, char *skinleft, char *skinmid, char *skinright, int speed)
{
	int xi;
	
	framedest = speed;
	
	display_text.assign(text);
	
	skin[0] = skinleft ? gamescreen->GetResources()->GetImage(skinleft) : NULL;
	skin[1] = skinmid ? gamescreen->GetResources()->GetImage(skinmid) : NULL;
	skin[2] = skinright ? gamescreen->GetResources()->GetImage(skinright) : NULL;
	
	if (skinleft && skinright && skinmid)
		h = MAX( skin[0]->h, MAX(skin[1]->h, skin[2]->h) );
	else
		h = text_height(font);
	
	// It's assumed that W has been already set up
	buf = create_bitmap(w, h);
	clear_to_color(buf, makecol(255,0,255));
	
	if (!skinleft || !skinright || !skinmid)
	{
		nchars = w / 8;
		return;
	}
	
	blit(skin[0], buf, 0, 0, 0, 0, skin[0]->w, skin[0]->h);
	blit(skin[2], buf, 0, 0, w-skin[2]->w, 0, skin[2]->w, skin[2]->h);
	
	nchars = (w-skin[0]->w-skin[2]->w) / skin[1]->w,
	xi = skin[0]->w;
	
	for( int i = 0; i < nchars; i++, xi+=skin[1]->w )
		blit(skin[1], buf, 0, 0, xi, 0, skin[1]->w, skin[1]->h);
	
	nchars /= 8;
}

void Marquee::Draw(BITMAP *dest)
{
	std::string temp;
	
	int
		tx = xpos>>8,
		ty = (ypos>>8) + (h-text_height(font))/2;
	
	draw_sprite(dest, buf, tx, ty);
	
	if (charpointer+nchars <= display_text.size())
	{
		temp.insert(0, display_text, charpointer, nchars);
		textout_ex(dest, font, temp.c_str(), tx, ty, makecol(255,255,255), -1);
	}
	else
		{
			temp.insert(0, display_text, charpointer, display_text.size()-charpointer);
			temp.insert(display_text.size()-charpointer, display_text, 0, nchars-display_text.size()-charpointer);
			textout_ex(dest, font, temp.c_str(), tx, ty, makecol(255,255,255), -1);
		}
}