#define DEBUGMODE

#include "MainCharacter.h"
#include "GameScreen.h"
#include "Particles.h"
#include "Possession.h"
#include "Play.h"
#include "MyINI.h"

MainCharacter::MainCharacter(GameScreen *gs)
	:Object(gs, true)
{
	type = OBJTYPE_WHITEBELI;
}

void MainCharacter::Init()
{
	Object::Init();
	
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["beliwalk"]));
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["beliidle"]));
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["belichant"]));
	
	achant = new AudioSampler(GetSound());
	aheartbeat = new AudioSampler(GetSound());
	
	Reset();
	
	possession = new Possession(gamescreen->GetPlay(), this, gamescreen->GetParticles(), achant);
}

void MainCharacter::ReadProperties(MyINI *ini)
{
	Object::ReadProperties(ini);
	
	if (!strcmp(ini->Variable(), "achant"))
		achant->LoadFromINI(ini);
	if (!strcmp(ini->Variable(), "aheartbeat"))
		aheartbeat->LoadFromINI(ini);
}

void MainCharacter::Reset()
{
	message.duration = 0;
	
	LoadProperties("data\\player.txt");

	health = fullhealth;
	healthbar_life = 0;
	hidden = false;
	//heartrate = 202;	
	
	SwitchToState(STATE_FALLING, 0, 0);
}

void MainCharacter::SwitchToState(int st, int param1, int param2)
{	
	Object::SwitchToState(st, param1, param2);
	
	switch( st )
	{
		case STATE_IDLE:
			anims[1]->GoToFrame(0);
			current_animation = 1;
			break;
		case STATE_WALKL:
			current_animation = 0;
			break;
		case STATE_WALKR:
			current_animation = 0;
			break;
		case STATE_FALLING:
			break;
		case STATE_JUMPING:
			current_animation = 0;
			break;
		case STATE_POSSESS:
			possession->PrepareChantIn();
			current_animation = 2;
			break;
	}
}

void MainCharacter::ProcessInput()
{
	Buttons *input = gamescreen->GetButtons();
	
	Object::ProcessInput();

	gamescreen->UpdateHeartrate(this);
	
	if (heartrate > 200)
	{
		aheartbeat->SetInterval(90*(1000-heartrate)/800);
		aheartbeat->Frametick();
	}
	
	switch( state )
	{
		case STATE_POSSESS:
			if (!input->KeyDown(BTN_ACT1))
				//SwitchToState(STATE_IDLE, 0, 0);
				possession->Abort();
			else
				possession->ChantIn();
			break;
	}
	/*
	if (achant->IsPlaying())
		if (state != STATE_POSSESS)
			{
				achant->FadeOutTick();
				if (!achant->Volume())
					achant->Stop();
			}*/
	
	if (input->KeyPress(BTN_ACT1) && ((state == STATE_IDLE) || (state == STATE_WALKL) || (state == STATE_WALKR)))
		if (gamescreen->GetPlay()->CursorMode())
			if (gamescreen->GetPlay()->Cursor()->IsPossessable())
				if (!gamescreen->HasAlarm())
				{
					TRACE("IT HAS ALARAM\n");
					SwitchToState(STATE_POSSESS, 0, 0);
				}
				else
					{ /* Impossible action sound */ }
	
	if (key[KEY_LSHIFT])
		anims[0]->SetRate(0x1E);
	else
		anims[0]->SetRate(0x10);
	
	if (key[KEY_TAB])
		Damage(10);
	
	if (input->KeyPress(BTN_NGS))
		gamescreen->GetPlay()->NextScreen(this);
	if (input->KeyPress(BTN_PGS))
		gamescreen->GetPlay()->PrevScreen(this);
		
	
	Object *cursorobj;
	if (gamescreen->GetPlay()->CursorValid())
		cursorobj = gamescreen->GetPlay()->Cursor();
	else
		cursorobj = NULL;
		
	if (input->KeyPress(BTN_SPK(7)))
		SetMessage(MSG_CALL, 0, cursorobj, 300);
	
	if (input->KeyPress(BTN_SPK(8)))
		SetMessage(MSG_FOLLOW, 0, cursorobj, 300);
	
	if (input->KeyPress(BTN_SPK(9)))
		SetMessage(MSG_STAY, 0, cursorobj, 300);
	
	if (input->KeyPress(BTN_SPK(4)))
		SetMessage(MSG_CALL, 1, cursorobj, 300);
}

void MainCharacter::ProcessAI()
{

}