#define DEBUGMODE

#include "HideObject.h"
#include "Play.h"
#include "GameScreen.h"

HideObject::HideObject(GameScreen *gs)
	:Object(gs, false)
{
	type = OBJTYPE_HIDEOBJECT;
	health = 100;
	user_controlled = false;
	uses_anims = false;
	is_character = false;
}

void HideObject::ProcessAI()
{
	Object *mc = gamescreen->GetPlay()->GetMainCharacter();
	if (!mc->IsDead())
		if (Intersect(mc))
			mc->SetHidden(true, this);
		else
			if (mc->HiddenBy() == this)
				mc->SetHidden(false, NULL);
	
	gamescreen->CNReset();
	while(!gamescreen->CNEnd())
	{
		Object *obj = gamescreen->CNGet();
		if (!obj->IsDead())
			if (Intersect(obj))
				obj->SetHidden(true, this);
			else
				if (obj->HiddenBy() == this)
					obj->SetHidden(false, NULL);
		gamescreen->CNNext();
	}
}