#ifndef		TIGCPB_GAMESCREEN_H
#define		TIGCPB_GAMESCREEN_H

#include <allegro.h>
#include <vector>
#include "Tegmap.h"
#include "Resources.h"
#include "Buttons.h"
#include "Messages.h"

class Play;
class Object;
class Particles;

typedef
	struct _RSDATA
	{
		Object *obj;
		int
			fc,
			fdest;
	} RSDATA;
	
class GameScreen
{
	private:
		Play *play;
		int identifier;
		
		Tegmap *map;
		MAPEX mapinfo;
		
		std::vector <Object*> characters;
		std::vector <int> c_removed;
		std::vector <int> c_killed;
		std::vector <Object*> objects;
		std::vector <int> o_removed;
		std::vector <int> o_killed;
		
		std::vector <RSDATA> respawn_queue;
		
		std::vector <MESSAGE> messages;
		
		BITMAP *background;
		Object *topobject;
		
		int
			CN, ON;
		
		// Frame
	protected:
		void DrawObjects(BITMAP *dest);
		
		void DrawSpotlight(BITMAP *dest, int hlsize, int steps, int pxd, int clrd);
	public:
		GameScreen(Play *owner, Tegmap *tm, MAPEX mex, int id);
		~GameScreen();
		
		void AddCharacter(Object *obj);
		void RemoveCharacter(Object *obj);
		void KillCharacter(Object *obj);
		void AddObject(Object *obj);
		void RemoveObject(Object *obj);
		void KillObject(Object *obj);
		
		void DrawBackground(BITMAP *dest);
		void DrawForeground(BITMAP *dest);
		
		void UpdateMessages();
		void UpdateCharacters();
		void UpdateObjects();
		void LogicalUpdate();
		
		void LoadScreen(char *path);
		void Exit(Object* obj, int side);
		int CanExit(int side);
		
		Play *GetPlay() { return play; }
		Tegmap *GetMap() { return map; }
		MAPEX GetMapinfo() { return mapinfo; }
		Resources *GetResources();
		Buttons *GetButtons();
		Particles *GetParticles();
		
		Object *GetObject(int id);
		
		MESSAGE Message(int id) { return messages[id]; }
		int MsgCount() { return messages.size(); }
		
		int Identifier() { return identifier; }
		int EnemiesCount() { return characters.size(); }		
		bool ObjectExists(Object *obj);
		bool HasAlarm() { return false; /* to be implemented */ }
		// Orientation
		bool CanPassOver(Object *obj, int dx);
		bool CanPassOverNJ(Object *obj, int dx);
		bool ReachablePos(Object *obj);
		bool Reachable(Object *obj, Object *obj2);
		bool PlayerInHorzView(Object *obj, bool reachable);
		bool HorzView(Object *obj1, Object *obj2, bool reachable);
		bool InGunnersSight(Object *gunner, Object *obj);
		
		void ResetInteraction();
		void UpdateHeartrate(Object *obj);
		void SetupRespawn(Object *obj);
		void UpdateRespawn();
		
		// Switch-specific.
		// Used for restoring original maps, without the need to load them again
		void ResetSwitches();
		
		// Character/object navigation routines
		
		void CNReset() { CN = 0; }
		void CNNext() { CN++; }
		void CNPrev() { CN--; }
		bool CNEnd() { return CN >= characters.size(); }
		Object *CNGet() { return characters[CN]; }
};

#endif		// TIGCPB_GAMESCREEN_H