#define DEBUGMODE

#include "GameScreen.h"
#include "Play.h"
#include "Object.h"
#include "Particles.h"

#include "Pip.h"
#include "GreenBeli.h"
#include "Zombie.h"
#include "Finch.h"
#include "Ghost.h"
#include "Dude.h"
#include "Gunner.h"
#include "Barak.h"

#include "StaticEnemy.h"
#include "FallingEnemy.h"
#include "Marquee.h"
#include "CollectableObject.h"
#include "HideObject.h"
#include "FlyingEnemy.h"
#include "Switch.h"
#include "ParticleObject.h"
#include "MusicObject.h"
#include "RescuePoint.h"

GameScreen::GameScreen( Play *owner, Tegmap *tm, MAPEX mex, int id )
	:play(owner),
	identifier(id),
	map(tm),
	mapinfo(mex),
	topobject(NULL),
	CN(0), ON(0)
{
	background = owner->GetResources()->GetImage(mex.bgname);
	LoadScreen(mex.infofile);
	//Pip *p = new Pip(this);
	/*
	AddCharacter(new Pip(this));
	AddCharacter(new GreenBeli(this));
	Marquee *m = new Marquee(this);
	m->SetShape(0,0,320,0);
	m->Setup("Being a beli you are able interact with other other belis. Use Z, X and C for interaction.   ",
	//	NULL,NULL,NULL,/*"skinleft", "skinmid", "skinright", 15);
	//AddObject(m);
	//AddObject(new Pip(this));
	
	//DrawSpotlight(background, 16, 4, 2, 10);*/
}

GameScreen::~GameScreen()
{
	for( int i = 0; i < objects.size(); i++ )
		delete objects[i];
	for( int i = 0; i < characters.size(); i++ )
		delete characters[i];
	characters.clear();
	objects.clear();
}

void GameScreen::LoadScreen(char *path)
{
	MyINI ini;
	int d, section;
	char *s;
	Object *obj = NULL;
	

	ini.LoadINI(path);

	for( int i=0; i<ini.Count(); i++ )
	{
		if (ini.IsSection())
		{
			section = objtype_str_to_id(ini.SectionName());
			switch( section )
			{
				case OBJTYPE_GREENBELI:
					obj = new GreenBeli(this);
					obj->Init();
					AddCharacter(obj);
					break;
				case OBJTYPE_PIP:
					obj = new Pip(this);
					obj->Init();
					AddCharacter(obj);
					break;
				case OBJTYPE_ZOMBIE:
					obj = new Zombie(this);
					obj->Init();
					AddCharacter(obj);
					break;
				case OBJTYPE_FINCH:
					obj = new Finch(this);
					obj->Init();
					AddCharacter(obj);
					break;
				case OBJTYPE_GHOST:
					obj = new Ghost(this);
					obj->Init();
					AddCharacter(obj);
					break;
				case OBJTYPE_DUDE:
					obj = new Dude(this);
					obj->Init();
					AddCharacter(obj);
					break;
				case OBJTYPE_GUNNER:
					obj = new Gunner(this);
					obj->Init();
					AddCharacter(obj);
					break;
				case OBJTYPE_BARAK:
					obj = new Barak(this);
					obj->Init();
					AddCharacter(obj);
					break;
				case OBJTYPE_MARQUEE:
					obj = new Marquee(this);
					obj->Init();
					AddObject(obj);
					break;
				case OBJTYPE_STATICENEMY:
					obj = new StaticEnemy(this);
					obj->Init();
					AddObject(obj);
					break;
				case OBJTYPE_FALLINGENEMY:
					obj = new FallingEnemy(this);
					obj->Init();
					AddObject(obj);
					break;
				case OBJTYPE_COLLECTABLE:
					obj = new CollectableObject(this);
					obj->Init();
					AddObject(obj);
					break;
				case OBJTYPE_HIDEOBJECT:
					obj = new HideObject(this);
					obj->Init();
					AddObject(obj);
					break;
				case OBJTYPE_FLYINGENEMY:
					obj = new FlyingEnemy(this);
					obj->Init();
					AddObject(obj);
					break;
				case OBJTYPE_SWITCH:
					obj = new Switch(this);
					obj->Init();
					AddObject(obj);
					break;
				case OBJTYPE_PARTICLEOBJECT:
					obj = new ParticleObject(this);
					obj->Init();
					AddObject(obj);
					break;
				case OBJTYPE_MUSICOBJECT:
					obj = new MusicObject(this);
					obj->Init();
					AddObject(obj);
					break;
				case OBJTYPE_RESCUEPOINT:
					obj = new RescuePoint(this);
					obj->Init();
					AddObject(obj);
					break;
			}
		}
		
		if (ini.IsAssignment())
			obj->ReadProperties(&ini);
		
		ini.NextLine();
	}
}

void GameScreen::AddCharacter( Object *obj )
{
	characters.push_back(obj);
	obj->SetGamescreen(this);
}

void GameScreen::AddObject( Object *obj )
{
	objects.push_back(obj);
	obj->SetGamescreen(this);
}

void GameScreen::KillCharacter( Object *obj )
{
	std::vector<Object*>::iterator i;
	for( i = characters.begin(); i != characters.end(); i++ )
	{
		if (*i == obj)
		{
			c_killed.push_back(i-characters.begin());
			break;
		}
	}
}

void GameScreen::KillObject( Object *obj )
{
	std::vector<Object*>::iterator i;
	for( i = objects.begin(); i != objects.end(); i++ )
	{
		if (*i == obj)
		{
			o_killed.push_back(i-objects.begin());
			break;
		}
	}
}

void GameScreen::RemoveCharacter( Object *obj )
{	
	std::vector<Object*>::iterator i;
	for( i = characters.begin(); i != characters.end(); i++ )
	{
		if (*i == obj)
		{
			c_removed.push_back(i-characters.begin());
			break;
		}
	}
}

void GameScreen::RemoveObject( Object *obj )
{
	std::vector<Object*>::iterator i;
	for( i = objects.begin(); i != objects.end(); i++ )
	{
		if (*i == obj)
		{
			o_removed.push_back(i-objects.begin());
			break;
		}
	}
}

void GameScreen::DrawBackground( BITMAP *dest )
{
	blit(background, dest, mapinfo.bgx, mapinfo.bgy, 0, 0, dest->w, dest->h);
	map->Draw(dest, 0, 0, 0);
	map->Draw(dest, 1, 0, 0);
	DrawObjects(dest);
}

void GameScreen::DrawForeground( BITMAP *dest )
{
	map->Draw(dest, 2, 0, 0);
}

void GameScreen::DrawObjects( BITMAP *dest )
{
	std::vector<Object*>::iterator i;
	// Drawing objects
	for( i = objects.begin(); i != objects.end(); i++ )
		(*i)->Draw(dest);
	// Drawing characters
	for( i = characters.begin(); i != characters.end(); i++ )
	{
		if (!(*i)->IsUserControlled())
			(*i)->Draw(dest);
		else
			topobject = *i;
	}
	// Drawing top-character
	if (topobject)
	{
		topobject->Draw(dest);
		topobject = NULL;
	}
}

void GameScreen::UpdateMessages()
{
	std::vector<Object*>::iterator i;
	MESSAGE msg;
	
	if (play->GetMainCharacter()->GS() == this)
	{
		msg = play->GetMainCharacter()->Message();
		
		if (msg.duration)
			messages.push_back(msg);
	}
	
	for( i = characters.begin(); i != characters.end(); i++ )
	{
		msg = (*i)->Message();
		
		if (msg.duration)
			messages.push_back(msg);		
	}
}

void GameScreen::UpdateCharacters()
{
	std::vector<Object*>::iterator i;
	//TRACE("void GameScreen::UpdateCharacters()\n");
	for( i = characters.begin(); i != characters.end(); i++ )
	{
		(*i)->LogicalUpdate();
	}

	while(!c_removed.empty())
	{
		characters.erase(characters.begin()+c_removed.back());
		c_removed.pop_back();
	}

	while(!c_killed.empty())
	{
		delete (Object*) *(characters.begin()+c_killed.back());
		characters.erase(characters.begin()+c_killed.back());
		c_killed.pop_back();
	}
	//TRACE("**** void GameScreen::UpdateCharacters()\n");
}

void GameScreen::UpdateObjects()
{
	std::vector<Object*>::iterator i;
	
	for( i = objects.begin(); i != objects.end(); i++ )
	{
		(*i)->LogicalUpdate();
	}
	
	while(!o_removed.empty())
	{
		objects.erase(objects.begin()+o_removed.back());
		o_removed.pop_back();
	}
	
	while(!o_killed.empty())
	{
		delete (Object*) *(objects.begin()+o_killed.back());
		objects.erase(objects.begin()+o_killed.back());
		o_killed.pop_back();
	}
}

void GameScreen::LogicalUpdate()
{
	UpdateRespawn();
	UpdateMessages();
	UpdateObjects();
	UpdateCharacters();
	
	messages.clear();
}

Resources *GameScreen::GetResources()
{
	return play->GetResources();
}

Buttons *GameScreen::GetButtons()
{
	return play->GetButtons();
}

Particles *GameScreen::GetParticles()
{
	return play->GetParticles();
}

Object *GameScreen::GetObject(int id)
{
	return characters[id];
}

int GameScreen::CanExit( int side )
{
	switch( side )
	{
		case 0:
			return mapinfo.left;
			break;
		case 1:
			return mapinfo.right;
			break;
		case 2:
			return mapinfo.top;
			break;
		case 3:
			return mapinfo.bottom;
			break;
	}
	return 0;
}

void GameScreen::DrawSpotlight(BITMAP *dest, int hlsize, int steps, int pxd, int clrd)
{
	BITMAP
		*black_bg,
		*spotlight;
	int colour;
	
	black_bg = create_bitmap(320, 240);
	spotlight = create_bitmap(320, 240);
	
	colour = 255-steps*clrd-1;
	
	clear_to_color(black_bg, makecol(colour, colour, colour));
	clear_to_color(spotlight, makecol(colour, colour, colour));
	
	colour++;
	hlsize += steps*pxd;
	
	for( int i = 0; i < steps; i++ )
	{
		circlefill(spotlight, 120, 90, hlsize, makecol(colour, colour, colour));
		hlsize -= pxd;
		colour += clrd;
	}

	blit(spotlight, black_bg, 0, 0, 120, 90, 320, 240);

	set_multiply_blender(0,0,0,255);
	
	draw_trans_sprite(dest, black_bg, 0, 0);
	
	destroy_bitmap(black_bg);
	destroy_bitmap(spotlight);
}

bool GameScreen::ObjectExists( Object *obj )
{
	bool b = false;
	std::vector<Object*>::iterator i;
	for( i = characters.begin(); i != characters.end(); i++ )
	{
		b = *i == obj;
		if (b) break;
	}
	return b;
}

void GameScreen::ResetInteraction()
{
	std::vector<Object*>::iterator i;
	for( i = characters.begin(); i != characters.end(); i++ )
		(*i)->SetCallingParty(NULL);
}

bool GameScreen::CanPassOverNJ(Object *obj, int dx)
{
	int
		x, y, yi, hb;
	bool
		b = true;
	
	if (!dx) return false;
	
	dx = dx > 0 ? +1 : -1;
	
	if (dx > 0)
		x = (obj->XPos() + obj->SolidX() + obj->SolidWidth() >> 4) + 1;
	else
		x = (obj->XPos() + obj->SolidX() >> 4) - 1;
	yi = obj->YPos() + obj->SolidY() + obj->SolidHeight() >> 4;
	hb = (obj->SolidHeight() >> 4)+1;
	/*
	if (dx < 0)
		x = MAX(x, 0);
	else
		x = MIN(x, 19);
	
	yi = MIN(yi, 14);*/
	
	for ( y=yi; y<yi-hb+1; y++ )
	{
		b = map->MapGet(1, x, y) == 0;
		if (!b) break;
	}
	
	return b;
}

bool GameScreen::CanPassOver(Object *obj, int dx)
{
	int
		i, j, x, yi, hb, jb;
	bool
		b = true;
	
	if (!dx) return false;
	
	dx = dx > 0 ? +1 : -1;
	
	if (dx > 0)
		x = (obj->XPos() + obj->SolidX() + obj->SolidWidth() >> 4) + 1;
	else
		x = (obj->XPos() + obj->SolidX() >> 4) - 1;
	yi = obj->YPos() + obj->SolidY() + obj->SolidHeight() >> 4;
	hb = (obj->SolidHeight() >> 4)+1;
	jb = (obj->VLSize() >> 4)+1;
	/*
	x = (obj->XPos() + dx * obj->SolidWidth() >> 4) + 1;
	yi = (obj->YPos() + obj->SolidX() + obj->SolidHeight() >> 4) - 1;
	hb = (obj->SolidHeight() >> 4) + 1;
	jb = obj->VLSize() >> 4;*/
	
//	TRACE("CanPassOver ENTERED\n");
//	TRACE("X=%d; Yi=%d; HB=%d; JB=%d\n", x, yi, hb, jb);
	
//	TRACE("---LOOP---\n");
	
	if (yi-jb+1 < -1) yi = jb+1;
	
	for ( i=yi; i>yi-jb+1; i-- )
	{
		b = true;
//		TRACE("  I=%d\n", i);
		for ( j=0; (j<hb) && b; j++ )
		{
//			TRACE("    J=%d\n", j);
//			TRACE("         MAP[%d, %d]=%d\n", x, i-j, map->MapGet(1, x, i-j));
			b = map->MapGet(1, x, i-j) == 0;
		}
		if (b) break;
//		TRACE("  ----\n");
	}
	//TRACE("---END---\n");
	
	return b;
}

void GameScreen::UpdateHeartrate(Object *obj)
{
	int
		danger = 0,
		y1 = obj->SolidTop(),
		y2 = obj->SolidBottom();
	
	std::vector<Object*>::iterator i;
	for( i=characters.begin(); i!=characters.end(); i++ )
	{
		if (i[0]->Dangerous() == 0) continue;
		if (PlayerInHorzView(i[0], true))
			danger += i[0]->Dangerous() * (9-abs(i[0]->XPos() - obj->XPos() >> 5));
	}
	
	danger = danger > 550 ? 700 : danger + 150;
	obj->SetHeartrate(danger);
}

// Is main character reachable?
// Jumps are not taken into account
// Missing floors are taken into account
bool GameScreen::ReachablePos(Object *obj)
{
	bool b = false;
	int x1, y1, x2, y2, dir;
	Object *player = GetPlay()->GetMainCharacter();
	
	if (obj->GS() != player->GS()) return false;
	if (abs(obj->XPos()+obj->SolidX() - player->XPos()-player->SolidX()) < 16) return true;
//	TRACE("obj x = %d --- player x = %d\n", obj->XPos(), player->XPos());
	if (obj->XPos() < player->XPos())
	{
		dir = +1;
		
		x1 = obj->XPos() + obj->SolidX() + obj->SolidWidth() >> 4;
		x2 = player->XPos() + player->SolidX() >> 4;
		
		if (x1 < 0) x1 = 0;
		if (x2 > 19) x2 = 19;
	}
	else
		{
			dir = -1;
			
			x1 = obj->XPos() + obj->SolidX() >> 4;
			x2 = player->XPos() + player->SolidX() + player->SolidWidth() >> 4;
			
			if (x1 > 19) x1 = 19;
			if (x2 < 0) x2 = 0;
		}
	
	y1 = obj->YPos() + obj->SolidY() >> 4;
	y2 = obj->YPos() + obj->SolidY() + obj->SolidHeight() >> 4;
	
	if (y1 < 0) y1 = 0;
	if (y2 > 14) y2 = 14;

//	TRACE("x1=%d	y1=%d	x2=%d	y2=%d\n", x1, y1, x2, y2);
	for( int x = x1; x != x2+dir; x+=dir )
	{
//		TRACE("---> X=%d\n",  x);
		b = true;
		for( int y = y1; y <= y2; y++ )
		{
//			TRACE("------------> Y=%d\n", y);
			b = map->MapGet(1, x, y) == 0;
//			TRACE("----------------> MapGet[%d, %d]=%d\n", x, y, map->MapGet(1, x, y));
		}
		if (!b) break;
	}
	
	if (!b) return false;
	
	// Missing floors check
//	TRACE("Missing floor check vv\n");
	if (y2+1>19) return false;
//	TRACE("X1 = %d X2 = %d\n", x1, x2);
//	TRACE("Y2 = %d X1 = %d X2 = %d\n", y2+1, x1, x2+dir*2);
	for ( int x = x1; x != x2+dir; x+=dir )
	{
//		TRACE("X=%d\n", x);
		b = map->MapGet(1, x, y2+1) != 0;
		if (!b) break;
	}
//	if (map->MapGet(1, x1+dir, y2+1) == 0) return false;
	
	return b;
}

bool GameScreen::Reachable(Object *obj, Object *obj2)
{
	bool b = false;
	int x1, y1, x2, y2, dir;
	Object *player = obj2;
	
	if (obj->GS() != player->GS()) return false;
	if (abs(obj->XPos()+obj->SolidX() - player->XPos()-player->SolidX()) < 16) return true;

	if (obj->XPos() < player->XPos())
	{
		dir = +1;
		
		x1 = obj->XPos() + obj->SolidX() + obj->SolidWidth() >> 4;
		x2 = player->XPos() + player->SolidX() >> 4;
		
		if (x1 < 0) x1 = 0;
		if (x2 > 19) x2 = 19;
	}
	else
		{
			dir = -1;
			
			x1 = obj->XPos() + obj->SolidX() >> 4;
			x2 = player->XPos() + player->SolidX() + player->SolidWidth() >> 4;
			
			if (x1 > 19) x1 = 19;
			if (x2 < 0) x2 = 0;
		}
	
	y1 = obj->YPos() + obj->SolidY() >> 4;
	y2 = obj->YPos() + obj->SolidY() + obj->SolidHeight() >> 4;
	
	if (y1 < 0) y1 = 0;
	if (y2 > 14) y2 = 14;

	for( int x = x1; x != x2+dir; x+=dir )
	{
		b = true;
		for( int y = y1; y <= y2; y++ )
			b = map->MapGet(1, x, y) == 0;
		if (!b) break;
	}
	
	if (!b) return false;
	
	// Missing floors check
	if (y2+1>19) return false;

	for ( int x = x1; x != x2+dir; x+=dir )
	{
		b = map->MapGet(1, x, y2+1) != 0;
		if (!b) break;
	}
	
	return b;
}

bool GameScreen::PlayerInHorzView(Object *obj, bool reachable)
{
	int
		y1 = obj->SolidTop(),
		y2 = obj->SolidBottom();
	
	bool cond1, cond2=true;
	
	Object *player = play->GetMainCharacter();
	
	cond1 = 
		( ((player->SolidTop() >= y1) && (player->SolidTop() <= y2)) ||
		((player->SolidBottom() >= y1) && (player->SolidBottom()  <= y2)) ||
		((player->SolidTop() <= y1) && (player->SolidBottom() >= y2)) );
	
	if (reachable)
		cond2 = ReachablePos(obj);
	
	return cond1 && cond2;
}

bool GameScreen::HorzView(Object *obj1, Object *obj2, bool reachable)
{
	int
		y1 = obj2->SolidTop(),
		y2 = obj2->SolidBottom();
	
	bool cond1, cond2 = true;
	
	cond1 = 
		( ((obj1->SolidTop() >= y1) && (obj1->SolidTop() <= y2)) ||
		((obj1->SolidBottom() >= y1) && (obj1->SolidBottom()  <= y2)) ||
		((obj1->SolidTop() <= y1) && (obj1->SolidBottom() >= y2)) );
	
	if (reachable)
		cond2 = Reachable(obj1, obj2);
	
	return cond1 && cond2;
}

bool GameScreen::InGunnersSight(Object *gunner, Object *obj)
{
	if (obj->IsHidden()) return false;
	
	if ( ((obj->XPos() < gunner->XPos()) && (!gunner->FacingLeft())) ||
		((obj->XPos() > gunner->XPos()) && (gunner->FacingLeft())) )
			return false;
	
	return HorzView(gunner, obj, true);
}

void GameScreen::SetupRespawn(Object *obj)
{
	RSDATA rd;
	
	rd.obj = obj;
	rd.fc = 0;
	rd.fdest = obj->RespawnData().time;
	respawn_queue.push_back(rd);
}

void GameScreen::UpdateRespawn()
{
	std::vector<int> to_remove;
	
	for( int i=0; i < respawn_queue.size(); i++ )
	{
		respawn_queue[i].fc++;
		if (respawn_queue[i].fc >= respawn_queue[i].fdest)
		{
			respawn_queue[i].obj->Respawn();
			to_remove.push_back(i);
		}
	}
	
	while(!to_remove.empty())
	{
		respawn_queue.erase(respawn_queue.begin()+to_remove.back());
		to_remove.pop_back();
	}
}

void GameScreen::ResetSwitches()
{
	std::vector<Object*>::iterator i;
	for( i = objects.begin(); i != objects.end(); i++ )
		if ((*i)->Type() == OBJTYPE_SWITCH)
			if (((Switch *) *i)->IsTurnedOn())
				((Switch *) *i)->TurnSwitch(false);
}