#define DEBUGMODE

#include "Game.h"
#include "Play.h"
#include <time.h>

//
// Timer section
//

int elapsed_frames=0;

void IncrementFrame()
{
	elapsed_frames++;
}
END_OF_FUNCTION(IncrementFrame);

//
// Game class
//

Game::Game():
	updated(false),
	quit_flag(false),
	game_mask(MASK_PLAY),
	virt(NULL)
{
}

Game::~Game()
{
	teg_uninstall();
}

int Game::Init()
{
	if (allegro_init())
	{
		allegro_message("Unable to initialize alleg42.dll\n%s\n",allegro_error);
		return 1;
	}
	
	set_window_title("Uneksians v0.1");
	
	install_keyboard();
	install_joystick(JOY_TYPE_AUTODETECT);
	install_timer();
	reserve_voices(32,0);
	if (install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) != 0)
	{
		reserve_voices(-1, -1);
		if (install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) != 0)
		{
			allegro_message("Error initialising sound system\n%s\n", allegro_error);
			return 1;
		}
	}
	teg_install();
	
	srand ( time(NULL) );

	settings.LoadFromConfig();
	
	/*
	if (VideoSetup
		(settings.colordepth, settings.resw, settings.resh,
		settings.fullscreen ? GFX_AUTODETECT : GFX_AUTODETECT_WINDOWED) != 0)
			return 1;*/
	
	VideoSetup(16, 320, 240, GFX_AUTODETECT);
	
	virt = create_bitmap(320, 240);
	
	// Page flipping data (exp)
	page[0] = create_video_bitmap(SCREEN_W,SCREEN_H);
	page[1] = create_video_bitmap(SCREEN_W,SCREEN_H);
	page_num = 0;
	
	TimerSetup(settings.fps);
	TRACE("Resources...\n");
	resources = new Resources;
	resources->Init();
	TRACE("Play...\n");	
	play = new Play(this);
	TRACE("Game successfully initialiazed...\n");
	return 0;
}

void Game::Run()
{
	// Main game loop
	while(!quit_flag)
	{
		while(elapsed_frames > 0)
		{
			updated = true;
			LogicalUpdate();
			elapsed_frames-=1;
		}
		if (updated)
		{
			ScreenUpdate();
			updated = false;
		}
	}
}

void Game::Quit()
{
	quit_flag = true;
}

void Game::LogicalUpdate()
{
	buttons.Update();
	
	//if (key[KEY_Q]) Quit();
	switch( game_mask )
	{
		case MASK_PLAY:
			play->LogicalUpdate();
			break;
	}
}

void Game::ScreenUpdate()
{
	clear_bitmap(virt);
	switch( game_mask )
	{
		case MASK_PLAY:
			play->Draw(virt);
			break;
	}
	
	//acquire_screen();
	//vsync();
	/*
	TRACE("Stretching to screen ");
	stretch_blit(virt, screen, 0, 0, 320, 240, 0, 0, SCREEN_W, SCREEN_H);
	TRACE("Stretched ");
	//release_screen();
	TRACE("->DONE\n");
	*/
	acquire_bitmap(page[page_num]);
	stretch_blit(virt, page[page_num], 0, 0, 320, 240, 0, 0, SCREEN_W, SCREEN_H);
	release_bitmap(page[page_num]);
	vsync();
	show_video_bitmap(page[page_num]);
	page_num=1-page_num;
}

int Game::TimerSetup( int bps )
{
	LOCK_VARIABLE(elapsed_frames);
	LOCK_FUNCTION(IncrementFrame);
	if(install_int_ex(IncrementFrame, BPS_TO_TIMER(bps))<0)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Unable to install timer interrupt service routine\n%s\n", allegro_error);
		return 1;
	}
	
	return 0;
}

int Game::VideoSetup( int colordepth, int resw, int resh, int card )
{
	set_color_depth(colordepth);
	if (set_gfx_mode(card, resw, resh, 0, 0) != 0)
	{
		if (set_gfx_mode(GFX_SAFE, 320, 240, 0, 0) != 0)
		{
			return 1;
		}
	}
	return 0;
}