#ifndef		TIGCPB_FALLINGENEMY_H
#define		TIGCPB_FALLINGENEMY_H

#include <allegro.h>
#include <vector>
#include "Object.h"

/*
	Falling enemy object for Uneksians
	
	Used for any kind of character-damaging vertically falling object.
	Falling sessions repeat and cannot be stopped.
	
	y_start - initial position (falls from this point)
	y_end - end position (where fall ends and starts again from y_start)
	particles - should we draw particles upon fall (i.e. upon reaching y_end position)?
	intervals - intervals at which object should fall
	yd - number of 1/256 pixels object moves vertically
*/

class FallingEnemy : public Object
{
	private:
		int
			y_start,
			y_end,
			damage,
			framecounter,
			framedest,
			yd;
		
		bool
			particles;
		
		int current_interval;
		std::vector <int> intervals;
		std::vector <int> pauseintervals;
		
		AudioSampler
			*afall;
	public:
		FallingEnemy(GameScreen *gs);
		
		void ReadProperties(MyINI *ini);
		
		void ProcessAI();
		void ProcessMessage(MESSAGE msg) {}
};

#endif		// TIGCPB_FALLINGENEMY_H