#define DEBUGMODE

#include "Bullet.h"
#include "GameScreen.h"
#include "Play.h"

Bullet::Bullet(GameScreen *gs)
	:Object(gs, false)
{	
	Object::Init();
	
	type = OBJTYPE_BULLET;
	health = 1;
	user_controlled = false;
	uses_anims = false;
	is_character = false;
}

void Bullet::Init()
{
	LoadProperties("data\\bullet.txt");
}

void Bullet::ReadProperties(MyINI *ini)
{
	Object::ReadProperties(ini);
	
	if (!strcmp(ini->Variable(), "damage"))
		damage = ini->ReadInteger();
}

int Bullet::MoveX(int dx)
{
	if (HEdgeCol(xpos+dx, dx) == 2)
		return 0;
	
	if (!HCollision(xpos+dx, ypos, dx))
	{
		xpos += dx;
		return 1;
	}
	else return 0;
}

void Bullet::ProcessAI()
{
	Object *player = gamescreen->GetPlay()->GetMainCharacter();
	bool
		cond1, cond2 = false;
	
	cond1 = !MoveX(direction * walkspeed);
	
	if (!player->IsDead())
		if (Intersect(player))
		{
			cond2 = true;
			player->DamageWD(damage);
		}
	
	if (!cond1)
	{
		gamescreen->CNReset();
		while(!gamescreen->CNEnd())
		{
			Object *obj = gamescreen->CNGet();
			if (Intersect(obj))
			{
				cond2 = true;
				obj->DamageWD(damage);
			}
			gamescreen->CNNext();
		}
	}
	
	if (cond1)
		if (IsOnScreen())
		{
			gamescreen->GetParticles()->SpawnParticles(
				xpos>>8, ypos>>8,
				rand()%8+2, gamescreen->Identifier(),
				makecol32(255,128,0), makecol32(255,255,0));
		}
	if (cond1 || cond2)
		SwitchToState(STATE_KILL, 0, 0);
}

void Bullet::Draw(BITMAP *dest)
{
	hline(dest, xpos>>8, ypos>>8, (xpos>>8)+w, makecol(255, 255, 255));
}