#define DEBUGMODE

#include "AudioSampler.h"
#include "Object.h"

AudioSampler::AudioSampler(Sound *snd)
	:sample(NULL),
	voice(0),
	framecounter(0), interval(0),
	sample_num(0), volume(0),
	t_fadein(0), t_fadeout(0),
	objvalid(false), is_playing(false)
{
	sound = snd;
}

AudioSampler::~AudioSampler()
{
}

void AudioSampler::Play()
{
	char buf[64];
	
	if (!objvalid) return;
	
	if (sample_num)
		usprintf(buf, "%s%d", objid, (rand() % sample_num) + 1);
	else
		usprintf(buf, "%s", objid);
		
	voice = sound->Play(buf, volume, 128, 0);
	sample = sound->GetSample(buf);
	is_playing = true;
}

void AudioSampler::PlayLooped()
{
	char buf[64];
	
	if (!objvalid) return;
	
	if (sample_num)
		usprintf(buf, "%s%d", objid, (rand() % sample_num) + 1);
	else
		usprintf(buf, "%s", objid);
	
	voice = sound->Play(buf, volume, 128, 1);
	sample = sound->GetSample(buf);
	
	is_playing = true;
}

void AudioSampler::Stop()
{
	if (!objvalid) return;
	
	stop_sample(sample);
	is_playing = false;
}

void AudioSampler::FadeInTick()
{
	if (framecounter < t_fadein)
	{
		framecounter++;
		voice_set_volume(voice, volume*framecounter/t_fadein);
	}
}

void AudioSampler::FadeOutTick()
{
	if (framecounter < t_fadeout+1)
	{
		framecounter++;
		voice_set_volume(voice, volume-volume*framecounter/t_fadeout);
	}
}

void AudioSampler::Frametick()
{
	char buf[64];
	
	framecounter++;
	if (framecounter >= interval)
	{
		Play();
		framecounter = 0;
	}
}

void AudioSampler::LoadFromINI(MyINI *ini)
{
	char *s = ini->ReadQString();
	SetObjectID(s);
	SetInterval(ini->ReadInteger());
	SetSamplenum(ini->ReadInteger());
	SetVolume(ini->ReadInteger());
	SetFadeInTime(ini->ReadInteger());
	SetFadeOutTime(ini->ReadInteger());
	free(s);
	//objvalid = true;
}