#ifndef		TIGCPB_ANIMATION_H
#define		TIGCPB_ANIMATION_H

#include <allegro.h>
#include <vector>

typedef
	struct _ANIMFRAME
	{
		BITMAP *frame_bmp;
		int duration;
	} ANIMFRAME;

class Animation
{
	private:
		std::vector <ANIMFRAME> aframes; // Animation frame
	public:		
		// Used for adding new animation frames to class instance
		void Add ( BITMAP *bmp );		
		void Add ( BITMAP *bmp, int d );
		
		// Returns bitmap of animation frame specified by f
		BITMAP *GetFrameBitmap ( int f );
		int GetFrameDuration( int f ) { return aframes[f].duration; }
		
		void SetIntervalToAll( int d );
		
		int FrameCount() { return aframes.size(); }		
};

class AnimPlayer
{
	private:
		Animation *animation;
		
		bool paused; // If set to true, calls to FrameTick() will have no effect
		
		int
			rate, // Frame-count rate (4-bytes precision)
			frame_counter, // Keeps the number of logical frames passed since last animation frame
			current_aframe; // Keeps the information about current animation frame
	public:
		AnimPlayer();
		AnimPlayer(Animation *a);
		
		// Sets animation
		void SetAnimation( Animation *a ) { animation = a; }
		
		// Frame bitmaps
		BITMAP *FrameBitmap( int f ) { return animation->GetFrameBitmap(f); }
		BITMAP *CurrentFrameBitmap() { return animation->GetFrameBitmap(current_aframe); }
		
		// Returns bitmap of actual animation frame
		BITMAP *GetCurrentFrame ( void ) { return FrameBitmap(current_aframe); }
		
		// Skips to specific animation frame
		void GoToFrame( int f ) { current_aframe = f; }
		
		// Updates animation for one logical frame
		void FrameTick ( void );
		
		void Pause() { paused = true; }
		void Unpause() { paused = false; }
		void SetRate(int r) { rate = r; }
};

#endif		//	TIGCPB_ANIMATION_H