#include "Animation.h"

//
// Animation class
//

void Animation::Add ( BITMAP *bmp )
{
	ANIMFRAME a;
	
	a.frame_bmp = bmp;
	a.duration = 0;
	
	aframes.push_back(a);
}

void Animation::Add ( BITMAP *bmp, int d )
{
	ANIMFRAME a;
	
	a.frame_bmp = bmp;
	a.duration = d;
	
	aframes.push_back(a);
}

// Returns bitmap of animation frame specified by f
BITMAP *Animation::GetFrameBitmap ( int f )
{
	if ( f < 0 || f >= aframes.size()) return NULL;
	return aframes[f].frame_bmp;
}

void Animation::SetIntervalToAll( int d )
{
	for( std::vector<ANIMFRAME>::iterator i = aframes.begin(); i != aframes.end(); i++ ) (*i).duration = d;
}

//
// AnimPlayer Class
//

AnimPlayer::AnimPlayer()
	:paused(false),
	rate(0x10),
	frame_counter(0),
	current_aframe(0)
{
}

AnimPlayer::AnimPlayer(Animation *a)
	:paused(false),
	rate(0x10),
	frame_counter(0),
	current_aframe(0)
{
	animation = a;
}

// Updates animation for one logical frame
void AnimPlayer::FrameTick ( void )
{
	if (paused) return;
	
	if (!animation->FrameCount()) return;
	
	frame_counter += (rate>>4);
	if (frame_counter > animation->GetFrameDuration(current_aframe))
	{
		frame_counter = 0;
		if (++current_aframe >= animation->FrameCount()) current_aframe = 0;
	}
}
