#define DEBUGMODE

#include "Zombie.h"
#include "GameScreen.h"
#include "AudioSampler.h"
#include "Possession.h"

Zombie::Zombie(GameScreen *owner)
	:GreenBeli(owner),
	walkdistance(0),
	waittime(0),
	wtbase(0),
	belidmg(0), dudedmg(0),
	fix1(0), fix2(0),
	fc(0), fd(0),
	wtrandom(true),
	fixed(false)
{
	type = OBJTYPE_ZOMBIE;
}

void Zombie::Init()
{
	Object::Init();
	
	LoadProperties("data\\zombie.txt");
	
	health = fullhealth;
	
	xpos = 0<<8; ypos = 160<<8;
	
	if (!gamescreen) return;
	
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["zombieidle"]));
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["zombiewalk"]));
	
	SwitchToState(STATE_FALLING, 0, 0);
}

void Zombie::ReadProperties(MyINI *ini)
{	
	if (!strcmp(ini->Variable(), "walkdistance"))
		walkdistance = ini->ReadInteger();
	
	if (!strcmp(ini->Variable(), "belidmg"))
		belidmg = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "dudedmg"))
		dudedmg = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "waittime"))
	{
		waittime = ini->ReadInteger();
		wtbase = ini->ReadInteger();
	}
	if (!strcmp(ini->Variable(), "wtrandom"))
		wtrandom = ini->ReadBool();
	if (!strcmp(ini->Variable(), "fixrange"))
	{
		fix1 = ini->ReadInteger();
		fix2 = ini->ReadInteger();
	}
	if (!strcmp(ini->Variable(), "fixed"))
		fixed = ini->ReadBool();
	
	GreenBeli::ReadProperties(ini);
}


void Zombie::ChangeParams(int param1, int param2)
{
	GreenBeli::ChangeParams(param1, param2);
	
	if (state == STATE_WALK)
		switch( param1 )
		{
			case 0:
				InitState(STATE_IDLE);
			case 1: // Go right
				current_animation = 1;
				travelled = 0;
				if (fixed)
					traveldest = (fix2 << 8) - xpos;
				else
					traveldest = walkdistance;
				InitState(STATE_WALKR);
				break;
			case 2: // Go left
				current_animation = 1;
				travelled = 0;
				if (fixed)
					traveldest = xpos - (fix1 << 8);
				else
					traveldest = walkdistance;
				InitState(STATE_WALKL);
				break;
			case 3: // Pause
				current_animation = 0;
				ResetCounter();
				break;
		}
}

void Zombie::ProcessAI()
{
	Object *target = NULL;
	Object *obj;
	
	gamescreen->CNReset();
	while(!gamescreen->CNEnd())
	{
		obj = gamescreen->CNGet();
		if (!obj->IsDead())
		{
			if (target != NULL)
			{
				if (obj->Type() == OBJTYPE_GREENBELI)
				{
					if (target->Type() == OBJTYPE_GREENBELI)
					{
						if (abs(obj->XPos()-XPos()) < abs(target->XPos()-XPos()))
							if (gamescreen->HorzView(this, obj, true))
								target = obj;
					}
				}
				if (obj->Type() == OBJTYPE_DUDE)
				{
					if (target->Type() == OBJTYPE_DUDE)
					{
						if (abs(obj->XPos()-XPos()) < abs(target->XPos()-XPos()))
							if (gamescreen->HorzView(this, obj, true))
								target = obj;
					}
					if (target->Type() == OBJTYPE_GREENBELI)
						if (gamescreen->HorzView(this, obj, true))
							target = obj;
				}
			}
			else
			{
				if ((obj->Type() == OBJTYPE_DUDE) || (obj->Type() == OBJTYPE_GREENBELI))
					if (gamescreen->HorzView(this, obj, true))
						target = obj;
			}
		}
		gamescreen->CNNext();
	}
	
	if (target != callingparty_obj)
	{
		callingparty_obj = target;
		if (callingparty_obj)
			xdiff = callingparty_obj->X() - this->X();
	}
	
	if (target && (state != STATE_FOLLOW))
		SwitchToState(STATE_FOLLOW, 0, 0);
	
	if (!target && (state != STATE_WALK) && (state != STATE_FALLING))
		SwitchToState(STATE_WALK, 3, 1);
	
	if (callingparty_obj)
	{
		if (Intersect(callingparty_obj))
		{
			if (target->Type() == OBJTYPE_GREENBELI)
				target->DamageWD(belidmg);
			else
				target->DamageWD(dudedmg);
		}
		
		if (callingparty_obj->IsDead())
		{
			callingparty_obj = NULL;
			SwitchToState(STATE_WALK, 3, 1);
		}
	}
	
	GreenBeli::ProcessAI();
}

void Zombie::StateWalk()
{
	switch( stparam1 )
	{
		case 1: // Go right
			if (!IsMissingGround(xpos+walkspeed, ypos)
				&& (!HEdgeCol(xpos+walkspeed, +walkspeed)))
			{
				if (MoveX(+walkspeed))
				{
					travelled += walkspeed;
					if (travelled >= traveldest)
						ChangeParams(3, 2);
				}
				else
					ChangeParams(3, 2);
			}
			else
				ChangeParams(3, 2);
			break;
		case 2: // Go left
			if (!IsMissingGround(xpos-walkspeed, ypos)
				&& (!HEdgeCol(xpos-walkspeed, -walkspeed)))
			{
				xpos -= walkspeed;
				if (MoveX(-walkspeed))
				{
					travelled += walkspeed;
					if (travelled >= traveldest)
						ChangeParams(3, 1);
				}
				else
					ChangeParams(3, 1);
			}
			else
				ChangeParams(3, 1);
			break;
		case 3: // Pause
			framecounter++;
			if (framecounter >= framedest)
				ChangeParams(stparam2, 0);
			break;
	}
}

void Zombie::ResetCounter()
{
	framecounter = 0;
	if (wtrandom)
		framedest = rand() % waittime + wtbase;
	else
		framedest = waittime;
}