#define DEBUGMODE

#include "Switch.h"
#include "Play.h"
#include "GameScreen.h"
#include "AudioSampler.h"

Switch::Switch(GameScreen *gs)
	:Object(gs, false),
	framecounter(0),
	framedest(0),
	switched(false)
{
	type = OBJTYPE_SWITCH;
	health = 100;
	is_character = false;
	user_controlled = false;
	possessable = false;
	fullhealth = 1000;
	
	aswitch = new AudioSampler(GetSound());
}

void Switch::ReadProperties(MyINI *ini)
{
	Object::ReadProperties(ini);
	
	if (!strcmp(ini->Variable(), "solidtile"))
	{
		SOLIDTILE sl;
		sl.x = ini->ReadInteger();
		sl.y = ini->ReadInteger();
		sl.gs = ini->ReadInteger();
		sl.newvalue = ini->ReadInteger();
		
		solidtiles.push_back(sl);
	}
	if (!strcmp(ini->Variable(), "animation"))
	{
		char *s = ini->ReadQString();
		anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist[s]));
		free(s);
	}
	if (!strcmp(ini->Variable(), "aswitch"))
		aswitch->LoadFromINI(ini);
	if (!strcmp(ini->Variable(), "switchtype"))
	{
		switch_type = ini->ReadInteger();
		framedest = ini->ReadInteger();
	}
}

void Switch::ProcessAI()
{
	static int
		first, second,
		xd, yd;
	
	bool pushed = false;
	
	if (visible)
	{
		Object *mc = gamescreen->GetPlay()->GetMainCharacter();
		if (!mc->IsDead())
			if (Intersect(mc))
				pushed = true;
		
		gamescreen->CNReset();
		while(!gamescreen->CNEnd() && !pushed)
		{
			Object *obj = gamescreen->CNGet();
			if (!obj->IsDead())
				if (
					(obj->Type() == OBJTYPE_GREENBELI) ||
					(obj->Type() == OBJTYPE_WHITEBELI) ||
					(obj->Type() == OBJTYPE_PIP) )
						if (Intersect(obj))
							pushed = true;
			gamescreen->CNNext();
		}
	}
	
	switch(switch_type)
	{
		case 0: // Push-switch. Once pushed always on.
			if ((switched == false) && (pushed == true))
			{
				TurnSwitch(true);
				switched = true;
				if (IsOnScreen())
					aswitch->Play();
				current_animation = 1;
			}
			break;
		case 1: // Standard. If pushed on, otherwise off.
			if (switched != pushed)
			{
				TurnSwitch(pushed);
				switched = pushed;
				if (pushed)
				{
					if (IsOnScreen())
						aswitch->Play();
					
					current_animation = 1;
				}
				else
					current_animation = 0;
			}
			break;
		case 2: // Timed. Once pushed on remains switched for some time.
			if (switched != pushed)
			{
				switched = true;
				TurnSwitch(pushed);
			}
			if (pushed)
				framecounter = framedest;
			if (framecounter > 0)
				framecounter--;
			else
				if (!switched)
					{
						switched = false;
						TurnSwitch(false);
					}
			break;
	}	
}

void Switch::TurnSwitch(bool turn)
{
	int i;
	
	if (turn)
	{
		for(i = 0; i < solidtiles.size(); i++)
		{
			solidtiles[i].oldvalue = gamescreen->GetPlay()->GetGS(solidtiles[i].gs)->GetMap()->MapGet(1, solidtiles[i].x, solidtiles[i].y);
			gamescreen->GetPlay()->GetGS(solidtiles[i].gs)->GetMap()->MapPut(1, solidtiles[i].x, solidtiles[i].y, solidtiles[i].newvalue);
		}		
	}
	else
		{
			for(i = 0; i < solidtiles.size(); i++)
				gamescreen->GetPlay()->GetGS(solidtiles[i].gs)->GetMap()->MapPut(1, solidtiles[i].x, solidtiles[i].y, solidtiles[i].oldvalue);
		}
	
	gamescreen->GetPlay()->GetMainCharacter()->CheckForMissingGround();
	
	gamescreen->CNReset();
	while(!gamescreen->CNEnd())
	{
		gamescreen->CNGet()->CheckForMissingGround();
		gamescreen->CNNext();
	}
}