#include "Sound.h"

Sound::Sound()
	:data(NULL)
{
}

Sound::~Sound()
{
	if (data) unload_datafile(data);
}

void Sound::LoadFromDatafile(char *path)
{
	if (data) unload_datafile(data);
	data = load_datafile(path);
}

int Sound::Play(char *sname)
{
	return play_sample(GetSample(sname), 255, 128, 1000, 0);
}

int Sound::Play(char *sname, int repeat)
{
	return play_sample(GetSample(sname), 255, 128, 1000,repeat);
}

int Sound::Play(char *sname, int vol, int pan, int repeat)
{
	return play_sample(GetSample(sname), vol, pan, 1000, repeat);
}

int Sound::Play(char *sname, int vol, int pan, int pitch, int repeat)
{
	return play_sample(GetSample(sname), vol, pan, pitch, repeat);
}

SAMPLE *Sound::GetSample(char *id)
{
	DATAFILE *d;
	d = find_datafile_object(data, id);
	if (d)
		if (d->type != DAT_SAMPLE)
			return NULL;
		else
			return (SAMPLE*) d->dat;
}