#ifndef		TIGCPB_RESOURCES_H
#define		TIGCPB_RESOURCES_H

#define	DEBUGMODE

#include <allegro.h>
#include <string>
#include <vector>
#include <map>
#include <string>
#include "Animation.h"
#include "Tegmap.h"
#include "MyINI.h"
#include "Messages.h"
#include "Sound.h"

#define	SEC_UNKNOWN		0
#define	SEC_ENTRYINFO		1
#define	SEC_GAMESCREENS	2

typedef
	struct _MAPEX
	{
		// Map links
		int
			left,
			right,
			top,
			bottom;
		// Map background information
		char
			*bgname,
			*music,
			*infofile;
		bool plays_music;
		int bgx, bgy;
	} MAPEX;

typedef
	struct _ENTRYINFO
	{
		int
			entryscreen,
			posx, posy;
		char *tileset;
	} ENTRYINFO;

class Resources
{
	public:
		// Main data objects
		DATAFILE *sprites;
		DATAFILE *tilesets;
		DATAFILE *sounds;
		DATAFILE *fonts;
		DATAFILE *images;
	public:
		// Maps and related data
		ENTRYINFO entryinfo;
		std::vector <MAPEX> mapex;
		std::vector <Tegmap*> maps;
		
		// Gamespeak data
		std::vector <std::string*> msgtexts[2][MSGCOUNT];
		
		// Animations
		std::map <std::string, Animation*> animlist;
		
		// Sounds
		Sound *sound;
		
		Resources();
		~Resources();
		
		void Init();
		
		void LoadMaps(char *path);
		void LoadAnimations(char *path);
		void LoadMessageTexts(char *path);
		
		BITMAP *GetSprite(char *id);
		TEG_TILELIST *GetTileset(char *id);
		SAMPLE *GetSound(char *id);
		FONT *GetFont(char *id);
		Animation *GetAnimation(std::string id);
		BITMAP *GetImage(char *id);
		const char *GetRndMsgtext(int msgid, int ref);
		const char *GetMsgtext(int msgid, int ref, int textid);
		
		Sound *GetSound() { return sound; }
};

#endif		// TIGCPB_RESOURCES_H