#ifndef		TIGCPB_RANDOMSOUNDS_H
#define		TIGCPB_RANDOMSOUNDS_H

#include <allegro.h>
#include <vector>
#include "Sound.h"
#include "Play.h"
#include "MyINI.h"
#include "AudioSampler.h"

class RandomSounds
{
	private:
		Sound *sound;
		
		std::vector<AudioSampler*> audio;
		
		unsigned long
			framecounter,
			framedest,
			cur_audiosample;
		
		bool active;
	protected:
		void GenerateNextSound();
	public:
		RandomSounds(Sound *snd, char *path);
		~RandomSounds();
		
		void LoadFromINI(char *path);
		
		void Frametick();
		
		unsigned long GetDelta() { return framedest-framecounter; }
};

#endif		// TIGCPB_RANDOMSOUNDS_H