#ifndef		TIGCPB_POSSESSION_H
#define		TIGCPB_POSSESSION_H

#include <allegro.h>
#include "AudioSampler.h"

class Play;
class MainCharacter;
class Particles;

class Possession
{
	private:
		Play *play;
		MainCharacter *mainc;
		Particles *particles;
		
		AudioSampler *chantsample;
		
		int
			framecounter,
			phase;
		
		Object *target;
		
		bool active;
	public:
		Possession(Play *pl, MainCharacter *mc, Particles *pt, AudioSampler *cs);
		
		void Activate();
		void Deactivate(int st);
		
		void Init();
		void ChantIn();
		void ChantOut();
		void PrepareChantIn();
		void PrepareChantOut();
		void Abort();
		
		int Phase() { return phase; }
		
		void SetParticles(Particles *p) { particles = p; }
};

#endif		// TIGCPB_POSSESSION_H