#define DEBUGMODE

#include "Possession.h"
#include "GameScreen.h"
#include "MainCharacter.h"
#include "Particles.h"
#include "Play.h"

Possession::Possession(Play *pl, MainCharacter *mc, Particles *pt, AudioSampler *cs)
	:play(pl),
	mainc(mc),
	particles(pt),
	chantsample(cs),
	framecounter(0),
	phase(0),
	target(NULL),
	active(false)
{
}

void Possession::Activate()
{
	active = true;
	phase = 2;
	if (play->CursorValid())
	{
		mainc->SetUserControl(false);
		target->SetUserControl(true);
		target->SetPossession(this);
	}
	chantsample->Stop();
}

void Possession::Deactivate(int st)
{
	active = false;
	phase = 0;
	framecounter = 0;
	mainc->SetUserControl(true);
	target->SetUserControl(false);
	target->SetPossession(NULL);
	mainc->SwitchToState(STATE_IDLE, 0, 0);
	//if (target->ShouldRespawn())
	//	target->GS()->SetupRespawn(target);
	target->SwitchToState(st, 0, 0);
	chantsample->Stop();
}

void Possession::PrepareChantIn()
{
	phase = 1;
	active = false;
	chantsample->Stop();
	framecounter = 0;
	target = mainc->GS()->GetObject(play->CursorObject());
	chantsample->ResetCounter();
	chantsample->PlayLooped();
}

void Possession::Abort()
{
	active = false;
	phase = 0;
	framecounter = 0;
	mainc->SwitchToState(STATE_IDLE, 0, 0);
	chantsample->Stop();
}

void Possession::PrepareChantOut()
{
	phase = 3;
	framecounter = 0;
}

void Possession::ChantIn()
{
	if (!active)
	{
		if (!mainc->GS()->ObjectExists(target))
		{
			Deactivate(STATE_IDLE);
			return;
		}
		particles->SpawnParticles(
			mainc->CenterX(), mainc->CenterY(),
			(framecounter * 50) / (mainc->Heartrate() << 2)+1, mainc->GS()->Identifier(),
			makecol32(0,0,0), makecol32((framecounter * 255) / (mainc->Heartrate() << 2),255,255));
//		if (mainc->Heartrate() < 500)
		if (!mainc->GS()->HorzView(target, mainc, true))
		{
			framecounter++;
			chantsample->FadeInTick();
			if (framecounter >= mainc->Heartrate() << 2)
				Activate();
		}
	}
}

void Possession::ChantOut()
{
	if (!target->KillAfterPossess())
	{
		framecounter++;
		if (framecounter <= 250)
			particles->SpawnParticles(
				target->CenterX(), target->CenterY(),
				framecounter * 50 / 250 + 1, target->GS()->Identifier(),
				makecol32(0,0,0), makecol32(255-framecounter * 255 / 250,255,255));
		if (framecounter >= 300)
		{
			Deactivate(STATE_IDLE);
			play->GoToScreen(mainc->GS()->Identifier());
		}
	}
	else
		{
			if (!target->IsDead())
				target->Damage(10);
			else
				{
					framecounter++;
					if (framecounter >= 150)
					{
						Deactivate(STATE_KILL);
						play->GoToScreen(mainc->GS()->Identifier());
					}
				}
			if (target->IsDead()) phase = 4;
		}
}

void Possession::Init()
{
}