#ifndef		TIGCPB_PLAY_H
#define		TIGCPB_PLAY_H

#include <allegro.h>
#include <vector>

#define DEBUGMODE

#define	MODE_PLAY		0
#define	MODE_SCRTRANSITION	1
#define	MODE_DIE			2
#define	MODE_RESPAWN		3
#define	MODE_PAUSE		4

#define	play_update(m1, m2) mode = m1; LogicalUpdate(); mode = m2;
#define	play_draw(m1, m2) mode = m1; Draw(dest); mode = m2;

#include "MainCharacter.h"
#include "Particles.h"
#include "Buttons.h"

class Game;
class GameScreen;
class MainCharacter;
class Particles;
class Tegmap;
class Resources;
class RandomSounds;
class AudioSampler;
class PauseMenu;

class Play
{
	private:
		Game *game;
		
		MainCharacter *player;
		Particles *particles;
		RandomSounds *rndsounds;
		AudioSampler *ambient;
		PauseMenu *pausemenu;
		
		int mode;
		
		// Gamescreen(s)
		int framecounter; // Transition frame counter
		int
			prev_gs, // Previous gamescreen (used for screen transition)
			cur_gs; // Current gamescreen
		
		// Cursor data
		BITMAP *cursor;
		int cursor_mode;
		int
			cursor_objid,
			cursor_fc,
			cursor_dir;
		
		std::vector <GameScreen*> gs;
		
		// Temporary bitmap
		BITMAP *temp;
		
		// Play status
		int
			rescued,
			saves;
	protected:
		void CreateGamescreens();
		void DestroyGamescreens();
		void ResetGamescreens();
		void CreatePlayer() { player = new MainCharacter(gs[0]); player->Init(); }
		void DestroyPlayer() { delete player; }
		void ResetPlayer() { player->Reset(); }
		void CreateParticles() { particles = new Particles(this); }
		void DestroyParticles() { delete particles; }
		void ResetParticles() { particles->ResetParticles(); }
		void CreateRandomSounds();
		void DestroyRandomSounds();
		void CreateAmbient();
		void DestroyAmbient();
		void CreatePauseMenu();
		void DestroyPauseMenu();
		
		void UpdatePlay();
		void UpdateScreenTransition();
		void UpdateDeathFadeout();
		void UpdateRespawn();
		
		void DrawPlay(BITMAP *dest);
		void DrawScreenTransition(BITMAP *dest);
		void DrawDeathFadeout(BITMAP *dest);
		void DrawRespawn(BITMAP *dest);
		
		void UpdateCursor();
		void DrawCursor(BITMAP *dest);
		
		void UpdatePauseMenu();
		void DrawPauseMenu(BITMAP *dest);
	public:
		Play(Game *owner);
		~Play();
		
		void LogicalUpdate();
		void Draw(BITMAP *dest);
		
		void GoToScreen(int next_gs);
		void Die();
		
		
		bool GSEmpty() { return gs.empty(); }
		GameScreen *GetActualGS() { return gs[cur_gs-1]; }
		GameScreen *GetGS(int gs_id) { return gs[gs_id-1]; }
		
		Tegmap *GetMap(int id);
		Tegmap *GetActualMap();
		Particles *GetParticles() { return particles; }
		
		Resources *GetResources();
		Buttons *GetButtons();
		MainCharacter *GetMainCharacter() { return player; }
		
		Object *Cursor();
		int CursorObject() { return cursor_objid; }
		int CursorMode() { return cursor_mode; }
		bool CursorValid();
		void PlayAmbient();
		void StopAmbient();
		
		void AddRescue() { rescued++; }
		void AddSave() { saves++; }
		
		int NoSaves() { return saves; }
		int NoRescued() { return rescued; }
		
		// Temporary
		void NextScreen(Object *obj)
		{
			cur_gs++;
			if (cur_gs > gs.size())
				cur_gs = 1;
			obj->SetGamescreen(cur_gs);
			GoToScreen(cur_gs);
		}
		void PrevScreen(Object *obj)
		{
			cur_gs--;
			if (cur_gs <= 0)
				cur_gs = gs.size();
			obj->SetGamescreen(cur_gs);
			GoToScreen(cur_gs);
		}
};

#endif		// TIGCPB_PLAY_H