#define DEBUGMODE

#include "Pip.h"
#include "GameScreen.h"
#include "AudioSampler.h"
#include "Possession.h"
#include "Play.h"

Pip::Pip(GameScreen *owner)
	:Object(owner, false),
	travelled(0), walkdistance(0),
	traveldest(20000),
	framecounter(0), framedest(0),
	waittime(0), wtbase(0), prepare_time(0),
	damage(0), turnsteps(0),
	fix1(0), fix2(0), wtrandom(false),
	fixed(false), can_exit_gs(false),
	fc(0), fd(0), rcchecktime(0)
{
	type = OBJTYPE_PIP;
}

void Pip::Init()
{
	Object::Init();
	
	LoadProperties("data\\pip.txt");
	
	health = fullhealth;
	
	xpos = 0<<8; ypos = 160<<8;
	
	if (!gamescreen) return;
	
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["pipidle"]));
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["piprun"]));
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["pipsleep"]));
	
	SwitchToState(STATE_FALLING, 0, 0);
}

void Pip::ReadProperties(MyINI *ini)
{
	Object::ReadProperties(ini);
	
	if (!strcmp(ini->Variable(), "walkdistance"))
		walkdistance = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "damage"))
		damage = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "waittime"))
	{
		waittime = ini->ReadInteger();
		wtbase = ini->ReadInteger();
	}
	if (!strcmp(ini->Variable(), "wtrandom"))
		wtrandom = ini->ReadBool();
	if (!strcmp(ini->Variable(), "preparetime"))
		prepare_time = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "turnsteps"))
		turnsteps = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "canexitgs"))
		can_exit_gs = ini->ReadBool();
	if (!strcmp(ini->Variable(), "rcchecktime"))
		rcchecktime = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "fixrange"))
	{
		fix1 = ini->ReadInteger();
		fix2 = ini->ReadInteger();
	}
	if (!strcmp(ini->Variable(), "fixed"))
		fixed = ini->ReadBool();
}

void Pip::InitState(int st)
{
	Object::InitState(st);
	
	switch( st )
	{
		case STATE_IDLE:
			anims[0]->GoToFrame(0);
			current_animation = 0;
			break;
		case STATE_SLEEP:
			current_animation = 2;
			break;
		case STATE_WALKL:
			current_animation = 1;
			break;
		case STATE_WALKR:
			current_animation = 1;
			break;
		case STATE_JUMPING:
			current_animation = 0;
			break;
		case STATE_FALLING:
			current_animation = 0;
			break;
		case STATE_ENDPOSSESS:
			possession->PrepareChantOut();
			break;
		case STATE_PREPARERUN:
			current_animation = 0;
			framecounter = 0;
			framedest = prepare_time;
			xdiff = gamescreen->GetPlay()->GetMainCharacter()->X() - this->X();
			break;
		case STATE_RUNFOR:
			//xdiff = gamescreen->GetPlay()->GetMainCharacter()->X() - this->X();
			break;
	}
}

void Pip::ChangeParams(int param1, int param2)
{
	int p2 = stparam2;
	Object::ChangeParams(param1, param2);
	
	if ((param2 == 1) && (p2 != 1))
	{
		fc = 0;
		fd = rcchecktime;
	}
	
	switch( state )
	{
		case STATE_RUNFOR:
			switch( param1 )
			{
				case -1:
				case 0:
					InitState(STATE_IDLE);
					break;
				case 1: // Prepare walking to right
					InitState(STATE_WALKR);
					break;
				case 2: // Prepare walking to left
					InitState(STATE_WALKL);
					break;
				case 3: // Turn-right
					InitState(STATE_WALKR);
					framecounter = 0;
					framedest = turnsteps;
					break;
				case 4: // Turn-left
					InitState(STATE_WALKL);
					framecounter = 0;
					framedest = turnsteps;
					break;
			}
			break;
		case STATE_WALK:
			switch( param1 )
			{
				case 0:
					InitState(STATE_IDLE);
				case 1: // Go right
					current_animation = 1;
					travelled = 0;
					if (fixed)
						traveldest = (fix2 << 8) - xpos;
					else
						traveldest = walkdistance;
					InitState(STATE_WALKR);
					break;
				case 2: // Go left
					current_animation = 1;
					travelled = 0;
					if (fixed)
						traveldest = xpos - (fix1 << 8);
					else
						traveldest = walkdistance;
					InitState(STATE_WALKL);
					break;
				case 3: // Pause
					current_animation = 0;
					ResetCounter();
					break;
			}
	}
}

void Pip::ProcessInput()
{
	Buttons *input = gamescreen->GetButtons();
	
	Object::ProcessInput();
	
	switch(state)
	{
		case STATE_SLEEP:
		case STATE_WALK:
		case STATE_RUNFOR:
//		case STATE_WAIT:
			state = STATE_IDLE;
			break;
	}
	
	if (key[KEY_LSHIFT])
		anims[0]->SetRate(0x1E);
	else
		anims[0]->SetRate(0x10);	
}

void Pip::ProcessAI()
{
	Object::ProcessAI();
	
	if ((state == STATE_SLEEP) || (state == STATE_WALK))
		if (gamescreen->PlayerInHorzView(this, true))
			SwitchToState(STATE_PREPARERUN, 0, 0);
	
	switch( state )
	{
		case STATE_IDLE:
			SwitchToState(STATE_SLEEP, 0, 0);
			break;
		case STATE_SLEEP:
			//if (gamescreen->PlayerInHorzView(this, true))
			//	SwitchToState(STATE_PREPARERUN, 0, 0);
			StateSleep();
			break;
		case STATE_PREPARERUN:
			framecounter++;
			if (framecounter >= framedest)
			{
				xdiff = gamescreen->GetPlay()->GetMainCharacter()->X() - this->X();
				SwitchToState(STATE_RUNFOR, 0, 0);
			}
			break;
		case STATE_RUNFOR:
			StateRunFor();
			break;
		case STATE_WALK:
			//if (gamescreen->PlayerInHorzView(this, true))
			//	SwitchToState(STATE_PREPARERUN, 0, 0);
			StateWalk();
			break;
		case STATE_FALLING:
			if (!FallFrametick())
			{
				SwitchToState(STATE_SLEEP, 0, 0);
				if (IsOnScreen())
					afootstep->Play();
			}
			break;
	}
}

void Pip::StateWalk()
{
	switch( stparam1 )
	{
		case 1: // Go right
			if (!IsMissingGround(xpos+walkspeed, ypos)
				&& (!(HEdgeCol(xpos+walkspeed, +walkspeed) && !can_exit_gs)))
			{
				if (MoveX(+walkspeed))
				{
					if (IsOnScreen())
						afootstep->Frametick();
					travelled += walkspeed;
					if (travelled >= traveldest)
						ChangeParams(3, 2);
				}
				else
					ChangeParams(3, 2);
			}
			else
				ChangeParams(3, 2);
			break;
		case 2: // Go left
			if (!IsMissingGround(xpos-walkspeed, ypos)
				&& (!(HEdgeCol(xpos-walkspeed, -walkspeed) && !can_exit_gs)))
			{
				if (MoveX(-walkspeed))
				{
					if (IsOnScreen())
						afootstep->Frametick();
					travelled += walkspeed;
					if (travelled >= traveldest)
						ChangeParams(3, 1);
				}
				else
					ChangeParams(3, 1);
			}
			else
				ChangeParams(3, 1);
			break;
		case 3: // Pause
			framecounter++;
			if (framecounter >= framedest)
				ChangeParams(stparam2, 0);
			break;
	}
}

void Pip::StateRunFor()
{
	int speed;
	Object *player = gamescreen->GetPlay()->GetMainCharacter();
	
	bool
		reachable = gamescreen->PlayerInHorzView(this, true),
		same_gs = gamescreen == player->GS();
	
	if (player->DXValid())
		xdiff += player->DX();
	
	if (Intersect(player) && !player->IsDead())
		player->Damage(damage);
	
	// Target object not reachable
	if (!reachable && (stparam2 != 1))
	{
		if (!can_exit_gs)
			ChangeParams(stparam1, 1);
		else
			if (same_gs)
				ChangeParams(stparam1, 1);
	}
	
	speed = runspeed;
	
	int absdif = abs(xdiff);
	int sp = abs(speed);

	if (absdif > sp/2)
	{
		if (xdiff > 0)
		{
			if (stparam1 == 0)
				ChangeParams(1, stparam2);
			if (stparam1 == -1)
				ChangeParams(3, stparam2);
			if (stparam1 == 2)
				ChangeParams(3, stparam2);
		}
		if (xdiff < 0)
		{
			if (stparam1 == 0)
				ChangeParams(2, stparam2);
			if (stparam1 == -1)
				ChangeParams(4, stparam2);
			if (stparam1 == 1)
				ChangeParams(4, stparam2);
		}
	}
	else
		if (stparam1 != 0)
			ChangeParams(-1, stparam2);
	
	// This sub-state is entered when target object (player) is suddenly not reachable
	// Wait some time. If still not reachable switch to walk state. Otherwise, exit the substate.
	if (stparam2 == 1)
	{
		if (reachable)
		{
			xdiff = gamescreen->GetPlay()->GetMainCharacter()->X() - this->X();
			SwitchToState(STATE_RUNFOR, stparam1, 0);
		}
		fc++;
		if (fc >= fd)
		{
			if (fixed)
			{
				if (fix1 >= XPos())
					SwitchToState(STATE_WALK, 3, 1);
				else
					if (XPos() >= fix2)
						SwitchToState(STATE_WALK, 3, 2);
					else
						SwitchToState(STATE_WALK, 3, rand()%2+1);
			}
			else
				SwitchToState(STATE_WALK, 3, rand()%2+1);
		}
	}
	
	switch( stparam1 )
	{
		case 0: // Do nothing
			break;
		case 1: // Follow right
			if (!IsMissingGround(xpos+speed, ypos))
			{
				int hec = HEdgeCol(xpos+speed, +speed);
				if (!(!can_exit_gs && hec))
				{
					if (MoveX(+speed))
					{
						if (IsOnScreen())
							afootstep->Frametick();
						xdiff -= speed;
					}
					else
						InitState(STATE_IDLE);
				}
			}
			else
				InitState(STATE_IDLE);
			break;
		case 2: // Follow left
			if (!IsMissingGround(xpos-speed, ypos))
			{
				int hec = HEdgeCol(xpos-speed, -speed);
				if (!(!can_exit_gs && hec))
				{
					if (MoveX(-speed))
					{
						if (IsOnScreen())
							afootstep->Frametick();
						xdiff += speed;
					}
					else
						InitState(STATE_IDLE);
				}
			}
			else
				InitState(STATE_IDLE);
			break;
		case 3: // Turn-right
			framecounter++;
			if (framecounter >= framedest)
				ChangeParams(1, stparam2);
			if (!IsMissingGround(xpos-runspeed, ypos) && !HEdgeCol(xpos-runspeed, -runspeed))
			{
				if (MoveX(-runspeed))
				{
					if (IsOnScreen())
						afootstep->Frametick();
					xdiff += runspeed;
				}
			}
			break;
		case 4: // Turn-left
			framecounter++;
			if (framecounter >= framedest)
				ChangeParams(2, stparam2);
			if (!IsMissingGround(xpos+runspeed, ypos)  && !HEdgeCol(xpos+runspeed, +runspeed))
			{
				if (MoveX(+runspeed))
				{
					if (IsOnScreen())
						afootstep->Frametick();
					xdiff -= runspeed;
				}
			}
			break;
	}
}

void Pip::StateSleep()
{
}
/*
void Pip::StateWait()
{
	if (gamescreen->PlayerInHorzView(this, true))
		SwitchToState(STATE_PREPARERUN, 0, 0);
	framecounter++;
	if (framecounter >= framedest)
		SwitchToState(STATE_WALK, 3, rand()%2+1);
}*/

void Pip::ResetCounter()
{
	framecounter = 0;
	if (wtrandom)
		framedest = rand() % waittime + wtbase;
	else
		framedest = waittime;
}