#ifndef		_PARTICLES_H
#define		_PARTICLES_H

/*
	C++ particle wrapper
	
	Original particle.c particle.hh found in Red Pixel source code
	Copyright (c) 1999 Psyk Software
*/

#include <allegro.h>
#include <vector>

#define	DEFAULT_PARTICLES	2000
#define	MAX_PARTICLES		10000

typedef
	struct _PARTICLE
	{
		int life;
		fixed x, y;
		fixed xv, yv;
		int colour, map;
	} PARTICLE;

class Play;
	
class Particles
{
	private:
		Play *play;
		std::vector<PARTICLE> particles;
	public:
		Particles(Play *owner);
		
		void SpawnParticles(int x, int y, int num, int map, int cmin, int cmax);
		void SpawnCasing(int x, int y, int facing);
		void LogicalUpdate();
		void Draw(BITMAP *dest);
		void ResetParticles();
		void ResetParticles(int lower);
};


#endif		//	_PARTICLES_H