#define DEBUGMODE

#include "ParticleObject.h"
#include "GameScreen.h"
#include "Particles.h"

ParticleObject::ParticleObject(GameScreen *gs)
	:Object(gs, false),
	framecounter(0),
	interval(0), quantity(0)
{
	type = OBJTYPE_PARTICLEOBJECT;
	
	health = 100;
	fullhealth = 1000;
	
	uses_anims = false;
	is_character = false;
	user_controlled = false;
	possessable = false;
}

void ParticleObject::ReadProperties(MyINI *ini)
{
	Object::ReadProperties(ini);
	
	if (!strcmp(ini->Variable(), "interval"))
		interval = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "quantity"))
		quantity = ini->ReadInteger();
}

void ParticleObject::ProcessAI()
{
	if (!IsOnScreen())
		return;
	
	framecounter++;
	
	if (framecounter >= interval)
	{
		framecounter = 0;
		gamescreen->GetParticles()->SpawnParticles(
			xpos>>8, ypos>>8,
			quantity, gamescreen->Identifier(),
			bp_mincolor, bp_maxcolor);
	}
}