#include "MusicObject.h"
#include "AudioSampler.h"
#include "GameScreen.h"
#include "Play.h"

MusicObject::MusicObject(GameScreen *gs)
	:Object(gs, false),
	played(false), ambient_off(false)
{
	type = OBJTYPE_MUSICOBJECT;
	
	health = fullhealth = 100;
	
	is_character = false;
	uses_anims = false;
	user_controlled = false;
	possessable = false;
	
	music = new AudioSampler(GetSound());
}

void MusicObject::ReadProperties(MyINI *ini)
{
	Object::ReadProperties(ini);
	
	if (!strcmp(ini->Variable(), "music"))
		music->LoadFromINI(ini);
}

void MusicObject::ProcessAI()
{
	if (!music->Active() && ambient_off)
	{
		gamescreen->GetPlay()->PlayAmbient();
		ambient_off = false;
	}
	
	if (!IsOnScreen())
		return;
	
	if (!played)
	{
		gamescreen->GetPlay()->StopAmbient();
		ambient_off = true;
		music->Play();
		played = true;
	}
}