#ifndef		TIGCPB_MARQUEE_H
#define		TIGCPB_MARQUEE_H

#include <allegro.h>
#include <string>
#include "Object.h"
#include "MyINI.h"

class Marquee : public Object
{
	private:
		std::string display_text;
		
		int
			framecounter,
			framedest,
			charpointer,
			nchars;
		
		BITMAP
			*buf,
			*skin[3]; // 0 - left 1 - mid 2 - right
//			*textbitmap;
	public:
		Marquee(GameScreen *gs);
		~Marquee();
		
		void ProcessAI();
		void ProcessMessage(MESSAGE msg) {}
		
		void Draw(BITMAP *dest);
		void ReadProperties(MyINI *ini);
		
		void Setup(char *text, char *skinleft, char *skinmid, char *skinright, int speed);
		void SetDisplayText(char *text) { display_text.assign(text); }
		void SetSpeed(int sp) { framedest = sp; }

};

#endif		// TIGCPB_MARQUEE_H