#define DEBUGMODE

#include "Gunner.h"
#include "GameScreen.h"
#include "Play.h"
#include "Bullet.h"

Gunner::Gunner(GameScreen *gs)
	:Pip(gs),
	burst(20), gunx(0), guny(0)
{
	type = OBJTYPE_GUNNER;
}

void Gunner::Init()
{
	Object::Init();
	
	ashoot = new AudioSampler(GetSound());
	
	LoadProperties("data\\gunner.txt");
	
	health = fullhealth;
	
	if (!gamescreen) return;
	
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["gunneridle"]));
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["gunnerwalk"]));
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["gunneridle"]));
	
	SwitchToState(STATE_FALLING, 0, 0);	
}

void Gunner::ReadProperties(MyINI *ini)
{
	Pip::ReadProperties(ini);
	
	if (!strcmp(ini->Variable(), "burst"))
		burst = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "gunpos"))
	{
		gunx = ini->ReadInteger();
		guny = ini->ReadInteger();
	}
	if (!strcmp(ini->Variable(), "ashoot"))
		ashoot->LoadFromINI(ini);
}

void Gunner::ProcessAI()
{
	Object::ProcessAI();
	
	switch( state )
	{
		case STATE_IDLE:
			current_animation = 0;
			SwitchToState(STATE_FALLING, 3, 1);
			break;
		case STATE_SLEEP:
			current_animation = 0;
			SwitchToState(STATE_WALK, 3, 1);
			break;
		case STATE_PREPARERUN:
			current_animation = 0;
			framecounter++;
			if (framecounter >= framedest)
				SwitchToState(STATE_RUNFOR, stparam1, 0);
			break;
		case STATE_RUNFOR:
			StateRunFor();
			break;
		case STATE_WALK:
			StateWalk();
			break;
		case STATE_SHOOT:
			break;
		case STATE_FALLING:
			if (!FallFrametick())
			{
				SwitchToState(STATE_SLEEP, 0, 0);
				if (IsOnScreen())
					afootstep->Play();
			}
			break;
	}
}

void Gunner::InitState(int st)
{
	Pip::InitState(st);
}

void Gunner::ChangeParams(int param1, int param2)
{
	Pip::ChangeParams(param1, param2);
	
	switch( state )
	{
		case STATE_WALK:
			switch( param1 )
			{
				case 4: // Check behind back
					current_animation = 0;
					ResetCounter();
					if (gamescreen->GetPlay()->GetMainCharacter()->XPos() > XPos())
						TurnRight();
					else
						TurnLeft();
					break;
			}
			break;
		case STATE_RUNFOR:
			switch( param1 )
			{
				case 5: // Shoot
					current_animation = 0;
					framecounter = 0;
					framedest = 0;
					break;
			}
	}
}

void Gunner::StateWalk()
{
	Object *player = gamescreen->GetPlay()->GetMainCharacter();
	static int ot, otd;
	
	if (gamescreen == player->GS())
		if (gamescreen->InGunnersSight(this, player))
		{
			SwitchToState(STATE_PREPARERUN, 5, 0);
			return;
		}
	
	if (player->WalkBoost())
		if (gamescreen->PlayerInHorzView(this, true))
			if (stparam1 != 4)
			{
				ot = travelled;
				otd = traveldest;
				ChangeParams(4, (stparam1 << 8) | stparam2);
			}
	
	Pip::StateWalk();
	
	if (stparam1 == 4)
	{
		framecounter++;
		if (framecounter >= framedest)
		{
			ChangeParams(stparam2 >> 8, stparam2 & 0xFF);
			travelled = ot;
			traveldest = otd;
		}
	}
}

void Gunner::StateRunFor()
{
	int speed;
	Object
		*player = gamescreen->GetPlay()->GetMainCharacter();
	
	bool
		reachable = gamescreen->PlayerInHorzView(this, true),
		same_gs = gamescreen == player->GS();
	
	if (player->IsDead())
		return;
	
	if (player->DXValid())
		xdiff += player->DX();
	
	if (reachable && same_gs && (stparam1 != 5))
	{
		if (!player->IsHidden())
		{
			xdiff = gamescreen->GetPlay()->GetMainCharacter()->X() - this->X();
			ChangeParams(5, 0);
		}
	}
	
	// Target object not reachable
	if (!reachable && (stparam2 != 1))
	{
		if (!same_gs)
		{
			if (can_exit_gs)
				ChangeParams(xdiff > 0 ? 1 : 2, 1);
		}
		else
			{
				if (!can_exit_gs)
					ChangeParams(stparam1, 1);
				else
					ChangeParams(stparam1, 1);
			}

	}
	
	speed = runspeed;
	
	// This sub-state is entered when target object (player) is suddenly not reachable
	// Wait some time. If still not reachable switch to walk state. Otherwise, exit the substate.
	
	if (stparam2 == 1)
	{
		if (reachable)
		{
			xdiff = gamescreen->GetPlay()->GetMainCharacter()->X() - this->X();
			SwitchToState(STATE_RUNFOR, stparam1, 0);
		}
		else
			{
				fc++;
				if (fc >= fd)
				{
					if (fixed)
					{
						if (fix1 >= XPos())
							SwitchToState(STATE_WALK, 3, 1);
						else
							if (XPos() >= fix2)
								SwitchToState(STATE_WALK, 3, 2);
							else
								SwitchToState(STATE_WALK, 3, rand()%2+1);
					}
					else
						SwitchToState(STATE_WALK, 3, rand()%2+1);
				}
			}
	}
	
	switch( stparam1 )
	{
		case 0: // Do nothing
			break;
		case 1: // Follow right
			if (!IsMissingGround(xpos+speed, ypos))
			{
				int hec = HEdgeCol(xpos+speed, +speed);
				if (!(!can_exit_gs && (hec==1)))
				{
					if (MoveX(+speed))
					{
						if (IsOnScreen())
							afootstep->Frametick();
						xdiff -= speed;
					}
					else
						InitState(STATE_IDLE);
				}
			}
			else
				InitState(STATE_IDLE);
			break;
		case 2: // Follow left
			if (!IsMissingGround(xpos-speed, ypos))
			{
				int hec = HEdgeCol(xpos-speed, -speed);
				if (!(!can_exit_gs && (hec==1)))
				{
					if (MoveX(-speed))
					{
						if (IsOnScreen())
							afootstep->Frametick();
						xdiff += speed;
					}
					else
						InitState(STATE_IDLE);
				}
			}
			else
				InitState(STATE_IDLE);
			break;
		case 3: // Turn-right
			framecounter++;
			if (framecounter >= framedest)
				ChangeParams(1, stparam2);
			if (!IsMissingGround(xpos-runspeed, ypos) && !HEdgeCol(xpos-runspeed, -runspeed))
			{
				if (MoveX(-runspeed))
				{
					if (IsOnScreen())
						afootstep->Frametick();
					xdiff += runspeed;
				}
			}
			break;
		case 4: // Turn-left
			framecounter++;
			if (framecounter >= framedest)
				ChangeParams(2, stparam2);
			if (!IsMissingGround(xpos+runspeed, ypos)  && !HEdgeCol(xpos+runspeed, +runspeed))
			{
				if (MoveX(+runspeed))
				{
					if (IsOnScreen())
						afootstep->Frametick();
					xdiff -= runspeed;
				}
			}
			break;
		case 5: // Shoot
			if (!same_gs)
			{
				if (xdiff > 0)
					ChangeParams(1, 0);
				else
					ChangeParams(2, 0);
				break;
			}
			if (facing && (xdiff > 0))
				TurnRight();
			if (!facing && (xdiff < 0))
				TurnLeft();
			if (!player->IsDead())
			{
				framecounter++;
				if (framecounter >= framedest)
				{
					framecounter = 0;
					framedest = rand() % burst + 1;
					Shoot();
				}
			}
			break;
	}
}

void Gunner::Shoot()
{
	Bullet *bullet = new Bullet(gamescreen);
	bullet->Init();
	bullet->SetY(ypos+(guny<<8));
	bullet->SetDirection(facing ? -1 : +1);
	if (facing)
		bullet->SetX(xpos-(gunx<<8));
	else
		bullet->SetX(xpos+(w+gunx-1<<8));
	gamescreen->AddObject(bullet);
	if (IsOnScreen())
		ashoot->Play();
	if (Intersect(gamescreen->GetPlay()->GetMainCharacter()))
		gamescreen->GetPlay()->GetMainCharacter()->DamageWD(100);
}

void Gunner::ProcessInput()
{
	Pip::ProcessInput();	
	Buttons *input = gamescreen->GetButtons();
	
	if (input->KeyPress(BTN_ACT4))
	{
		Shoot();
	}
}