#define DEBUGMODE

#include "GreenBeli.h"
#include "GameScreen.h"
#include "AudioSampler.h"
#include "Possession.h"
#include "Play.h"

GreenBeli::GreenBeli(GameScreen *owner)
	:Object(owner, false),
	xdiff(0),
	travelled(0), traveldest(18000),
	framecounter(0), framedest(0)
{
	type = OBJTYPE_GREENBELI;
}

void GreenBeli::ReadProperties(MyINI *ini)
{
	Object::ReadProperties(ini);
	
	if (!strcmp(ini->Variable(), "walkdistance"))
		traveldest = ini->ReadInteger();
}

void GreenBeli::Init()
{
	Object::Init();
	
	LoadProperties("data\\greenbeli.txt");
	
	health = fullhealth;
	
	xpos = 0<<8; ypos = 160<<8;
	
	if (!gamescreen) return;
	
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["gbeliidle"]));
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["gbeliwalk"]));
	
	SwitchToState(STATE_FALLING, 0, 0);
}

void GreenBeli::InitState(int st)
{
	Object::InitState(st);
	
	switch( st )
	{
		case STATE_WAIT:
		case STATE_IDLE:
			anims[0]->GoToFrame(0);
			current_animation = 0;
			break;
		case STATE_WALKL:
			current_animation = 1;
			break;
		case STATE_WALKR:
			current_animation = 1;
			break;
		case STATE_FALLING:
			current_animation = 1;
			break;
		case STATE_JUMPING:
			current_animation = 1;
			break;
	}
}

void GreenBeli::SwitchToState(int st, int param1, int param2)
{	
	Object::SwitchToState(st, param1, param2);
	
	switch( st )
	{
		case STATE_FOLLOW:
			break;
		case STATE_WALK:
			break;
	}
}

void GreenBeli::ChangeParams(int param1, int param2)
{
	Object::ChangeParams(param1, param2);
	
	switch( state )
	{
		case STATE_FOLLOW:
			switch( param1 )
			{
				case 0:
					InitState(STATE_IDLE);
					break;
				case 1: // Prepare walking to right
					InitState(STATE_WALKR);
					break;
				case 2: // Prepare walking to left
					InitState(STATE_WALKL);
					break;
				case 3: // Prepare leap
					if (stparam2 > 0)
						TurnRight();
					else
						TurnLeft();
					InitState(STATE_JUMPING);
					break;
				case 4: // Prepare fall
					if (stparam2 > 0)
						TurnRight();
					else
						TurnLeft();
					InitState(STATE_FALLING);
					break;
			}
			break;
		case STATE_WALK:
			switch( param1 )
			{
				case 1: // Go right
					current_animation = 1;
					travelled = 0;
					InitState(STATE_WALKR);
					break;
				case 2: // Go left
					current_animation = 1;
					travelled = 0;
					InitState(STATE_WALKL);
					break;
				case 3: // Pause
					current_animation = 0;
					framecounter = 0;
					framedest = rand() % 200 + 50;
					//InitState(STATE_IDLE);
					break;
			}
	}
}

void GreenBeli::StateWalk()
{
	switch( stparam1 )
	{
		case 1: // Go right
			if (MoveX(+walkspeed))
			{
				travelled += walkspeed;
				if (travelled >= traveldest)
					ChangeParams(3, 2);
			}
			else
				ChangeParams(3, 2);
			if (IsMissingGround(xpos, ypos))
				ChangeParams(4, 0);
			break;
		case 2: // Go left
			if (MoveX(-walkspeed))
			{
				travelled += walkspeed;
				if (travelled >= traveldest)
					ChangeParams(3, 1);
			}
			else
				ChangeParams(3, 1);
			if (IsMissingGround(xpos, ypos))
				ChangeParams(4, +1);
			break;
		case 3: // Pause
			framecounter++;
			if (framecounter >= framedest)
				ChangeParams(stparam2, 0);
			break;
		case 4: // Fall
			if (!FallFrametick())
			{
				ChangeParams(1, 0);
				if (IsOnScreen())
					afootstep->Play();
			}
			break;
	}
}

void GreenBeli::StateFollow()
{
	int speed;
	
	if (!callingparty_obj)
	{
		if (state == STATE_FOLLOW)
		{
			if ((stparam1 == 3) || (stparam1 = 4))
				SwitchToState(STATE_FALLING, 0, 0);
			else
				SwitchToState(STATE_WAIT, 0, 0);
		}
		else
			SwitchToState(STATE_WAIT, 0, 0);
		return;
	}
	
	speed = callingparty_obj->WalkBoost() ? runspeed : walkspeed;
	
	if ((stparam1 == 0) || (stparam1 == 1) || (stparam1 == 2))
	{
		int absdif = abs(xdiff);
		int sp = abs(speed);
		if (absdif <= sp && (callingparty_obj->GS() == this->GS()))
		{
			xdiff = callingparty_obj->X() - this->X();
			absdif = abs(xdiff);
		}
		if (absdif > sp)
		{
			if ((xdiff > 0) && (stparam1 != 1))
//				if (gamescreen->CanPassOver(this, +1))
					ChangeParams(1, 0);
			if ((xdiff < 0) && (stparam1 != 2))
//				if (gamescreen->CanPassOver(this, -1))
					ChangeParams(2, 0);
		}
		else
			if (stparam1 != 0)
				ChangeParams(0, 0);
	}

	switch( stparam1 )
	{
		case 0: // Do nothing
			break;
		case 1: // Follow right
			if (!MoveX(+speed))
			{
				if (gamescreen->CanPassOver(this, +1))
					ChangeParams(3, +1);
				else
					ChangeParams(0, 0);
			}
			else
				{
					if (IsOnScreen())
						afootstep->Frametick();
					xdiff -= speed;
				}
			if (IsMissingGround(xpos, ypos))
				ChangeParams(4, +1);
			break;
		case 2: // Follow left
			if (!MoveX(-speed))
			{
				if (gamescreen->CanPassOver(this, -1))
					ChangeParams(3, -1);
				else
					ChangeParams(0, 0);
			}
			else
				{
					if (IsOnScreen())
						afootstep->Frametick();
					xdiff += speed;
				}
			if (IsMissingGround(xpos, ypos))
				ChangeParams(4, -1);			
			break;
		case 3: // Leap
			if (!LeapFrametick())
				ChangeParams(4, stparam2);
			if (MoveX(stparam2*speed))
				xdiff -= stparam2*speed;
			break;
		case 4: // Fall
			if (!FallFrametick())
			{
				ChangeParams(0, 0);
				if (IsOnScreen())
					afootstep->Play();
			}
			if (MoveX(stparam2*speed))
				xdiff -= stparam2*speed;
			break;
	}
}

void GreenBeli::ProcessAI()
{
	Object::ProcessAI();
	
	if (callingparty_obj)
		if (callingparty_obj->DXValid())
			xdiff += callingparty_obj->DX();
	
	switch( state )
	{
		case STATE_IDLE:
			//if (rand() % 100)
			//	SwitchToState(STATE_WALK, 1, 0);
			//else
				SwitchToState(STATE_WAIT, 0, 0);
			break;
		case STATE_FOLLOW:
			StateFollow();
			break;
		case STATE_WAIT:
			break;
		case STATE_WALK:
			StateWalk();
			//MoveX(+walkspeed);
			break;
		case STATE_JUMPING:
			if (!LeapFrametick())
				SwitchToState(STATE_FALLING, 0, 0);
			break;
		case STATE_FALLING:
			if (!FallFrametick())
			{
				SwitchToState(STATE_IDLE, 1, 0);
				if (IsOnScreen())
					afootstep->Play();
			}
			break;
	}
}

void GreenBeli::ProcessInput()
{
	Object::ProcessInput();
	
	if (key[KEY_LSHIFT])
		anims[0]->SetRate(0x1E);
	else
		anims[0]->SetRate(0x10);
}

void GreenBeli::ProcessMessage(MESSAGE msg)
{
	if (msg.duration != 250) return;
	
	switch( msg.msgtype )
	{
		case MSG_CALL:
			callingparty_obj = msg.sender;
			SetMessage(MSG_RESPOND, 0, 0, 300);
			break;
		case MSG_FOLLOW:
			xdiff = callingparty_obj->X() - this->X();
			SetMessage(MSG_POSITIVE, 0, 0, 300);
			if (state != STATE_FOLLOW)
				SwitchToState(STATE_FOLLOW, 0, 0);
			break;
		case MSG_STAY:
			SetMessage(MSG_POSITIVE, 0, 0, 300);
			if (state != STATE_FOLLOW || ((state == STATE_FOLLOW) && (stparam1 < 3)))
			SwitchToState(STATE_WAIT, 0, 0);
			//	SwitchToState(STATE_WALK, 1, 0);
			else
				SwitchToState(STATE_FALLING, 0, 0);
			break;
	}
}

void GreenBeli::Rescue()
{
	gamescreen->KillCharacter(this);
	gamescreen->GetPlay()->AddRescue();
}