#define DEBUGMODE

#include "Ghost.h"
#include "Play.h"
#include "GameScreen.h"
#include "AudioSampler.h"
#include "Possession.h"

Ghost::Ghost(GameScreen *owner)
	:Object(owner, false),
	travelled(0), traveldest(18000),
	framecounter(0), framedest(0),
	damage(0), waittime(0), wtrandom(false),
	wtbase(0)
{
	type = OBJTYPE_GHOST;
}

void Ghost::Init()
{
	Object::Init();
	
	LoadProperties("data\\ghost.txt");
	
	health = fullhealth;
	
	xpos = 0<<8; ypos = 160<<8;
	
	if (!gamescreen) return;
	
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["ghostidle"]));
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["ghostwalk"]));
	
	SwitchToState(STATE_FALLING, 0, 0);	
}

void Ghost::ReadProperties(MyINI *ini)
{
	Object::ReadProperties(ini);

	if (!strcmp(ini->Variable(), "walkdistance"))
		traveldest = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "damage"))
		damage = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "waittime"))
	{
		waittime = ini->ReadInteger();
		wtbase = ini->ReadInteger();
	}
	if (!strcmp(ini->Variable(), "wtrandom"))
		wtrandom = ini->ReadBool();
}

void Ghost::InitState(int st)
{
	Object::InitState(st);
	
	switch( st )
	{
		case STATE_WAIT:
		case STATE_IDLE:
			anims[0]->GoToFrame(0);
			current_animation = 0;
			break;
		case STATE_WALKL:
			current_animation = 1;
			break;
		case STATE_WALKR:
			current_animation = 1;
			break;
		case STATE_FALLING:
			current_animation = 1;
			break;
		case STATE_JUMPING:
			current_animation = 1;
			break;
	}
}

void Ghost::SwitchToState(int st, int param1, int param2)
{	
	Object::SwitchToState(st, param1, param2);
	
	switch( st )
	{

		case STATE_WALK:
			break;
	}
}

void Ghost::ChangeParams(int param1, int param2)
{
	Object::ChangeParams(param1, param2);
	
	switch( state )
	{
		case STATE_WALK:
			switch( param1 )
			{
				case 1: // Go right
					current_animation = 1;
					travelled = 0;
					InitState(STATE_WALKR);
					break;
				case 2: // Go left
					current_animation = 1;
					travelled = 0;
					InitState(STATE_WALKL);
					break;
				case 3: // Pause
					current_animation = 0;
					framecounter = 0;
					if (wtrandom)
						framedest = rand() % waittime + wtbase;
					else
						framedest = waittime;
					//InitState(STATE_IDLE);
					break;
			}
	}
}

void Ghost::StateWalk()
{
	switch( stparam1 )
	{
		case 1: // Go right
			if (MoveX(+walkspeed))
			{
				travelled += walkspeed;
				if (travelled >= traveldest)
					ChangeParams(3, 2);
			}
			else
				ChangeParams(3, 2);
			if (IsMissingGround(xpos, ypos))
				ChangeParams(4, 0);
			break;
		case 2: // Go left
			if (MoveX(-walkspeed))
			{
				travelled += walkspeed;
				if (travelled >= traveldest)
					ChangeParams(3, 1);
			}
			else
				ChangeParams(3, 1);
			if (IsMissingGround(xpos, ypos))
				ChangeParams(4, +1);
			break;
		case 3: // Pause
			framecounter++;
			if (framecounter >= framedest)
				ChangeParams(stparam2, 0);
			break;
		case 4: // Fall
			if (!FallFrametick())
			{
				ChangeParams(1, 0);
				if (IsOnScreen())
					afootstep->Play();
			}
			break;
	}
}

void Ghost::ProcessAI()
{
	Object::ProcessAI();
	
	Object *mc = gamescreen->GetPlay()->GetMainCharacter();
	if (!mc->IsDead())
		if (Intersect(mc) && ((mc->DXValid() && mc->DX()) || (mc->DYValid() && mc->DY())))
			mc->Damage(damage);
	
	switch( state )
	{
		case STATE_IDLE:
			SwitchToState(STATE_WALK, 0, 0);
			break;
		case STATE_WALK:
			StateWalk();
			break;
		case STATE_FALLING:
			if (!FallFrametick())
			{
				SwitchToState(STATE_IDLE, 1, 0);
				if (IsOnScreen())
					afootstep->Play();
			}
			break;
	}
}